
DROP FUNCTION IF EXISTS ptdmdbill_generateforassessment(character varying);

DROP FUNCTION IF EXISTS ptdmdbill_generatecurrentinstdetails(character varying, bigint, bigint, bigint, bigint, character varying);

DROP FUNCTION IF EXISTS ptdmdbill_generatearrearsdetails(character varying, bigint, bigint, bigint);

DROP FUNCTION IF EXISTS ptdmdbill_preparemonthwisetaxwithpenalty(character varying, bigint, bigint, bigint, timestamp without time zone, double precision, double precision, double precision, bigint);

DROP FUNCTION IF EXISTS ptdmdbill_modifiedassessmentpenalty(character varying, bigint, bigint, bigint, timestamp without time zone, double precision, double precision, double precision, bigint);

DROP FUNCTION IF EXISTS ptdmdbill_modifiedmonthwisetaxwithpenalty(bigint, bigint, timestamp without time zone, double precision, double precision, double precision, bigint, bigint, date);

DROP FUNCTION IF EXISTS ptdmdbill_migratedunmodifiedassessmentpenalty(character varying, bigint, bigint, timestamp without time zone, double precision, double precision, double precision, bigint);

DROP FUNCTION IF EXISTS ptdmdbill_migratedunmodifiedmonthwisetaxwithpenalty(character varying, bigint, bigint, timestamp without time zone, double precision, double precision, double precision, bigint);

DROP FUNCTION IF EXISTS ptdmdbill_createdunmodifiedassessmentpenalty(character varying, date, bigint, bigint, timestamp without time zone, double precision, double precision, double precision, bigint);

DROP FUNCTION IF EXISTS ptdmdbill_createdunmodifiedmonthwisetaxwithpenalty(character varying, bigint, bigint, timestamp without time zone, double precision, double precision, double precision, bigint, date);

DROP FUNCTION IF EXISTS ptdmdbill_generateforward(bigint);

-------------------------------------------------------------------------------

CREATE OR REPLACE FUNCTION ptdmdbill_generateforassessment(v_assessmentno character varying,v_noticeType character varying)
  RETURNS character varying AS
$BODY$
declare
  v_billno character varying(14);
  v_ownername character varying(256);
  v_bpid bigint;
  v_idpropertyid bigint;
  v_blockid bigint;
  v_localityid bigint;
  v_addressid bigint;
  v_ward_adm_id bigint;
  v_moduleid bigint;
  v_currinst bigint;
  v_houseno character varying(64);
  v_currdemand bigint;
  v_propid bigint;
  v_advance double precision;
  v_arrearspenalty double precision;
  v_finyear character varying(10);
  v_billpk bigint;
  v_demandbill bigint;
  v_arreartax double precision;
  v_currfirsthalftax double precision;
  v_currsecondhalftax double precision; 
  v_balance double precision;
  citycode character varying(4);
  v_temp bigint;
  instal record;
  v_month bigint;
  v_currfinenddate timestamp without time zone;
  v_sewconsumercode character varying;
  v_wtrconsumercode character varying;
  appconfigvalues character varying;
  v_sewadvance double precision;
  v_wtradvance double precision;
  v_sewtaxCurrFirstHalf double precision;
  v_wtrtaxCurrFirstHalf double precision;
  v_sewtaxCurrSecondHalf double precision;
  v_wtrtaxCurrSecondHalf double precision;
  v_wtrtaxarrear double precision;
  v_sewtaxarrear double precision;
  v_totalWaterTax double precision;
  v_totalSewerageTax double precision;
  appconfigvalue character varying;
  isModuleEnabled character varying(4);
begin
  --raise notice 'ptdmdbill_generateforassessment: assessmentno, (%)',v_assessmentno;
  select id into v_demandbill from eg_demand_bill where assessmentno = v_assessmentno;
  if (v_demandbill is null) then
    select id into v_moduleid from eg_module where name = 'Property Tax';
  select id into v_currinst from eg_installment_master where financial_year = (select financialyear from financialyear where now() between startingdate and endingdate) and id_module = v_moduleid order by start_date limit 1;
    select id, id_propertyid, addressid into v_bpid, v_idpropertyid, v_addressid from egpt_basic_property where propertyid = v_assessmentno;
    select id into v_propid from egpt_property where id_basic_property = v_bpid and status in ('A','I');
    select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property = v_propid) and id_installment = v_currinst;
    select sum(amount-amt_collected) into v_balance from eg_demand_details where id_demand = v_currdemand;
    --raise notice 'ptdmdbill_generateforassessment: (% % % % %)', v_moduleid, v_currinst, v_propid, v_currdemand, v_balance;
    if (v_balance > 0) then
      select code into citycode from eg_city;
      select coalesce(dd.amount, 0) into v_advance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand_reason = dr.id 
      and dr.id_demand_reason_master = drm.id and drm.code = 'ADVANCE' and dr.id_installment = v_currinst and dd.id_demand = v_currdemand;

      select coalesce(sum(dd.amount-dd.amt_collected), 0) into v_arrearspenalty from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand_reason = dr.id 
      and dr.id_demand_reason_master = drm.id and drm.code = 'PENALTY_FINES' and dr.id_installment not in (select id from eg_installment_master where financial_year = (
      select financialyear from financialyear where now() between startingdate and endingdate) and id_module = v_moduleid) and dd.id_demand = v_currdemand;
      
      select ward_adm_id, adm1, adm2 into v_ward_adm_id, v_blockid, v_localityid from egpt_propertyid where id = v_idpropertyid;
      select housenobldgapt into v_houseno from eg_address where id = v_addressid;
      select ownername(v_bpid) into v_ownername;
      
      --raise notice 'ptdmdbill_generateforassessment: (% % % % % %)',v_billno, v_ownername, v_blockid, v_localityid, v_ward_adm_id, v_houseno;
      select nextval('seq_eg_demand_bill') into v_billpk;
      if(v_noticeType = 'Bill') then
        select citycode || lpad(nextval('seq_demand_bill_number')::text,8,'0') into v_billno;
        insert into eg_demand_bill(id,assessmentno,houseno,ownername,locality,revenueward,block,advance,arrear_interest,createddate,createdby,lastmodifieddate,lastmodifiedby,billnumber,isactive)
        values (v_billpk, v_assessmentno, v_houseno, v_ownername, v_localityid, v_ward_adm_id, v_blockid, v_advance, v_arrearspenalty, now(), 1, now(), 1, v_billno, true);
      elsif(v_noticeType ='Integrated Bill') then
        v_sewadvance := 0;
        v_sewtaxCurrFirstHalf := 0;
        v_sewtaxCurrSecondHalf := 0;
        v_sewtaxarrear := 0;
        v_sewconsumercode = '';
        select 'I/'||citycode || lpad(nextval('seq_demand_bill_number')::text,8,'0') into v_billno;
        select value into appconfigvalues from eg_appconfig_values where key_id = (select id from eg_appconfig  where key_name ='PTIS_INTG_DMD_BILL' and module =(select id from eg_module where name='Property Tax')); 
        for appconfigvalue in (select * from regexp_split_to_table(appconfigvalues, ','))
        loop
          select enabled into isModuleEnabled from eg_module where lower(name) like '%'||appconfigvalue||'%';
          if (appconfigvalue = 'water tax' and isModuleEnabled = 't') then
            SELECT * FROM getwatertaxtotalconnectionsumofdemand(v_assessmentno) INTO v_wtrtaxCurrFirstHalf, v_wtrtaxCurrSecondHalf,v_wtradvance,v_wtrtaxarrear,v_wtrconsumercode;
          elsif (appconfigvalue = 'sewerage tax' and isModuleEnabled = 't') then
             SELECT * FROM getSewerageTaxTotalConnectionSumofDemand(v_assessmentno) INTO v_sewtaxCurrFirstHalf,v_sewtaxCurrSecondHalf,v_sewadvance,v_sewtaxarrear,v_sewconsumercode;
          end if;
        end loop;
        v_totalWaterTax := v_wtrtaxCurrFirstHalf + v_wtrtaxCurrSecondHalf + v_wtrtaxarrear - v_wtradvance;
        v_totalSewerageTax := v_sewtaxCurrFirstHalf + v_sewtaxCurrSecondHalf + v_sewtaxarrear - v_sewadvance;
        insert into eg_demand_bill(id,assessmentno,houseno,ownername,locality,revenueward,block,advance,arrear_interest,createddate,createdby,lastmodifieddate,lastmodifiedby,billnumber,isactive,ST_CONSUMER_CODE,WT_CONSUMER_CODE,ST_ADVANCE,WT_ADVANCE,ST_ARREARS_INTEREST,WT_ARREARS_INTEREST)
        values (v_billpk, v_assessmentno, v_houseno, v_ownername, v_localityid, v_ward_adm_id, v_blockid, v_advance, v_arrearspenalty, now(), 1, now(), 1, v_billno, true,v_sewconsumercode,v_wtrconsumercode,v_sewadvance,v_wtradvance,0,0);
       end if;
      select financialyear, endingdate into v_finyear, v_currfinenddate from financialyear where now() between startingdate and endingdate;
      for instal in (select id, start_date from eg_installment_master where financial_year = v_finyear and id_module = v_moduleid order by start_date)
      loop
  select extract(month from instal.start_date) into v_month;
  if (v_month>=4 and v_month<=9) then
    v_currfirsthalftax := ptdmdbill_generatecurrentinstdetails(v_currdemand, v_billpk, instal.id, 'Current 1st Half',v_wtrtaxCurrFirstHalf,v_sewtaxCurrFirstHalf);
  else
    v_currsecondhalftax := ptdmdbill_generatecurrentinstdetails(v_currdemand, v_billpk, instal.id, 'Current 2nd Half',v_wtrtaxCurrSecondHalf,v_sewtaxCurrSecondHalf);
  end if;
      end loop;
      v_arreartax := ptdmdbill_generatearrearsdetails(v_finyear, v_moduleid, v_currdemand, v_billpk, v_wtrtaxarrear, v_sewtaxarrear);
      v_temp := ptdmdbill_preparemonthwisetaxwithpenalty(v_assessmentno, v_currinst, v_currdemand, v_moduleid, v_currfinenddate, v_currfirsthalftax, v_currsecondhalftax, v_arreartax, v_billpk,v_totalWaterTax,v_totalSewerageTax);
      if(v_noticeType = 'Bill') then
        update egpt_basic_property set is_bill_created = 'Y' where propertyid = v_assessmentno;
      elsif(v_noticeType ='Integrated Bill') then
        update egpt_basic_property set is_intg_bill_created = 'Y' where propertyid = v_assessmentno;
       end if; 
    end if;
  end if;
  return v_billno;
  exception
  when others then
    raise notice 'ptdmdbill_generateforassessment % %', SQLERRM,SQLSTATE;
end;
$BODY$ LANGUAGE plpgsql;






create or replace function ptdmdbill_generatecurrentinstdetails(v_currdemand bigint, v_billpk bigint, v_instid bigint, v_installment character varying(24),v_wtrtax double precision,v_sewtax double precision)
returns double precision as
$BODY$
declare
  v_propertytax double precision;
  v_gentax double precision;
  v_vlttax double precision;
  v_libcess double precision;
  v_educess double precision;
  v_uacpenalty double precision;
  v_totaltax double precision;
  rec record;
begin
  --raise notice 'ptdmdbill_generatecurrentinstdetails (% % % )', v_currdemand, v_billpk, v_installment;
  v_propertytax := 0;
  v_gentax := 0;
  v_vlttax := 0;
  v_libcess := 0;
  v_educess := 0;
  v_uacpenalty := 0;
  v_totaltax := 0;
  for rec in (select drm.code, dd.amount-dd.amt_collected balance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = v_instid and dd.id_demand = v_currdemand) 
  loop
    if rec.code = 'GEN_TAX' then
      v_gentax := coalesce(rec.balance, 0);
    elsif rec.code = 'VAC_LAND_TAX' then
      v_vlttax := coalesce(rec.balance, 0);
    elsif rec.code = 'LIB_CESS' then
      v_libcess := coalesce(rec.balance, 0);
    elsif rec.code = 'EDU_CESS' then
      v_educess := coalesce(rec.balance, 0);
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_uacpenalty := coalesce(rec.balance, 0);
    end if;
  v_propertytax := v_gentax + v_vlttax;
    --raise notice 'ptdmdbill_generatecurrentinstdetails (% % % %)',v_gentax, v_libcess, v_educess, v_uacpenalty;
  end loop;
  v_totaltax = v_gentax+v_vlttax+v_libcess+v_educess+v_uacpenalty;
  insert into eg_demand_inst_details(id,installment,generaltax,educationtax,librarycess,unauthorizedpenalty,totaltax,egdemandbillid,createddate,createdby,lastmodifieddate,lastmodifiedby,water_tax,sewerage_tax)
  values (nextval('seq_eg_demand_inst_details'),v_installment,v_propertytax,v_educess,v_libcess,v_uacpenalty,v_totaltax,v_billpk,now(),1,now(),1,v_wtrtax,v_sewtax);
return v_totaltax;
exception
  when others then
    raise notice 'ptdmdbill_generatecurrentinstdetails % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;





CREATE OR REPLACE FUNCTION ptdmdbill_generatearrearsdetails(
    v_finyear character varying,
    v_moduleid bigint,
    v_currdemand bigint,
    v_billpk bigint,
    v_wtrtax double precision,
    v_sewtax double precision)
  RETURNS double precision AS
$BODY$
declare
  v_propertytax double precision;
  v_vlttax double precision;
  v_gentax double precision;
  v_libcess double precision;
  v_educess double precision;
  v_uacpenalty double precision;
  v_totaltax double precision;
  rec record;
begin
  v_propertytax := 0;
  v_vlttax := 0;
  v_gentax := 0;
  v_libcess := 0;
  v_educess := 0;
  v_uacpenalty := 0;
  v_totaltax := 0;
  --raise notice 'ptdmdbill_generatearrearsdetails (% % % %)',v_finyear, v_moduleid, v_currdemand, v_billpk;
  for rec in (select drm.code, sum(dd.amount-dd.amt_collected) balance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm 
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment not in (
    select id from eg_installment_master where financial_year = v_finyear and id_module = v_moduleid) and dd.id_demand = v_currdemand group by drm.code) 
  loop
    if rec.code = 'GEN_TAX' then
      v_gentax := coalesce(rec.balance, 0);
    elsif rec.code = 'VAC_LAND_TAX' then
      v_vlttax := coalesce(rec.balance, 0);
    elsif rec.code = 'LIB_CESS' then
      v_libcess := coalesce(rec.balance, 0);
    elsif rec.code = 'EDU_CESS' then
      v_educess := coalesce(rec.balance, 0);
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_uacpenalty := coalesce(rec.balance, 0);
    end if;
  v_propertytax := v_gentax + v_vlttax;
    --raise notice 'ptdmdbill_generatearrearsdetails (% % % %)',v_gentax, v_libcess, v_educess, v_uacpenalty;
    end loop;
    v_totaltax = v_gentax + v_vlttax+v_libcess+v_educess+v_uacpenalty;
    insert into eg_demand_inst_details(id,installment,generaltax,educationtax,librarycess,unauthorizedpenalty,totaltax,egdemandbillid,createddate,createdby,lastmodifieddate,lastmodifiedby,WATER_TAX,SEWERAGE_TAX)
  values (nextval('seq_eg_demand_inst_details'),'Arrears',v_propertytax,v_educess,v_libcess,v_uacpenalty,v_totaltax,v_billpk,now(),1,now(),1,v_wtrtax,v_sewtax);
return v_totaltax;
exception
  when others then
    raise notice 'ptdmdbill_generatearrearsdetails % %', SQLERRM,SQLSTATE;
end;
$BODY$ LANGUAGE plpgsql;





CREATE OR REPLACE FUNCTION ptdmdbill_preparemonthwisetaxwithpenalty(
    in_assessmentno character varying,
    in_currinst bigint,
    in_currdemand bigint,
    in_moduleid bigint,
    in_currfinenddate timestamp without time zone,
    in_firsthalftax double precision,
    in_secondhalftax double precision,
    in_arreartax double precision,
    in_billpk bigint,
    in_wtrtax double precision,
    in_sewtax double precision)
  RETURNS bigint AS
$BODY$
declare
  v_ismigrated boolean;
  v_ismodified boolean;
  v_basicpropid bigint;
  v_assessmentdate date;
  v_temp bigint;
begin
  select id, assessmentdate into v_basicpropid, v_assessmentdate from egpt_basic_property where propertyid = in_assessmentno;
  
  v_ismigrated := lppcalc_ismigrated(in_assessmentno);
  v_ismodified := lppcalc_modifiedinerp(v_basicpropid);
  --raise notice 'ptdmdbill_preparemonthwisetaxwithpenalty v_ismigrated, v_ismodified % %', v_ismigrated, v_ismodified;

  if (v_ismodified) then
    v_temp := ptdmdbill_modifiedassessmentpenalty(in_assessmentno, in_currinst, in_moduleid, in_currdemand, in_currfinenddate, in_firsthalftax, in_secondhalftax, in_arreartax, in_billpk, in_wtrtax, in_sewtax);
  else
    if (v_ismigrated) then
      v_temp := ptdmdbill_migratedunmodifiedassessmentpenalty(in_assessmentno, in_currinst, in_currdemand, in_currfinenddate, in_firsthalftax, in_secondhalftax, in_arreartax, in_billpk, in_wtrtax, in_sewtax);
    else
      v_temp := ptdmdbill_createdunmodifiedassessmentpenalty(in_assessmentno, v_assessmentdate, in_currinst, in_currdemand, in_currfinenddate, in_firsthalftax, in_secondhalftax, in_arreartax, in_billpk, in_wtrtax, in_sewtax);
    end if;
  end if;
return 1;
exception 
  when others then
    raise notice 'ptdmdbill_preparemonthwisetaxwithpenalty % %', SQLERRM, SQLSTATE;
end;
$BODY$ LANGUAGE plpgsql;




CREATE OR REPLACE FUNCTION ptdmdbill_modifiedassessmentpenalty(
    in_assessmentno character varying,
    in_currinst bigint,
    in_moduleid bigint,
    in_demandid bigint,
    in_currfinenddate timestamp without time zone,
    in_firsthalftax double precision,
    in_secondhalftax double precision,
    in_arreartax double precision,
    in_billpk bigint,
    in_wtrtax double precision,
    in_sewtax double precision)
  RETURNS numeric AS
$BODY$
declare
  v_temp bigint;
  v_oldpropid bigint;
  v_olddemandid bigint;
  v_alteration_date date;
  v_peneffdate date;
BEGIN 
  --raise notice 'ptdmdbill_modifiedassessmentpenalty: in_assessmentno, in_currinst, in_moduleid, in_demandid (% % % %)',in_assessmentno, in_currinst, in_moduleid, in_demandid;
  select id into v_oldpropid from egpt_property where id_basic_property = (select id from egpt_basic_property where propertyid = in_assessmentno) 
    and status = 'H' order by modified_date desc limit 1;
    
  select dmd.id into v_olddemandid from eg_demand dmd, egpt_ptdemand ptd, eg_installment_master inst where ptd.id_property = v_oldpropid and ptd.id_demand = dmd.id and dmd.id_installment = inst.id and inst.installment_year = (
  select max(installment_year) from eg_installment_master where id in (select id_installment from eg_demand where id in (select id_demand from egpt_ptdemand where id_property = v_oldpropid)));
  
  select modified_date into v_alteration_date from egpt_property_status_values where id_basic_property = (select id_basic_property from egpt_property where id = v_oldpropid) 
  and id_status in (select id from egpt_status where code in ('ADD_OR_ALTER', 'BIFURCATE', 'RP')) and is_active = 'Y' order by id desc limit 1;
  
  v_peneffdate := lppcalc_getpeneffdate(in_assessmentno, v_alteration_date);
  --raise notice 'ptdmdbill_modifiedassessmentpenalty: v_peneffdate (%)',v_peneffdate;
  v_temp := ptdmdbill_modifiedMonthwiseTaxwithpenalty(in_currinst, in_demandid, in_currfinenddate, in_firsthalftax, in_secondhalftax, in_arreartax, in_billpk, v_olddemandid, v_peneffdate,in_wtrtax,in_sewtax);
return v_temp;  
exception
  when others then
    raise notice 'ptdmdbill_modifiedassessmentpenalty, % %',SQLERRM,SQLSTATE;
END;
$BODY$ LANGUAGE plpgsql;





CREATE OR REPLACE FUNCTION ptdmdbill_modifiedmonthwisetaxwithpenalty(
    v_currinst bigint,
    v_currdemand bigint,
    v_currfinenddate timestamp without time zone,
    v_firsthalftax double precision,
    v_secondhalftax double precision,
    v_arreartax double precision,
    v_billpk bigint,
    v_olddemand bigint,
    v_peneffdate date,
    v_wtrtax double precision,
    v_sewtax double precision)
  RETURNS bigint AS
$BODY$
declare
  v_paydate date;
  v_interval bigint;
  v_firsthalfpenalty double precision;
  v_secondhalfpenalty double precision;
  v_arrearspenalty double precision;
  v_total double precision;
  v_module bigint;
  v_firsthalfinst bigint;
  v_secondhalfinst bigint;
  v_count integer;
  v_arrerpercentage bigint;
  v_firsthalfpercentage bigint;
  v_secondhalfpercentage bigint;
  v_counter integer;
  rec record;
  v_montharrpenalty double precision;
  v_monthfirsthalfpenalty double precision;
  v_monthsecondhalfpenalty double precision;
  v_paydatestart date;
  v_currmonth bigint;
begin
  --raise notice 'ptdmdbill_modifiedMonthwiseTaxwithpenalty % % % % % % % ', v_currinst, v_currdemand, v_currfinenddate, v_firsthalftax, v_secondhalftax, v_arreartax, v_billpk;
  v_interval := 1;
  v_currmonth := extract(month from now());
  select id into v_module from eg_module where name = 'Property Tax';
  v_count := 0;
  v_arrearspenalty := 0;
  v_firsthalfpenalty := 0;
  v_secondhalfpenalty := 0;
  for rec in (select inst.id from eg_installment_master inst, financialyear fin where inst.financial_year = fin.financialyear 
  and now() between fin.startingdate and fin.endingdate and inst.id_module = v_module order by inst.start_date)
  loop
    if (v_count = 0) then
      v_firsthalfinst := rec.id;
      v_count := v_count + 1;
    else 
      v_secondhalfinst := rec.id;
    end if;
  end loop;
  v_arrerpercentage := 0;
  v_firsthalfpercentage := 0;
  v_secondhalfpercentage := 0;
  v_counter := v_currmonth;
  loop
    v_montharrpenalty := 0;
    v_monthfirsthalfpenalty := 0;
    v_monthsecondhalfpenalty := 0;
    v_total := 0;
    v_paydate := ptdmdbill_getlastday(v_interval);
    v_paydatestart := date_trunc('month', v_paydate)::date;
    if (v_counter > v_currmonth) then
      v_arrerpercentage := 2;
    end if;
    if (v_paydatestart < v_peneffdate) then
      v_montharrpenalty := ptdmdbill_arrearsPenalty_olddemand(v_currdemand, v_olddemand, v_firsthalfinst, v_secondhalfinst, v_arrerpercentage);
    else 
      v_montharrpenalty := ptdmdbill_arrearsPenalty(v_currdemand, v_firsthalfinst, v_secondhalfinst, v_arrerpercentage);
    end if;
    v_arrearspenalty := v_arrearspenalty + v_montharrpenalty;
    if (v_counter > 6 or v_counter < 4) then
    v_firsthalfpercentage := 2;
    if (v_paydatestart < v_peneffdate) then
    v_monthfirsthalfpenalty := ptdmdbill_currentPenalty_olddemand(v_olddemand, v_firsthalfpercentage, v_firsthalfinst);
    else 
    v_monthfirsthalfpenalty := ptdmdbill_currentPenalty(v_firsthalfpercentage, v_firsthalftax);
    end if;
    v_firsthalfpenalty := v_firsthalfpenalty + v_monthfirsthalfpenalty;
    end if;
    if (v_counter < 4 or v_counter > 12) then
    v_secondhalfpercentage := 2;
    if (v_paydatestart < v_peneffdate) then
    v_monthsecondhalfpenalty := ptdmdbill_currentPenalty_olddemand(v_olddemand, v_secondhalfpercentage, v_secondhalfinst);
    else 
    v_monthsecondhalfpenalty := ptdmdbill_currentPenalty(v_secondhalfpercentage, v_secondhalftax);
    end if;
    v_secondhalfpenalty := v_secondhalfpenalty + v_monthsecondhalfpenalty;
    end if;
    v_counter := v_counter + 1;
    v_total := v_arreartax+v_firsthalftax+v_secondhalftax+v_arrearspenalty+v_firsthalfpenalty+v_secondhalfpenalty;
    --raise notice 'ptdmdbill_modifiedMonthwiseTaxwithpenalty %', v_paydate;
    insert into eg_demand_bill_details (id,paidbeforedate,arreartax,arrearpenalty,currfirsthalftax,currsecondhalftax,currfirsthalfpenalty,currsecondhalfpenalty,totalamount,egdemandbillid,
    createddate,createdby,lastmodifieddate,lastmodifiedby,water_tax,sewerage_tax) values (nextval('seq_eg_demand_bill_details'),v_paydate,v_arreartax,v_arrearspenalty,v_firsthalftax,v_secondhalftax,
    v_firsthalfpenalty,v_secondhalfpenalty,v_total,v_billpk,now(),1,now(),1,v_wtrtax,v_sewtax);
    
    exit when v_paydate >= v_currfinenddate;
    v_interval := v_interval + 1;
  end loop;
return 1;
exception 
  when others then
    raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % %', SQLERRM, SQLSTATE;
end;
$BODY$ LANGUAGE plpgsql;





CREATE OR REPLACE FUNCTION ptdmdbill_migratedunmodifiedassessmentpenalty(
    in_assessmentno character varying,
    in_currinst bigint,
    in_demandid bigint,
    in_currfinenddate timestamp without time zone,
    in_firsthalftax double precision,
    in_secondhalftax double precision,
    in_arreartax double precision,
    in_billpk bigint,
    v_wtrtax double precision,
    v_sewtax double precision)
  RETURNS numeric AS
$BODY$
declare
  v_temp bigint;
BEGIN 
  --raise notice 'ptdmdbill_migratedunmodifiedassessmentpenalty in_assessmentno, in_currinst, in_moduleid, in_demandid (% % % %)',in_assessmentno, in_currinst, in_moduleid, in_demandid;
  v_temp := ptdmdbill_migratedunmodifiedMonthwiseTaxwithpenalty(in_assessmentno, in_currinst, in_demandid, in_currfinenddate, in_firsthalftax, in_secondhalftax, in_arreartax, in_billpk,v_wtrtax,v_sewtax);
return v_temp;  
exception
  when others then
    raise notice 'ptdmdbill_migratedunmodifiedassessmentpenalty, % %',SQLERRM,SQLSTATE;
END;
$BODY$ LANGUAGE plpgsql;



create or replace function ptdmdbill_migratedunmodifiedMonthwiseTaxwithpenalty(in_assessmentno character varying, v_currinst bigint, v_currdemand bigint, v_currfinenddate timestamp without time zone,
  v_firsthalftax double precision, v_secondhalftax double precision, v_arreartax double precision, v_billpk bigint,v_wtrtax double precision,v_sewtax double precision)
returns bigint as
$BODY$
declare
  v_paydate date;
  v_interval bigint;
  v_firsthalfpenalty double precision;
  v_secondhalfpenalty double precision;
  v_arrearspenalty double precision;
  v_total double precision;
  v_module bigint;
  v_firsthalfinst bigint;
  v_secondhalfinst bigint;
  v_count integer;
  v_arrerpercentage bigint;
  v_firsthalfpercentage bigint;
  v_secondhalfpercentage bigint;
  v_counter integer;
  rec record;
  v_montharrpenalty double precision;
  v_monthfirsthalfpenalty double precision;
  v_monthsecondhalfpenalty double precision;
  v_currmonth bigint;
begin
  --raise notice 'ptdmdbill_migratedunmodifiedMonthwiseTaxwithpenalty % % % % % % % ', v_currinst, v_currdemand, v_currfinenddate, v_firsthalftax, v_secondhalftax, v_arreartax, v_billpk;
  v_interval := 1;
  v_currmonth := extract(month from now());
  select id into v_module from eg_module where name = 'Property Tax';
  v_count := 0;
  for rec in (select inst.id from eg_installment_master inst, financialyear fin where inst.financial_year = fin.financialyear 
  and now() between fin.startingdate and fin.endingdate and inst.id_module = v_module order by inst.start_date)
  loop
    if (v_count = 0) then
      v_firsthalfinst := rec.id;
      v_count := v_count + 1;
    else 
      v_secondhalfinst := rec.id;
    end if;
  end loop;
  v_arrearspenalty := 0;
  --getting first half peanlty if any
  select coalesce(sum(dd.amount-dd.amt_collected),0) into v_firsthalfpenalty from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = v_firsthalfinst and dd.id_demand = v_currdemand and drm.code = 'PENALTY_FINES';
  --getting second half peanlty if any
  select coalesce(sum(dd.amount-dd.amt_collected),0) into v_secondhalfpenalty from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = v_secondhalfinst and dd.id_demand = v_currdemand and drm.code = 'PENALTY_FINES';
  --raise notice 'ptdmdbill_migratedunmodifiedMonthwiseTaxwithpenalty v_firsthalfpenalty, v_secondhalfpenalty % %', v_firsthalfpenalty, v_secondhalfpenalty;
  v_arrerpercentage := 0;
  v_firsthalfpercentage := 0;
  v_secondhalfpercentage := 0;
  v_counter := v_currmonth;
  loop
  --raise notice 'ptdmdbill_migratedunmodifiedMonthwiseTaxwithpenalty v_counter, v_currmonth % %', v_counter, v_currmonth;
    v_montharrpenalty := 0;
    v_monthfirsthalfpenalty := 0;
    v_monthsecondhalfpenalty := 0;
    v_total := 0;
    v_paydate := ptdmdbill_getlastday(v_interval);
    if (v_counter > v_currmonth) then
      v_arrerpercentage := 2;
    end if;
     
    v_montharrpenalty := ptdmdbill_arrearsPenalty(v_currdemand, v_firsthalfinst, v_secondhalfinst, v_arrerpercentage);
    
    v_arrearspenalty := v_arrearspenalty + v_montharrpenalty;
    if (v_counter > 6 or v_counter < 4) then
    v_firsthalfpercentage := 2;
    if (v_counter > v_currmonth) then
      v_monthfirsthalfpenalty := ptdmdbill_currentPenalty(v_firsthalfpercentage, v_firsthalftax);
      --raise notice 'ptdmdbill_migratedunmodifiedMonthwiseTaxwithpenalty v_monthfirsthalfpenalty %', v_monthfirsthalfpenalty;
    end if;
    v_firsthalfpenalty := v_firsthalfpenalty + v_monthfirsthalfpenalty;
      --raise notice 'ptdmdbill_migratedunmodifiedMonthwiseTaxwithpenalty v_firsthalfpenalty, v_monthfirsthalfpenalty % %', v_firsthalfpenalty, v_monthfirsthalfpenalty;
    end if;
    if (v_counter < 4 or v_counter > 12) then
    v_secondhalfpercentage := 2;
    if (v_counter > v_currmonth) then
      v_monthsecondhalfpenalty := ptdmdbill_currentPenalty(v_secondhalfpercentage, v_secondhalftax);
    end if;
        v_secondhalfpenalty := v_secondhalfpenalty + v_monthsecondhalfpenalty;
    end if;
    v_counter := v_counter + 1;
    v_total := v_arreartax+v_firsthalftax+v_secondhalftax+v_arrearspenalty+v_firsthalfpenalty+v_secondhalfpenalty;
    --raise notice 'ptdmdbill_migratedunmodifiedMonthwiseTaxwithpenalty %', v_paydate;
    insert into eg_demand_bill_details (id,paidbeforedate,arreartax,arrearpenalty,currfirsthalftax,currsecondhalftax,currfirsthalfpenalty,currsecondhalfpenalty,totalamount,egdemandbillid,
    createddate,createdby,lastmodifieddate,lastmodifiedby,water_tax,sewerage_tax) values (nextval('seq_eg_demand_bill_details'),v_paydate,v_arreartax,v_arrearspenalty,v_firsthalftax,v_secondhalftax,
    v_firsthalfpenalty,v_secondhalfpenalty,v_total,v_billpk,now(),1,now(),1,v_wtrtax,v_sewtax);
    
    exit when v_paydate >= v_currfinenddate;
    v_interval := v_interval + 1;
  end loop;
return 1;
exception 
  when others then
    raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % %', SQLERRM, SQLSTATE;
end;
$BODY$ language plpgsql;





CREATE OR REPLACE FUNCTION ptdmdbill_createdunmodifiedassessmentpenalty(
    in_assessmentno character varying,
    v_assessmentdate date,
    in_currinst bigint,
    in_demandid bigint,
    in_currfinenddate timestamp without time zone,
    in_firsthalftax double precision,
    in_secondhalftax double precision,
    in_arreartax double precision,
    in_billpk bigint,
    v_wtrtax double precision,
    v_sewtax double precision)
  RETURNS numeric AS
$BODY$
declare
  v_temp bigint;
  v_peneffdate date;
BEGIN 
  --raise notice 'ptdmdbill_createdunmodifiedassessmentpenalty in_assessmentno, in_currinst, in_moduleid, in_demandid (% % % %)',in_assessmentno, in_currinst, in_moduleid, in_demandid;
  v_peneffdate := lppcalc_getpeneffdate(in_assessmentno, v_assessmentdate);
  --raise notice 'lppcalc_createdunmodifiedassessmentpenalty: v_peneffdate (%)', v_peneffdate;
  v_temp := ptdmdbill_createdunmodifiedMonthwiseTaxwithpenalty(in_assessmentno, in_currinst, in_demandid, in_currfinenddate, in_firsthalftax, in_secondhalftax, in_arreartax, in_billpk, v_peneffdate, v_wtrtax, v_sewtax);
return v_temp;  
exception
  when others then
    raise notice 'ptdmdbill_createdunmodifiedassessmentpenalty, % %',SQLERRM,SQLSTATE;
END;
$BODY$ LANGUAGE plpgsql;





CREATE OR REPLACE FUNCTION ptdmdbill_createdunmodifiedmonthwisetaxwithpenalty(
    in_assessmentno character varying,
    v_currinst bigint,
    v_currdemand bigint,
    v_currfinenddate timestamp without time zone,
    v_firsthalftax double precision,
    v_secondhalftax double precision,
    v_arreartax double precision,
    v_billpk bigint,
    v_peneffdate date,
    v_wtrtax double precision,
    v_sewtax double precision)
  RETURNS bigint AS
$BODY$
declare
  v_paydate date;
  v_interval bigint;
  v_firsthalfpenalty double precision;
  v_secondhalfpenalty double precision;
  v_arrearspenalty double precision;
  v_total double precision;
  v_module bigint;
  v_firsthalfinst bigint;
  v_secondhalfinst bigint;
  v_count integer;
  v_arrerpercentage bigint;
  v_firsthalfpercentage bigint;
  v_secondhalfpercentage bigint;
  v_counter integer;
  rec record;
  v_montharrpenalty double precision;
  v_monthfirsthalfpenalty double precision;
  v_monthsecondhalfpenalty double precision;
  v_paydatestart date;
  v_currmonth bigint;
begin
  --raise notice 'ptdmdbill_createdunmodifiedMonthwiseTaxwithpenalty % % % % % % % ', v_currinst, v_currdemand, v_currfinenddate, v_firsthalftax, v_secondhalftax, v_arreartax, v_billpk;
  v_interval := 1;
  v_currmonth := extract(month from now());
  select id into v_module from eg_module where name = 'Property Tax';
  v_count := 0;
  v_arrearspenalty := 0;
  v_firsthalfpenalty := 0;
  v_secondhalfpenalty := 0;
  for rec in (select inst.id from eg_installment_master inst, financialyear fin where inst.financial_year = fin.financialyear 
  and now() between fin.startingdate and fin.endingdate and inst.id_module = v_module order by inst.start_date)
  loop
    if (v_count = 0) then
      v_firsthalfinst := rec.id;
      v_count := v_count + 1;
    else 
      v_secondhalfinst := rec.id;
    end if;
  end loop;
  v_arrerpercentage := 0;
  v_firsthalfpercentage := 0;
  v_secondhalfpercentage := 0;
  v_counter := v_currmonth;
  loop
    v_montharrpenalty := 0;
    v_monthfirsthalfpenalty := 0;
    v_monthsecondhalfpenalty := 0;
    v_total := 0;
    v_paydate := ptdmdbill_getlastday(v_interval);
    v_paydatestart := date_trunc('month', v_paydate)::date;
    if (v_counter > v_currmonth) then
      v_arrerpercentage := 2;
    end if;
    
    if (v_peneffdate <= v_paydatestart ) then
      v_montharrpenalty := ptdmdbill_arrearsPenalty(v_currdemand, v_firsthalfinst, v_secondhalfinst, v_arrerpercentage);
    end if;
    
    v_arrearspenalty := v_arrearspenalty + v_montharrpenalty;
    if (v_counter > 6 or v_counter < 4 ) then
    v_firsthalfpercentage := 2;
    if (v_peneffdate <= v_paydatestart ) then
    v_monthfirsthalfpenalty := ptdmdbill_currentPenalty(v_firsthalfpercentage, v_firsthalftax);
    end if;
    v_firsthalfpenalty := v_firsthalfpenalty + v_monthfirsthalfpenalty;
    end if;
    if (v_counter < 4 or v_counter > 12) then
    v_secondhalfpercentage := 2;
    if (v_peneffdate <= v_paydatestart ) then
    v_monthsecondhalfpenalty := ptdmdbill_currentPenalty(v_secondhalfpercentage, v_secondhalftax);
    end if;
    v_secondhalfpenalty := v_secondhalfpenalty + v_monthsecondhalfpenalty;
    end if;
    v_counter := v_counter + 1;
    v_total := v_arreartax+v_firsthalftax+v_secondhalftax+v_arrearspenalty+v_firsthalfpenalty+v_secondhalfpenalty;
    --raise notice 'ptdmdbill_createdunmodifiedMonthwiseTaxwithpenalty %', v_paydate;
    insert into eg_demand_bill_details (id,paidbeforedate,arreartax,arrearpenalty,currfirsthalftax,currsecondhalftax,currfirsthalfpenalty,currsecondhalfpenalty,totalamount,egdemandbillid,
    createddate,createdby,lastmodifieddate,lastmodifiedby,water_tax,sewerage_tax) values (nextval('seq_eg_demand_bill_details'),v_paydate,v_arreartax,v_arrearspenalty,v_firsthalftax,v_secondhalftax,
    v_firsthalfpenalty,v_secondhalfpenalty,v_total,v_billpk,now(),1,now(),1,v_wtrtax,v_sewtax);
    
    exit when v_paydate >= v_currfinenddate;
    v_interval := v_interval + 1;
  end loop;
return 1;
exception 
  when others then
    raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % %', SQLERRM, SQLSTATE;
end;
$BODY$ LANGUAGE plpgsql;


create or replace function ptdmdbill_generateforward(wardid bigint , v_noticeType character varying)
returns void as 
$BODY$
declare
  rec record;
  v_temp bigint;
  v_moduleid bigint;
  v_currinst bigint;
begin
  --raise notice 'ptdmdbill_generateforward, wardid (%)', wardid;
  --generating bills for active, non-exempted
  select id into v_moduleid from eg_module where name = 'Property Tax';
  select id into v_currinst from eg_installment_master where financial_year = (select financialyear from financialyear where now() between startingdate and endingdate) and id_module = v_moduleid order by start_date limit 1;
  for rec in (select propertyid from (
    select bp.propertyid, sum(dd.amount - dd.amt_collected) balance from egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand dmd, eg_demand_details dd
    where bp.id = prop.id_basic_property and prop.status in ('A','I') and bp.propertyid is not null and bp.isactive = true and bp.is_bill_created = 'N'
    and prop.isexemptedfromtax = false and prop.id = ptd.id_property and ptd.id_demand = dmd.id and dmd.id_installment = v_currinst 
    and dmd.id = dd.id_demand and bp.id_propertyid in (select id from egpt_propertyid where ward_adm_id = wardid) group by bp.propertyid) temp where balance > 0)
  loop
    v_temp := ptdmdbill_generateforassessment(rec.propertyid,v_noticeType);
  end loop;
  --raise notice 'ptdmdbill_generateforward completed for Ward: (%)', wardid;
end;
$BODY$ language plpgsql;