--Inserts required for migration of Tax Rates
--Demand Reason Master inserts

INSERT INTO EG_DEMAND_REASON_MASTER ( ID, REASONMASTER, "category", ISDEBIT, module, CODE, "order", create_date, modified_date, isdemand) VALUES(nextval('seq_eg_demand_reason_master'), 'Total Residential Tax', (select id from eg_reason_category where code='TAX'), 'N', (select id from eg_module where name='Property Tax'), 'GEN_TAX_RESD', 1, current_timestamp, current_timestamp,'true');

INSERT INTO EG_DEMAND_REASON_MASTER ( ID, REASONMASTER, "category", ISDEBIT, module, CODE, "order", create_date, modified_date, isdemand) VALUES(nextval('seq_eg_demand_reason_master'), 'Total Non Residential Tax', (select id from eg_reason_category where code='TAX'), 'N', (select id from eg_module where name='Property Tax'), 'GEN_TAX_NR', 1, current_timestamp, current_timestamp,'true');

--Demand Reason inserts

Insert into EG_DEMAND_REASON (ID,ID_DEMAND_REASON_MASTER,ID_INSTALLMENT,PERCENTAGE_BASIS,ID_BASE_REASON,create_date,modified_date,GLCODEID) select nextval('seq_eg_demand_reason'), (select id from eg_demand_reason_master where reasonmaster='Total Residential Tax' and module=(select id from eg_module where name='Property Tax')), inst.id, null, null, current_timestamp, current_timestamp, null from eg_installment_master inst where inst.id_module=(select id from eg_module where name='Property Tax') and start_date = (select start_date from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date);

Insert into EG_DEMAND_REASON (ID,ID_DEMAND_REASON_MASTER,ID_INSTALLMENT,PERCENTAGE_BASIS,ID_BASE_REASON,create_date,modified_date,GLCODEID) select nextval('seq_eg_demand_reason'), (select id from eg_demand_reason_master where reasonmaster='Total Non Residential Tax' and module=(select id from eg_module where name='Property Tax')), inst.id, null, null, current_timestamp, current_timestamp, null from eg_installment_master inst where inst.id_module=(select id from eg_module where name='Property Tax') and start_date = (select start_date from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date);

-------------procedure to migrate Appconfig taxrates to Demand Reason Details

create or replace FUNCTION migrateTaxRates() 
RETURNS void as $$
declare
	v_test_result 	  varchar[];
	v_percent	      varchar[];
	v_temp		      varchar;
BEGIN 
	--raise notice 'taxrates_migration assessmentNo (%)', assessmentNo;
	 select value into v_temp from eg_appconfig_values where key_id=(SELECT id FROM EG_APPCONFIG WHERE KEY_NAME='PT_TAXRATES' and module = (select id from eg_module where name='Property Tax'));

	select regexp_split_to_array(v_temp, chr(10)) into v_test_result;

--General Tax Residential
	select regexp_split_to_array(v_test_result[1], E'=') into v_percent;
	raise notice '%,%', v_percent[1], v_percent[2];
	Insert into eg_demand_reason_details (ID,ID_DEMAND_REASON,PERCENTAGE,FROM_DATE,TO_DATE,LOW_LIMIT,HIGH_LIMIT,CREATE_DATE,MODIFIED_DATE,FLAT_AMOUNT,IS_FLATAMNT_MAX) values (nextval('seq_eg_demand_reason_details'),(select id from eg_demand_reason where id_demand_reason_master = (select id from EG_DEMAND_REASON_MASTER where code = v_percent[1] and module=(select id from eg_module where name='Property Tax')) and id_installment = (select id from EG_INSTALLMENT_MASTER where ID_MODULE = (select id from EG_MODULE where name = 'Property Tax') and now() between start_date and end_date)), v_percent[2]::real,to_date('01/10/2016 00:00:00','dd/MM/yyyy HH24:MI:SS'),to_date('31/03/2050 23:59:59','dd/MM/yyyy HH24:MI:SS'),0,0,current_timestamp, current_timestamp,0,0);

--General Tax Non-Residential
	select regexp_split_to_array(v_test_result[2], E'=') into v_percent;
	raise notice '%,%', v_percent[1], v_percent[2];
	Insert into eg_demand_reason_details (ID,ID_DEMAND_REASON,PERCENTAGE,FROM_DATE,TO_DATE,LOW_LIMIT,HIGH_LIMIT,CREATE_DATE,MODIFIED_DATE,FLAT_AMOUNT,IS_FLATAMNT_MAX) values (nextval('seq_eg_demand_reason_details'),(select id from eg_demand_reason where id_demand_reason_master = (select id from EG_DEMAND_REASON_MASTER where code = v_percent[1] and module=(select id from eg_module where name='Property Tax')) and id_installment = (select id from EG_INSTALLMENT_MASTER where ID_MODULE = (select id from EG_MODULE where name = 'Property Tax') and now() between start_date and end_date)), v_percent[2]::real,to_date('01/10/2016 00:00:00','dd/MM/yyyy HH24:MI:SS'),to_date('31/03/2050 23:59:59','dd/MM/yyyy HH24:MI:SS'),0,0,current_timestamp, current_timestamp,0,0);

--Vacant Land Tax
	select regexp_split_to_array(v_test_result[3], E'=') into v_percent;
	raise notice '%,%', v_percent[1], v_percent[2];
	Insert into eg_demand_reason_details (ID,ID_DEMAND_REASON,PERCENTAGE,FROM_DATE,TO_DATE,LOW_LIMIT,HIGH_LIMIT,CREATE_DATE,MODIFIED_DATE,FLAT_AMOUNT,IS_FLATAMNT_MAX) values (nextval('seq_eg_demand_reason_details'),(select id from eg_demand_reason where id_demand_reason_master = (select id from EG_DEMAND_REASON_MASTER where code = v_percent[1] and module=(select id from eg_module where name='Property Tax')) and id_installment = (select id from EG_INSTALLMENT_MASTER where ID_MODULE = (select id from EG_MODULE where name = 'Property Tax') and now() between start_date and end_date)), v_percent[2]::real,to_date('01/10/2016 00:00:00','dd/MM/yyyy HH24:MI:SS'),to_date('31/03/2050 23:59:59','dd/MM/yyyy HH24:MI:SS'),0,0,current_timestamp, current_timestamp,0,0);

--Library Cess
	select regexp_split_to_array(v_test_result[4], E'=') into v_percent;
	raise notice '%,%', v_percent[1], v_percent[2];
	Insert into eg_demand_reason_details (ID,ID_DEMAND_REASON,PERCENTAGE,FROM_DATE,TO_DATE,LOW_LIMIT,HIGH_LIMIT,CREATE_DATE,MODIFIED_DATE,FLAT_AMOUNT,IS_FLATAMNT_MAX) values (nextval('seq_eg_demand_reason_details'),(select id from eg_demand_reason where id_demand_reason_master = (select id from EG_DEMAND_REASON_MASTER where code = v_percent[1] and module=(select id from eg_module where name='Property Tax')) and id_installment = (select id from EG_INSTALLMENT_MASTER where ID_MODULE = (select id from EG_MODULE where name = 'Property Tax') and now() between start_date and end_date)), v_percent[2]::real,to_date('01/10/2016 00:00:00','dd/MM/yyyy HH24:MI:SS'),to_date('31/03/2050 23:59:59','dd/MM/yyyy HH24:MI:SS'),0,0,current_timestamp, current_timestamp,0,0);

--Education Cess
	select regexp_split_to_array(v_test_result[5], E'=') into v_percent;
	raise notice '%,%', v_percent[1], v_percent[2];
	Insert into eg_demand_reason_details (ID,ID_DEMAND_REASON,PERCENTAGE,FROM_DATE,TO_DATE,LOW_LIMIT,HIGH_LIMIT,CREATE_DATE,MODIFIED_DATE,FLAT_AMOUNT,IS_FLATAMNT_MAX) values (nextval('seq_eg_demand_reason_details'),(select id from eg_demand_reason where id_demand_reason_master = (select id from EG_DEMAND_REASON_MASTER where code = v_percent[1] and module=(select id from eg_module where name='Property Tax')) and id_installment = (select id from EG_INSTALLMENT_MASTER where ID_MODULE = (select id from EG_MODULE where name = 'Property Tax') and now() between start_date and end_date)), v_percent[2]::real,to_date('01/10/2016 00:00:00','dd/MM/yyyy HH24:MI:SS'),to_date('31/03/2050 23:59:59','dd/MM/yyyy HH24:MI:SS'),0,0,current_timestamp, current_timestamp,0,0);

update eg_demand_reason_master set code ='TOT_RESD_TAX' where reasonmaster='Total Residential Tax' and module=(select id from eg_module where name='Property Tax');
update eg_demand_reason_master set code ='TOT_NR_RESD_TAX' where reasonmaster='Total Non Residential Tax' and module=(select id from eg_module where name='Property Tax');
	
EXCEPTION
WHEN OTHERS THEN
raise notice 'migrateTaxRates : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

select migrateTaxRates();
