--Procedure to update old consumer number with the current format
CREATE OR REPLACE FUNCTION generateWaterChargesNewConsumerCode()
RETURNS void AS
$BODY$
DECLARE
oldrecord record;
newconsumercode  character varying(50);

BEGIN
	BEGIN
		create sequence SEQ_CONSUMER_NUMBER;
	EXCEPTION
		WHEN OTHERS THEN
		raise notice 'sequence already exists';		
	END;	
	for oldrecord in (select id,consumercode,oldConsumerNumber from egwtr_connection where (length(consumercode)<10 or length(consumercode)>10) order by consumercode)
	loop
		begin
                    select (select code from eg_city)||lpad(nextval('SEQ_CONSUMER_NUMBER')::text,6,'0') into newconsumercode;
                    update egwtr_connection set oldConsumerNumber=consumerCode where id=oldrecord.id;
                    update egwtr_connection set consumercode=newconsumercode where id=oldrecord.id;
		end;
	end loop;
END;
$BODY$ LANGUAGE plpgsql;
