CREATE TABLE eg_stg_sla_escalation_time (
    complainttype character varying(256),
    category character varying(256),
    complainttypeid numeric,
    complainttypecode character varying(256),
    routerlvlsla bigint,lvl1sla bigint,lvl2sla bigint,routerload boolean, lvl1load boolean,lvl2load boolean
);

--DML

insert into eg_stg_sla_escalation_time values ('Non Burning of Street Lights','Street Lighting',(select id from egpgr_complainttype where name='Non Burning of Street Lights'),(select code from egpgr_complainttype where name='Non Burning of Street Lights'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Electric Shock due to street light','Street Lighting',(select id from egpgr_complainttype where name='Electric Shock due to street light'),(select code from egpgr_complainttype where name='Electric Shock due to street light'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Pot hole fill up/Repairs to the damage surface','Engineering',(select id from egpgr_complainttype where name='Pot hole fill up/Repairs to the damage surface'),(select code from egpgr_complainttype where name='Pot hole fill up/Repairs to the damage surface'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Repairs to existing footpath','Engineering',(select id from egpgr_complainttype where name='Repairs to existing footpath'),(select code from egpgr_complainttype where name='Repairs to existing footpath'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Removal of shops in the footpath','Town Planning',(select id from egpgr_complainttype where name='Removal of shops in the footpath'),(select code from egpgr_complainttype where name='Removal of shops in the footpath'),72,24,24);
insert into eg_stg_sla_escalation_time values ('Repairs to the SWD','Engineering',(select id from egpgr_complainttype where name='Repairs to the SWD'),(select code from egpgr_complainttype where name='Repairs to the SWD'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Desilting of Drain','Public Health and Sanitation',(select id from egpgr_complainttype where name='Desilting of Drain'),(select code from egpgr_complainttype where name='Desilting of Drain'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Obstruction of water flow','Engineering',(select id from egpgr_complainttype where name='Obstruction of water flow'),(select code from egpgr_complainttype where name='Obstruction of water flow'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Stagnation of water','Public Health and Sanitation',(select id from egpgr_complainttype where name='Stagnation of water'),(select code from egpgr_complainttype where name='Stagnation of water'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Disposal of removed silt on the Road','Public Health and Sanitation',(select id from egpgr_complainttype where name='Disposal of removed silt on the Road'),(select code from egpgr_complainttype where name='Disposal of removed silt on the Road'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Removal of fallen trees','Public Health and Sanitation',(select id from egpgr_complainttype where name='Removal of fallen trees'),(select code from egpgr_complainttype where name='Removal of fallen trees'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Replacement of Cover for Manholes','Engineering',(select id from egpgr_complainttype where name='Replacement of Cover for Manholes'),(select code from egpgr_complainttype where name='Replacement of Cover for Manholes'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Unauthorised / Illegal construction','Town Planning',(select id from egpgr_complainttype where name='Unauthorised / Illegal construction'),(select code from egpgr_complainttype where name='Unauthorised / Illegal construction'),360,48,48);
insert into eg_stg_sla_escalation_time values ('Violation of DCR/Building bye laws','Town Planning',(select id from egpgr_complainttype where name='Violation of DCR/Building bye laws'),(select code from egpgr_complainttype where name='Violation of DCR/Building bye laws'),360,48,48);
insert into eg_stg_sla_escalation_time values ('Encroachment on the public property','Town Planning',(select id from egpgr_complainttype where name='Encroachment on the public property'),(select code from egpgr_complainttype where name='Encroachment on the public property'),48,24,24);
insert into eg_stg_sla_escalation_time values ('Illegal draining of sewage to SWD/Open site','Public Health and Sanitation',(select id from egpgr_complainttype where name='Illegal draining of sewage to SWD/Open site'),(select code from egpgr_complainttype where name='Illegal draining of sewage to SWD/Open site'),48,24,24);
insert into eg_stg_sla_escalation_time values ('Misuse of Community Hall','Town Planning',(select id from egpgr_complainttype where name='Misuse of Community Hall'),(select code from egpgr_complainttype where name='Misuse of Community Hall'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Maintenance of Parks','Engineering',(select id from egpgr_complainttype where name='Maintenance of Parks'),(select code from egpgr_complainttype where name='Maintenance of Parks'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Maintenance of Playground','Engineering',(select id from egpgr_complainttype where name='Maintenance of Playground'),(select code from egpgr_complainttype where name='Maintenance of Playground'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Repairs to Flyovers/ bridges/ Culverts','Engineering',(select id from egpgr_complainttype where name='Repairs to Flyovers/ bridges/ Culverts'),(select code from egpgr_complainttype where name='Repairs to Flyovers/ bridges/ Culverts'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Repairs to Centre Median','Engineering',(select id from egpgr_complainttype where name='Repairs to Centre Median'),(select code from egpgr_complainttype where name='Repairs to Centre Median'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Repairs to Traffic Island','Engineering',(select id from egpgr_complainttype where name='Repairs to Traffic Island'),(select code from egpgr_complainttype where name='Repairs to Traffic Island'),168,72,24);
insert into eg_stg_sla_escalation_time values ('Unauthorised tree Cutting','Public Health and Sanitation',(select id from egpgr_complainttype where name='Unauthorised tree Cutting'),(select code from egpgr_complainttype where name='Unauthorised tree Cutting'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Parking Issue','Town Planning',(select id from egpgr_complainttype where name='Parking Issue'),(select code from egpgr_complainttype where name='Parking Issue'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Stoppage of Civil Works','Engineering',(select id from egpgr_complainttype where name='Stoppage of Civil Works'),(select code from egpgr_complainttype where name='Stoppage of Civil Works'),48,24,24);
insert into eg_stg_sla_escalation_time values ('Poor quality of work','Engineering',(select id from egpgr_complainttype where name='Poor quality of work'),(select code from egpgr_complainttype where name='Poor quality of work'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Over head cable Wires running in Hapazard manner','Town Planning',(select id from egpgr_complainttype where name='Over head cable Wires running in Hapazard manner'),(select code from egpgr_complainttype where name='Over head cable Wires running in Hapazard manner'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Removal of garbage','Public Health and Sanitation',(select id from egpgr_complainttype where name='Removal of garbage'),(select code from egpgr_complainttype where name='Removal of garbage'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Over flowing of garbage bins','Public Health and Sanitation',(select id from egpgr_complainttype where name='Over flowing of garbage bins'),(select code from egpgr_complainttype where name='Over flowing of garbage bins'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Shifting of garbage bin','Public Health and Sanitation',(select id from egpgr_complainttype where name='Shifting of garbage bin'),(select code from egpgr_complainttype where name='Shifting of garbage bin'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Provision of garbage bin','Public Health and Sanitation',(select id from egpgr_complainttype where name='Provision of garbage bin'),(select code from egpgr_complainttype where name='Provision of garbage bin'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Absenteesim of sweepers','Public Health and Sanitation',(select id from egpgr_complainttype where name='Absenteesim of sweepers'),(select code from egpgr_complainttype where name='Absenteesim of sweepers'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Absenteesim of door to door garbage collector','Public Health and Sanitation',(select id from egpgr_complainttype where name='Absenteesim of door to door garbage collector'),(select code from egpgr_complainttype where name='Absenteesim of door to door garbage collector'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Removal of Debris','Public Health and Sanitation',(select id from egpgr_complainttype where name='Removal of Debris'),(select code from egpgr_complainttype where name='Removal of Debris'),72,24,24);
insert into eg_stg_sla_escalation_time values ('Bio Medical waste/Health hazard waste removal','Public Health and Sanitation',(select id from egpgr_complainttype where name='Bio Medical waste/Health hazard waste removal'),(select code from egpgr_complainttype where name='Bio Medical waste/Health hazard waste removal'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Obstruction of road by Trees branches','Public Health and Sanitation',(select id from egpgr_complainttype where name='Obstruction of road by Trees branches'),(select code from egpgr_complainttype where name='Obstruction of road by Trees branches'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Complaints regarding burial ground','Public Health and Sanitation',(select id from egpgr_complainttype where name='Complaints regarding burial ground'),(select code from egpgr_complainttype where name='Complaints regarding burial ground'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Complaints regarding public toilets','Public Health and Sanitation',(select id from egpgr_complainttype where name='Complaints regarding public toilets'),(select code from egpgr_complainttype where name='Complaints regarding public toilets'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Complaints regarding restaurants / Function halls','Public Health and Sanitation',(select id from egpgr_complainttype where name='Complaints regarding restaurants / Function halls'),(select code from egpgr_complainttype where name='Complaints regarding restaurants / Function halls'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Complaints regarding Dispensary','Public Health and Sanitation',(select id from egpgr_complainttype where name='Complaints regarding Dispensary'),(select code from egpgr_complainttype where name='Complaints regarding Dispensary'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Request for Anti Larval operations - to prevent  Dengue /Malaria etc','Public Health and Sanitation',(select id from egpgr_complainttype where name='Request for Anti Larval operations - to prevent Dengue /Malaria etc'),(select code from egpgr_complainttype where name='Request for Anti Larval operations - to prevent Dengue /Malaria etc'),48,24,24);
insert into eg_stg_sla_escalation_time values ('Mosquito menace','Public Health and Sanitation',(select id from egpgr_complainttype where name='Mosquito menace'),(select code from egpgr_complainttype where name='Mosquito menace'),48,24,24);
insert into eg_stg_sla_escalation_time values ('Dog menace','Public Health and Sanitation',(select id from egpgr_complainttype where name='Dog menace'),(select code from egpgr_complainttype where name='Dog menace'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Burning of garbage','Public Health and Sanitation',(select id from egpgr_complainttype where name='Burning of garbage'),(select code from egpgr_complainttype where name='Burning of garbage'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Unsanitary conditions on the road','Public Health and Sanitation',(select id from egpgr_complainttype where name='Unsanitary conditions on the road'),(select code from egpgr_complainttype where name='Unsanitary conditions on the road'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Unhygeinic conditions because of Slaughter House','Public Health and Sanitation',(select id from egpgr_complainttype where name='Unhygeinic conditions because of Slaughter House'),(select code from egpgr_complainttype where name='Unhygeinic conditions because of Slaughter House'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Unauthorised sale of meat and meat product','Public Health and Sanitation',(select id from egpgr_complainttype where name='Unauthorised sale of meat and meat product'),(select code from egpgr_complainttype where name='Unauthorised sale of meat and meat product'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Stray cattle','Public Health and Sanitation',(select id from egpgr_complainttype where name='Stray cattle'),(select code from egpgr_complainttype where name='Stray cattle'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Illegal slaughtering','Public Health and Sanitation',(select id from egpgr_complainttype where name='Illegal slaughtering'),(select code from egpgr_complainttype where name='Illegal slaughtering'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Stray Pigs','Public Health and Sanitation',(select id from egpgr_complainttype where name='Stray Pigs'),(select code from egpgr_complainttype where name='Stray Pigs'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Death of Stray Animals','Public Health and Sanitation',(select id from egpgr_complainttype where name='Death of Stray Animals'),(select code from egpgr_complainttype where name='Death of Stray Animals'),12,12,12);
insert into eg_stg_sla_escalation_time values ('Unhygienic and improper transport of meat and livestock','Public Health and Sanitation',(select id from egpgr_complainttype where name='Unhygienic and improper transport of meat and livestock'),(select code from egpgr_complainttype where name='Unhygienic and improper transport of meat and livestock'),12,12,12);
insert into eg_stg_sla_escalation_time values ('Improper Sweeping','Public Health and Sanitation',(select id from egpgr_complainttype where name='Improper Sweeping'),(select code from egpgr_complainttype where name='Improper Sweeping'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Broken Bin','Public Health and Sanitation',(select id from egpgr_complainttype where name='Broken Bin'),(select code from egpgr_complainttype where name='Broken Bin'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Garbage lorry with out Net','Public Health and Sanitation',(select id from egpgr_complainttype where name='Garbage lorry with out Net'),(select code from egpgr_complainttype where name='Garbage lorry with out Net'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Transfer Station Smell','Public Health and Sanitation',(select id from egpgr_complainttype where name='Transfer Station Smell'),(select code from egpgr_complainttype where name='Transfer Station Smell'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Spilling of Garbage from lorry','Public Health and Sanitation',(select id from egpgr_complainttype where name='Spilling of Garbage from lorry'),(select code from egpgr_complainttype where name='Spilling of Garbage from lorry'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Complaints related to property tax','Revenue',(select id from egpgr_complainttype where name='Complaints related to property tax'),(select code from egpgr_complainttype where name='Complaints related to property tax'),120,48,48);
insert into eg_stg_sla_escalation_time values ('Complaints related to issue of Trade License','Revenue',(select id from egpgr_complainttype where name='Complaints related to issue of Trade License'),(select code from egpgr_complainttype where name='Complaints related to issue of Trade License'),120,48,48);
insert into eg_stg_sla_escalation_time values ('Complaints regarding Voter list','Election',(select id from egpgr_complainttype where name='Complaints regarding Voter list'),(select code from egpgr_complainttype where name='Complaints regarding Voter list'),144,48,48);
insert into eg_stg_sla_escalation_time values ('Inclusion, delection of correction in the Voter list','Election',(select id from egpgr_complainttype where name='Inclusion, delection of correction in the Voter list'),(select code from egpgr_complainttype where name='Inclusion, delection of correction in the Voter list'),144,48,48);
insert into eg_stg_sla_escalation_time values ('Complaints regarding Schools','Administration',(select id from egpgr_complainttype where name='Complaints regarding Schools'),(select code from egpgr_complainttype where name='Complaints regarding Schools'),72,24,24);
insert into eg_stg_sla_escalation_time values ('Unauthorised Advt. Boards','Town Planning',(select id from egpgr_complainttype where name='Unauthorised Advt. Boards'),(select code from egpgr_complainttype where name='Unauthorised Advt. Boards'),72,24,24);
insert into eg_stg_sla_escalation_time values ('Fevers - Dengue/Malaria/ Gastro-enteritis','Public Health and Sanitation',(select id from egpgr_complainttype where name='Fevers - Dengue/Malaria/ Gastro-enteritis'),(select code from egpgr_complainttype where name='Fevers - Dengue/Malaria/ Gastro-enteritis'),48,24,24);
insert into eg_stg_sla_escalation_time values ('Food adulteration: Road Side Eateries','Public Health and Sanitation',(select id from egpgr_complainttype where name='Food adulteration: Road Side Eateries'),(select code from egpgr_complainttype where name='Food adulteration: Road Side Eateries'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Issues relating to Vacant lands','Public Health and Sanitation',(select id from egpgr_complainttype where name='Issues relating to Vacant lands'),(select code from egpgr_complainttype where name='Issues relating to Vacant lands'),72,48,24);
insert into eg_stg_sla_escalation_time values ('New Property Tax Fixation','Revenue',(select id from egpgr_complainttype where name='New Property Tax Fixation'),(select code from egpgr_complainttype where name='New Property Tax Fixation'),120,48,48);
insert into eg_stg_sla_escalation_time values ('New Vacant Land tax Fixation','Revenue',(select id from egpgr_complainttype where name='New Vacant Land tax Fixation'),(select code from egpgr_complainttype where name='New Vacant Land tax Fixation'),120,48,48);
insert into eg_stg_sla_escalation_time values ('Property Tax Bifurcation','Revenue',(select id from egpgr_complainttype where name='Property Tax Bifurcation'),(select code from egpgr_complainttype where name='Property Tax Bifurcation'),120,48,48);
insert into eg_stg_sla_escalation_time values ('Revision Petition on Property Tax','Revenue',(select id from egpgr_complainttype where name='Revision Petition on Property Tax'),(select code from egpgr_complainttype where name='Revision Petition on Property Tax'),720,48,48);
insert into eg_stg_sla_escalation_time values ('Transfer of Title of property','Revenue',(select id from egpgr_complainttype where name='Transfer of Title of property'),(select code from egpgr_complainttype where name='Transfer of Title of property'),168,48,24);
insert into eg_stg_sla_escalation_time values ('Vacancy Remission','Revenue',(select id from egpgr_complainttype where name='Vacancy Remission'),(select code from egpgr_complainttype where name='Vacancy Remission'),720,48,24);
insert into eg_stg_sla_escalation_time values ('Issues relating to Advertisement Boards','Town Planning',(select id from egpgr_complainttype where name='Issues relating to Advertisement Boards'),(select code from egpgr_complainttype where name='Issues relating to Advertisement Boards'),168,48,24);
insert into eg_stg_sla_escalation_time values ('Vaddi Leni Runalu','UPA',(select id from egpgr_complainttype where name='Vaddi Leni Runalu'),(select code from egpgr_complainttype where name='Vaddi Leni Runalu'),72,48,24);
insert into eg_stg_sla_escalation_time values ('Non Receipt of Pensions (Disabled/ Old age/ Widow)','UPA',(select id from egpgr_complainttype where name='Non Receipt of Pensions (Disabled/ Old age/ Widow)'),(select code from egpgr_complainttype where name='Non Receipt of Pensions (Disabled/ Old age/ Widow)'),72,48,24);
insert into eg_stg_sla_escalation_time values ('Sanction of Gas Connection Under Deepam Scheme','UPA',(select id from egpgr_complainttype where name='Sanction of Gas Connection Under Deepam Scheme'),(select code from egpgr_complainttype where name='Sanction of Gas Connection Under Deepam Scheme'),168,48,24);
insert into eg_stg_sla_escalation_time values ('Complaints regarding all Sanctioned loans','UPA',(select id from egpgr_complainttype where name='Complaints regarding all Sanctioned loans'),(select code from egpgr_complainttype where name='Complaints regarding all Sanctioned loans'),168,48,24);
insert into eg_stg_sla_escalation_time values ('Contamination of Water','Water Supply',(select id from egpgr_complainttype where name='Contamination of Water'),(select code from egpgr_complainttype where name='Contamination of Water'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Issues Related to Drinking Water Supply','Water Supply',(select id from egpgr_complainttype where name='Issues Related to Drinking Water Supply'),(select code from egpgr_complainttype where name='Issues Related to Drinking Water Supply'),48,24,24);
insert into eg_stg_sla_escalation_time values ('Repair Bore wells','Water Supply',(select id from egpgr_complainttype where name='Repair Bore wells'),(select code from egpgr_complainttype where name='Repair Bore wells'),48,24,24);
insert into eg_stg_sla_escalation_time values ('Water pipe leakage','Water Supply',(select id from egpgr_complainttype where name='Water pipe leakage'),(select code from egpgr_complainttype where name='Water pipe leakage'),48,24,24);
insert into eg_stg_sla_escalation_time values ('UGD Over Flow','Engineering',(select id from egpgr_complainttype where name='UGD Over Flow'),(select code from egpgr_complainttype where name='UGD Over Flow'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Hanging of Streetlight Wires','Streetlight',(select id from egpgr_complainttype where name='Hanging of Streetlight Wires'),(select code from egpgr_complainttype where name='Hanging of Streetlight Wires'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Unauthorised Road cutting','Engineering',(select id from egpgr_complainttype where name='Unauthorised Road cutting'),(select code from egpgr_complainttype where name='Unauthorised Road cutting'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Complaints regarding function Halls','Public Health and Sanitation',(select id from egpgr_complainttype where name='Complaints regarding function Halls'),(select code from egpgr_complainttype where name='Complaints regarding function Halls'),24,24,24);
insert into eg_stg_sla_escalation_time values ('Unclaimed Dead Bodies','Public Health and Sanitation',(select id from egpgr_complainttype where name='Unclaimed Dead Bodies'),(select code from egpgr_complainttype where name='Unclaimed Dead Bodies'),12,12,12);
insert into eg_stg_sla_escalation_time values ('Errors in demand Notice','Revenue',(select id from egpgr_complainttype where name='Errors in demand Notice'),(select code from egpgr_complainttype where name='Errors in demand Notice'),168,48,48);
insert into eg_stg_sla_escalation_time values ('Double Assessments','Revenue',(select id from egpgr_complainttype where name='Double Assessments'),(select code from egpgr_complainttype where name='Double Assessments'),168,48,48);
insert into eg_stg_sla_escalation_time values ('Non Sanction of Bank Linkage to the group','UPA',(select id from egpgr_complainttype where name='Non Sanction of Bank Linkage to the group'),(select code from egpgr_complainttype where name='Non Sanction of Bank Linkage to the group'),168,48,24);
insert into eg_stg_sla_escalation_time values ('Provision of Placement after Training under ESTP','UPA',(select id from egpgr_complainttype where name='Provision of Placement after Training under ESTP'),(select code from egpgr_complainttype where name='Provision of Placement after Training under ESTP'),168,48,24);
insert into eg_stg_sla_escalation_time values ('Disputes in SSG / SLF / TLF','UPA',(select id from egpgr_complainttype where name='Disputes in SSG / SLF / TLF'),(select code from egpgr_complainttype where name='Disputes in SSG / SLF / TLF'),168,48,24);



---------------------FUNCTION----------------------

CREATE OR REPLACE FUNCTION load_escalation_slahrs()
  RETURNS void AS
$BODY$
declare
comp_type_id numeric default 0;
comp_type_name varchar(200);
comp_type_code varchar(200);
routersla numeric default 0;
lvl1slah numeric default 0;
lvl2slah numeric default 0;
cur_stg_obj eg_stg_sla_escalation_time%ROWTYPE;
router_obj egpgr_router%ROWTYPE;
rout_pos numeric default 0;
rout_desig numeric default 0;
lvl1pos numeric default 0;
lvl2pos numeric default 0;
lvl1desig numeric default 0;
lvl2desig numeric default 0;
rout_obj_cnt numeric default 0;
begin
RAISE NOTICE 'begin---';

for cur_stg_obj in(select * from eg_stg_sla_escalation_time)
loop
begin
	comp_type_id:=cur_stg_obj.complainttypeid;
	comp_type_name:=cur_stg_obj.complainttype;
	comp_type_code:=cur_stg_obj.complainttypecode;
	routersla:=cur_stg_obj.routerlvlsla;
	lvl1slah:=cur_stg_obj.lvl1sla;
	lvl2slah:=cur_stg_obj.lvl2sla;
	rout_obj_cnt:=(select count(*) from egpgr_router where complainttypeid=comp_type_id);
  RAISE NOTICE 'Inside eg_stg_sla_escalation_time ';
  if(comp_type_id is not null and rout_obj_cnt > 0) then
	    for router_obj in (select * from egpgr_router where complainttypeid=comp_type_id)
		 loop
		 begin	
		   RAISE NOTICE 'Inside egpgr_router';
		   rout_pos:=router_obj.position;
		   RAISE NOTICE 'Inside egpgr_router % %',rout_pos,comp_type_id;
		   rout_desig:=(select designation from egeis_deptdesig  where id  in (select deptdesig from eg_position where id=rout_pos));

				if(rout_pos is not null and rout_desig is not null) then
					update egpgr_escalation set no_of_hrs=routersla where complaint_type_id=comp_type_id and designation_id=rout_desig;
					IF NOT FOUND THEN
						update eg_stg_sla_escalation_time set routerload=false where complainttype=comp_type_name and routerlvlsla=routersla;
					else	
						update eg_stg_sla_escalation_time set routerload=true where complainttype=comp_type_name and routerlvlsla=routersla;
					end if;
		   
						if(rout_pos is not null) then
							lvl1pos:=(select position_to from egeis_position_hierarchy where position_from=rout_pos and object_sub_type=comp_type_code);
							lvl1desig:=(select designation from egeis_deptdesig  where id  in (select deptdesig from eg_position where id=lvl1pos));
							update egpgr_escalation set no_of_hrs=lvl1slah where complaint_type_id=comp_type_id and designation_id=lvl1desig;
							IF NOT FOUND THEN
								update eg_stg_sla_escalation_time set lvl1load=false where complainttype=comp_type_name and routerlvlsla=routersla and lvl1sla=lvl1slah;
							else	
								update eg_stg_sla_escalation_time set lvl1load=true where complainttype=comp_type_name and routerlvlsla=routersla and lvl1sla=lvl1slah;
							end if;
							if(lvl1pos is not null) then
								lvl2pos:=(select position_to from egeis_position_hierarchy where position_from=lvl1pos and object_sub_type=comp_type_code);
								lvl2desig:=(select designation from egeis_deptdesig  where id  in (select deptdesig from eg_position where id=lvl2pos));
								update egpgr_escalation set no_of_hrs=lvl2slah where complaint_type_id=comp_type_id and designation_id=lvl2desig ;
								IF NOT FOUND THEN
									update eg_stg_sla_escalation_time set lvl2load=false where complainttype=comp_type_name and routerlvlsla=routersla and lvl1sla = lvl1slah and lvl2sla = lvl2slah;
								else	
									update eg_stg_sla_escalation_time set lvl2load=true where complainttype=comp_type_name and routerlvlsla=routersla and lvl1sla = lvl1slah and lvl2sla = lvl2slah;
								end if;
							else
								update eg_stg_sla_escalation_time set lvl2load=false where complainttype=comp_type_name and routerlvlsla=routersla and lvl1sla = lvl1slah and lvl2sla = lvl2slah;
							end if;
						else
							update eg_stg_sla_escalation_time set lvl1load=false,lvl2load=false where complainttype=comp_type_name and routerlvlsla=routersla and lvl1sla = lvl1slah and lvl2sla = lvl2slah;
						end if;
				else 
					update eg_stg_sla_escalation_time set routerload=false,lvl1load=false,lvl2load=false where complainttype=comp_type_name and routerlvlsla=routersla and lvl1sla = lvl1slah and lvl2sla = lvl2slah;
				end if;
			end;
		end loop;
  else
	update eg_stg_sla_escalation_time set routerload=false,lvl1load=false,lvl2load=false where complainttype=comp_type_name and routerlvlsla=routersla and lvl1sla = lvl1slah and lvl2sla = lvl2slah;
end if;
end;
end loop;
end;
$BODY$
  LANGUAGE plpgsql;
---------------------END----------------------

  select load_escalation_slahrs();

