--FULL ULB rollover
CREATE OR REPLACE FUNCTION wtms_AmountCollectedRecords_RegenerateDemand_Full_Rollover()
RETURNS void AS
$BODY$
DECLARE
props record;
v_temp bigint;
v_temp1 bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_moduleid bigint;

BEGIN
	
	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date('01/04/2016', 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date('01/10/2016', 'dd/MM/yyyy');
	

	for props in (select id,name from eg_boundary where id in (select distinct(ward_adm_id)
	from egpt_propertyid where id in (select id_propertyid from egpt_basic_property where 
	propertyid in (SELECT distinct conn.propertyidentifier FROM 
	egwtr_connection conn, egwtr_connectiondetails conndet, egw_status status WHERE 
	conn.id=conndet.connection and conndet.connectionstatus='ACTIVE' and 
	conndet.connectiontype='NON_METERED' AND conndet.statusid=status.id 
	and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED'
	and EXISTS (SELECT demConn.* from egwtr_demand_connection demConn where 
	conndet.id=demConn.connectiondetails and EXISTS (select egDemand.* from
	eg_demand egDemand where demConn.demand=egDemand.id  and EXISTS 
	(select demDetail.* from eg_demand_details demDetail where
	egDemand.id=demDetail.id_demand and EXISTS (select dmcoll.* from egdm_collected_receipts 
	dmcoll where demDetail.id=dmcoll.id_demand_detail) and demDetail.id_demand_reason in
	(select id from eg_demand_reason where 
	id_demand_reason_master in (select id from eg_demand_reason_master
	where code='WTAXCHARGES' and module=(select id from eg_module where name='Water Tax Management')) 
	and id_installment in (v_new1st_instid,v_new2nd_instid)))))))))
	loop 
		begin
			v_temp  := wtms_demand_collected_RegeDemand_rolloverward(props.id,v_new1st_instid,v_new2nd_instid);
			
		EXCEPTION
		WHEN OTHERS THEN
		raise notice ' rolloverward For FULL ULB  % %',SQLERRM, SQLSTATE;
		END;
	END LOOP;
	
END;
$BODY$ LANGUAGE plpgsql;


--for waterrates changed and non_collection records
--FULL ULB rollover
CREATE OR REPLACE FUNCTION wtms_Ulb_waterratesChanged_RegenerateDemand_Rollover()
RETURNS void AS
$BODY$
DECLARE
props record;
v_temp bigint;
v_temp1 bigint;
v_new2nd_instid bigint;
v_new1st_instid bigint;
v_moduleid bigint;
BEGIN
	
	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date('01/04/2016', 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date('01/10/2016', 'dd/MM/yyyy');
	
	for props in (select id,name from eg_boundary where id in(select distinct(ward_adm_id) from egpt_propertyid where 
		id in(select id_propertyid from egpt_basic_property where propertyid 
		in(select propertyidentifier from egwtr_connection where id in
		(SELECT distinct conndet.connection FROM egwtr_connection conn,egwtr_connectiondetails conndet, egw_status status
		WHERE conn.id=conndet.connection and conndet.connectionstatus='ACTIVE' and conndet.connectiontype='NON_METERED' 
		AND conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' 
		and  EXISTS (select demConn.* from egwtr_demand_connection demConn where 
	   	conndet.id=demConn.connectiondetails and NOT EXISTS (select demDetail.id_demand 
	   	from eg_demand_details demDetail where demConn.demand=demDetail.id_demand and EXISTS 
	   	(select dmcoll.* from egdm_collected_receipts dmcoll where demDetail.id=dmcoll.id_demand_detail) 
	   	and demDetail.id_demand_reason in(select id from eg_demand_reason where id_demand_reason_master in 
		(select id from eg_demand_reason_master where code='WTAXCHARGES' 
		and module=(select id from eg_module where name='Water Tax Management')
		)and id_installment in (v_new1st_instid,v_new2nd_instid)))))))))
	loop 
		begin
			v_temp  := wtms_RegeDemand_waterrateschnaged_rolloverward(props.id,'01/10/2015','01/04/2016','01/04/2016','01/10/2016');
			
		EXCEPTION
		WHEN OTHERS THEN
		raise notice ' rolloverward For FULL ULB  % %',SQLERRM, SQLSTATE;
		END;
	END LOOP;
	
END;
$BODY$ LANGUAGE plpgsql;


--ward wise rollover
CREATE OR REPLACE FUNCTION wtms_RegeDemand_waterrateschnaged_rolloverward(in_wardid bigint,in_oldinststartdate1 varchar(16), in_oldinststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
props record;
v_oldinstid bigint;
v_new1st_instid bigint;
v_oldinstid1 bigint;
v_new2nd_instid bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_newInstId integer;
v_temp integer;
v_rollovercount integer default 0;
BEGIN
	raise notice 'rolloverward : in_wardid, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate (% % % %)', in_wardid, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate;
	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_oldinstid1 from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate1, 'dd/MM/yyyy');
	select id into v_oldinstid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');
	raise notice 'rolloverward : v_oldinstid, v_new1st_instid, v_new2nd_instid,ward (% % % %)', v_oldinstid, v_new1st_instid, v_new2nd_instid,in_wardid;

	for props in (SELECT distinct conn.consumercode,conndet.id  FROM egwtr_connection conn,egwtr_connectiondetails conndet, egpt_basic_property bp, egpt_property p, egpt_propertyid pid,egw_status status
		WHERE conn.id=conndet.connection and conndet.connectionstatus='ACTIVE' and conndet.connectiontype='NON_METERED' 
		and bp.id = p.id_basic_property and bp.id_propertyid = pid.id and bp.propertyid=conn.propertyidentifier 
		AND conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' 
		and EXISTS (select demConn.* from egwtr_demand_connection demConn where 
	   	conndet.id=demConn.connectiondetails and NOT EXISTS (select demDetail.id_demand 
	   	from eg_demand_details demDetail where demConn.demand=demDetail.id_demand and EXISTS 
	   	(select dmcoll.* from egdm_collected_receipts dmcoll where 
	   	demDetail.id=dmcoll.id_demand_detail) 
	   	and demDetail.id_demand_reason in(select id from eg_demand_reason where id_demand_reason_master in 
		(select id from eg_demand_reason_master where code='WTAXCHARGES' 
		and module=(select id from eg_module where name='Water Tax Management')
		)and id_installment in (v_new1st_instid,v_new2nd_instid)))) 
		AND pid.ward_adm_id = in_wardid )
	loop 
		begin
			raise notice 'rolloverward : Started for consumernumber, idconnectiondetail (% %)', props.consumercode, props.id;
			v_temp  := wtms_RegeDemand_waterrateschanged_rollover(props.id, v_oldinstid1,v_oldinstid, v_new1st_instid, v_new2nd_instid);
			v_rollovercount := v_rollovercount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice ' rolloverward conndetId  and consumercode: % % % %',props.id,props.consumercode,SQLERRM, SQLSTATE;
		END;
	END LOOP;
	raise notice 'wtms_RegeDemand_rolloverward completed for Ward: (%)', in_wardid;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION wtms_RegeDemand_waterrateschanged_rollover(in_idconndetail bigint,in_oldinstid1 bigint, in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_olddemandid bigint;
v_newdemandid bigint;
v_newConnDemand bigint;
v_temp integer;
v_glcodeid bigint;
v_iddemResmaster bigint;
v_newdemand_reason bigint;
v_newdemand_reason2 bigint;
v_demandAmountfromWtRate double precision;
v_newbase_demnd double precision;
v_demandreasoninst1 bigint;
v_demandreasoninst2 bigint;
v_demandexistforInstallment bigint;
v_firstinstallmentAmount1 double precision;
BEGIN
	raise notice 'rollover : in_idconndetail, in_oldinstid, in_new_1stinstid, in_new_2ndinstid (% % % %)', in_idconndetail, in_oldinstid, in_new_1stinstid, in_new_2ndinstid;
	select max(conndem.demand) into v_olddemandid from eg_demand d, egwtr_demand_connection conndem where d.id = conndem.demand and d.is_history='N' and conndem.connectiondetails = in_idconndetail;
    select id into v_glcodeid from chartofaccounts where glcode='1405016';
	select id into v_iddemResmaster from eg_demand_reason_master where code='WTAXCHARGES';
	SELECT id into v_demandreasoninst1 from eg_demand_reason where id_demand_reason_master=v_iddemResmaster and id_installment=in_new_1stinstid;
	-- demandReason entry for installments
	--1st Half
	
	raise notice '  v_olddemandid( %)',v_olddemandid;
	if(v_demandreasoninst1 is not null) then
		raise notice 'rolloversingleconnection : DemandReason is already exists for this first Installment';
	else
		SELECT nextval('SEQ_EG_DEMAND_REASON') INTO v_newdemand_reason;
		insert into eg_demand_reason(id, id_demand_reason_master, id_installment, percentage_basis, id_base_reason, create_date, modified_date, glcodeid) values (v_newdemand_reason, v_iddemResmaster, in_new_1stinstid, null,null,now(),now(), v_glcodeid);
	end if;

	raise notice '1st half  demand reason created';--2nd Half
	SELECT id into v_demandreasoninst2 from eg_demand_reason where id_demand_reason_master =v_iddemResmaster and id_installment=in_new_2ndinstid;
 
	if(v_demandreasoninst2 is not null) then
		raise notice 'rolloversingleconnection : DemandReason is already exists for this second Installment';
	else
		SELECT nextval('SEQ_EG_DEMAND_REASON') INTO v_newdemand_reason2;
		insert into eg_demand_reason(id, id_demand_reason_master, id_installment, percentage_basis, id_base_reason, create_date, modified_date, glcodeid) values (v_newdemand_reason2, v_iddemResmaster, in_new_2ndinstid, null,null,now(),now(), v_glcodeid);
	end if;
	raise notice '2nd half demand reason created';
	
	select (waterratedet.monthlyrate*6) into v_demandAmountfromWtRate from egwtr_water_rates_details waterratedet where waterratedet.waterratesheader in (select wthead.id from egwtr_water_rates_header wthead, egwtr_connectiondetails conndet where wthead.connectiontype='NON_METERED' and wthead.connectiontype=conndet.connectiontype and wthead.usagetype=conndet.usagetype and wthead.pipesize=conndet.pipesize and wthead.watersource=conndet.watersource and wthead.active=true and conndet.id=in_idconndetail);
	
	raise notice 'v_demandAmountfromWtRate (%)' ,v_demandAmountfromWtRate;
	if(v_demandAmountfromWtRate is not null)then
			select nextval('SEQ_EG_DEMAND') into v_newdemandid;
			select (base_demand)  into v_newbase_demnd from  eg_demand where id = v_olddemandid and is_history='N';
			insert into eg_demand (id, id_installment, base_demand, is_history, create_date, modified_date,
			amt_collected, status, min_amt_payable, amt_rebate) 
			select v_newdemandid, in_new_1stinstid, v_newbase_demnd,
			is_history, now(), now(),amt_collected, status, null, 0 from eg_demand where id = v_olddemandid;
			raise notice 'new demand created for consumercode ';
			
			--copying old demand_demand_details to new eg_demand.
			insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date,
			create_date, amt_collected, amt_rebate) 
			select nextval('seq_eg_demand_details'), v_newdemandid, id_demand_reason, id_status,
			file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate 
			from eg_demand_details where id_demand = v_olddemandid
			and id_demand_reason not in(1906,1907)
			and id_demand in(select id from eg_demand where id_installment=in_oldinstid) ;
			
			raise notice 'copied old demand_demand_details to new eg_demand';
			
			update eg_demand set is_history='Y' where id=v_olddemandid;
			
			v_temp := wtms_demandRegenerate_createddforannual(v_demandAmountfromWtRate ,v_olddemandid, v_newdemandid, in_oldinstid, in_new_1stinstid, in_new_2ndinstid);
			--creating new egwtr_demand_connection for new demand.
		 	SELECT nextval('seq_egwtr_demand_connection') INTO v_newConnDemand;
		   	insert into egwtr_demand_connection (id,demand, connectiondetails,createdby,createddate,lastmodifieddate,lastmodifiedby,version) values (v_newConnDemand,v_newdemandid,in_idconndetail,1,now(),now(),1,0);
			return v_temp;
        	else
        	raise notice 'No Water Rates present so No demand generation';
        end if;
END;
$BODY$ LANGUAGE plpgsql;