create or replace function ptdmdbill_generateCurrentInstDetails(v_currdemand bigint, v_billpk bigint, v_instid bigint, v_installment character varying(24))
returns double precision as
$BODY$
declare
  v_gentax double precision;
  v_vaclandtax double precision;
  v_libcess double precision;
  v_educess double precision;
  v_uacpenalty double precision;
  v_totaltax double precision;
  rec record;
begin
  --raise notice 'ptdmdbill_generateCurrentInstDetails v_currdemand, v_billpk, v_installment (% % %)', v_currdemand, v_billpk, v_installment;
  v_gentax := 0;
  v_vaclandtax := 0;
  v_libcess := 0;
  v_educess := 0;
  v_uacpenalty := 0;
  v_totaltax := 0;
  for rec in (select drm.code, dd.amount-dd.amt_collected balance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = v_instid and dd.id_demand = v_currdemand) 
  loop
    if rec.code = 'GEN_TAX' then
      v_gentax := coalesce(rec.balance, 0);
    elsif rec.code = 'VAC_LAND_TAX' then
      v_vaclandtax := coalesce(rec.balance, 0);
    elsif rec.code = 'LIB_CESS' then
      v_libcess := coalesce(rec.balance, 0);
    elsif rec.code = 'EDU_CESS' then
      v_educess := coalesce(rec.balance, 0);
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_uacpenalty := coalesce(rec.balance, 0);
    end if;
    --raise notice 'ptdmdbill_generateCurrentInstDetails v_gentax, v_vaclandtax, v_libcess, v_educess, v_uacpenalty (% % % % %)',v_gentax, v_vaclandtax, v_libcess, v_educess, v_uacpenalty;
  end loop;
	v_gentax := v_gentax+v_vaclandtax;
  	v_totaltax := v_gentax+v_libcess+v_educess+v_uacpenalty;
	--raise notice 'ptdmdbill_generateCurrentInstDetails v_gentax, v_libcess, v_educess, v_uacpenalty, v_totaltax (% % % % %)',v_gentax, v_libcess, v_educess, v_uacpenalty, v_totaltax;
  	insert into eg_demand_inst_details(id,installment,generaltax,educationtax,librarycess,unauthorizedpenalty,totaltax,egdemandbillid,createddate,createdby,lastmodifieddate,lastmodifiedby)
  	values (nextval('seq_eg_demand_inst_details'),v_installment,v_gentax,v_educess,v_libcess,v_uacpenalty,v_totaltax,v_billpk,now(),1,now(),1);
return v_totaltax;
exception
  when others then
    raise notice 'ptdmdbill_generateCurrentInstDetails % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;
