create or replace function lppcalc_migratepenaltyward(in_wardid bigint)
returns void as 
$$
declare
  v_moduleid bigint;
  v_currinst bigint;
  v_assessmento character varying(16);
  v_demandid bigint;
  proprec record;
  v_temp bigint;
begin
  --raise notice 'lppcalc_migratepenaltyward: in_wardid (%)', in_wardid;
  select id into v_moduleid from eg_module where name='Property Tax';
  select id into v_currinst from eg_installment_master where id_module = v_moduleid and now() between start_date and end_date;
  for proprec in (select mv.upicno, cd.id_demand from egpt_mv_propertyinfo mv, egpt_mv_bp_curr_demand cd where cd.id_basic_property = mv.basicpropertyid and ((aggregate_arrear_demand - arrearcollection) > 0 or (annualdemand-annualcoll) > 0) and mv.isexempted = false and mv.isactive = true and mv.wardid = in_wardid)
  loop 
    begin
      v_assessmento := proprec.upicno;
      v_demandid := proprec.id_demand;
      --raise notice 'lppcalc_migratepenaltyward: v_demandid, v_assessmento (% %)', v_demandid, v_assessmento;
      v_temp := lppcalc_migratepenaltyassessment(v_assessmento, v_currinst, v_moduleid, v_demandid);
    END;
  end loop;
exception
  when others then
    raise notice 'lppcalc_migratepenaltyward % %', SQLERRM, SQLSTATE;
end;
$$ language plpgsql;

create or replace function lppcalc_migratepenaltyassessment(in_assessmentno character varying(16), in_currinst bigint, in_moduleid bigint, in_demandid bigint)
returns bigint as
$$
declare
  v_category character varying(20);
  v_ismigrated boolean;
  v_ismodified boolean;
  v_basicpropid bigint;
  v_temp bigint;
  v_assessmentdate date;
begin
  --raise notice 'lppcalc_migratepenaltyassessment: in_assessmentno, in_currinst, in_moduleid, in_demandid  (% % % %)', in_assessmentno, in_currinst, in_moduleid, in_demandid;
  select id, assessmentdate into v_basicpropid, v_assessmentdate from egpt_basic_property where propertyid = in_assessmentno;
  v_ismigrated := lppcalc_ismigrated(in_assessmentno);
  v_ismodified := lppcalc_modifiedinerp(v_basicpropid);
    
  if (v_ismodified) then
    v_temp := lppcalc_modifiedassessmentpenalty(in_assessmentno,in_currinst,in_moduleid,in_demandid);
  else
    if (v_ismigrated) then
      v_temp := lppcalc_migratedunmodifiedassessmentpenalty(in_assessmentno,in_currinst,in_moduleid,in_demandid,v_assessmentdate);
    else
      v_temp := lppcalc_createdunmodifiedassessmentpenalty(in_assessmentno,in_currinst,in_moduleid,in_demandid,v_assessmentdate);
    end if;
  end if;
return v_temp;
exception
  when others then
    raise notice 'lppcalc_migratepenaltyassessment: % %', SQLERRM, SQLSTATE;
end;
$$ language plpgsql;

create or replace function lppcalc_modifiedassessmentpenalty(in_assessmentno varchar(16), in_currinst IN bigint, in_moduleid IN bigint, in_demandid IN bigint) 
RETURNS numeric as $$
declare
  v_temp bigint;
  v_oldpropid bigint;
  v_olddemandid bigint;
  v_alteration_date date;
  v_graceperioddate date;
  v_peneffdate date;
  v_undergone_rp boolean;
BEGIN 
  --raise notice 'lppcalc_modifiedassessmentpenalty: in_assessmentno, in_currinst, in_moduleid, in_demandid (% % % %)',in_assessmentno, in_currinst, in_moduleid, in_demandid;
  select id into v_oldpropid from egpt_property where id_basic_property = (select id from egpt_basic_property where propertyid = in_assessmentno) 
    and status = 'H' order by modified_date desc limit 1;
    
  select dmd.id into v_olddemandid from eg_demand dmd, egpt_ptdemand ptd, eg_installment_master inst where ptd.id_property = v_oldpropid and ptd.id_demand = dmd.id and dmd.id_installment = inst.id and inst.installment_year = (
  select max(installment_year) from eg_installment_master where id in (select id_installment from eg_demand where id in (select id_demand from egpt_ptdemand where id_property = v_oldpropid)));
  
  select modified_date into v_alteration_date from egpt_property_status_values where id_basic_property = (select id_basic_property from egpt_property where id = v_oldpropid) 
  and id_status in (select id from egpt_status where code in ('ADD_OR_ALTER', 'BIFURCATE', 'RP')) and is_active = 'Y' order by id desc limit 1;
  
  v_peneffdate := lppcalc_getpeneffdate(in_assessmentno, v_alteration_date);
  --raise notice 'lppcalc_modifiedassessmentpenalty: v_peneffdate (%)',v_peneffdate;
  if (now() < v_peneffdate) then
    v_temp := lppcalc_addmonthpenaltyonolddemand(in_assessmentno, in_currinst, in_moduleid, in_demandid, v_olddemandid, v_alteration_date);
  else
    v_temp := lppcalc_addmonthpenalty(in_assessmentno, in_currinst, in_moduleid, in_demandid, v_alteration_date);
  end if;   
return v_temp;	
exception
  when others then
    raise notice 'lppcalc_modifiedassessmentpenalty, % %',SQLERRM,SQLSTATE;
END;
$$ LANGUAGE plpgsql;

create or replace function lppcalc_migratedunmodifiedassessmentpenalty(in_assessmentno varchar(16), in_currinst IN bigint, in_moduleid IN bigint, in_demandid IN bigint, v_assessmentdate date) 
RETURNS numeric as $$
declare
  v_temp bigint;
BEGIN 
  --raise notice 'lppcalc_migratedunmodifiedassessmentpenalty: in_assessmentno, in_currinst, in_moduleid, in_demandid (% % % %)',in_assessmentno, in_currinst, in_moduleid, in_demandid;
  v_temp := lppcalc_addmonthpenalty(in_assessmentno, in_currinst, in_moduleid, in_demandid, v_assessmentdate);
return v_temp;
exception
  when others then
    raise notice 'lppcalc_migratedunmodifiedassessmentpenalty, % %',SQLERRM,SQLSTATE;
END;
$$ LANGUAGE plpgsql;


create or replace function lppcalc_createdunmodifiedassessmentpenalty(in_assessmentno varchar(16), in_currinst IN bigint, in_moduleid IN bigint, in_demandid IN bigint, v_assessmentdate date) 
RETURNS numeric as $$
declare
  v_temp bigint;
  v_graceperioddate date;
  v_peneffdate date;
BEGIN 
  --raise notice 'lppcalc_createdunmodifiedassessmentpenalty: in_assessmentno, in_currinst, in_moduleid, in_demandid, v_assessmentdate (% % % % %)',in_assessmentno, in_currinst, in_moduleid, in_demandid, v_assessmentdate;
  v_peneffdate := lppcalc_getpeneffdate(in_assessmentno, v_assessmentdate);
  --raise notice 'lppcalc_createdunmodifiedassessmentpenalty: v_peneffdate (%)', v_peneffdate;
  if (v_peneffdate <= now()) then
    v_temp := lppcalc_addmonthpenalty(in_assessmentno, in_currinst, in_moduleid, in_demandid,v_assessmentdate);
  end if;
return v_temp;
exception
  when others then
    raise notice 'lppcalc_createdunmodifiedassessmentpenalty, % %',SQLERRM,SQLSTATE;
END;
$$ LANGUAGE plpgsql;

create or replace function lppcalc_getpeneffdate(in_assessmentno varchar(16), in_assesseddate date) 
returns date as
$$
declare
  v_day bigint;
  v_peneffdate date;
  v_undergone_rp boolean;
  v_graceperioddate date;
begin
  --raise notice 'lppcalc_getpeneffdate: in_assessmentno, in_assesseddate (% %)',in_assessmentno, in_assesseddate;
  v_undergone_rp := lppcalc_undergone_rp(in_assessmentno, in_assesseddate);
  --raise notice 'lppcalc_getpeneffdate: v_undergone_rp (%)',v_undergone_rp;
  if (v_undergone_rp) then
    v_graceperioddate := in_assesseddate + interval '90' day;
  else
    v_graceperioddate := in_assesseddate + interval '60' day;
  end if;
  v_day := extract(day from v_graceperioddate);
  if (v_day >=1 and v_day <=15) then
    v_peneffdate := v_graceperioddate;
  else 
    v_peneffdate := v_graceperioddate + interval '1' month;
  end if;  
  v_peneffdate := date_trunc('month', v_peneffdate)::date;
  --raise notice 'lppcalc_getpeneffdate: v_peneffdate (%)',v_peneffdate;
return v_peneffdate;
exception
  when others then
    raise notice 'lppcalc_getpeneffdate, % %',SQLERRM,SQLSTATE;
end;
$$ LANGUAGE plpgsql;

create or replace function lppcalc_undergone_rp(in_assessmentno varchar(16), in_assesseddate date) 
returns boolean as
$$
declare
  v_undergone_rp boolean;
  v_statusid bigint;
begin
  select id into v_statusid from egpt_property_status_values where id_basic_property = (select id from egpt_basic_property where propertyid = in_assessmentno) 
  and id_status = (select id from egpt_status where code = 'RP') and is_active = 'Y' and created_date >= in_assesseddate order by created_date desc limit 1;
  return case when v_statusid is null then false else true end;
exception
  when others then
    raise notice 'lppcalc_undergone_rp, % %',SQLERRM,SQLSTATE;
end;
$$ LANGUAGE plpgsql;

create or replace function lppcalc_addmonthpenalty(in_assessmentno varchar(16), in_currinst IN bigint, in_moduleid IN bigint, in_demandid IN bigint, v_assessmentdate date) 
RETURNS numeric as $$
declare
  v_temp bigint; 
  v_idinst bigint; 
  v_inst varchar(16);
  v_tax double precision;
  v_penalty double precision;
  dcbrec record;
  v_currmonth bigint;
BEGIN 
  --raise notice 'lppcalc_addmonthpenalty: in_assessmentno, in_currinst, in_moduleid, in_demandid (% % % %)',in_assessmentno, in_currinst, in_moduleid, in_demandid;
  for dcbrec in (select inst.id, inst.description, sum(dd.amount - dd.amt_collected) balance
  from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst
  where dd.id_demand = in_demandid
  and dd.id_demand_reason = dr.id
  and dr.id_installment = inst.id
  and inst.start_date <= now()
  and dr.id_demand_reason_master in (select id from eg_demand_reason_master where module = in_moduleid and code in ('GEN_TAX','VAC_LAND_TAX','LIB_CESS','EDU_CESS','UNAUTH_PENALTY'))
  group by inst.description, inst.id order by inst.description, inst.id)
  loop 
    begin
      v_inst := dcbrec.description;
      v_idinst := dcbrec.id;
      v_tax := dcbrec.balance;
      v_penalty := 0;
      
      --raise notice 'lppcalc_addmonthpenalty v_inst, v_idinst, v_tax (% % %)', v_inst, v_idinst, v_tax;
      if (v_tax > 0) then
	v_penalty := lppcalc_getcalculatedpenalty(v_idinst, in_currinst, v_tax, v_assessmentdate);
	
	--raise notice 'lppcalc_addmonthpenalty v_penalty (%)', v_penalty;
	if(v_penalty > 0) then
	  v_temp := lppcalc_createorupdatemonthlyinterest(in_demandid, getDemandReason(v_idinst, 'PENALTY_FINES', in_moduleid), round(v_penalty), now()::date);
	end if;
      end if;
    END;
  END LOOP;
return v_temp;
EXCEPTION
  WHEN OTHERS THEN
    raise notice 'lppcalc_addmonthpenalty : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

create or replace function lppcalc_addmonthpenaltyonolddemand(in_assessmentno varchar(16), in_currinst IN bigint, in_moduleid IN bigint, in_demandid IN bigint, in_olddemandid IN bigint, v_alteration_date IN date) 
RETURNS numeric as $$
declare
  v_temp bigint; 
  v_idinst bigint; 
  v_inst varchar(16);
  v_tax double precision;
  v_penalty double precision;
  dcbrec record;
BEGIN 
  --raise notice 'lppcalc_addmonthpenaltyonolddemand: in_assessmentno, in_currinst, in_moduleid, in_demandid, in_olddemandid (% % % % %)',in_assessmentno, in_currinst, in_moduleid, in_demandid, in_olddemandid;
  for dcbrec in (select inst.id, inst.description
  from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst
  where dd.id_demand = in_demandid
  and dd.id_demand_reason = dr.id
  and dr.id_installment = inst.id
  and inst.start_date <= now()
  and dr.id_demand_reason_master in (select id from eg_demand_reason_master where module = in_moduleid and code in ('GEN_TAX','VAC_LAND_TAX','LIB_CESS','EDU_CESS','UNAUTH_PENALTY'))
  group by inst.description, inst.id order by inst.description, inst.id)
  loop 
    begin
      v_inst := dcbrec.description;
      v_idinst := dcbrec.id;
      v_penalty := 0;
      
      select coalesce(sum(amount - amt_collected), 0) into v_tax from eg_demand_details where id_demand_reason in (select id from eg_demand_reason where id_installment = v_idinst) and id_demand = in_olddemandid;
      
      --raise notice 'lppcalc_addmonthpenaltyonolddemand v_inst, v_idinst, v_tax (% % %)', v_inst, v_idinst, v_tax;
      if (v_tax > 0) then
	v_penalty := lppcalc_getcalculatedpenalty(v_idinst, in_currinst, v_tax, v_alteration_date);
	
	--raise notice 'lppcalc_addmonthpenaltyonolddemand v_penalty (%)', v_penalty;
	if(v_penalty > 0) then
	  v_temp := lppcalc_createorupdatemonthlyinterest(in_demandid, getDemandReason(v_idinst, 'PENALTY_FINES', in_moduleid), round(v_penalty), now()::date);
	end if;
      end if;
    END;
  END LOOP;
return v_temp;
EXCEPTION
  WHEN OTHERS THEN
    raise notice 'lppcalc_addmonthpenaltyonolddemand : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

create or replace function lppcalc_getcalculatedpenalty(v_idinst IN bigint, in_currinst IN bigint, v_tax IN double precision, v_assessmentdate date) 
RETURNS double precision as $$
declare
  v_penalty double precision;
  v_currmonth bigint;
  assessed_installemnt bigint;
BEGIN 
  --raise notice 'lppcalc_getcalculatedpenalty: v_idinst, in_currinst, v_tax (% % %)',v_idinst, in_currinst, v_tax;
  v_penalty := 0;
  if (v_idinst != in_currinst) then
    v_penalty := v_tax * 0.02;--calcualting for one month
  else 
    v_currmonth := extract(month from now());
    if ((v_currmonth > 6 and v_currmonth <= 9) or (v_currmonth >=1 and v_currmonth <=3)) then
      v_penalty := v_tax * 0.02;--calcualting for one month
    end if;   
  end if;
  --raise notice 'lppcalc_getcalculatedpenalty: v_penalty (%)',v_penalty;
return v_penalty;
end;
$$ language plpgsql;
	
create or replace FUNCTION lppcalc_createorupdatemonthlyinterest(in_demandid IN bigint, idDemandRsn IN bigint, taxAmount IN double precision, assessmentdate IN date) 
RETURNS numeric as $$
declare
  v_dmddetpk bigint;  
  v_ddid bigint;  
BEGIN 
  --raise notice 'lppcalc_createorupdatemonthlyinterest in_demandid, idDemandRsn, taxAmount, assessmentdate (% % % %)',in_demandid, idDemandRsn, taxAmount, assessmentdate;
  select id into v_ddid from eg_demand_details where id_demand = in_demandid and id_demand_reason = idDemandRsn;
  --raise notice 'createorupdatepenalty v_ddid (%)', v_ddid;
  if (v_ddid is not null) then
    update eg_demand_details set amount = amount + taxAmount where id = v_ddid;
  else
    select nextval('seq_eg_demand_details') into v_dmddetpk;
    INSERT INTO eg_demand_details(id, id_demand, id_demand_reason, amount, modified_date, create_date, amt_collected)
    VALUES (v_dmddetpk, in_demandid, idDemandRsn, taxAmount, assessmentdate, assessmentdate, 0);
  end if;
  --raise notice 'lppcalc_createorupdatemonthlyinterest updated';
return v_dmddetpk;
EXCEPTION
  WHEN OTHERS THEN
    raise notice 'lppcalc_createorupdatemonthlyinterest : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

create or replace function lppcalc_ismigrated(in_assessmentno character varying(16))
  returns boolean as $$
declare
  v_source character varying(1);
begin
  select source into v_source from egpt_basic_property where propertyid = in_assessmentno;
  return case when v_source = 'M' then true else false end;
exception
  when others then
    raise notice 'lppcalc_ismigrated : % %', SQLERRM, SQLSTATE;
end; 
$$ language plpgsql;

create or replace function lppcalc_modifiedinerp(in_basicpropid bigint)
returns boolean as
$$
declare
  v_count bigint;
  v_modified boolean default false;
begin
  select count(*) into v_count from egpt_property_status_values where id_basic_property = in_basicpropid and id_status in (select id  from egpt_status where code in ('ADD_OR_ALTER', 'BIFURCATE', 'RP')) and is_active = 'Y';
  if (v_count > 0) then
    v_modified := true;
  end if;
return v_modified;
exception when others then
  raise notice 'lppcalc_modifiedinerp: % %', SQLERRM, SQLSTATE;
  return false;
end;
$$ language plpgsql;
