--PROCEDURE to load 


-- Recovery: load_recovery()

CREATE OR REPLACE FUNCTION load_recovery()
  RETURNS void AS
$$
declare
tds_glcode varchar(10); 
tds_remitted varchar(200);
tds_detailtype varchar(20);
tds_recoveryname varchar(200);
tds_isactive boolean default false;
tds_seq bigint;
COAdetail_seq bigint;

isTdsExists boolean default true;
isDetailTypeSame boolean default true;
isDetailTypeSameforSupplier boolean default true;
isSLcodeExists boolean default true;
cur_tds temp_tds%ROWTYPE;
begin



for cur_tds  in( select * from temp_tds)
loop
begin
tds_glcode:= cur_tds.glcode;
tds_detailtype:=cur_tds.detailtype;
tds_remitted:=cur_tds.remitted;
tds_recoveryname:=cur_tds.recoveryname;
tds_isactive:=cur_tds.isactive;


-- Check tds is already exist for given code
isTdsExists:=tds_exist(tds_glcode);

--If exist then check Detail type is same or different

if(isTdsExists=true) then

--if detailtype is contractor then
if(upper(tds_detailtype)='CONTRACTOR') then
isDetailTypeSame:=detailType_exist(tds_glcode,tds_detailtype);
--tds_detailtype:='SUPPLIER';
isDetailTypeSameforSupplier:=detailType_exist(tds_glcode,'SUPPLIER');


if(isDetailTypeSame=true) then
if(isDetailTypeSameforSupplier=true) then
RAISE NOTICE 'TDS  exist with same detail type%',tds_detailtype;
end if;
if(isDetailTypeSameforSupplier=false) then
select nextval('seq_chartofaccountdetail') into COAdetail_seq;
RAISE NOTICE 'COAdetail_seq %',COAdetail_seq;
insert into chartofaccountdetail(id,glcodeid,detailtypeid,createdby,createddate) values(COAdetail_seq,(select  id from chartofaccounts 
where glcode =tds_glcode),(select id from accountdetailtype where upper(name)='SUPPLIER'),1,current_date);

end if;

end if;
if(isDetailTypeSame=false) then
if(isDetailTypeSameforSupplier=false) then
select nextval('seq_chartofaccountdetail') into COAdetail_seq;
RAISE NOTICE 'COAdetail_seq %',COAdetail_seq;
insert into chartofaccountdetail(id,glcodeid,detailtypeid,createdby,createddate) values(COAdetail_seq,(select  id from chartofaccounts 
where glcode =tds_glcode),(select id from accountdetailtype where upper(name)='SUPPLIER'),1,current_date);

end if;
select nextval('seq_chartofaccountdetail') into COAdetail_seq;
RAISE NOTICE 'COAdetail_seq %',COAdetail_seq;
insert into chartofaccountdetail(id,glcodeid,detailtypeid,createdby,createddate) values(COAdetail_seq,(select  id from chartofaccounts 
where glcode =tds_glcode),(select id from accountdetailtype where upper(name)=tds_detailtype),1,current_date);
end if;
end if;

--detail type is not a contractor then

if(tds_detailtype!='CONTRACTOR') then
isDetailTypeSame:=detailType_exist(tds_glcode,tds_detailtype);
if(isDetailTypeSame=true) then
RAISE NOTICE 'TDS  exist with same detail type%',tds_detailtype;
end if;
if(isDetailTypeSame=false) then
select nextval('seq_chartofaccountdetail') into COAdetail_seq;
RAISE NOTICE 'COAdetail_seq %',COAdetail_seq;
insert into chartofaccountdetail(id,glcodeid,detailtypeid,createdby,createddate) values(COAdetail_seq,(select  id from chartofaccounts 
where glcode =tds_glcode),(select id from accountdetailtype where upper(name)=tds_detailtype),1,current_date);
end if;
end if;
end if;

------------------------------------------------------
--TDS does not exist
if(isTdsExists=false) then
RAISE NOTICE 'TDS does not exist %',tds_glcode; 
--if detailtype is contractor then
if(upper(tds_detailtype)='CONTRACTOR') then
isDetailTypeSame:=detailType_exist(tds_glcode,tds_detailtype);
--tds_detailtype:='SUPPLIER';
isDetailTypeSameforSupplier:=detailType_exist(tds_glcode,'SUPPLIER');


if(isDetailTypeSame=true) then
if(isDetailTypeSameforSupplier=true) then
RAISE NOTICE 'COAdetail  exist with given detail type%',tds_detailtype;
end if;
if(isDetailTypeSameforSupplier=false) then
select nextval('seq_chartofaccountdetail') into COAdetail_seq;
RAISE NOTICE 'COAdetail_seq %',COAdetail_seq;
insert into chartofaccountdetail(id,glcodeid,detailtypeid,createdby,createddate) values(COAdetail_seq,(select  id from chartofaccounts 
where glcode =tds_glcode),(select id from accountdetailtype where upper(name)='SUPPLIER'),1,current_date);

end if;
select nextval('seq_tds') into tds_seq;

RAISE NOTICE 'tds_seq %',tds_seq;
insert into tds(id,type,glcodeid,remitted,recoveryname,isactive,partytypeid,createddate,createdby,version) values(tds_seq,tds_glcode,(select  id from chartofaccounts 
where glcode =tds_glcode),tds_remitted,tds_recoveryname,tds_isactive,(select id from eg_partytype where upper(code)=upper(tds_detailtype)),current_date,1,0);

end if;

if(isDetailTypeSame=false) then
if(isDetailTypeSameforSupplier=false) then
select nextval('seq_chartofaccountdetail') into COAdetail_seq;
RAISE NOTICE 'COAdetail_seq %',COAdetail_seq;
insert into chartofaccountdetail(id,glcodeid,detailtypeid,createdby,createddate) values(COAdetail_seq,(select  id from chartofaccounts 
where glcode =tds_glcode),(select id from accountdetailtype where upper(name)='SUPPLIER'),1,current_date);

end if;

select nextval('seq_chartofaccountdetail') into COAdetail_seq;
RAISE NOTICE 'COAdetail_seq %',COAdetail_seq;
insert into chartofaccountdetail(id,glcodeid,detailtypeid,createdby,createddate) values(COAdetail_seq,(select  id from chartofaccounts 
where glcode =tds_glcode),(select id from accountdetailtype where upper(name)=tds_detailtype),1,current_date);

select nextval('seq_tds') into tds_seq;

RAISE NOTICE 'tds_seq %',tds_seq;
insert into tds(id,type,glcodeid,remitted,recoveryname,isactive,partytypeid,createddate,createdby,version) values(tds_seq,tds_glcode,(select  id from chartofaccounts 
where glcode =tds_glcode),tds_remitted,tds_recoveryname,tds_isactive,(select id from eg_partytype where upper(code)=upper(tds_detailtype)),current_date,1,0);


end if;
end if;

--detail type is not a contractor then

if(tds_detailtype!='CONTRACTOR') then
isSLcodeExists:=detailType_exist(tds_glcode,tds_detailtype);

--COA detail having glcode and detailtype
RAISE NOTICE 'isSLcodeExists%',isSLcodeExists;
if(isSLcodeExists=true) then

select nextval('seq_tds') into tds_seq;

RAISE NOTICE 'tds_seq %',tds_seq;
insert into tds(id,type,glcodeid,remitted,recoveryname,isactive,partytypeid,createddate,createdby,version) values(tds_seq,tds_glcode,(select  id from chartofaccounts 
where glcode =tds_glcode),tds_remitted,tds_recoveryname,tds_isactive,(select id from eg_partytype where upper(code)=upper(tds_detailtype)),current_date,1,0);

end if;

--insertion
if(isSLcodeExists=false) then
select nextval('seq_chartofaccountdetail') into COAdetail_seq;
RAISE NOTICE 'COAdetail_seq %',COAdetail_seq;
insert into chartofaccountdetail(id,glcodeid,detailtypeid,createdby,createddate) values(COAdetail_seq,(select  id from chartofaccounts 
where glcode =tds_glcode),(select id from accountdetailtype where upper(name)=tds_detailtype),1,current_date);

select nextval('seq_tds') into tds_seq;

RAISE NOTICE 'tds_seq %',tds_seq;
insert into tds(id,type,glcodeid,remitted,recoveryname,isactive,partytypeid,createddate,createdby,version) values(tds_seq,tds_glcode,(select  id from chartofaccounts 
where glcode =tds_glcode),tds_remitted,tds_recoveryname,tds_isactive,(select id from eg_partytype where upper(code)=upper(tds_detailtype)),current_date,1,0);


end if;
end if;
end if;
end;
end loop;
end;
$$ LANGUAGE plpgsql ;

----------------------------------------------------

--Function: tds_exist(character varying)

CREATE OR REPLACE FUNCTION tds_exist(glcodes character varying)
  RETURNS boolean AS
$$
declare isexist boolean default true;
begin
PERFORM id from tds where glcodeid=(select id from chartofaccounts where glcode=glcodes);
IF NOT FOUND THEN
RAISE NOTICE 'Inside TDS glcode Unique checking %',glcodes;
isexist:=false;
END IF;
return isexist;
end;
$$  LANGUAGE plpgsql;

-----------------------------------------------------------


--Function: detailType_exist(character varying,character varying)

CREATE OR REPLACE FUNCTION detailType_exist(glcodes character varying,detailtype character varying)
  RETURNS boolean AS
$$
declare isexist boolean default true;
begin
PERFORM id from chartofaccountdetail where glcodeid=(select id from chartofaccounts where glcode=glcodes) and detailtypeid=(select id from accountdetailtype where upper(name)=detailtype);
IF NOT FOUND THEN
RAISE NOTICE 'Inside TDS  glcode and  detail type Unique checking %',glcodes;
RAISE NOTICE 'Inside TDS  glcode and  detail type Unique checking %',detailtype;
isexist:=false;
END IF;
return isexist;
end;
$$ LANGUAGE plpgsql;




