CREATE OR REPLACE FUNCTION migrateremittancedatawithoutvoucher()
  RETURNS void AS
$BODY$
declare
	v_temp 	bigint;  
	account record;
	v_accountid bigint;
	remittancedata record;
	v_remittancepk bigint;
	v_functionid bigint;
	v_fundid bigint;
	v_remittancedetailspk bigint;
	v_status bigint;
	v_receiptid bigint;
	v_receiptdate timestamp without time zone;
	v_createdby bigint;
	v_cashamount numeric;
	v_chequeamount numeric;
	v_glcodeid bigint;
	v_debitamount numeric;
	v_serviceid bigint;
	v_receiptIds character varying;
	v_referencenumber character varying;
	
BEGIN 
	for account in (select distinct ba.id as accountid, ba.fundid, sd.id as serviceid  from BANKACCOUNT ba, EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.BANKACCOUNT=ba.ID and asm.servicedetails=sd.ID and fd.ID=ba.FUNDID and exists (select ch.* from egcl_collectionheader ch where sd.id=ch.servicedetails and ch.status=(select id from egw_status where code='REMITTED' and moduletype='ReceiptHeader') and not exists (select cr.* from egcl_collectionremittance cr where cr.collectionheader=ch.id)))
	loop 
		begin
		select nextval('seq_egcl_remittance') into v_remittancepk;
		select id from egw_status where moduletype ='Remittance' and code='APPROVED' into v_status;
		select id from eg_user where username ='egovernments' into v_createdby;
		select id from function where code='0301' into v_functionid;
		v_fundid = account.fundid;
		v_accountid = account.accountid;
		v_serviceid = account.serviceid;
		v_referencenumber= getremittancereferencenumber(now());
		raise notice 'v_referencenumber>>>>>:::::::::: %', v_referencenumber;
		raise notice 'v_remittancepk>>>>>:::::::::: %', v_remittancepk;
		INSERT INTO egcl_remittance(id, version, referencenumber, referencedate, status, fund, function, createdby, createddate, lastmodifiedby, lastmodifieddate,bankaccount) VALUES (v_remittancepk, 0,v_referencenumber, now(), v_status, v_fundid,v_functionid, v_createdby, now(), v_createdby, now(), v_accountid);
		for remittancedata in (select RECEIPTDATE,sum(CASHAMOUNT) as CASHAMOUNT,sum(CHEQUEDDAMOUNT) AS CHEQUEDDAMOUNT from ((SELECT  (CASE WHEN it.TYPE='cash' THEN ih.INSTRUMENTAMOUNT END) AS CASHAMOUNT,0 AS CHEQUEDDAMOUNT,date(ch.RECEIPTDATE) AS RECEIPTDATE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm, FUND fnd,EG_DEPARTMENT dpt where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS in (select distinct asm.servicedetails from EGCL_BANKACCOUNTSERVICEMAPPING asm,bankaccount ba where ba.id=asm.bankaccount and ba.id=v_accountid and ba.fundid=v_fundid) and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and fnd.id = v_fundid AND ch.source='SYSTEM' and it.TYPE in ('cash') and ih.ISPAYCHEQUE='0' AND ch.status =(select id from egw_status where code='REMITTED' and moduletype='ReceiptHeader') and not exists (select cr.* from egcl_collectionremittance cr where cr.collectionheader=ch.id) and exists (select ci1.* from egcl_collectioninstrument ci1 where ci1.collectionheader=ch.id and exists (select iod.* from egf_instrumentotherdetails iod where ci1.instrumentheader=iod.instrumentheaderid and payinslipid is null)) order by RECEIPTDATE) union (SELECT 0 AS CASHAMOUNT,(CASE WHEN it.TYPE in ('cheque','dd') THEN ih.INSTRUMENTAMOUNT END) AS CHEQUEDDAMOUNT, date(ch.RECEIPTDATE) AS RECEIPTDATE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih, EGCL_COLLECTIONINSTRUMENT ci, EGCL_SERVICEDETAILS sd, EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm, FUND fnd,EG_DEPARTMENT dpt where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS in (select distinct asm.servicedetails from EGCL_BANKACCOUNTSERVICEMAPPING asm,bankaccount ba where ba.id=asm.bankaccount and ba.id=v_accountid and ba.fundid=v_fundid) and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and fnd.id=v_fundid AND ch.source='SYSTEM' and it.TYPE in ('cheque', 'dd') and ih.ISPAYCHEQUE='0' AND ch.status =(select id from egw_status where code = 'REMITTED' and moduletype='ReceiptHeader') and not exists (select cr.* from egcl_collectionremittance cr where cr.collectionheader=ch.id) and exists (select ci1.* from egcl_collectioninstrument ci1 where ci1.collectionheader=ch.id and exists (select iod.* from egf_instrumentotherdetails iod where ci1.instrumentheader=iod.instrumentheaderid and payinslipid is null)) order by RECEIPTDATE)) AS RESULT group by date(RECEIPTDATE))
		loop
		begin
			v_receiptdate=remittancedata.receiptdate;
			v_cashamount=remittancedata.cashamount;
			v_chequeamount=remittancedata.chequeddamount;
			v_debitamount:=0;
			raise notice 'v_receiptdate>>>>>:::::::::: %', v_receiptdate;
			if v_cashamount > 0 THEN
		    		select nextval('seq_egcl_remittancedetails') into v_remittancedetailspk;
				select id from chartofaccounts where purposeid  = (select id from egf_accountcode_purpose where name ='Cash In Hand') into v_glcodeid;
				v_debitamount := v_debitamount + v_cashamount;
				INSERT INTO egcl_remittancedetails(id, remittance, chartofaccount, creditamount, debitamount) VALUES (v_remittancedetailspk, v_remittancepk,v_glcodeid, v_cashamount, 0);
			END IF;
			if v_chequeamount > 0 THEN
				select nextval('seq_egcl_remittancedetails') into v_remittancedetailspk;
				select id from chartofaccounts where purposeid  = (select id from egf_accountcode_purpose where name ='Cheque In Hand') into v_glcodeid;
				v_debitamount := v_debitamount + v_chequeamount;
				INSERT INTO egcl_remittancedetails(id, remittance, chartofaccount, creditamount, debitamount) VALUES (v_remittancedetailspk, v_remittancepk,v_glcodeid, v_chequeamount, 0);
			END IF;
			IF v_debitamount > 0 THEN
	    			select nextval('seq_egcl_remittancedetails') into v_remittancedetailspk;
				select glcodeid from bankaccount where id=v_accountid into v_glcodeid;
				INSERT INTO egcl_remittancedetails(id, remittance, chartofaccount, creditamount, debitamount) VALUES (v_remittancedetailspk, v_remittancepk,v_glcodeid, 0, v_debitamount);
			END IF;
		end;
		end loop;
		v_referencenumber=getremittancereferencenumber(v_receiptdate);
		raise notice 'v_referencenumber>>>>>:::::::::: %', v_referencenumber;
		raise notice 'v_remittancepk>>>>>:::::::::: %', v_remittancepk;
		update egcl_remittance set referencenumber=v_referencenumber,referencedate=v_receiptdate where id=v_remittancepk;
       		INSERT INTO egcl_collectionremittance(collectionheader, remittance) (select distinct(ch.id),v_remittancepk from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih, EGCL_COLLECTIONINSTRUMENT ci, EGCL_SERVICEDETAILS sd, EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm, FUND fnd,EG_DEPARTMENT dpt where ch.id=cm.collectionheader  and date(ch.receiptdate)=v_receiptdate AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS in (select distinct asm.servicedetails from EGCL_BANKACCOUNTSERVICEMAPPING asm,bankaccount ba where ba.id=asm.bankaccount and ba.id=v_accountid and ba.fundid=v_fundid) and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and fnd.id=v_fundid AND ch.source='SYSTEM' and it.TYPE in ('cash','cheque', 'dd') and ih.ISPAYCHEQUE='0' AND ch.status =(select id from egw_status where code = 'REMITTED' and moduletype='ReceiptHeader') and not exists (select cr.* from egcl_collectionremittance cr where cr.collectionheader=ch.id) and exists (select ci1.* from egcl_collectioninstrument ci1 where ci1.collectionheader=ch.id and exists (select iod.* from egf_instrumentotherdetails iod where ci1.instrumentheader=iod.instrumentheaderid and payinslipid is null)));
		EXCEPTION	
		WHEN OTHERS THEN
		raise notice 'migrateremittancedetails insert : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
EXCEPTION
WHEN OTHERS THEN
raise notice 'migrateremittancedata : % %', SQLERRM, SQLSTATE;
END;
$BODY$
LANGUAGE plpgsql;

/*delete from egcl_collectionremittance where remittance in (select id from egcl_remittance where voucherheader is null);
delete from egcl_remittancedetails where remittance in (select id from egcl_remittance where voucherheader is null);
delete from egcl_remittance where voucherheader is null;

select migrateremittancedatawithoutvoucher(); */