CREATE OR REPLACE FUNCTION getremittancereferencenumber(referencedate timestamp without time zone)
  RETURNS character varying AS
$BODY$
declare
	referencenumber character varying (30);
	nextsequencenumber character varying(10);
	finYear character varying(10);
	month character varying(10);
begin
	SELECT trim(to_char(nextval('sq_remittance2016'), '000000')) into nextsequencenumber;
	select financialyear from  financialyear where referencedate between startingdate and endingdate into finYear; 
	select extract(MONTH from referencedate) into month;
	referencenumber = 'REM/'||nextsequencenumber || '/' || month || '/' || finYear;
	return trim(referencenumber);
end;
$BODY$
LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION getremittancereferencenumber(referencedate timestamp with time zone)
  RETURNS character varying AS
$BODY$
declare
	referencenumber character varying (30);
	nextsequencenumber character varying(10);
	finYear character varying(10);
	month character varying(10);
begin
	SELECT trim(to_char(nextval('sq_remittance2016'), '000000')) into nextsequencenumber;
	select financialyear from  financialyear where referencedate between startingdate and endingdate into finYear; 
	select extract(MONTH from referencedate) into month;
	referencenumber = 'REM/'||nextsequencenumber || '/' || month || '/' || finYear;
	return trim(referencenumber);
end;
$BODY$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION migrateremittancedatawithvoucher()
  RETURNS void AS
$BODY$
declare
	v_temp 	bigint;  
	receipts record;
	remittancedata record;
	v_remittancepk bigint;
	v_functionid bigint;
	v_fundid bigint;
	v_voucherheaderid bigint;
	v_remittancedetailspk bigint;
	v_status bigint;
	v_receiptid bigint;
	v_voucherdate timestamp without time zone;
	v_createdby bigint;
	v_referencenumber character varying;
	
BEGIN 
	for receipts in (select ch.id from egcl_collectionheader ch where ch.status =(select id from egw_status where code = 'REMITTED') and not exists (select cr.* 
from egcl_collectionremittance cr where cr.collectionheader=ch.id) and ch.id in (select collectionheader from egcl_collectioninstrument where instrumentheader in 
(select id from egf_instrumentotherdetails where payinslipid is not null)))
	loop 
		begin
		select nextval('seq_egcl_remittance') into v_remittancepk;
		select id from egw_status where moduletype ='Remittance' and code='APPROVED' into v_status;
		select id from eg_user where username ='egovernments' into v_createdby;
		v_receiptid = receipts.id;
		v_referencenumber=getremittancereferencenumber(now());
		INSERT INTO egcl_remittance(id, version, referencenumber, referencedate, status, createdby, createddate, lastmodifiedby, lastmodifieddate) VALUES (v_remittancepk,0,v_referencenumber, now(), v_status, v_createdby, now(), v_createdby, now());
		raise notice 'v_receiptid>>>>> %', v_receiptid;
		for remittancedata in(select ch.id,ci.instrumentheader, gl.glcodeid, gl.creditamount, gl.debitamount, gl.functionid, vh.fundid, gl.voucherheaderid,vh.voucherdate,vh.createdby from egcl_collectionheader ch, egcl_collectioninstrument ci, 
egf_instrumentotherdetails iod, generalledger gl, voucherheader vh where ch.status =(select id from egw_status where code = 'REMITTED') and ch.id=ci.collectionheader and ci.instrumentheader=iod.instrumentheaderid and iod.payinslipid=gl.voucherheaderid and vh.id=gl.voucherheaderid and ch.id=v_receiptid and not exists (select cr.* from egcl_collectionremittance cr where cr.collectionheader=ch.id))
		loop
			begin
				v_functionid = remittancedata.functionid;
				v_fundid = remittancedata.fundid;
				v_voucherheaderid=remittancedata.voucherheaderid;
				v_voucherdate=remittancedata.voucherdate;
				v_createdby = remittancedata.createdby;
				select nextval('seq_egcl_remittancedetails') into v_remittancedetailspk;

				INSERT INTO egcl_remittancedetails(id, remittance, chartofaccount, creditamount, debitamount) VALUES (v_remittancedetailspk, v_remittancepk,remittancedata.glcodeid, remittancedata.creditamount, remittancedata.debitamount);
			end;
		end loop;
		v_referencenumber=getremittancereferencenumber(v_voucherdate);
		raise notice 'v_referencenumber>>>>> %', v_referencenumber;
		update egcl_remittance set voucherheader=v_voucherheaderid, fund=v_fundid, function=v_functionid, referencenumber=v_referencenumber, referencedate=v_voucherdate, createdby=v_createdby,lastmodifiedby=v_createdby where id=v_remittancepk;
       	INSERT INTO egcl_collectionremittance(collectionheader, remittance) VALUES (v_receiptid, v_remittancepk);
		EXCEPTION	
		WHEN OTHERS THEN
			raise notice 'migrateremittancedetails insert : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
EXCEPTION
WHEN OTHERS THEN
raise notice 'migrateremittancedata : % %', SQLERRM, SQLSTATE;
END;
$BODY$
LANGUAGE plpgsql;

--select migrateremittancedatawithvoucher();
