--------------------------------------------create vlt_setCategoryType------------------------------------------------

create or replace FUNCTION vlt_setCategoryType(assessmentNo IN Integer) 
RETURNS character varying as $$
declare
	v_categorytype	character varying; 
	v_temp 		character varying; 
BEGIN 
	--raise notice 'vlt_setCategoryType assessmentNo (%)', assessmentNo;
	 select vc_osdesc into v_categorytype from vlt_os_mstr_tbl where i_oscode in (select i_oscode from vlt_asmt_mstr_tbl where i_asmtno=assessmentNo);

	 if (v_categorytype ~* 'state' or v_categorytype ~* 'govt') then
		v_categorytype := 'STATE_GOVT';
	elsif (v_categorytype ~* 'central') then
		v_categorytype := 'CENTRAL_GOVT';
	else
		v_categorytype :='VACANTLAND';
	end if;
	--raise notice 'vlt_setCdelflag Property Created';
return v_categorytype;
EXCEPTION
WHEN OTHERS THEN
raise notice 'vlt_setCategoryType : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

------------------------------------------------------end-------------------------------------------------------------

