create or replace function ptdmdbill_generateForWard(wardid bigint)
returns void as 
$BODY$
declare
  rec record;
  v_temp bigint;
  v_isModified boolean;
begin
  --raise notice 'ptdmdbill_generateForWard, wardid (%)', wardid;
  --generating bills for migrated, untouched, active, non-exempted
  for rec in (select propertyid from egpt_basic_property  where propertyid is not null and isactive=TRUE and source = 'M' and is_bill_created='N' and id_propertyid in (select id from egpt_propertyid where ward_adm_id = wardid)
and id not in (select id_basic_property from egpt_property_status_values group by id_basic_property having count(id_basic_property)>0) and id not in (select id_basic_property from egpt_property where status='A' and isexemptedfromtax=TRUE))
  loop
    v_isModified := isModifiedInERP(rec.propertyid);
    if (v_isModified <> true) then
      v_temp := ptdmdbill_generateForAssessment(rec.propertyid);
    end if;
  end loop;
  --raise notice 'ptdmdbill_generateForWard completed for Ward: (%)', wardid;
end;
$BODY$ language plpgsql;

create or replace function isModifiedInERP(assessmentno character varying(12))
	returns boolean as $$
declare
	v_basicPropId bigint;
	v_isModified boolean default false;
begin
	--raise notice 'isModifiedInERP assessmentno : %', assessmentno;
	select id into v_basicPropId from egpt_basic_property where propertyid = assessmentno;
	if (select count(*) from egpt_property_status_values where id_basic_property = v_basicPropId) > 0 then
	  v_isModified := true;
	elsif (select count(*) from egpt_vacancy_remission where basicproperty = v_basicPropId) > 0 then
	  v_isModified := true;
	elsif (select count(*) from egpt_property_mutation where basicproperty = v_basicPropId) > 0 then
	   v_isModified := true;
	end if;
	--raise notice 'isModifiedInERP trans isModified: ( %)', v_isModified;
	return v_isModified;
exception
	when others then
	  raise notice 'isModifiedInERP : % %', SQLERRM, SQLSTATE;
	return false;
end; 
$$ language plpgsql;

create or replace function ptdmdbill_generateMonthwiseTaxwithpenalty(v_currinst bigint, v_currdemand bigint, v_currfinenddate timestamp without time zone,
  v_firsthalftax double precision, v_secondhalftax double precision, v_arreartax double precision, v_billpk bigint)
returns bigint as
$BODY$
declare
  v_paydate date;
  v_interval bigint;
  v_firsthalfpenalty double precision;
  v_secondhalfpenalty double precision;
  v_arrearspenalty double precision;
  v_total double precision;
  v_module bigint;
  v_firsthalfinst bigint;
  v_secondhalfinst bigint;
  v_count integer;
  v_arrerpercentage bigint;
  v_firsthalfpercentage bigint;
  v_secondhalfpercentage bigint;
  v_counter integer;
  rec record;
  v_montharrpenalty double precision;
  v_monthfirsthalfpenalty double precision;
  v_monthsecondhalfpenalty double precision;
begin
  --raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % % % % % % % ', v_currinst, v_currdemand, v_currfinenddate, v_firsthalftax, v_secondhalftax, v_arreartax, v_billpk;
  v_interval := 1;
  select id into v_module from eg_module where name = 'Property Tax';
  v_count := 0;
  v_arrearspenalty := 0;
  v_firsthalfpenalty := 0;
  v_secondhalfpenalty := 0;
  for rec in (select inst.id from eg_installment_master inst, financialyear fin where inst.financial_year = fin.financialyear 
  and now() between fin.startingdate and fin.endingdate and inst.id_module = v_module order by inst.start_date)
  loop
    if (v_count = 0) then
      v_firsthalfinst := rec.id;
      v_count := v_count + 1;
    else 
      v_secondhalfinst := rec.id;
    end if;
  end loop;
  v_arrerpercentage := 0;
  v_firsthalfpercentage := 0;
  v_secondhalfpercentage := 0;
  v_counter := 1;
  loop
    v_montharrpenalty := 0;
    v_monthfirsthalfpenalty := 0;
    v_monthsecondhalfpenalty := 0;
    v_total := 0;
    v_paydate := ptdmdbill_getlastday(v_interval);
    if (v_counter > 1) then
      v_arrerpercentage := 2;
    end if;
    v_montharrpenalty := ptdmdbill_arrearsPenalty(v_currdemand, v_firsthalfinst, v_secondhalfinst, v_arrerpercentage, v_arreartax);
    v_arrearspenalty := v_arrearspenalty + v_montharrpenalty;
    if (v_counter > 3) then
      v_firsthalfpercentage := 2;
      v_monthfirsthalfpenalty := ptdmdbill_currentPenalty(v_firsthalfpercentage, v_firsthalftax);
      v_firsthalfpenalty := v_firsthalfpenalty + v_monthfirsthalfpenalty;
    end if;
    if (v_counter > 9) then
      v_secondhalfpercentage := 2;
      v_monthsecondhalfpenalty := ptdmdbill_currentPenalty(v_secondhalfpercentage, v_secondhalftax);
      v_secondhalfpenalty := v_secondhalfpenalty + v_monthsecondhalfpenalty;
    end if;
    v_counter := v_counter + 1;
    v_total := v_arreartax+v_firsthalftax+v_secondhalftax+v_arrearspenalty+v_firsthalfpenalty+v_secondhalfpenalty;
    --raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: %', v_paydate;
    insert into eg_demand_bill_details (id,paidbeforedate,arreartax,arrearpenalty,currfirsthalftax,currsecondhalftax,currfirsthalfpenalty,currsecondhalfpenalty,totalamount,egdemandbillid,
    createddate,createdby,lastmodifieddate,lastmodifiedby) values (nextval('seq_eg_demand_bill_details'),v_paydate,v_arreartax,v_arrearspenalty,v_firsthalftax,v_secondhalftax,
    v_firsthalfpenalty,v_secondhalfpenalty,v_total,v_billpk,now(),1,now(),1);
    
    exit when v_paydate >= v_currfinenddate;
    v_interval := v_interval + 1;
  end loop;
return 1;
exception 
  when others then
    raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % %', SQLERRM, SQLSTATE;
end;
$BODY$ language plpgsql;

create or replace function ptdmdbill_arrearsPenalty(v_currdemand bigint, v_firsthalfinst bigint, v_secondhalfinst bigint, v_arrerpercentage bigint, v_arreartax double precision)
returns double precision as
$BODY$
declare
  v_arrearpenalty double precision;
  v_instarrearpenalty double precision;
  v_instarreartax double precision;
  rec record;
begin
  --raise notice 'ptdmdbill_arrearsPenalty, penalty percentage : (%)', v_arrerpercentage;
  v_arrearpenalty := 0;
  for rec in (select distinct(dr.id_installment) id_installment from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm 
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment not in (v_firsthalfinst, v_secondhalfinst)
    and dd.id_demand = v_currdemand order by dr.id_installment)
  loop
    select coalesce(sum(dd.amount-dd.amt_collected),0) into v_instarreartax  from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm 
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = rec.id_installment
    and dd.id_demand = v_currdemand and drm.code <> 'PENALTY_FINES' group by dr.id_installment order by dr.id_installment;

    if (v_arrerpercentage > 0 and v_instarreartax::numeric > 0) then
      v_arrearpenalty = v_arrearpenalty + round((v_instarreartax * v_arrerpercentage)/100);
    else
      --April month (there is no calculation)
      select coalesce(sum(dd.amount-dd.amt_collected),0) into v_instarrearpenalty from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm 
      where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = rec.id_installment
      and dd.id_demand = v_currdemand and drm.code = 'PENALTY_FINES' group by dr.id_installment order by dr.id_installment;
      
      v_instarrearpenalty := coalesce(v_instarrearpenalty,0);      
      v_arrearpenalty = v_arrearpenalty + v_instarrearpenalty;
    end if;
  end loop;
  --raise notice 'ptdmdbill_arrearsPenalty, arrear penalty: (%)',v_arrearpenalty;
  return v_arrearpenalty;
exception 
  when others then
    raise notice 'ptdmdbill_arrearsPenalty % %', SQLERRM, SQLSTATE;
end;
$BODY$ language plpgsql;

create or replace function ptdmdbill_currentPenalty(v_percentage bigint, v_tax double precision)
returns double precision as
$BODY$
declare
  v_penalty double precision;
begin
  --raise notice 'ptdmdbill_currentPenalty, penalty percentage : (%)', v_percentage;
  if (v_percentage > 0 and v_tax::numeric > 0) then
    v_penalty := round((v_tax * v_percentage)/100); 
  end if;
  --raise notice 'ptdmdbill_currentPenalty, current penalty: (%)',v_penalty;
  return v_penalty;
exception 
  when others then
    raise notice 'ptdmdbill_currentPenalty % %', SQLERRM, SQLSTATE;
end;
$BODY$ language plpgsql;

create or replace function ptdmdbill_generateArrearsDetails(v_finyear character varying(10), v_moduleid bigint, v_currdemand bigint, v_billpk bigint)
returns double precision as
$BODY$
declare
  v_gentax double precision;
  v_libcess double precision;
  v_educess double precision;
  v_uacpenalty double precision;
  v_totaltax double precision;
  rec record;
begin
  v_gentax := 0;
  v_libcess := 0;
  v_educess := 0;
  v_uacpenalty := 0;
  v_totaltax := 0;
  --raise notice 'ptdmdbill_generateArrearsDetails (% % % %)',v_finyear, v_moduleid, v_currdemand, v_billpk;
  for rec in (select drm.code, sum(dd.amount-dd.amt_collected) balance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm 
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment not in (
    select id from eg_installment_master where financial_year = v_finyear and id_module = v_moduleid) and dd.id_demand = v_currdemand group by drm.code) 
  loop
    if rec.code = 'GEN_TAX' then
      v_gentax := coalesce(rec.balance, 0);
    elsif rec.code = 'LIB_CESS' then
      v_libcess := coalesce(rec.balance, 0);
    elsif rec.code = 'EDU_CESS' then
      v_educess := coalesce(rec.balance, 0);
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_uacpenalty := coalesce(rec.balance, 0);
    end if;
    --raise notice 'ptdmdbill_generateArrearsDetails (% % % %)',v_gentax, v_libcess, v_educess, v_uacpenalty;
    end loop;
    v_totaltax = v_gentax+v_libcess+v_educess+v_uacpenalty;
    insert into eg_demand_inst_details(id,installment,generaltax,educationtax,librarycess,unauthorizedpenalty,totaltax,egdemandbillid,createddate,createdby,lastmodifieddate,lastmodifiedby)
	values (nextval('seq_eg_demand_inst_details'),'Arrears',v_gentax,v_educess,v_libcess,v_uacpenalty,v_totaltax,v_billpk,now(),1,now(),1);
return v_totaltax;
exception
  when others then
    raise notice 'ptdmdbill_generateArrearsDetails % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;

create or replace function ptdmdbill_generateCurrentInstDetails(v_finyear character varying(10), v_moduleid bigint, v_currdemand bigint, v_billpk bigint, v_instid bigint, v_installment character varying(24))
returns double precision as
$BODY$
declare
  v_gentax double precision;
  v_libcess double precision;
  v_educess double precision;
  v_uacpenalty double precision;
  v_totaltax double precision;
  rec record;
begin
  --raise notice 'ptdmdbill_generateCurrentInstDetails (% % % % %)',v_finyear, v_moduleid, v_currdemand, v_billpk, v_installment;
  v_gentax := 0;
  v_libcess := 0;
  v_educess := 0;
  v_uacpenalty := 0;
  v_totaltax := 0;
  for rec in (select drm.code, dd.amount-dd.amt_collected balance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = v_instid and dd.id_demand = v_currdemand) 
  loop
    if rec.code = 'GEN_TAX' then
      v_gentax := coalesce(rec.balance, 0);
    elsif rec.code = 'LIB_CESS' then
      v_libcess := coalesce(rec.balance, 0);
    elsif rec.code = 'EDU_CESS' then
      v_educess := coalesce(rec.balance, 0);
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_uacpenalty := coalesce(rec.balance, 0);
    end if;
    --raise notice 'ptdmdbill_generateCurrentInstDetails (% % % %)',v_gentax, v_libcess, v_educess, v_uacpenalty;
  end loop;
  v_totaltax = v_gentax+v_libcess+v_educess+v_uacpenalty;
  insert into eg_demand_inst_details(id,installment,generaltax,educationtax,librarycess,unauthorizedpenalty,totaltax,egdemandbillid,createddate,createdby,lastmodifieddate,lastmodifiedby)
  values (nextval('seq_eg_demand_inst_details'),v_installment,v_gentax,v_educess,v_libcess,v_uacpenalty,v_totaltax,v_billpk,now(),1,now(),1);
return v_totaltax;
exception
  when others then
    raise notice 'ptdmdbill_generateCurrentInstDetails % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;

create or replace function ptdmdbill_generateForAssessment(v_assessmentno character varying)
returns character varying as 
$BODY$
declare
  v_billno character varying(12);
  v_ownername character varying(256);
  v_bpid bigint;
  v_idpropertyid bigint;
  v_blockid bigint;
  v_localityid bigint;
  v_addressid bigint;
  v_ward_adm_id bigint;
  v_moduleid bigint;
  v_currinst bigint;
  v_houseno character varying(64);
  v_currdemand bigint;
  v_propid bigint;
  v_advance double precision;
  v_arrearspenalty double precision;
  v_finyear character varying(10);
  v_billpk bigint;
  v_demandbill bigint;
  v_arreartax double precision;
  v_currfirsthalftax double precision;
  v_currsecondhalftax double precision; 
  v_balance double precision;
  citycode character varying(4);
  v_temp bigint;
  instal record;
  v_month bigint;
  v_currfinenddate timestamp without time zone;
begin
  --raise notice 'ptdmdbill_generateForAssessment assessmentno, (%)',v_assessmentno;
  select id into v_demandbill from eg_demand_bill where assessmentno = v_assessmentno;
  if (v_demandbill is null) then
    select id into v_moduleid from eg_module where name='Property Tax';
    select id into v_currinst from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;
    select id, id_propertyid, addressid into v_bpid, v_idpropertyid, v_addressid from egpt_basic_property where propertyid = v_assessmentno;
    select id into v_propid from egpt_property where id_basic_property = v_bpid and status = 'A';
    select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property = v_propid) and id_installment = v_currinst;
    select sum(amount-amt_collected) into v_balance from eg_demand_details where id_demand = v_currdemand;
    --raise notice '% % % % %', v_moduleid, v_currinst, v_propid, v_currdemand, v_balance;
    if (v_balance > 0) then
      select code into citycode from eg_city;
      select citycode || lpad(nextval('seq_demand_bill_number')::text,8,'0') into v_billno;
      
      select coalesce(dd.amount, 0) into v_advance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand_reason = dr.id 
      and dr.id_demand_reason_master = drm.id and drm.code = 'ADVANCE' and dr.id_installment = v_currinst and dd.id_demand = v_currdemand;

      select coalesce(sum(dd.amount-dd.amt_collected), 0) into v_arrearspenalty from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand_reason = dr.id 
      and dr.id_demand_reason_master = drm.id and drm.code = 'PENALTY_FINES' and dr.id_installment not in (select id from eg_installment_master where financial_year = (
      select financialyear from financialyear where now() between startingdate and endingdate) and id_module = v_moduleid) and dd.id_demand = v_currdemand;
      
      select ward_adm_id, adm1, adm2 into v_ward_adm_id, v_blockid, v_localityid from egpt_propertyid where id = v_idpropertyid;
      select housenobldgapt into v_houseno from eg_address where id = v_addressid;
      select ownername(v_bpid) into v_ownername;
      --raise notice 'ptdmdbill_generateForAssessment (% % % % % %)',v_billno, v_ownername, v_blockid, v_localityid, v_ward_adm_id, v_houseno;

      select nextval('seq_eg_demand_bill') into v_billpk;
      insert into eg_demand_bill(id,assessmentno,houseno,ownername,locality,revenueward,block,advance,arrearspenalty,createddate,createdby,lastmodifieddate,lastmodifiedby,billnumber,isactive)
      values (v_billpk, v_assessmentno, v_houseno, v_ownername, v_localityid, v_ward_adm_id, v_blockid, v_advance, v_arrearspenalty, now(), 1, now(), 1, v_billno, true);
      
      select financialyear, endingdate into v_finyear, v_currfinenddate from financialyear where now() between startingdate and endingdate;
      for instal in (select id, start_date from eg_installment_master where financial_year = v_finyear and id_module = v_moduleid order by start_date)
      loop
	select extract(month from instal.start_date) into v_month;
	  if (v_month>=4 and v_month<=9) then
	    v_currfirsthalftax := ptdmdbill_generateCurrentInstDetails(v_finyear, v_moduleid, v_currdemand, v_billpk, instal.id, 'Current 1st Half');
	  else
	    v_currsecondhalftax := ptdmdbill_generateCurrentInstDetails(v_finyear, v_moduleid, v_currdemand, v_billpk, instal.id, 'Current 2nd Half');
	  end if;
      end loop;
      v_arreartax := ptdmdbill_generateArrearsDetails(v_finyear, v_moduleid, v_currdemand, v_billpk);
      v_temp := ptdmdbill_generateMonthwiseTaxwithpenalty(v_currinst, v_currdemand, v_currfinenddate, v_currfirsthalftax, v_currsecondhalftax, v_arreartax, v_billpk);
      update egpt_basic_property set is_bill_created = 'Y' where propertyid = v_assessmentno;
    end if;
  end if;
  return v_billno;
  exception
  when others then
    raise notice 'ptdmdbill_generateForAssessment % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;
