
----------------procedure for Add eg_bill and eg_bill_details entry
create or replace function wtmsbill_generateForWard(wardid bigint,in_oldinststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
returns numeric as 
$BODY$
declare
rec record;
v_oldinstid bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_moduleid  bigint;
v_temp integer;
v_rollovercount integer default 0;
begin
       --raise notice 'wtmsbill_generateForWard, wardid (%)', wardid;
	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_oldinstid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');

for rec in (SELECT conn.consumercode, conndet.id FROM egwtr_connection conn,egwtr_connectiondetails conndet,egwtr_demand_connection conndem, egpt_basic_property bp, egpt_property prop,  egpt_propertyid pid, eg_demand dem, egw_status status WHERE conn.id=conndet.connection and conndet.id=conndem.connectiondetails and conndet.connectionstatus='ACTIVE' and conndet.connectiontype='NON_METERED' and bp.propertyid=conn.propertyidentifier and bp.id = prop.id_basic_property AND bp.id_propertyid = pid.id AND conndem.demand = dem.id AND pid.ward_adm_id = wardid AND conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' AND dem.is_history='N' and dem.id_installment = v_new1st_instid)

  	loop
		begin
		raise notice 'generateForWard inside loop consumercode :%',rec.consumercode;
    		v_temp := wtmsbill_generateForConsumerCode(rec.consumercode,v_oldinstid, v_new1st_instid, v_new2nd_instid);
		v_rollovercount := v_rollovercount + 1;
		raise notice 'v_rollovercount :(%)',v_rollovercount;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'generateForWard : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;  
	raise notice 'wtmsbill_generateForWard completed for Ward: (%)', wardid;
	return v_temp;	
  	
end;
$BODY$ language plpgsql;

------
create or replace function wtmsbill_generateForConsumerCode(v_consumercode varchar(16),in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
returns numeric  as 
$BODY$
declare
v_billno character varying(10);
v_description  character varying(256);
v_bpid bigint;
v_addressid bigint;
v_ward_adm_id bigint;
v_moduleid bigint;
v_idbillype bigint;
v_currdemand bigint;
v_iduser bigint;
v_propertyid bigint;
v_totalamountcollected double precision;
v_totalamount double precision;
citycode character varying(4);
v_temp integer;
v_demandbill bigint;
v_ownername character varying(256);
v_billpk bigint;
v_bpropId bigint;
v_olddemand bigint;
v_houseno character varying(256);

begin
	raise notice 'wtmsbill_generateForConsumerCode consumercode, (%)',v_consumercode;
	select id into v_demandbill from eg_bill where consumer_id=v_consumercode and id_bill_type=(select id from  eg_bill_type where name='MANUAL') and is_cancelled='N' and issue_date>=(select start_date from eg_installment_master where id=in_new_1stinstid) and issue_date<=(select end_date from eg_installment_master where id=in_new_2ndinstid);
		
	if (v_demandbill is null) then
	
raise notice 'v_demandbill ==consumercode,rollcount (% %)',v_demandbill,v_consumercode;
		select id into v_moduleid from eg_module where name='Property Tax';
		select id into v_iduser from eg_user where username='egovernments';
		select code into citycode from eg_city;
 		select citycode || lpad(nextval('seq_eg_bill')::text,6,'0') into v_billno;
		select 'Water Charge H.S.C No: ' || v_consumercode into v_description;
		select id into v_idbillype from  eg_bill_type where name='MANUAL';
		select id into v_bpid from egwtr_connectiondetails where connectionstatus='ACTIVE' and connectiontype='NON_METERED' and  connection in(select id from egwtr_connection where consumercode=v_consumercode);
	
			select id, addressid ,id_propertyid into v_bpropId,v_addressid,v_propertyid  FROM egpt_basic_property WHERE propertyid in(select propertyidentifier from egwtr_connection where consumercode=v_consumercode);

			select id into v_olddemand from eg_demand where id in (select demand from egwtr_demand_connection where connectiondetails=v_bpid) and id_installment = in_oldinstid ;

    		select id into v_currdemand from eg_demand where id in (select demand from egwtr_demand_connection where connectiondetails=v_bpid) and id_installment = in_new_1stinstid and is_history='N'  ;

    		select base_demand,amt_collected into v_totalamount,v_totalamountcollected from eg_demand where id=v_currdemand;


		select ward_adm_id into v_ward_adm_id from egpt_propertyid where id = v_propertyid;
		select ownername(v_bpid) into v_ownername;
    	select streetroadline into v_houseno from eg_address where id = v_addressid;


		raise notice 'wtmsbill_generateForConsumerCode  (% %)',v_billno, v_ward_adm_id;

		select nextval('seq_eg_bill') into v_billpk;

		insert into eg_bill(id, id_demand, citizen_name, citizen_address, bill_no, id_bill_type, issue_date, last_date, module_id, user_id, create_date, modified_date, is_history, is_cancelled, fundcode, functionary_code, fundsource_code, department_code, coll_modes_not_allowed, boundary_num, boundary_type, total_amount, total_collected_amount, service_code, part_payment_allowed, override_accountheads_allowed, description, min_amt_payable, consumer_id, dspl_message, callback_for_apportion)
 values (v_billpk, v_currdemand, v_ownername,v_houseno, v_billno, v_idbillype, now(), now(), (select id 
 from eg_module where name='Water Tax Management'), v_iduser, now(), now(), 'N', 'N', '01', 1, '01', 'REV', null, v_ward_adm_id, 'Ward', v_totalamount, v_totalamountcollected, 'WT', 'Y', 'N', v_description, 0, v_consumercode, 'Water Charge Collection', 'N');


    		v_temp := wtmsbill_createbilldetail(v_billpk,v_currdemand,v_olddemand,  in_oldinstid, in_new_1stinstid, in_new_2ndinstid);
 	end if;
	raise notice 'wtmsbill_generateForConsumerCode  Done';
  	return v_temp;
	
end;
$BODY$ language plpgsql;


--rollover
CREATE OR REPLACE FUNCTION wtmsbill_createbilldetail(v_billpk bigint, in_demandid bigint,v_olddemand bigint, in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_installmentDesc character varying(256);
v_installmentDesc2 character varying(256);
v_billDesc character varying(256);
v_billDesc2 character varying(256);
v_demandreason_1instalment bigint;
v_demandreason_2instalment bigint;
rec record;
v_forcount integer default 0;
v_billid bigint;
BEGIN
	raise notice 'createbilldetail : in_demandid, in_oldinstid, in_new_1stinstid, in_new_2ndinstid (% % % %)', in_demandid,  in_oldinstid, in_new_1stinstid, in_new_2ndinstid;
--1st Half
	select id into v_demandreason_1instalment from eg_demand_reason where id_demand_reason_master in (select id from eg_demand_reason_master where code='WTAXCHARGES') and id_installment=in_new_1stinstid;

	select description into v_installmentDesc from eg_installment_master where id=in_new_1stinstid;
select 'Water Charges -' || v_installmentDesc into v_billDesc;

	insert into eg_bill_details(id ,id_demand_reason , create_date,modified_date,id_bill ,collected_amount, order_no ,glcode ,function_code ,cr_amount ,dr_amount,description ,id_installment ,  additional_flag) 
select nextval('seq_eg_bill_details'),  v_demandreason_1instalment, now(),now(), v_billpk,0, 1, '1405016','50515100',amount, 0,v_billDesc,in_new_1stinstid,1 from eg_demand_details dd where dd.id_demand=in_demandid and dd.amount>0 and dd.id_demand_reason=v_demandreason_1instalment ;
raise notice '1st half created (%)',v_demandreason_1instalment;

	--2nd Half
	select id into v_demandreason_2instalment from eg_demand_reason where id_demand_reason_master in(select id from eg_demand_reason_master where code='WTAXCHARGES') and id_installment=in_new_2ndinstid;
select description into v_installmentDesc2 from eg_installment_master where id=in_new_2ndinstid;
select 'Water Charges -' || v_installmentDesc2 into v_billDesc2;

	insert into eg_bill_details(id, id_demand_reason, create_date, modified_date, id_bill, collected_amount, order_no, glcode, function_code, cr_amount, dr_amount, description, id_installment, additional_flag)
select nextval('seq_eg_bill_details'), v_demandreason_2instalment, now(),now(), v_billpk,0, 2, '1405016','50515100',amount, 
0,v_billDesc2,in_new_2ndinstid,1 from eg_demand_details dd where dd.id_demand=in_demandid and dd.amount>0 and dd.id_demand_reason=v_demandreason_2instalment;

	raise notice '2nd half created (%)',v_demandreason_2instalment;
-- old bill-details entry for demand_details where amount is not paid

		insert into eg_bill_details(id, id_demand_reason, create_date, modified_date, id_bill, collected_amount, order_no, glcode, function_code, cr_amount, dr_amount, description, id_installment, additional_flag) select nextval('seq_eg_bill_details'), dd.id_demand_reason, now(), now(), v_billpk, 0, 3, '1405016', '50515100', dd.amount, 0, 'Water Charges -'::character varying|| install.description, install.id, 1 from eg_demand_details dd,eg_installment_master install,eg_demand_reason demreas where  dd.id_demand_reason=demreas.id and demreas.id_installment=install.id and dd.id_demand=v_olddemand and dd.amount>0 and dd.amount<> dd.amt_collected;
	
	
return 1;
END;
$BODY$ LANGUAGE plpgsql;