--ward wise rollover
CREATE OR REPLACE FUNCTION wtms_rolloverward(in_wardid bigint, in_oldinststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
props record;
v_oldinstid bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_newInstId integer;
v_temp integer;
v_rollovercount integer default 0;
BEGIN
	raise notice 'rolloverward : in_wardid, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate (% % % %)', in_wardid, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate;

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_oldinstid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');
	raise notice 'rolloverward : v_oldinstid, v_new1st_instid, v_new2nd_instid,ward (% % % %)', v_oldinstid, v_new1st_instid, v_new2nd_instid,in_wardid;

	for props in (SELECT conn.consumercode, conndet.id FROM egwtr_connection conn,egwtr_connectiondetails conndet, egpt_basic_property bp, egpt_property p, egpt_propertyid pid,egw_status status WHERE conn.id=conndet.connection and conndet.connectionstatus='ACTIVE' and conndet.connectiontype='NON_METERED' and bp.id = p.id_basic_property and bp.id_propertyid = pid.id and bp.propertyid=conn.propertyidentifier AND conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' AND pid.ward_adm_id = in_wardid except SELECT conn.consumercode, conndet.id FROM egwtr_connection conn,egwtr_connectiondetails conndet,egwtr_demand_connection conndem, egpt_basic_property bp, egpt_property prop,  egpt_propertyid pid, eg_demand dem, egw_status status WHERE conn.id=conndet.connection and conndet.id=conndem.connectiondetails and conndet.connectionstatus='ACTIVE' and conndet.connectiontype='NON_METERED' and bp.propertyid=conn.propertyidentifier and bp.id = prop.id_basic_property AND bp.id_propertyid = pid.id AND conndem.demand = dem.id AND pid.ward_adm_id = in_wardid AND conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' AND dem.is_history='N' and dem.id_installment = v_new1st_instid)
	loop 
		begin
			raise notice 'rolloverward : Started for consumernumber, idconnectiondetail (% %)', props.consumercode, props.id;
			v_temp  := wtms_rollover(props.id, v_oldinstid, v_new1st_instid, v_new2nd_instid);
			v_rollovercount := v_rollovercount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice ' rolloverward conndetId  and consumercode: % % % %',props.id,props.consumercode,SQLERRM, SQLSTATE;
		END;
	END LOOP;
	raise notice 'wtms_rolloverward completed for Ward: (%)', in_wardid;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION wtms_rollover(in_idconndetail bigint, in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_olddemandid	bigint;
v_newdemandid	bigint;
v_newConnDemand bigint;
v_temp 	integer;
v_glcodeid bigint;
v_iddemResmaster bigint;
v_newdemand_reason bigint;
v_newdemand_reason2 bigint;
v_demandAmountfromWtRate double precision;
v_demandreasoninst1 bigint;
v_demandreasoninst2 bigint;
v_demandexistforInstallment bigint;
BEGIN
	raise notice 'rollover : in_idconndetail, in_oldinstid, in_new_1stinstid, in_new_2ndinstid (% % % %)', in_idconndetail, in_oldinstid, in_new_1stinstid, in_new_2ndinstid;

	select d.id into v_olddemandid from eg_demand d, egwtr_demand_connection conndem where d.id_installment = in_oldinstid and d.id = conndem.demand and conndem.connectiondetails = in_idconndetail;
    raise notice 'rollover : v_olddemandid (%)', v_olddemandid;
	select id into v_glcodeid from chartofaccounts where glcode='1405016';
	select id into v_iddemResmaster from eg_demand_reason_master where code='WTAXCHARGES';
	SELECT id into v_demandreasoninst1 from eg_demand_reason where id_demand_reason_master=v_iddemResmaster and id_installment=in_new_1stinstid;
-- demandReason entry for installments
--1st Half
	if(v_demandreasoninst1 is not null) then
		raise notice 'rolloversingleconnection : DemandReason is already exists for this first Installment';
	else
		SELECT nextval('SEQ_EG_DEMAND_REASON') INTO v_newdemand_reason;
		insert into eg_demand_reason(id, id_demand_reason_master, id_installment, percentage_basis, id_base_reason, create_date, modified_date, glcodeid) values (v_newdemand_reason, v_iddemResmaster, in_new_1stinstid, null,null,now(),now(), v_glcodeid);
	end if;

	raise notice '1st half  demand reason created';--2nd Half
	SELECT id into v_demandreasoninst2 from eg_demand_reason where id_demand_reason_master =v_iddemResmaster and id_installment=in_new_2ndinstid;
 
	if(v_demandreasoninst2 is not null) then
		raise notice 'rolloversingleconnection : DemandReason is already exists for this second Installment';
	else
		SELECT nextval('SEQ_EG_DEMAND_REASON') INTO v_newdemand_reason2;
		insert into eg_demand_reason(id, id_demand_reason_master, id_installment, percentage_basis, id_base_reason, create_date, modified_date, glcodeid) values (v_newdemand_reason2, v_iddemResmaster, in_new_2ndinstid, null,null,now(),now(), v_glcodeid);
	end if;
	raise notice '2nd half demand reason created';
	
	select (waterratedet.monthlyrate*6) into v_demandAmountfromWtRate from egwtr_water_rates_details waterratedet where waterratedet.waterratesheader in (select wthead.id from egwtr_water_rates_header wthead, egwtr_connectiondetails conndet where wthead.connectiontype='NON_METERED' and wthead.connectiontype=conndet.connectiontype and wthead.usagetype=conndet.usagetype and wthead.pipesize=conndet.pipesize and wthead.watersource=conndet.watersource and wthead.active=true and conndet.id=in_idconndetail);
	
-- just make old demand as history='N' and create new one no need to chect it with old installment or current installment
	
	--select id into v_demandexistforInstallment from eg_demand where id_installment=in_new_1stinstid;
	--if(v_demandexistforInstallment is not null) then
		--creating new eg_demand for new installment and updating old demand to history='Y'.
	--	update eg_demand set is_history='Y' where id=v_olddemandid;
	--raise notice ' record is from 1st installment and need to update is_history=Y for old demand';
	--else
		
		--select id into v_demandexistforInstallment from eg_demand where id_installment=in_oldinstid;
	--raise notice ' record is from old installment and need to update is_history=Y for old demand';
		--update eg_demand set is_history='Y' where id=v_olddemandid;
		--creating new eg_demand for new installment.
	--end if;
	select nextval('SEQ_EG_DEMAND') into v_newdemandid;

	insert into eg_demand (id, id_installment, base_demand, is_history, create_date, modified_date, amt_collected, status, min_amt_payable, amt_rebate) select v_newdemandid, in_new_1stinstid, base_demand, is_history, now(), now(), 0, status, null, 0 from eg_demand where id = v_olddemandid;
raise notice 'new demand created for consumercode ';
--copying old demand_demand_details to new eg_demand.
	insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate) select nextval('seq_eg_demand_details'), v_newdemandid, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate from eg_demand_details where id_demand = v_olddemandid and id_demand in(select id from eg_demand where id_installment=in_oldinstid) ;

raise notice 'copied old demand_demand_details to new eg_demand';
update eg_demand set is_history='Y' where id_installment=in_oldinstid and id=v_olddemandid;

raise notice 'updated old demand with history=N';
	
	v_temp := wtms_createddforannual(v_demandAmountfromWtRate ,v_olddemandid, v_newdemandid, in_oldinstid, in_new_1stinstid, in_new_2ndinstid);

	--creating new egwtr_demand_connection for new demand.
 	SELECT nextval('seq_egwtr_demand_connection') INTO v_newConnDemand;
        insert into egwtr_demand_connection (id,demand, connectiondetails,createdby,createddate,lastmodifieddate,lastmodifiedby,version) values (v_newConnDemand,v_newdemandid,in_idconndetail,1,now(),now(),1,0);
raise notice 'created new egwtr_demand_connection for new demand';
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;



--rollover
CREATE OR REPLACE FUNCTION wtms_createddforannual(v_demandAmountfromWtRate double precision,in_olddemandid bigint, in_newdemandid bigint, in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_demandreason_1instalment bigint;
v_demandreason_2instalment bigint;
v_demandreason_oldinstalment bigint;
v_ddfirsthalf bigint;
v_ddsecondhalf bigint;
v_oldddamount double precision;
BEGIN
	raise notice 'createddforannual : in_olddemandid, in_newdemandid, in_oldinstid, in_new_1stinstid, in_new_2ndinstid (% % % % %)', in_olddemandid, in_newdemandid, in_oldinstid, in_new_1stinstid, in_new_2ndinstid;
	select id into v_demandreason_1instalment from eg_demand_reason where id_demand_reason_master in(select id from eg_demand_reason_master where code='WTAXCHARGES') and id_installment=in_new_1stinstid;

select id into v_demandreason_oldinstalment from eg_demand_reason where id_demand_reason_master in(select id from eg_demand_reason_master where code='WTAXCHARGES') and id_installment=in_oldinstid;

	select id into v_demandreason_2instalment from eg_demand_reason where id_demand_reason_master in(select id from eg_demand_reason_master where code='WTAXCHARGES') and id_installment=in_new_2ndinstid;
select amount into v_oldddAmount from  eg_demand_details where id_demand=in_olddemandid and id_demand_reason=v_demandreason_oldinstalment;
	--1st Half
SELECT nextval('seq_eg_demand_details') INTO v_ddfirsthalf;

if(v_demandAmountfromWtRate is not null)then
	insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate) values (v_ddfirsthalf, in_newdemandid, v_demandreason_1instalment, null, null, null,v_demandAmountfromWtRate, now(), now(), 0, 0);

raise notice '1st half demand detail created with water rate';
--2nd Half
	SELECT nextval('seq_eg_demand_details') INTO v_ddsecondhalf;
	insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate) values (v_ddsecondhalf, in_newdemandid, v_demandreason_2instalment, null, null, null,v_demandAmountfromWtRate, now(), now(), 0, 0);

 update eg_demand set base_demand= base_demand+(2*v_demandAmountfromWtRate) where id=in_newdemandid;
	raise notice '2nd half demand detail created with water rate';
else
insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate) values (v_ddfirsthalf, in_newdemandid, v_demandreason_1instalment, null, null, null,v_oldddAmount, now(), now(), 0, 0);
raise notice '1st half demand detail created without water rate';
SELECT nextval('seq_eg_demand_details') INTO v_ddsecondhalf;
insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate) values (v_ddsecondhalf, in_newdemandid, v_demandreason_2instalment, null, null, null,v_oldddAmount, now(), now(), 0, 0);
 update eg_demand set base_demand=  base_demand + (2*v_oldddAmount) where id=in_newdemandid;
raise notice '2nd half demand detail created without water rate';
end if;
	
	
	return 1;
END;
$BODY$ LANGUAGE plpgsql;



--rolloversingleproperty
CREATE OR REPLACE FUNCTION wtms_rolloversingleconnection(in_consumerNumber varchar(16), in_oldinststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
v_idconndetail	integer;
v_oldinstid 	bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_currinstdesc 	varchar(16);
v_moduleid 		bigint;
v_newInstId 	integer;
v_temp 			integer;
BEGIN
	raise notice 'rolloversingleconnection : in_consumerNumber, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate (% % % %)', in_consumerNumber, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate;

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_oldinstid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');
	raise notice 'rolloversingleconnection : v_oldinstid, v_new1st_instid, v_new2nd_instid (% % %)', v_oldinstid, v_new1st_instid, v_new2nd_instid;
	SELECT conndet.id into v_idconndetail FROM egwtr_connection conn,egwtr_connectiondetails conndet,egw_status status where   conn.id=conndet.connection and conndet.connectionstatus='ACTIVE' and conndet.connectiontype='NON_METERED' AND conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' AND conn.consumercode=in_consumerNumber; 

	raise notice 'rolloversingleconnection : v_idconndetail (%)', v_idconndetail;
	if(v_idconndetail is not null)then
		v_temp  := wtms_rollover(v_idconndetail, v_oldinstid, v_new1st_instid, v_new2nd_instid);
	else
		raise notice 'rolloversingleconnection : rollover is already done for this connection';
	end if;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;