create or replace function ptdmdbill_generateForAssessment(v_assessmentno character varying)
returns character varying as 
$BODY$
declare
  v_billno character varying(10);
  v_ownername character varying(256);
  v_bpid bigint;
  v_idpropertyid bigint;
  v_blockid bigint;
  v_localityid bigint;
  v_addressid bigint;
  v_ward_adm_id bigint;
  v_moduleid bigint;
  v_currinst bigint;
  v_houseno character varying(64);
  v_currdemand bigint;
  v_propid bigint;
  v_advance double precision;
  v_arrearspenalty double precision;
  v_finyear character varying(10);
  v_billpk bigint;
  v_demandbill bigint;
  v_arreartax double precision;
  v_currfirsthalftax double precision;
  v_currsecondhalftax double precision; 
  citycode character varying(4);
  v_temp bigint;
  instal record;
  v_month bigint;
  v_currfinenddate timestamp without time zone;
begin
  --raise notice 'ptdmdbill_generateForAssessment assessmentno, (%)',v_assessmentno;
  select id into v_demandbill from eg_demand_bill where assessmentno = v_assessmentno;
  if (v_demandbill is null) then
    select id into v_moduleid from eg_module where name='Property Tax';
    select id into v_currinst from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;
    select code into citycode from eg_city;
    select citycode || lpad(nextval('seq_demand_bill_number')::text,6,'0') into v_billno;
    select id, id_propertyid, addressid into v_bpid, v_idpropertyid, v_addressid from egpt_basic_property where propertyid = v_assessmentno;
    select id into v_propid from egpt_property where id_basic_property = v_bpid and status = 'A';
    select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property=v_propid) and id_installment = v_currinst;
    
    select coalesce(dd.amount, 0) into v_advance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand_reason = dr.id 
    and dr.id_demand_reason_master = drm.id and drm.code = 'ADVANCE' and dr.id_installment = v_currinst and dd.id_demand = v_currdemand;
    
    select ward_adm_id, adm1, adm2 into v_ward_adm_id, v_blockid, v_localityid from egpt_propertyid where id = v_idpropertyid;
    select housenobldgapt into v_houseno from eg_address where id = v_addressid;
    select ownername(v_bpid) into v_ownername;
    --raise notice 'ptdmdbill_generateForAssessment (% % % % % %)',v_billno, v_ownername, v_blockid, v_localityid, v_ward_adm_id, v_houseno;
    v_arrearspenalty := 0;
    select nextval('seq_eg_demand_bill') into v_billpk;
    insert into eg_demand_bill(id,assessmentno,houseno,ownername,locality,revenueward,block,advance,arrearspenalty,createddate,createdby,lastmodifieddate,lastmodifiedby,billnumber,isactive)
    values (v_billpk, v_assessmentno, v_houseno, v_ownername, v_localityid, v_ward_adm_id, v_blockid, v_advance, v_arrearspenalty, now(), 1, now(), 1, v_billno, true);
    
    select financialyear, endingdate into v_finyear, v_currfinenddate from financialyear where now() between startingdate and endingdate;
    for instal in (select id, start_date from eg_installment_master where financial_year = v_finyear and id_module = v_moduleid order by start_date)
    loop
      select extract(month from instal.start_date) into v_month;
	if (v_month>=4 and v_month<=9) then
	  v_currfirsthalftax := ptdmdbill_generateCurrentInstDetails(v_finyear, v_moduleid, v_currdemand, v_billpk, instal.id, 'Current 1st Half');
	else
	  v_currsecondhalftax := ptdmdbill_generateCurrentInstDetails(v_finyear, v_moduleid, v_currdemand, v_billpk, instal.id, 'Current 2nd Half');
	end if;
    end loop;
    v_arreartax := ptdmdbill_generateArrearsDetails(v_finyear, v_moduleid, v_currdemand, v_billpk);
    v_temp := ptdmdbill_generateMonthwiseTaxwithpenalty(v_currinst, v_currdemand, v_currfinenddate, v_currfirsthalftax, v_currsecondhalftax, v_arreartax, v_billpk);
    update egpt_basic_property set is_bill_created = 'Y' where propertyid = v_assessmentno;
  end if;
  return v_billno;
  exception
  when others then
    raise notice 'ptdmdbill_generateForAssessment % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;
