create or replace function ptdmdbill_generateMonthwiseTaxwithpenalty(v_currinst bigint, v_currdemand bigint, v_currfinenddate timestamp without time zone,
  v_currfirsthalftax double precision, v_currsecondhalftax double precision, v_arreartax double precision, v_billpk bigint)
returns bigint as
$BODY$
declare
  v_paydate date;
  v_interval bigint;
  v_currfirsthalfpenalty double precision;
  v_currsecondhalfpenalty double precision;
  v_arrearspenalty double precision;
  v_total double precision;
begin
  --raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % % % % % % % ', v_currinst, v_currdemand, v_currfinenddate, v_currfirsthalftax, v_currsecondhalftax, v_arreartax, v_billpk;
  v_interval := 1;
  loop
    v_arrearspenalty := 0;
    v_currfirsthalfpenalty := 0;
    v_currsecondhalfpenalty := 0;
    v_total := 0;
    v_paydate := ptdmdbill_getlastday(v_interval);
    --v_arrearspenalty := ptdmdbill_arrearsPenalty(v_paydate, v_arreartax);
    --v_currfirsthalfpenalty := ptdmdbill_currentFirstHalfPenalty(v_paydate, v_currfirsthalftax);
    --v_currsecondhalfpenalty := ptdmdbill_currentSecondHalfPenalty(v_paydate, v_currsecondhalftax);
    v_total := v_arreartax+v_currfirsthalftax+v_currsecondhalftax+v_arrearspenalty+v_currfirsthalfpenalty+v_currsecondhalfpenalty;
    --raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: %', v_paydate;
    insert into eg_demand_bill_details (id,paidbeforedate,arreartax,arrearpenalty,currfirsthalftax,currsecondhalftax,currfirsthalfpenalty,currsecondhalfpenalty,totalamount,egdemandbillid,
    createddate,createdby,lastmodifieddate,lastmodifiedby) values (nextval('seq_eg_demand_bill_details'),v_paydate,v_arreartax,v_arrearspenalty,v_currfirsthalftax,v_currsecondhalftax,
    v_currfirsthalfpenalty,v_currsecondhalfpenalty,v_total,v_billpk,now(),1,now(),1);
    
    exit when v_paydate >= v_currfinenddate;
    v_interval := v_interval + 1;
  end loop;
return 1;
exception 
  when others then
    raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % %', SQLERRM, SQLSTATE;
end;
$BODY$ language plpgsql;