create or replace function ptdmdbill_generateForWard(wardid bigint)
returns void as 
$BODY$
declare
  rec record;
  v_temp bigint;
begin
  --raise notice 'ptdmdbill_generateForWard, wardid (%)', wardid;
  for rec in (select propertyid from egpt_basic_property where id_propertyid  in (select id from egpt_propertyid where ward_adm_id = wardid))
  loop
    v_temp := ptdmdbill_generateForAssessment(rec.propertyid);
  end loop;
  --raise notice 'ptdmdbill_generateForWard completed for Ward: (%)', wardid;
end;
$BODY$ language plpgsql;


create or replace function ptdmdbill_generateForAssessment(v_assessmentno character varying)
returns character varying as 
$BODY$
declare
  v_billno character varying(10);
  v_ownername character varying(256);
  v_bpid bigint;
  v_idpropertyid bigint;
  v_blockid bigint;
  v_localityid bigint;
  v_addressid bigint;
  v_ward_adm_id bigint;
  v_moduleid bigint;
  v_currinst bigint;
  v_houseno character varying(64);
  v_currdemand bigint;
  v_propid bigint;
  v_advance double precision;
  v_arrearspenalty double precision;
  v_finyear character varying(10);
  v_billpk bigint;
  v_demandbill bigint;
  v_arreartax double precision;
  v_currfirsthalftax double precision;
  v_currsecondhalftax double precision; 
  citycode character varying(4);
  v_temp bigint;
  instal record;
  v_month bigint;
  v_currfinenddate timestamp without time zone;
begin
  --raise notice 'ptdmdbill_generateForAssessment assessmentno, (%)',v_assessmentno;
  select id into v_demandbill from eg_demand_bill where assessmentno = v_assessmentno;
  if (v_demandbill is null) then
    select id into v_moduleid from eg_module where name='Property Tax';
    select id into v_currinst from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;
    select code into citycode from eg_city;
    select citycode || lpad(nextval('seq_demand_bill_number')::text,6,'0') into v_billno;
    select id, id_propertyid, addressid into v_bpid, v_idpropertyid, v_addressid from egpt_basic_property where propertyid = v_assessmentno;
    select id into v_propid from egpt_property where id_basic_property = v_bpid and status = 'A';
    select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property=v_propid) and id_installment = v_currinst;
    
    select coalesce(dd.amount, 0) into v_advance from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand_reason = dr.id 
    and dr.id_demand_reason_master = drm.id and drm.code = 'ADVANCE' and dr.id_installment = v_currinst and dd.id_demand = v_currdemand;
    
    select ward_adm_id, adm1, adm2 into v_ward_adm_id, v_blockid, v_localityid from egpt_propertyid where id = v_idpropertyid;
    select housenobldgapt into v_houseno from eg_address where id = v_addressid;
    select ownername(v_bpid) into v_ownername;
    --raise notice 'ptdmdbill_generateForAssessment (% % % % % %)',v_billno, v_ownername, v_blockid, v_localityid, v_ward_adm_id, v_houseno;
    v_arrearspenalty := 0;
    select nextval('seq_eg_demand_bill') into v_billpk;
    insert into eg_demand_bill(id,assessmentno,houseno,ownername,locality,revenueward,block,advance,arrearspenalty,createddate,createdby,lastmodifieddate,lastmodifiedby,billnumber,isactive)
    values (v_billpk, v_assessmentno, v_houseno, v_ownername, v_localityid, v_ward_adm_id, v_blockid, v_advance, v_arrearspenalty, now(), 1, now(), 1, v_billno, true);
    
    select financialyear, endingdate into v_finyear, v_currfinenddate from financialyear where now() between startingdate and endingdate;
    for instal in (select id, start_date from eg_installment_master where financial_year = v_finyear and id_module = v_moduleid order by start_date)
    loop
      select extract(month from instal.start_date) into v_month;
	if (v_month>=4 and v_month<=9) then
	  v_currfirsthalftax := ptdmdbill_generateCurrentInstDetails(v_finyear, v_moduleid, v_currdemand, v_billpk, instal.id, 'Current 1st Half');
	else
	  v_currsecondhalftax := ptdmdbill_generateCurrentInstDetails(v_finyear, v_moduleid, v_currdemand, v_billpk, instal.id, 'Current 2nd Half');
	end if;
    end loop;
    v_arreartax := ptdmdbill_generateArrearsDetails(v_finyear, v_moduleid, v_currdemand, v_billpk);
    v_temp := ptdmdbill_generateMonthwiseTaxwithpenalty(v_currinst, v_currdemand, v_currfinenddate, v_currfirsthalftax, v_currsecondhalftax, v_arreartax, v_billpk);
  end if;
  return v_billno;
  exception
  when others then
    raise notice 'ptdmdbill_generateForAssessment % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;

create or replace function ptdmdbill_generateArrearsDetails(v_finyear character varying(10), v_moduleid bigint, v_currdemand bigint, v_billpk bigint)
returns double precision as
$BODY$
declare
  v_gentax double precision;
  v_libcess double precision;
  v_educess double precision;
  v_uacpenalty double precision;
  v_totaltax double precision;
  rec record;
begin
  v_gentax := 0;
  v_libcess := 0;
  v_educess := 0;
  v_uacpenalty := 0;
  v_totaltax := 0;
  --raise notice 'ptdmdbill_generateArrearsDetails (% % % %)',v_finyear, v_moduleid, v_currdemand, v_billpk;
  for rec in (select drm.code, sum(dd.amount) amount from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm 
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment not in (
    select id from eg_installment_master where financial_year = v_finyear and id_module = v_moduleid) and dd.id_demand = v_currdemand group by drm.code) 
  loop
    if rec.code = 'GEN_TAX' then
      v_gentax := coalesce(rec.amount, 0);
    elsif rec.code = 'LIB_CESS' then
      v_libcess := coalesce(rec.amount, 0);
    elsif rec.code = 'EDU_CESS' then
      v_educess := coalesce(rec.amount, 0);
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_uacpenalty := coalesce(rec.amount, 0);
    end if;
    v_totaltax = v_gentax+v_libcess+v_educess+v_uacpenalty;
    --raise notice 'ptdmdbill_generateArrearsDetails (% % % % %)',v_gentax, v_libcess, v_educess, v_uacpenalty, v_totaltax;
    end loop;
    insert into eg_demand_inst_details(id,installment,generaltax,educationtax,librarycess,unauthorizedpenalty,totaltax,egdemandbillid,createddate,createdby,lastmodifieddate,lastmodifiedby)
	values (nextval('seq_eg_demand_inst_details'),'Arrears',v_gentax,v_educess,v_libcess,v_uacpenalty,v_totaltax,v_billpk,now(),1,now(),1);
return v_totaltax;
exception
  when others then
    raise notice 'ptdmdbill_generateArrearsDetails % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;


create or replace function ptdmdbill_generateCurrentInstDetails(v_finyear character varying(10), v_moduleid bigint, v_currdemand bigint, v_billpk bigint, v_instid bigint, v_installment character varying(24))
returns double precision as
$BODY$
declare
  v_gentax double precision;
  v_libcess double precision;
  v_educess double precision;
  v_uacpenalty double precision;
  v_totaltax double precision;
  rec record;
begin
  --raise notice 'ptdmdbill_generateCurrentInstDetails (% % % % %)',v_finyear, v_moduleid, v_currdemand, v_billpk, v_installment;
  v_gentax := 0;
  v_libcess := 0;
  v_educess := 0;
  v_uacpenalty := 0;
  v_totaltax := 0;
  for rec in (select drm.code, dd.amount from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = v_instid and dd.id_demand = v_currdemand) 
  loop
    if rec.code = 'GEN_TAX' then
      v_gentax := coalesce(rec.amount, 0);
    elsif rec.code = 'LIB_CESS' then
      v_libcess := coalesce(rec.amount, 0);
    elsif rec.code = 'EDU_CESS' then
      v_educess := coalesce(rec.amount, 0);
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_uacpenalty := coalesce(rec.amount, 0);
    end if;
    v_totaltax = v_gentax+v_libcess+v_educess+v_uacpenalty;
    --raise notice 'ptdmdbill_generateCurrentInstDetails (% % % % %)',v_gentax, v_libcess, v_educess, v_uacpenalty, v_totaltax;
  end loop;
  insert into eg_demand_inst_details(id,installment,generaltax,educationtax,librarycess,unauthorizedpenalty,totaltax,egdemandbillid,createddate,createdby,lastmodifieddate,lastmodifiedby)
  values (nextval('seq_eg_demand_inst_details'),v_installment,v_gentax,v_educess,v_libcess,v_uacpenalty,v_totaltax,v_billpk,now(),1,now(),1);
return v_totaltax;
exception
  when others then
    raise notice 'ptdmdbill_generateCurrentInstDetails % %', SQLERRM,SQLSTATE;
end;
$BODY$ language plpgsql;

create or replace function ptdmdbill_getlastday(noofmonths bigint)
returns date as
$$
declare
  v_date date;
begin
SELECT (date_trunc('month', now()) + ($1 || ' MONTH - 1 day')::interval)::date into v_date;
return v_date;
end;
$$ language plpgsql;


create or replace function ptdmdbill_generateMonthwiseTaxwithpenalty(v_currinst bigint, v_currdemand bigint, v_currfinenddate timestamp without time zone,
  v_currfirsthalftax double precision, v_currsecondhalftax double precision, v_arreartax double precision, v_billpk bigint)
returns bigint as
$BODY$
declare
  v_paydate date;
  v_interval bigint;
  v_currfirsthalfpenalty double precision;
  v_currsecondhalfpenalty double precision;
  v_arrearspenalty double precision;
  v_total double precision;
begin
  --raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % % % % % % % ', v_currinst, v_currdemand, v_currfinenddate, v_currfirsthalftax, v_currsecondhalftax, v_arreartax, v_billpk;
  loop
    v_arrearspenalty := 0;
    v_currfirsthalfpenalty := 0;
    v_currsecondhalfpenalty := 0;
    v_total := 0;
    v_interval := 1;
    v_paydate := ptdmdbill_getlastday(v_interval);
    --v_arrearspenalty := ptdmdbill_arrearsPenalty(v_paydate, v_arreartax);
    --v_currfirsthalfpenalty := ptdmdbill_currentFirstHalfPenalty(v_paydate, v_currfirsthalftax);
    --v_currsecondhalfpenalty := ptdmdbill_currentSecondHalfPenalty(v_paydate, v_currsecondhalftax);
    v_total := v_arreartax+v_currfirsthalftax+v_currsecondhalftax+v_arrearspenalty+v_currfirsthalfpenalty+v_currsecondhalfpenalty;
    --raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: %', v_paydate;
    insert into eg_demand_bill_details (id,paidbeforedate,arreartax,arrearpenalty,currfirsthalftax,currsecondhalftax,currfirsthalfpenalty,currsecondhalfpenalty,totalamount,egdemandbillid,
    createddate,createdby,lastmodifieddate,lastmodifiedby) values (nextval('seq_eg_demand_bill_details'),v_paydate,v_arreartax,v_arrearspenalty,v_currfirsthalftax,v_currsecondhalftax,
    v_currfirsthalfpenalty,v_currsecondhalfpenalty,v_total,v_billpk,now(),1,now(),1);
    
    exit when v_paydate >= v_currfinenddate;
    v_interval := v_interval + 1;
  end loop;
return 1;
exception 
  when others then
    raise notice 'ptdmdbill_generateMonthwiseTaxwithpenalty: % %', SQLERRM, SQLSTATE;
end;
$BODY$ language plpgsql;


