--ward wise rollover
CREATE OR REPLACE FUNCTION pt_rolloverward(in_wardid bigint, in_oldinststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
props record;

v_oldinstid bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_newInstId integer;
v_temp integer;
v_rollovercount integer default 0;
BEGIN
	raise notice 'rolloverward : in_wardid, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate (% % % %)', in_wardid, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate;

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_oldinstid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');
	raise notice 'rolloverward : v_oldinstid, v_new1st_instid, v_new2nd_instid (% % %)', v_oldinstid, v_new1st_instid, v_new2nd_instid;

	for props in (SELECT bp.propertyid, p.id FROM egpt_basic_property bp, egpt_property p, egpt_propertyid pid
WHERE bp.id = p.id_basic_property AND p.is_default_property = 'Y' AND p.status = 'A' AND bp.id_propertyid = pid.id
AND pid.ward_adm_id = in_wardid
except
    SELECT bp.propertyid, prop.id FROM egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, egpt_propertyid pid, eg_demand dem WHERE bp.id = prop.id_basic_property AND prop.id = ptd.id_property AND ptd.id_demand = dem.id AND prop.is_default_property = 'Y' AND prop.status = 'A' AND bp.id_propertyid = pid.id AND pid.ward_adm_id = in_wardid AND dem.id_installment = v_new1st_instid)
	loop 
		begin
			raise notice 'rolloverward : Started for assessmentno, idproperty (% %)', props.propertyid, props.id;
			v_temp  := pt_rollover(props.id, v_oldinstid, v_new1st_instid, v_new2nd_instid);
			v_rollovercount := v_rollovercount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'rolloverward : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

--rolloversingleproperty
CREATE OR REPLACE FUNCTION pt_rolloversingleproperty(in_assessmentno varchar(16), in_oldinststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
v_idproperty	integer;
v_oldinstid 	bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_currinstdesc 	varchar(16);
v_moduleid 		bigint;
v_newInstId 	integer;
v_temp 			integer;
BEGIN
	raise notice 'rolloversingleproperty : in_assessmentno, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate (% % % %)', in_assessmentno, in_oldinststartdate, in_new1st_inststartdate, in_new2nd_inststartdate;

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_oldinstid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');
	raise notice 'rolloversingleproperty : v_oldinstid, v_new1st_instid, v_new2nd_instid (% % %)', v_oldinstid, v_new1st_instid, v_new2nd_instid;

	SELECT p.id into v_idproperty FROM egpt_basic_property bp, egpt_property p WHERE bp.id = p.id_basic_property AND p.is_default_property = 'Y' AND p.status = 'A' AND bp.propertyid = in_assessmentno
	except
		SELECT prop.id FROM egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand dem WHERE bp.id = prop.id_basic_property AND prop.id = ptd.id_property AND ptd.id_demand = dem.id AND prop.is_default_property = 'Y' AND prop.status = 'A' and bp.propertyid = in_assessmentno AND dem.id_installment = v_new1st_instid;

	raise notice 'rolloversingleproperty : v_idproperty (%)', v_idproperty;

	if(v_idproperty is not null)then
		v_temp  := pt_rollover(v_idproperty, v_oldinstid, v_new1st_instid, v_new2nd_instid);
	else
		raise notice 'rolloversingleproperty : rollover is already done for this property';
	end if;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

--rollover
CREATE OR REPLACE FUNCTION pt_rollover(in_idproperty bigint, in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_olddemandid	bigint;
v_newdemandid	bigint;
v_temp 			integer;
BEGIN
	raise notice 'rollover : in_idproperty, in_oldinstid, in_new_1stinstid, in_new_2ndinstid (% % % %)', in_idproperty, in_oldinstid, in_new_1stinstid, in_new_2ndinstid;

    select d.id into v_olddemandid from eg_demand d, egpt_ptdemand pd where d.id_installment = in_oldinstid and d.id = pd.id_demand and pd.id_property = in_idproperty;
    raise notice 'rollover : v_olddemandid (%)', v_olddemandid;

	--select id_basic_property into idBasicProp from egpt_property where id_property=in_idproperty;
    SELECT nextval('seq_eg_demand') INTO v_newdemandid;
    raise notice 'rollover : v_newdemandid (%)', v_newdemandid;    

	--creating new eg_demand for new installment.
    insert into eg_demand (id, id_installment, base_demand, is_history, create_date, modified_date, amt_collected, status, min_amt_payable, amt_rebate)
	select v_newdemandid, in_new_1stinstid, base_demand, is_history, now(), now(), 0, status, null, 0 from eg_demand where id = v_olddemandid;

	--creating new egpt_demandcalculations for new installment.
	insert into egpt_demandcalculations (id, id_demand, propertytax, rate_of_tax, current_interest, arrear_interest, modified_date, created_date, created_by, modified_by, taxinfo, alv)
	select nextval('seq_egpt_demandcalculations'), v_newdemandid, propertytax, rate_of_tax, current_interest, arrear_interest, now(), now(), 1, 1, taxinfo, alv from egpt_demandcalculations where id_demand = v_olddemandid;

	--creating new EGPT_PTDEMAND for new installment.
    insert into egpt_ptdemand (id_demand, id_property) values (v_newdemandid, in_idproperty);

	--copying old demand_demand_details to new eg_demand.
    insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate)
    select nextval('seq_eg_demand_details'), v_newdemandid, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate from eg_demand_details where id_demand = v_olddemandid;

	v_temp := pt_createddforannual(v_olddemandid, v_newdemandid, in_oldinstid, in_new_1stinstid, in_new_2ndinstid);
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

--rollover
CREATE OR REPLACE FUNCTION pt_createddforannual(in_olddemandid bigint, in_newdemandid bigint, in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE

BEGIN
	raise notice 'createddforannual : in_olddemandid, in_newdemandid, in_oldinstid, in_new_1stinstid, in_new_2ndinstid (% % % % %)', in_olddemandid, in_newdemandid, in_oldinstid, in_new_1stinstid, in_new_2ndinstid;
--1st Half
    insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate)
    select nextval('seq_eg_demand_details'), in_newdemandid, dr2.id, dd.id_status, dd.file_reference_no, dd.remarks, dd.amount, now(), now(), 0, 0 from eg_demand_details dd, eg_demand_reason dr1, eg_demand_reason dr2
where dd.id_demand=in_olddemandid
and dd.amount>0
and dr1.id_demand_reason_master=dr2.id_demand_reason_master
and dd.id_demand_reason=dr1.id
and dr1.id_demand_reason_master not in (select id from eg_demand_reason_master where module=359 and code in ('CHQ_BUNC_PENALTY', 'PENALTY_FINES'))
and dr1.id_installment=in_oldinstid
and dr2.id_installment=in_new_1stinstid;
raise notice '1st half created';
--2nd Half
    insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate)
    select nextval('seq_eg_demand_details'), in_newdemandid, dr2.id, dd.id_status, dd.file_reference_no, dd.remarks, dd.amount, now(), now(), 0, 0 from eg_demand_details dd, eg_demand_reason dr1, eg_demand_reason dr2
where dd.id_demand=in_olddemandid
and dd.amount>0
and dr1.id_demand_reason_master=dr2.id_demand_reason_master
and dd.id_demand_reason=dr1.id
and dr1.id_demand_reason_master not in (select id from eg_demand_reason_master where module=359 and code in ('CHQ_BUNC_PENALTY', 'PENALTY_FINES'))
and dr1.id_installment=in_oldinstid
and dr2.id_installment=in_new_2ndinstid;
raise notice '2nd half created';

	return 1;
END;
$BODY$ LANGUAGE plpgsql;