create table tmp_new_coa
(srlno numeric,
glcode varchar(10),
name varchar(150),
status varchar(150));

alter table tmp_new_coa add column coatype char(1);
alter table tmp_new_coa add column budgetenable boolean;

CREATE OR REPLACE FUNCTION load_coa()  RETURNS void AS
$BODY$
declare
coa_name varchar(200); 
coa_code varchar(10);
coa_type varchar(1);
coa_budgetreq boolean;
isCoaExists boolean default true;
srl bigint;
coa_seq bigint;
minor_code varchar(5);
major_code varchar(3);
top_code char(1);
cur_coa tmp_new_coa%ROWTYPE;

begin
RAISE NOTICE 'Inside COA data load';
for cur_coa  in( select * from tmp_new_coa where status is null order by srlno)
loop
begin
coa_name:=cur_coa.name;
coa_code:=cur_coa.glcode;
srl:=cur_coa.srlno;
coa_type:=cur_coa.coatype;
coa_budgetreq:=cur_coa.budgetenable;

RAISE NOTICE 'Loading data for code %',coa_code;
-- Check if glcode already exist
isCoaExists:=coa_exist(coa_code);

--If exist then dont load again
if(isCoaExists=true) then
	update chartofaccounts set name=coa_name,budgetcheckreq=coa_budgetreq where glcode=coa_code;
	update tmp_new_coa set status ='COA already exist.Updated details' where srlno=srl;
end if;

-- check if glcode does not exist check if minor code,major code exit
if(isCoaExists=false) then
	RAISE NOTICE 'COA does not exist %',coa_code;
	minor_code:=substring(coa_code,0,6);
	major_code:=substring(coa_code,0,4);

	--check major exit
	if(coa_exist(major_code)=true ) then
		-- check minor exist
		if(coa_exist(minor_code)=true ) then
			RAISE NOTICE 'Minor code exist %',minor_code;
		else
			-- load minor
			select nextval('seq_chartofaccounts') into coa_seq;
			INSERT INTO chartofaccounts (id, glcode, name,isactiveforposting, parentid, lastmodified, modifiedby,created,type, classification, budgetcheckreq, majorcode, createdby) values
			(coa_seq,minor_code,coa_name,false,(select id from chartofaccounts where glcode=major_code),current_date,1,current_date,coa_type,2,false,major_code,1);
		
		end if;
		select nextval('seq_chartofaccounts') into coa_seq;
		--load detailed code
			INSERT INTO chartofaccounts (id, glcode, name,isactiveforposting, parentid, lastmodified, modifiedby,created,type, classification, budgetcheckreq, majorcode, createdby) values
			(coa_seq,coa_code,coa_name,true,(select id from chartofaccounts where glcode=minor_code),current_date,1,current_date,coa_type,4,coa_budgetreq,major_code,1);

	else
		if(coa_type='A')then
			top_code:='4';
		elsif(coa_type='L') then
			top_code:='3';
		elsif(coa_type='I')then
			top_code:='1';
		elsif(coa_type='E')then
			top_code:='2';
		else
			RAISE NOTICE 'Wrong data..for top code... %',coa_type;
		end if;
		
		--load major code
		select nextval('seq_chartofaccounts') into coa_seq;
		INSERT INTO chartofaccounts (id, glcode, name,isactiveforposting, parentid, lastmodified, modifiedby,created,type, classification, budgetcheckreq, majorcode, createdby) values
		(coa_seq,major_code,coa_name,false,(select id from chartofaccounts where glcode=top_code),current_date,1,current_date,coa_type,1,false,major_code,1);
		
		-- load minor code
		select nextval('seq_chartofaccounts') into coa_seq;
		INSERT INTO chartofaccounts (id, glcode, name,isactiveforposting, parentid, lastmodified, modifiedby,created,type, classification, budgetcheckreq, majorcode, createdby) values
		(coa_seq,minor_code,coa_name,false,(select id from chartofaccounts where glcode=major_code),current_date,1,current_date,coa_type,2,false,major_code,1);
		
		-- load detailed code
		select nextval('seq_chartofaccounts') into coa_seq;
		INSERT INTO chartofaccounts (id, glcode, name,isactiveforposting, parentid, lastmodified, modifiedby,created,type, classification, budgetcheckreq, majorcode, createdby) values
		(coa_seq,coa_code,coa_name,true,(select id from chartofaccounts where glcode=minor_code),current_date,1,current_date,coa_type,4,coa_budgetreq,major_code,1);
	end if;
				
update tmp_new_coa set status ='Updated' where srlno=srl;
end if;		
end;
 end loop;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

CREATE OR REPLACE FUNCTION coa_exist(code character varying)
  RETURNS boolean AS
$BODY$
declare isexist boolean default true;
begin
PERFORM id from chartofaccounts where upper(glcode)=upper(code);
IF NOT FOUND THEN
RAISE NOTICE 'Inside COA Code Unique checking %',code;
isexist:=false;
END IF;
return isexist;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;


  ----------------------
  create table tmp_delete_coa
(srlno numeric,
glcode varchar(10),
name varchar(150),
status varchar(150));

CREATE OR REPLACE FUNCTION delete_coa()  RETURNS void AS
$BODY$
declare
coa_name varchar(200); 
coa_code varchar(10);

isCoaTxnExists boolean default true;
srl bigint;
cur_coa chartofaccounts%ROWTYPE;

begin
RAISE NOTICE 'Inside COA deletion..';
for cur_coa  in(select * from chartofaccounts where glcode not in(select glcode from tmp_new_coa) and classification=4 order by glcode)
loop
begin
coa_name:=cur_coa.name;
coa_code:=cur_coa.glcode;

RAISE NOTICE 'Processing COA code %',coa_code;
-- Check if glcode already exist
isCoaTxnExists:=coa_records_exist(coa_code);

--If exist then dont load again
if(isCoaTxnExists=false) then
	delete from chartofaccountdetail where glcodeid in(select id from chartofaccounts where glcode=coa_code);
	delete from chartofaccounts where glcode=coa_code;
	insert into tmp_delete_coa(glcode,name,status) values (coa_code,coa_name,'DELETED');
else
	insert into tmp_delete_coa(glcode,name,status) values (coa_code,coa_name,'CANNOT DELETE..TXN EXIST');
end if;

end;
end loop;
RAISE NOTICE 'Finished processing deletion of COA';
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

 CREATE OR REPLACE FUNCTION coa_records_exist(code character varying)
  RETURNS boolean AS
$BODY$
declare isexist boolean default true;
begin
PERFORM distinct gcode from (
select glcode as gcode,name as gname from chartofaccounts where id in(
select distinct chartofaccount from egcl_collectiondetails) and classification=4 and glcode=code
union
select glcode as gcode,name as gname from chartofaccounts where id in(
select distinct glcodeid from generalledger) and classification=4 and glcode=code
union
select distinct c.glcode as gcode,name as gname  from egcl_service_accountdetails sa,chartofaccounts c where c.id=sa.chartofaccount and c.glcode=code
union
select distinct c.glcode as gcode,name as gname  from eg_demand_reason dr,chartofaccounts c where c.id=dr.glcodeid and c.glcode=code
union
select distinct c.glcode as gcode,name as gname  from bankaccount ba,chartofaccounts c where c.id=ba.glcodeid and c.glcode=code
union
select distinct c.glcode as gcode,name as gname  from eg_billdetails db,chartofaccounts c where c.id=db.glcodeid and c.glcode=code
union
select distinct c.glcode as gcode,name as gname  from transactionsummary ts,chartofaccounts c where c.id=ts.glcodeid and c.glcode=code
union
select distinct c.glcode as gcode,c.name as gname  from egf_budgetgroup bg,chartofaccounts c where c.id=bg.maxcode and c.glcode=code
union
select distinct c.glcode as gcode,name as gname  from tds td,chartofaccounts c where c.id=td.glcodeid and c.glcode=code
) as s1  order by gcode;

IF NOT FOUND THEN
RAISE NOTICE 'COA TXNS does not exist %',code;
isexist:=false;
END IF;
return isexist;
end;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
----------------------------
  
  ---Loading data to tmp table---------
  insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1,'1100101','Properties– General Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (2,'1100102','Vacant Land Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (3,'1100103','PT on State Government Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (4,'1100104','PT on State Government Undertaking Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (5,'1100105','PT on Central Government Undertaking Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (6,'1100106','Service Charges in lieu of Property Tax from Central Govt Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (7,'1100107','Service Charges in lieu of Property Tax from Railway Authorities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (8,'1100108','Tax on Agriculture Lands','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (9,'1100201','Properties– Water Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (10,'1100301','Properties– Sewerage Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (11,'1100401','Properties– Conservancy Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (12,'1100501','Properties– Lighting Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (13,'1100502','Properties– Scavenging Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (14,'1100601','Properties– Education Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (15,'1100701','Tax on Carriages','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (16,'1100702','Tax on Carts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (17,'1100801','Tax on Animals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (18,'1101101','Advt. Tax on Hoardings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (19,'1101102','Advt. Tax on Cinema Houses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (20,'1101103','Advt. Tax on Hoardings on Vehicles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (21,'1101104','Advt.Tax on Public Screens','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (22,'1101105','Advt. Tax on Cable Operators','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (23,'1101199','Advt. Tax - Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (24,'1101201','Piligrimage Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (25,'1105101','Octroi','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (26,'1105102','Toll','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (27,'1105103','Entry Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (28,'1105201','Cess','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (29,'1108001','Tax on Cell Towers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (30,'1109001','Vacancy Remission','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (31,'1109002','Tax Remission','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (32,'1109003','Tax Refunds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (33,'1201001','Surcharge on Stamp Duty for Transfer of Immovable Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (34,'1201002','Entertainment Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (35,'1201003','Profession Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (36,'1201004','Tax on Cable TV','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (37,'1201005','Share in Tax Demand in Specific Areas','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (38,'1201006','Seignorage Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (39,'1202001','Compensation in lieu of Octroi & Toll Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (40,'1202002','Compensation in lieu of Motor Vehicles Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (41,'1202003','Compensation in lieu of Profession Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (42,'1203001','Property Tax compensations due to concessions to taxpayers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (43,'1301001','Rent from Markets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (44,'1301002','Rent from Auditoriums','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (45,'1301003','Rent from Function/Community Halls','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (46,'1301004','Rent from Open Spaces','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (47,'1301005','Rent from Staff Quarters','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (48,'1301006','Lease of Canteens','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (49,'1301007','Rent from stalls in Slaughter Houses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (50,'1301008','Rent of Choultries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (51,'1301009','Lease from Nurseries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (52,'1301010','Lease/Rent from Parking Places','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (53,'1301011','Lease of Traffic Islands/ Central Media','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (54,'1301012','Lease of Land for Bus Shelters','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (55,'1301013','Lease of Jetties & Boats','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (56,'1301014','Lease of Advertisement Right','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (57,'1301015','Rent from Shopping Complexes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (58,'1301016','Rent from School Grounds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (59,'1301017','Rent from Open Air Theatres','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (60,'1301018','Lease from Vehice Stands','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (61,'1301019','Rent from Sports Grounds/Stadia','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (62,'1301020','Ground Rent on space for Advertisements/Hoardings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (63,'1301021','Lease from Fish Tanks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (64,'1301022','Road Margin Lease','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (65,'1301023','Ferry Rents','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (66,'1301024','Lease from Water Tanks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (67,'1301025','Lease for Boating','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (68,'1301099','Rent from other Civic Amenities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (69,'1302001','Rent from Government Offices','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (70,'1302002','Rent from Private Offices','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (71,'1302099','Rent from other Offices','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (72,'1303001','Rent from Guest Houses and Travellers Bunglows','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (73,'1304001','Rent from Lease of Land','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (74,'1308001','Rent from Night Shelter Home','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (75,'1308002','Rent from Funeral House','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (76,'1309001','Rent Remission','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (77,'1309002','Rent Refund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (78,'1401001','Regn. Charges from Contractors, Agencies etc','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (79,'1401002','Regn. Charges from Technical Professionals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (80,'1401003','Regn. Charges from Builders & Developers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (81,'1401004','Plumbers Regn. Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (82,'1401101','Trade License Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (83,'1401102','Licensing of Cattle Pounding','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (84,'1401103','Licensing of Animals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (85,'1401104','Slaughter House License','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (86,'1401105','Cell Towers License','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (87,'1401106','Encroachment Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (88,'1401107','Butchers and Meat Traders License','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (89,'1401108','Poultry License Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (90,'1401109','License Fee on Liquor Shops','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (91,'1401199','Other License Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (92,'1401201','Fee for Layout/Sub division','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (93,'1401202','Building Permit/License Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (94,'1401203','Fee for Erection of Hoardings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (95,'1401204','Intensive Zoning Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (96,'1401205','Fee for Film Shooting in Parks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (97,'1401206','Additional Building License Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (98,'1401207','Fee for installing Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (99,'1401208','Fee for Festivals and Fairs','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (100,'1401209','Fee for Private Markets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (101,'1401210','Fee for Public Markets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (102,'1401211','Fee for Diwali Shops','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (103,'1401212','Animal Slaughtering Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (104,'1401213','Cart Stand Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (105,'1401301','Fee for Copy of Plan/Certificate','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (106,'1401302','Fee for Birth & Death Certificates','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (107,'1401303','Fee for Sanitation Certificate','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (108,'1401304','Fee for Copy of Extract','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (109,'1401305','Fee for No House Certificate','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (110,'1401306','Fee for No Due Certificate','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (111,'1401307','Fee for Valuation Certificate','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (112,'1401308','Fee for Voter List','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (113,'1401309','Fee for Marriage Certificate','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (114,'1401310','Fee for Enjoinment Sketch','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (115,'1401401','Building Development Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (116,'1401402','Betterment Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (117,'1401403','External Betterment Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (118,'1401404','Special Development Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (119,'1401405','Impact Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (120,'1401406','Un-Authorised Colony Improvement Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (121,'1401407','Open Space Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (122,'1401408','Parking Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (123,'1401409','Postage & Advertisement Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (124,'1401499','Other Town Planning Receipts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (125,'1401501','Building Regularization','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (126,'1402001','Penalty for Un-authorised Construction (TP)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (127,'1402002','Penalty on Contractors for Works, Supplies and Services','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (128,'1402003','Continuing Penalty for Un-authorised Construction (TP)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (129,'1402004','Spot Fines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (130,'1402005','Fine for littering','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (131,'1402006','Late fee for Birth & Death Regn.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (132,'1402007','Fine for Using Banned Items','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (133,'1402008','Fine under No Tobacco Act','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (134,'1402009','Road Damage Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (135,'1402010','Interest on PT Late Payment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (136,'1402011','Interest on VLT Late Payment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (137,'1402012','Interest on Water Charges Late Payment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (138,'1402013','Interest on Advt. Tax Late Payment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (139,'1402014','Interest on Shop Rents/Leases Late Payment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (140,'1402015','Penalty on Trade License Late Payment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (141,'1402016','Penalty for Un-authorised Construction on Property Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (142,'1402017','Towing Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (143,'1402018','Fines imposed by Courts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (144,'1402019','Audit Recoveries from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (145,'1402020','Audit Recoveries from Contractors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (146,'1402021','Penalty on Unauthorized Water Connections','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (147,'1402022','Penalty on Unauthorized Sewerage Connections','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (148,'1402099','Other Penalties and Fines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (149,'1404001','School Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (150,'1404002','School Admission Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (151,'1404003','School Sports Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (152,'1404004','School Library Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (153,'1404005','Survey fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (154,'1404006','Connection/Disconnection charges (Water Supply)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (155,'1404007','Notice Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (156,'1404008','Warrant & Distraint Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (157,'1404009','Mutation Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (158,'1404010','Property Transfer Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (159,'1404011','Fee under RTI Act','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (160,'1404012','Training Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (161,'1404013','Tap Re open Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (162,'1404014','Land Conversion Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (163,'1404015','Building Application Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (164,'1404016','BPS Application Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (165,'1404017','LRS Application Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (166,'1404018','Fees under PPR Act','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (167,'1404019','Connection/Disconnection charges (Sewerage)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (168,'1404020','Fees from Entertainment Facilities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (169,'1404021','Industrial Effluent Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (170,'1404022','Staircase Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (171,'1404023','Fee from Advertisement on Tree Guards','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (172,'1404024','Attendance Shortage Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (173,'1404025','School Examination Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (174,'1404026','Hospital Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (175,'1404027','Building Material Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (176,'1404099','Other Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (177,'1405001','Medicines Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (178,'1405002','Examination Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (179,'1405003','Ambulance Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (180,'1405004','Funeral Van Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (181,'1405005','Garbage Collection Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (182,'1405006','Littering and Debris collection Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (183,'1405007','Septic Tank Clearance Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (184,'1405008','Special Sanitation Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (185,'1405009','Sewerage Clearance charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (186,'1405010','Crematorium Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (187,'1405011','Burial Ground Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (188,'1405012','Lease of Pay & Use Toilets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (189,'1405013','Water Supply - Non Metered','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (190,'1405014','Water Supply - Metered','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (191,'1405015','Water Tanker Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (192,'1405016','Water Meter','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (193,'1405017','Fire Extinguishing Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (194,'1405018','Water Supply - Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (195,'1405019','Water Supply - Bulk','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (196,'1405020','Storm Water Drainage Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (197,'1405021','Parking fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (198,'1405022','Pre-Paid Parking Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (199,'1405023','Playgorunds User Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (200,'1405024','Quality Control Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (201,'1405025','Coaching Camp Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (202,'1405026','Gym Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (203,'1405027','Drainage User Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (204,'1405028','Animal Catching Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (205,'1405029','User Charges on Hotels, Restaurants, Guest Houses, Lodges etc.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (206,'1405030','Valuation Estimation Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (207,'1405031','Tree/Grass Cutting Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (208,'1405032','Site Approval Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (209,'1405033','Primary Service Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (210,'1405034','Garbage Administration Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (211,'1405035','Fogging Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (212,'1405036','Investigation/Treatment Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (213,'1405037','Skating Rings Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (214,'1405038','Fire Prevention User Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (215,'1405039','Private Scavenging Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (216,'1405099','Other User Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (217,'1406001','Parks Entry Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (218,'1406002','Playgrounds Entry Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (219,'1406003','Swimming Pool Entry Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (220,'1406005','Museum Entry Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (221,'1406006','Monuments Entry Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (222,'1406099','Other Entry Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (223,'1407001','Road Cutting & Restoration Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (224,'1407002','Library Cess Collection Administrative Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (225,'1407003','Plan Preparation Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (226,'1407004','Charges for Removal of Un-authorised Hoardings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (227,'1407005','Charges for Removal of Demolition','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (228,'1407006','Charges for Removal of Encroachments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (229,'1407007','Charges for Removal of Public Nuisances','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (230,'1407008','Administrative Charges for Deposit Works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (231,'1407009','Fee for NOC of Public Health Section','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (232,'1407010','Fee for NOC of Town Planning Section','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (233,'1407011','Water Supply Tap Estimation Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (234,'1407012','Water Supply Tap Repair Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (235,'1407013','Fee for Solvency Certificate','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (236,'1407014','Water Supply Tap Shifting Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (237,'1407015','Drainage Estimation Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (238,'1407016','Drainage Repair Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (239,'1407017','Rent of Tools/Plant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (240,'1407018','Electricity Charges recovery for Rented Premises','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (241,'1407019','Court Charges Recovery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (242,'1407020','Shop Mutation Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (243,'1407021','Lease for Amusement in Parks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (244,'1407022','Receipts from Flower Shows','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (245,'1407023','Advertisement Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (246,'1407024','Other Income from Parks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (247,'1407025','WALTA Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (248,'1407026','Building Material Encroachment Fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (249,'1407027','Vaccination Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (250,'1408001','Compounding fee','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (251,'1408099','Other Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (252,'1409001','Refund of Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (253,'1409002','Remission of Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (254,'1501001','Sale of Tree-Guards','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (255,'1501002','Sale of House Number Plates','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (256,'1501003','Sale of Raw Water','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (257,'1501004','Sale of Nursery plants','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (258,'1501005','Sale of Grass, Flowers & Fruits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (259,'1501006','Sale of Trees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (260,'1501007','Sale of Rubbish','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (261,'1501008','Sale of Garbage','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (262,'1501009','Sale of Manure','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (263,'1501010','Sale of Compost','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (264,'1501011','Sale of Water meter','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (265,'1501012','Sale of Mosquito Nets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (266,'1501013','Sale of Wood','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (267,'1501014','Sale of Animals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (268,'1501101','Sale of Tender Schedules','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (269,'1501102','Sale of Data, Plans & Maps','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (270,'1501103','Sale of Forms & Pass Books','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (271,'1501104','Sale of Trade License Book','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (272,'1501201','Sale of Obsolete stores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (273,'1501202','Sale of Scrap','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (274,'1503001','Sale of Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (275,'1503002','Sale of Old news papers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (276,'1504001','Hire Charges from Cars, Jeeps and Buses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (277,'1504101','Hire Charges from Rollers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (278,'1504102','Hire Charges from Tools & Equipments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (279,'1601001','Road Maintenance Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (280,'1601002','Per Capita Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (281,'1601003','Census Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (282,'1601004','Election Grants','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (283,'1601005','Family Welfare Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (284,'1601006','Secondary Education Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (285,'1601007','Elementary Education Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (286,'1601008','Mid day Meals Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (287,'1601009','CC Charges Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (288,'1601010','Assistance to Municipalities for desiltation of Major & Minor Drains.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (289,'1601011','Compensation to Local Bodies and others in lieu of Magesterial Fines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (290,'1601012','Special Nutrition Programme in Urban Slum Areas','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (291,'1601099','Other Revenue Grants','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (292,'1602001','Reimbursement of Election Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (293,'1602002','Reimbursement of External-aided Projects','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (294,'1602003','Reimbursement of Family Planning Centre Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (295,'1602004','Reimbursement of Family Planning Incentives','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (296,'1602005','Reimbursement of Anti Malaria Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (297,'1602006','Reimbursement of Janmabhoomi Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (298,'1602007','Reimbursement of Sankranthi Sambaralu Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (299,'1602008','Reimbursement of State Festivals Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (300,'1602009','UHC Salaries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (301,'1602099','Reimbursement of Other Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (302,'1603001','Contibution for Swarna Jayanthi Shari Rojgar Yojana','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (303,'1603002','Contibution for National Slum Development Project','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (304,'1603003','Contibution for Integrated Development of Small and Medium Towns','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (305,'1603004','Contibution for Integrated Low Cost Sanitation','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (306,'1603005','Water Supply Tap Donation','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (307,'1603006','Sewerage Donation','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (308,'1603099','Other Contributions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (309,'1604001','Salaries by State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (310,'1604002','Pensions by State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (311,'1604003','Medical Reimbursement by State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (312,'1604004','Obsequies Charges by State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (313,'1604005','DCRG by State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (314,'1701001','Interest on FDs with Scheduled Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (315,'1701003','Interest on Government Securities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (316,'1701004','Interest on Post Office Deposits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (317,'1702001','Dividend on Mutual Fund Investments/Shares','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (318,'1703001','Income from projects taken up on commercial basis','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (319,'1704001','Profit on Sale of Mutual Fund Investments/Shares','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (320,'1708001','Income from Investments-Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (321,'1711001','Interest on Savings Bank Accounts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (322,'1712001','Interest on House Building Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (323,'1712002','Interest on Hire Purchase Quarters','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (324,'1712003','Interest on Vehicle Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (325,'1712004','Interest on Marriage Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (326,'1712005','Interest on Computer Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (327,'1713000','Interest on loans to others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (328,'1718001','Interest on Late Payment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (329,'1718002','Interest on Hire Purchase Sales','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (330,'1718003','Interest on Mobilization Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (331,'1801001','Security Deposits Forfeited','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (332,'1801002','Rental Deposits Forfeited','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (333,'1801003','EMD Forfeited','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (334,'1801101','Lapsed Deposits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (335,'1801102','Lapsed Security Deposits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (336,'1801103','Lapsed Rental Deposits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (337,'1802001','Claims from Insurance Companies for Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (338,'1802002','Claims from Insurance Companies for Vehicles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (339,'1802003','Claims from Insurance Companies for Electronic Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (340,'1802004','Claims from Insurance Companies for Furniture','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (341,'1802005','Claims from Insurance Companies for Inventory','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (342,'1803000','Profit on Disposal of Fixed assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (343,'1804001','Recovery of Excess Fuel Usage from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (344,'1804002','Recovery of Vehicle Use Charges from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (345,'1804003','Recovery of Water & Electricity Charges from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (346,'1804004','Recovery of Cell Phone charges from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (347,'1804005','Recovery of Tele Phone charges from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (348,'1804006','Recovery of Rent from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (349,'1805001','Liabilities Written Back','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (350,'1805002','Stale Cheques','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (351,'1806001','Property Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (352,'1806002','Advertisement Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (353,'1806003','Trade License','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (354,'1806004','Rents','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (355,'1806005','Loans & Advances to Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (356,'1806006','Water Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (357,'1806099','Other Excess Provisions Written Back','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (358,'1808001','Pension & Leave Salary Contribution for Deputataionists','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (359,'1808002','Bounced Cheques Realization Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (360,'1808003','Magisterial Fines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (361,'1808004','Prior Period Income','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (362,'1808005','Other Penalties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (363,'1808006','Other Income Un Classified','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (364,'2101001','Basic Pay','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (365,'2101002','Dearness Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (366,'2101003','House Rent Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (367,'2101004','CCA','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (368,'2101005','Conveyance Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (369,'2101006','Interim Relief','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (370,'2101007','Surrender Leave Encashment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (371,'2101008','Performance Bonus','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (372,'2101009','Personal Pay','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (373,'2101010','Time Scale Wages','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (374,'2101011','Wages to workers through Placement Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (375,'2101012','Pensionary Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (376,'2101013','Contribution for Salaries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (377,'2101014','Contract Staff Salaries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (378,'2101015','Program Workers Wages','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (379,'2101016','Family Planning Incentive','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (380,'2101017','Graduate Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (381,'2101018','Post Graduate Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (382,'2101019','Stagnation Increment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (383,'2101020','Addl. House Rent Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (384,'2101021','New Pension Scheme (Employer Contribution)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (385,'2101022','Special Pay','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (386,'2101023','Computer Professionals Salaries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (387,'2101024','MEPMA Wages','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (388,'2101025','Joining Time Pay','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (389,'2101099','Other Wages and Salaries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (390,'2102001','Leave Travel Concession','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (391,'2102002','Medical Reimbursement','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (392,'2102003','Tuition Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (393,'2102004','Education Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (394,'2102005','Uniform allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (395,'2102006','Workmen Compensations','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (396,'2102007','Training Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (397,'2102008','Concession in Bus-Pass','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (398,'2102009','Dirty Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (399,'2102010','Educational Concession & Scholarships','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (400,'2102011','PHC Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (401,'2102012','Special Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (402,'2102013','Addl. Charge Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (403,'2102014','Subsistence Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (404,'2102015','Monsoon Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (405,'2102016','Night Shift Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (406,'2102017','Conveyance Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (407,'2102018','Non Private Practice Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (408,'2102019','Washing Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (409,'2102020','Physically Handicapped Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (410,'2102021','Tribal/Bad Climate Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (411,'2102022','Risk Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (412,'2102023','Typist Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (413,'2102024','Computer Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (414,'2102025','Overtime Allowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (415,'2102026','Performance Incentives','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (416,'2102027','Health Care and Medical Insurance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (417,'2102028','SupervisoryAllowance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (418,'2102029','Ex Gratia','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (419,'2102099','Other Allowances','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (420,'2103001','Service Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (421,'2103002','Family Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (422,'2103003','Provisional Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (423,'2103004','Anticipatory Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (424,'2104001','Leave encashment on Retirement','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (425,'2104002','Death cum Retirement gratuity','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (426,'2104003','Commuted Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (427,'2104004','Pension and Leave Salary Contributions for Deputationists','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (428,'2104005','General Provident Fund Interest Short fall','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (429,'2104006','Obsequies Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (430,'2201001','Rents for Hired Premises','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (431,'2201002','Rates and Taxes','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (432,'2201101','Electricity Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (433,'2201102','Water Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (434,'2201103','Office Security','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (435,'2201104','Hospitality expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (436,'2201105','Ward Committee Meeting Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (437,'2201106','Standing Committee Meeting Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (438,'2201107','Council/Corporation Meeting Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (439,'2201201','Telephone Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (440,'2201202','Mobiles Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (441,'2201203','Faxes Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (442,'2201204','Leased Lines & Internet Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (443,'2202001','Newspapers & Journals','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (444,'2202002','Magazines','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (445,'2202101','Printing','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (446,'2202102','Stationery','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (447,'2202103','Computer Consumables','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (448,'2202104','Service postage','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (449,'2202105','Xerox','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (450,'2202106','Printing of Invitations and Books','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (451,'2203001','Traveling In land','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (452,'2203002','Traveling Abroad','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (453,'2203003','Fuel for Office Vehicles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (454,'2203004','Hire Charges for Office Vehicles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (455,'2203005','Daily Allowance for Tour','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (456,'2203006','Transfer Travel Allowance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (457,'2204001','Buildings Insurance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (458,'2204002','Vehicles Insurance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (459,'2204003','Electronic Equipment Insurance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (460,'2204004','Furniture Insurance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (461,'2204005','Inventory Insurance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (462,'2205001','Statutory Audit Fee','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (463,'2205002','Certification Fee','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (464,'2205003','Out of Pocket Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (465,'2205101','Legal Fees','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (466,'2205102','Cost of recoveries of tax revenue','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (467,'2205103','Cost of recoveries of other revenues','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (468,'2205104','Cost of Compensations Ordered by Courts','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (469,'2205201','Design and Consultancy Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (470,'2205202','Other Professional Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (471,'2205203','Comprehensive Revenue Survey Fees','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (472,'2205204','Charges for Preparation of DPR','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (473,'2205205','Charges for Preparation of Tender Documents','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (474,'2205206','Accounting Fees','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (475,'2206001','Advertisement – Print Media','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (476,'2206002','Advertisement -TV & Radio media','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (477,'2206003','Advertisement on Hoardings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (478,'2206004','Taxes Collection Campaigns','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (479,'2206005','Non Taxes Collection Campaign','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (480,'2206006','Maintenance of Statutes','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (481,'2206101','Contribution to Professional Associations','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (482,'2206102','Subscriptions and Membership Fees','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (483,'2206103','Subscriptions to Sports Association, Tournments etc.','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (484,'2208001','Honorarium/Conveyance Allowance to Chairman and Councilors','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (485,'2208002','Honorarium to Others','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (486,'2208003','Organization of Festivals','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (487,'2208004','Honorarium to Medical Officers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (488,'2208005','Honorarium to Resource Persons','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (489,'2208006','Honorarium to Assistants','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (490,'2208007','Honorarium to Technical Persons','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (491,'2208099','Other Administrative Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (492,'2301001','Power Charges for Lighting','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (493,'2301002','Power Charges for Water Pumping','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (494,'2301003','Power charges for other services','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (495,'2301004','Fuel to Heavy Vehicles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (496,'2301005','Fuel to Light Vehicles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (497,'2301006','Fuel supply for Field Staff Vehicles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (498,'2302001','Sanitation/Conservancy Material','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (499,'2302002','Purchase of Medicines','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (500,'2302003','Fogging/Anti malaria Material','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (501,'2302004','Water Supply Material','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (502,'2302005','Street Lighting Material','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (503,'2303001','Engineering Stores','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (504,'2303002','Transport Stores','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (505,'2303003','Medical Stores','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (506,'2303004','Central Stationary Stores','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (507,'2303005','Livery for PH staff','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (508,'2303006','Livery for Engineering staff','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (509,'2303007','Livery for Administration staff','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (510,'2303008','Sanitation Stores','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (511,'2303099','Consumption of Other Stores','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (512,'2304001','Machinery Rental Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (513,'2304002','O & M Vehicles Hire Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (514,'2305001','Main Roads - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (515,'2305002','By-lane Roads - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (516,'2305003','Bridges - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (517,'2305004','Fly-Overs - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (518,'2305005','Water Supply Lines - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (519,'2305006','Sewerage Lines - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (520,'2305007','Storm Water Drains - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (521,'2305008','Traffic Signals - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (522,'2305009','Street Lighting - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (523,'2305010','Burial Grounds - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (524,'2305011','Water Supply Mains - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (525,'2305012','Solid Waste Management - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (526,'2305013','Transit Station - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (527,'2305014','Dumping Yard - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (528,'2305015','Compost Yard - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (529,'2305016','Footpaths and Pavements - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (530,'2305017','Rain Water Harvesting Structures - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (531,'2305018','CC Drains Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (532,'2305019','Road Cutting Restoration','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (533,'2305020','Road Marking','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (534,'2305021','Reservoirs and Tanks - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (535,'2305022','Works Scutiny Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (536,'2305023','Heritage Structures/Buildings - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (537,'2305024','Open/Bore Wells - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (538,'2305025','Sewerage Treatment Plant - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (539,'2305026','Sanitation Equipment - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (540,'2305027','CC Culverts - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (541,'2305028','Shifting of Poles and Transformers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (542,'2305029','Survey Stones','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (543,'2305030','Zymnasium Repirs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (544,'2305099','Other Infra Assets - Repairs and Maintenances','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (545,'2305101','Major Parks - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (546,'2305102','Minor Parks - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (547,'2305103','Colony Parks - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (548,'2305104','Stadium - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (549,'2305105','Play Grounds - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (550,'2305106','Swimming Pools - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (551,'2305107','Nursery - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (552,'2305108','Play Materials - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (553,'2305109','Public Toilets & Urinals - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (554,'2305110','Market Yards - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (555,'2305111','Parking Lots - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (556,'2305112','Avenue and Other Plantations - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (557,'2305113','Traffic Islands/Central Media - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (558,'2305114','Forestry and Woodlot Plantations - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (559,'2305115','School Buildings - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (560,'2305116','Reading Rooms/Libraries - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (561,'2305117','Dhobi Ghats - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (562,'2305199','Other Civic Amenities - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (563,'2305201','Auditoriums/Community Halls/Function Halls - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (564,'2305202','Commercial Complex - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (565,'2305203','Office Buildings - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (566,'2305204','Staff Quarters - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (567,'2305205','Hospitals - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (568,'2305206','Schools - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (569,'2305299','Other Buildings - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (570,'2305301','Heavy Vehicles - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (571,'2305302','Light Vehicles - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (572,'2305303','Vehicle Tax','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (573,'2305304','Machinery and Equipment - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (574,'2305305','Vehicle Tracking System Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (575,'2305399','Other Vehicles - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (576,'2305901','Furniture & Fixtures - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (577,'2305902','Computers & Net Work - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (578,'2305903','Electronic Equipment - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (579,'2305904','Office Equipment - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (580,'2305905','Survey & Drawing Equipment - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (581,'2305906','Plant & Machinery - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (582,'2305907','Conservancy Tools - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (583,'2305908','Statues - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (584,'2305909','Quality Control Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (585,'2305910','Computer Software','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (586,'2305911','Electrical Fixures and Appliances - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (587,'2305999','Other Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (588,'2308001','Garbage Clearance Equipment - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (589,'2308002','Testing & Inspection','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (590,'2308003','Field Survey & Inspection','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (591,'2308004','Water Purification - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (592,'2308005','Mapping, Plotting & Drawing Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (593,'2308006','Naming & Numbering of Streets','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (594,'2308007','Demolition & Removal Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (595,'2308008','Quality Control Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (596,'2308009','Prevention of Epidemics','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (597,'2308010','Collection and Testing of Food Samples','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (598,'2308011','Expenses on Unclaimed Dead Bodies','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (599,'2308012','Control of Stray Animals','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (600,'2308013','Sanitation/Conservancy Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (601,'2308014','Intensive/Special Sanitation including for Fairs & Festivals','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (602,'2308015','Maintenance of Garbage Dumping Yards/Transfer Stations','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (603,'2308016','Slaughter Houses - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (604,'2308017','Dumper Bins - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (605,'2308018','Desiltation Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (606,'2308019','Vaccines to Stray Animals','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (607,'2308020','Veterinary Services','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (608,'2308021','Uniforms to Students','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (609,'2308022','Books to Students','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (610,'2308023','Merit Student Scholarships','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (611,'2308024','Master Plan Preparation','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (612,'2308025','Rationalization of Door Numbering','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (613,'2308026','Mother and Child Care Centers Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (614,'2308027','Food Adulteration Tests','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (615,'2308028','School Sweeping Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (616,'2308029','Library Sweeping Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (617,'2308030','School Building Rent','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (618,'2308031','Private Sanitation','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (619,'2308032','Insurance to School Children','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (620,'2308033','Part Time Watchmen Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (621,'2308034','Works Photography and Video','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (622,'2308035','Contract Labour Wages','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (623,'2308036','Recycling expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (624,'2308037','School Toilets Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (625,'2308038','Tricycles Push Carts - Repairs and Maintenance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (626,'2308039','Estimate Scrutiny Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (627,'2308040','Bulk Water Supply Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (628,'2308041','Water Cess','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (629,'2308042','Water Charges for other services','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (630,'2308043','Security Expenses for other premises','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (631,'2308044','Diet to Patients','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (632,'2308099','Other Operating and Maintenance Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (633,'2401000','Interest on Loans from Central Government','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (634,'2402000','Interest on Loans from State Government','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (635,'2403000','Interest on Loans from Government Bodies & Associations','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (636,'2404000','Interest on Loans from International Agencies','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (637,'2405000','Interest on Loans from Banks and Other Financial Institutions','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (638,'2406001','Interest on Bonds','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (639,'2406002','Interest on Finance Lease','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (640,'2406003','Interest on Hire Purchase','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (641,'2406099','Interest on Other Credits','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (642,'2407001','Miscellaneous Bank Charges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (643,'2408001','Expenses on Issue of Bonds','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (644,'2408002','Surveillance Fee','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (645,'2408003','Transaction Processing For Collections','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (646,'2408004','Credit Rating Analysis Fee','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (647,'2408099','Other Finance Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (648,'2501001','Local Body Elections','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (649,'2501002','MLA/MP Elections','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (650,'2502001','Environmental Awareness Programme','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (651,'2502002','Visit of Study Teams/VIPs','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (652,'2502003','Study Tour/Trainings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (653,'2502004','Meetings, Seminars, Conferences etc.','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (654,'2502005','Voluntary Garbage Disposal Programme','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (655,'2502006','Cultural Programmes','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (656,'2502007','Community Organisation /Mobilisation','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (657,'2502008','Special Nutritation Programme','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (658,'2502009','Summer/Winter Coaching Camps','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (659,'2502010','Exhibitions','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (660,'2502011','Janmabhoomi','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (661,'2502012','Sankranthi Sambaralu','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (662,'2502013','National and State Festivals','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (663,'2502014','Capacity Building/Training','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (664,'2502015','Pulse Polio Camps','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (665,'2502016','AIDS Control Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (666,'2502017','Family Planning Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (667,'2502018','Literacy Camps','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (668,'2502019','Child Labour Eradication Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (669,'2502020','Leprosy/TB Eradication','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (670,'2502021','Child Marriages Eradication Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (671,'2502022','Assistance to Orphans and Widows','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (672,'2502023','Low Cost Meals Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (673,'2502024','Clean and Green Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (674,'2502025','Health Camps','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (675,'2502026','Mosquito Control Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (676,'2502027','Play Schools','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (677,'2502028','Neeru Chettu Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (678,'2502029','Sports Competitions','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (679,'2502030','Street Vendors Rehabilitation','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (680,'2502031','Urban Homeless Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (681,'2502032','Multipurpose Resource Centers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (682,'2502033','Teachers Incentives','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (683,'2502034','Mass Immunization Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (684,'2502035','Grants to Charities','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (685,'2502036','Pushkar Festival','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (686,'2502099','Other Program Expenses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (687,'2503001','Family Welfare Programme','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (688,'2503002','Financial Aid for Urban Self Help Groups','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (689,'2503003','Disbursements to T&S / DWCUA and Self Help Groups under SJSRY','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (690,'2503004','Shilparamam Greening/Others','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (691,'2503005','Urban Malaria Eradication','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (692,'2503006','Mid Day Meals Program','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (693,'2503099','Share in Others Programs','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (694,'2601000','Grants-Grants','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (695,'2602000','Contributions-Contributions','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (696,'2603000','Subsidies-Subsidies','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (697,'2701001','Provision for Property Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (698,'2701002','Provision for Advertisement Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (699,'2701003','Provision for Water Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (700,'2701004','Provision for Trade License','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (701,'2701005','Provision of VLT','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (702,'2701006','Provision for Rental Income','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (703,'2701007','Provision for Sewerage Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (704,'2701099','Provision for Other Receivables','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (705,'2702003','Provision for Loans & Advances to others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (706,'2703001','Write off - Property Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (707,'2703002','Write off - Advertisement Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (708,'2703003','Write off - Water Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (709,'2703004','Write off - Trade License','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (710,'2703005','Write off - VLT','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (711,'2703006','Write off - Rental Income','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (712,'2703007','Write off - Sewerage Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (713,'2703099','Write off - Other Income','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (714,'2704001','Write off - Stores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (715,'2704002','Write off - Investments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (716,'2704003','Decline in Fixed Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (717,'2704004','Write off - Loans & Advances to others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (718,'2705001','Deferred Revenue Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (719,'2711000','Loss on disposal of Assets-Loss on disposal of Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (720,'2712001','Loss on disposal of Mutual Fund Investment/shares','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (721,'2713000','Decline in Value of Investments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (722,'2718001','Refund of Lapsed Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (723,'2722000','Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (724,'2723000','Roads and Bridges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (725,'2723100','Sewerage and Drainage','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (726,'2723200','Waterways','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (727,'2723300','Public Lighting','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (728,'2724000','Plant and machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (729,'2725000','Vehicles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (730,'2726000','Office & Other Equipments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (731,'2727000','Furniture, Fixtures, Fittings and Electrical Appliances','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (732,'2728000','Other Fixed Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (733,'2801000','Taxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (734,'2802000','Other – Revenues','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (735,'2803000','Recovery of revenues written off','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (736,'2804000','Other Income','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (737,'2805000','Refund of Taxes-Refund of Taxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (738,'2806000','Refund of Other – Revenues','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (739,'2808000','Other Expenses-Other Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (740,'2901001','Transfer to City Development Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (741,'2901002','Transfer to UCD Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (742,'2902001','Transfer to Sinking Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (743,'2902002','Transfer to Salary Reserve Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (744,'2902003','Transfer to Pension Reserve Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (745,'2902004','Urban Poverty Alleviation Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (746,'2903001','Transfer to General Reserve','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (747,'2903002','Transfer to Surplus/Deficit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (748,'3101001','Revenue Transfers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (749,'3109000','Excess of Income over Expenditure','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (750,'3111001','City Development Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (751,'3111002','Urban Poverty Alleviation Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (752,'3111003','Abatement of Pollution of Rivers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (753,'3111004','Preservation of Heritage sites fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (754,'3111005','Revolving Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (755,'3111006','Benefit Fund for Members','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (756,'3111007','Allocation to SCs','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (757,'3111008','Allocation to STs','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (758,'3111009','Allocation to Women and Child welfare','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (759,'3111010','Allocation to Physically Challenged','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (760,'3111099','Other Special Funds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (761,'3115001','City Development Bonds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (762,'3115099','Other Sinking Funds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (763,'3117001','Salary Reserve Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (764,'3117002','Pension Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (765,'3117003','Municipal Provident Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (766,'3117004','Janasree Bhima Yojana','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (767,'3117005','Pavala Vaddi/ Vaddi leni Runalu','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (768,'3117006','Old age Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (769,'3117007','Widow Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (770,'3117008','Disabled Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (771,'3117009','Weavers Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (772,'3117010','Toddy Toppers Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (773,'3117011','Abhaya Hastam Pension','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (774,'3117012','National Family Benefit Scheme Scheme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (775,'3117013','National Maternity Benefit Scheme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (776,'3117014','Girl Child Protection Scheme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (777,'3117015','Corpus fund for Poor Students','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (778,'3117099','Other Trust or Agency Funds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (779,'3121000','Capital Contribution-Capital Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (780,'3121100','Capital Reserve-Capital Reserve','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (781,'3122000','Recovery of Excess Fuel Usage from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (782,'3123001','Special Development Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (783,'3123002','SC ST Special Development Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (784,'3123003','City Challenge Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (785,'3124000','Statutory Reserve-Statutory Reserve','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (786,'3125001','Other Reserves','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (787,'3126001','Fixed Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (788,'3201001','Adarsh Basti Scheme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (789,'3201002','Abatement of Pollution of Rivers Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (790,'3201003','Jnnurm GoI','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (791,'3201004','RAY GOI','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (792,'3201005','XII Finance Commission','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (793,'3201006','XIII Finance Commission','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (794,'3201007','MP Local Area Development','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (795,'3201008','XIV Finance Commission','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (796,'3201009','AMRUT','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (797,'3201010','HRIDAY','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (798,'3201011','IHHL and CL (SBM) GoI Share','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (799,'3201012','IDSMT','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (800,'3201013','UIDSSMT','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (801,'3201014','IHSDP','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (802,'3201015','Fisheries Grant (NFDP)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (803,'3201016','Jnnurm Institutional Funding','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (804,'3201017','BRGF','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (805,'3201018','BSUP','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (806,'3201099','Other Central Govt. Grants','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (807,'3202001','Assistance for Water Supply Schemes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (808,'3202002','State Finance Commission','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (809,'3202003','MLA Local Area Development','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (810,'3202004','Assembly Constituency Development Programme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (811,'3202005','Adverse Seasonal Conditions Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (812,'3202006','Jnnurm GoAP','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (813,'3202007','RAY GoAP','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (814,'3202008','Improvement of Cities Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (815,'3202009','MEPMA','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (816,'3202010','Rain Water Harvesting (RWH) Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (817,'3202011','Make City Green','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (818,'3202012','MRTS Project','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (819,'3202013','TWINS/e-Seva Project','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (820,'3202014','National Slum Development Programme (NSDP)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (821,'3202015','SJSRY EUP','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (822,'3202016','Balika Samrudhi Yojana (BSY)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (823,'3202017','Local Water Supply & Sewerage in Slums Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (824,'3202018','Urban Community Development (UCD) Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (825,'3202019','IPP VIII Project','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (826,'3202020','Natural Calamities Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (827,'3202021','Reimbursementfrom Govt Departments including R&B','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (828,'3202022','Abatement of Pollution of Rivers Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (829,'3202023','Mid Day Meals - School Kitchens Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (830,'3202024','Under Ground Drainage Scheme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (831,'3202025','AMRUT State Share','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (832,'3202026','IHHL and CL (SBM) GoAP Share','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (833,'3202027','Solid Waste Management','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (834,'3202028','Parks Development','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (835,'3202029','Basic Facilities to Municipal Schools','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (836,'3202030','Summer Action Plan','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (837,'3202031','Cyclone Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (838,'3202032','Internal Roads - Plan','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (839,'3202033','Internal Roads - Non Plan','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (840,'3202034','Office Building Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (841,'3202035','APMDP - Water Supply','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (842,'3202036','Night Shelter Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (843,'3202037','Special Nutrition Scheme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (844,'3202038','Assistance under Indiramma Program for Maintenance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (845,'3202039','Assistance under Indiramma Program for Infrastructure','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (846,'3202040','Assistance to New Municipalities for Development Works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (847,'3202041','Special Development Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (848,'3202042','Civic Infrastructure','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (849,'3202043','Internal Roads (FOB)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (850,'3202044','Public Awareness and IEC (SBM)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (851,'3202045','Assistance for Infrastructure (Rajeev Nagara Bata)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (852,'3202046','Eseva Building','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (853,'3202047','Civic Amenities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (854,'3202048','Urban Health Center','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (855,'3202049','Environment Improvement in Urban Slums (EIUS) Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (856,'3202050','Fencing of Parks and Playgrounds Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (857,'3202051','Storm Water Drainage Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (858,'3202052','Flood Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (859,'3202053','NULM Self Employment Scheme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (860,'3202054','Employment Skills Program','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (861,'3202055','Shelter for Urban homeless','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (862,'3202056','Street Vendors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (863,'3202057','Social Mobilization and Institutional Development','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (864,'3202058','Stadium Development','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (865,'3202059','Community Halls and Cultural Facilities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (866,'3202060','City Livelihood Centers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (867,'3202061','Capacity Building and Training','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (868,'3202062','CM Assurance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (869,'3202063','Pushkaram Grant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (870,'3202099','Other State Govt. Grants','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (871,'3203001','Grants from Other Central GovernmentAgencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (872,'3203002','Grants from Other State Government Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (873,'3204000','Financial Institutions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (874,'3205000','Welfare Bodies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (875,'3206001','Water & Sanitation Programme (World Bank)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (876,'3206002','Urban Management/CitiesAlliance Programme (UNCHS –World Bank)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (877,'3206099','Other Grants from International Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (878,'3208001','Public Contribution for Works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (879,'3208002','Abatement of Pollution of River (Industry Contribution)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (880,'3208003','Other Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (881,'3208004','Beneficiary Contribution for Schemes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (882,'3208005','Beneficiary Contribution for ILCS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (883,'3208006','Beneficiary Contribution for IHHL','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (884,'3208007','Donations for Education','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (885,'3208008','Donations for Play Material and Park Seats','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (886,'3208009','Water Supply Tap Donations','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (887,'3208010','Sewerage Donations','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (888,'3208011','Endowments and Donations','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (889,'3208012','Tree Guards Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (890,'3208013','RWHS Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (891,'3208014','BPS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (892,'3208015','BRS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (893,'3208016','LRS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (894,'3208017','Water Tap Regularization Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (895,'3208018','Sewerage Connection Regularization Fees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (896,'3208019','Development Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (897,'3208020','Goodwill from Shops','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (898,'3208021','Goodwill from Markets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (899,'3208022','Open Space Contribution','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (900,'3208023','City Level Infrastructure Development Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (901,'3208024','Receipts for Naming of Civic Utilities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (902,'3301001','Secured Short Term Loans from Central Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (903,'3301002','Secured Long Term Loans from Central Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (904,'3302001','Secured Short Term Loans from State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (905,'3302002','Secured Long Term Loans from State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (906,'3303000','Loans from Government Bodies & Association','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (907,'3304000','Loans from International Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (908,'3305001','Secured Loans from Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (909,'3305002','Secured Loans from Other Financial Institutions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (910,'3305003','Secured Loans from Institutional Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (911,'3306001','Secured HUDCO Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (912,'3306099','Other Secured Term Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (913,'3307001','Secured Bonds & Debentures','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (914,'3308000','Other Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (915,'3311001','Unsecured Short Term Loans from Cental Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (916,'3311002','Unsecured Long Term Loans from Central Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (917,'3312001','Unsecured Short Term Loans from State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (918,'3312002','Unsecured Long Term Loans from State Govt.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (919,'3313000','Loans from Government Bodies and Association','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (920,'3314000','Loans from International Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (921,'3315001','Unsecured Loans from Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (922,'3315002','Unsecured Loans from Other Financial Institutions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (923,'3315003','Unsecured Loans from Institutional Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (924,'3316001','Unsecured HUDCO Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (925,'3317001','Unsecured Bonds & Debentures','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (926,'3318000','Other Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (927,'3401001','Ernest Money Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (928,'3401002','Retention Money Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (929,'3401003','Further Security Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (930,'3401004','Additional Security Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (931,'3401005','Performance Security Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (932,'3402001','Rental Deposits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (933,'3402002','Security Deposits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (934,'3402003','Auction Deposits - Markets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (935,'3402004','Auction Deposits - Slaughter Houses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (936,'3402005','Auction Deposits - Leases','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (937,'3403001','Security Deposit - Staff','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (938,'3408001','Technical Professionals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (939,'3408002','Security Deposit - Building Permission','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (940,'3411001','Civil Deposit Works State Government Departments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (941,'3411002','Civil Deposit Works Public Sector Undertakings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (942,'3411003','Civil Deposit Works Private Organizations & Citizens','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (943,'3412000','Electrical works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (944,'3418001','Other Deposit Works - State Government Departments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (945,'3418002','Other Deposit Works - Public Sector Undertakings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (946,'3418003','Other Deposit Works - Private Organizations & Citizens','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (947,'3501001','Suppliers Payables','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (948,'3501002','Contractors Payables','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (949,'3501003','Expenses Payables','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (950,'3501101','Salary Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (951,'3501102','Pension Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (952,'3501103','Leave Salary Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (953,'3501104','Terminal Benefits Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (954,'3501105','Deputationists Salary and Pension payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (955,'3501106','Unpaid Salaries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (956,'3501107','Contributory Pension Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (957,'3501201','Interest accrued and due on Central Government Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (958,'3501202','Interest accrued and due on State Government Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (959,'3501203','Interest accrued and due on International Agencies Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (960,'3501204','Interest accrued and due on Financial Institutions Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (961,'3501205','Interest accrued and due on Bonds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (962,'3501299','Interest accrued and due on Other Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (963,'3502001','GPF','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (964,'3502002','GPF –Employees on Deputation','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (965,'3502003','GIS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (966,'3502004','Profession Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (967,'3502005','APGLI','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (968,'3502006','LIC Premia','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (969,'3502007','Bank Loan','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (970,'3502008','TDS from Employees','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (971,'3502009','APEWF','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (972,'3502010','Court Recoveries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (973,'3502011','Rent on Quarters','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (974,'3502012','New Pension Scheme','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (975,'3502013','Flag Day Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (976,'3502014','CM Relief Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (977,'3502015','Labour Cess','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (978,'3502016','Employee Provident Fund','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (979,'3502017','Employee State Insurance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (980,'3502018','Cooperative Society1','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (981,'3502019','Cooperative Society2','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (982,'3502020','Cooperative Society3','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (983,'3502021','Cooperative Society4','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (984,'3502022','Other Cooperative Society','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (985,'3502023','GLIS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (986,'3502024','Other Employee Deductions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (987,'3502025','TDS from Contractors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (988,'3502026','GST','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (989,'3502027','Service Tax on Rents','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (990,'3502028','Service Tax on Sale of Space for Advertisements','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (991,'3502029','Interest on Service Tax on Rents','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (992,'3502030','Penalty on Service Tax on Rents','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (993,'3502031','Interest on Service Tax on Sale of Space for Advts.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (994,'3502032','Penalty on Service Tax on Sale of Space for Advts.','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (995,'3502033','Third Party Quality Control','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (996,'3502051','Turnover Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (997,'3502052','VAT/Works Contract Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (998,'3502053','CST','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (999,'3502054','Service Tax on Works/Consultancies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1000,'3502055','NAC','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1001,'3502056','Seignorage Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1002,'3502057','TDS Payable Interest','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1003,'3502058','Other Recoveries From Contractors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1004,'3502061','Court Attachments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1005,'3503001','Library Cess','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1006,'3503002','Education Cess','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1007,'3503003','Govt Dues Court Attachment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1008,'3504001','Tax Refunds Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1009,'3504002','Family Benefit Fund Settlements Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1010,'3504003','Group Insurance Settlements Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1011,'3504004','Unutilized Grants','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1012,'3504005','Deposit Works Refund Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1013,'3504006','Development Charges to UDA','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1014,'3504099','Other Refunds Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1015,'3504101','Property Tax Advance Collection','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1016,'3504102','Advertisement Tax Advance Collection','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1017,'3504103','Trade License Advance Collection','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1018,'3504104','Rent Advance Collection','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1019,'3504105','VLT Advance Collection','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1020,'3504106','Water Charges Advance Collection','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1021,'3504199','Other Revenue Advance Collection','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1022,'3508001','Stale Cheque','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1023,'3508002','Compensation Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1024,'3508003','Lease Charges Payable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1025,'3508004','Advances under Hire Purchases','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1026,'3508005','Election deposit from candidates','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1027,'3509001','Sale proceeds from Distrained Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1028,'3509002','Sale proceeds from Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1029,'3509003','Sale proceeds from Stores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1030,'3601001','Provison for Establishment Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1031,'3601002','Provison for Administrative Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1032,'3601003','Provision for Operations & Maintenance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1033,'3602001','Provison for Interest Accrued and not due','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1034,'3603001','Provison for loss of Inventory','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1035,'3603002','Provison for loss on Investments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1036,'3604001','Provision for Property Tax Receivables','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1037,'3604002','Provison for Advertisement Tax Receivables','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1038,'3604003','Provison for Trade License Receivable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1039,'3604004','Provison for Rents Receivable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1040,'3604005','Provison for VLT Receivable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1041,'3604006','Provison for Water Charges Receivable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1042,'3604099','Provison for other receivables','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1043,'4101001','Open Space','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1044,'4101002','Grounds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1045,'4101003','Parks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1046,'4101004','Gardens','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1047,'4101005','Burial ground','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1048,'4101006','Nurseries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1049,'4101007','Urban Forestry and Plantation','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1050,'4101008','Lay Outs and Land Development','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1051,'4101099','Other Lands','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1052,'4102001','Office Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1053,'4102002','Commercial Complex','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1054,'4102003','Health Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1055,'4102004','Community Halls','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1056,'4102005','Guest Houses and Travellers Bunglows','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1057,'4102006','Staff Quarters','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1058,'4102007','Public Latrines & Urinals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1059,'4102008','School Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1060,'4102009','Stadium','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1061,'4102010','Reading Rooms/Libraries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1062,'4102011','Swimming Pools','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1063,'4102012','Skating Ring','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1064,'4102013','Slaughter House','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1065,'4102014','Markets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1066,'4102015','Eseva Building','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1067,'4102016','Crematorium Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1068,'4102017','Dhobi Ghats','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1069,'4102018','Zymnasium Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1070,'4102019','Town Halls and Theatres','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1071,'4102020','Open Air Theatres','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1072,'4102021','Bus Shelters','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1073,'4102022','Public Conveniences','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1074,'4102023','Compound Walls','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1075,'4102024','Seats in Parks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1076,'4102099','Other Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1077,'4103001','Concrete Road','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1078,'4103002','Black Topped Roads','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1079,'4103003','Link Roads, Parallel Roads & Slip Roads','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1080,'4103004','Footpaths & Pavements Concrete','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1081,'4103005','Bridges & Culverts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1082,'4103006','Fly-overs & Over Bridges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1083,'4103007','Subways & Causeways','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1084,'4103008','Foot-over Bridges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1085,'4103009','Traffic Junctions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1086,'4103010','Traffic Island and Central Media','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1087,'4103011','Traffic Signals and Solar Signalling','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1088,'4103012','Road Widening Compensation','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1089,'4103013','Pedestrain Project','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1090,'4103014','Parking Lots','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1091,'4103015','Stone and Metal Roads','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1092,'4103016','Footpaths & Pavements Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1093,'4103099','Others Roads and Bridges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1094,'4103101','Underground Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1095,'4103102','Major Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1096,'4103103','Minor Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1097,'4103104','Sewerage Treatment Plant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1098,'4103105','CC Culverts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1099,'4103106','Open Mason Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1100,'4103107','Table Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1101,'4103108','Sewerage Lines (MS/GI/CI)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1102,'4103109','Dewatering Pumps','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1103,'4103110','Pumps, Motors and Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1104,'4103201','Water Works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1105,'4103202','Open Wells','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1106,'4103203','Reservoirs','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1107,'4103204','Pump House','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1108,'4103205','Water Main Lines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1109,'4103206','Water Distribution Lines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1110,'4103207','Water bodies – Major','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1111,'4103208','Water bodies - Minor','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1112,'4103209','Elevated Service Reservoir','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1113,'4103210','Ground Level Service Reservoir','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1114,'4103211','Summer Storage Tank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1115,'4103212','Water Channels','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1116,'4103213','Bore Wells - Motor','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1117,'4103214','Submersible Pumps','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1118,'4103215','SCADA System','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1119,'4103216','Water Quality Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1120,'4103217','Water Metering','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1121,'4103218','Water Fountains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1122,'4103219','River Embanking','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1123,'4103220','Drinking Water Units','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1124,'4103301','Lighting On Main Roads','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1125,'4103302','Lighting On Lanes By lanes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1126,'4103303','Decorative Lighting','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1127,'4103304','Solar Lighting','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1128,'4104001','Roads Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1129,'4104002','Water Supply Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1130,'4104003','Transport Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1131,'4104004','Electrical Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1132,'4104005','Electrical Crematorium','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1133,'4104006','Slaughter House Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1134,'4104099','Other Plant and Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1135,'4105001','Ambulance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1136,'4105002','Buses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1137,'4105003','Cars & Jeeps','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1138,'4105004','Cranes/JCB/Proclainer','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1139,'4105005','Trucks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1140,'4105006','Tankers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1141,'4105007','Sweeping Machines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1142,'4105008','Autos','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1143,'4105009','Tractors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1144,'4105010','Two Wheelers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1145,'4105011','Mini Lorries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1146,'4105012','Hydraulic Ladders','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1147,'4105013','Loader','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1148,'4105014','Compacter','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1149,'4105015','Carts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1150,'4105016','Bicycles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1151,'4105017','Tricycles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1152,'4105018','Push Carts and Trolleys','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1153,'4105019','Wheel Borrows','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1154,'4105020','Vehicle Tracking System','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1155,'4105021','Road Rollers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1156,'4105022','Bull Dozers and Excavators','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1157,'4105099','Other Vehicles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1158,'4106001','Air Conditioners','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1159,'4106002','Computers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1160,'4106003','Faxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1161,'4106004','Photocopiers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1162,'4106005','Refrigerators','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1163,'4106006','Network Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1164,'4106007','Network Cabling','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1165,'4106008','TV','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1166,'4106009','Mobiles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1167,'4106010','Telephones and EPABX','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1168,'4106011','Cameras','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1169,'4106012','WiFi Connectivity','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1170,'4106013','Water Coolers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1171,'4106014','Public Address System','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1172,'4106015','Typewriters/Duplicating Machines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1173,'4106016','Radios','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1174,'4106017','Computer Peripherals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1175,'4106018','Stabilizer and UPS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1176,'4106019','Plotter and Scanner','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1177,'4106020','Printers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1178,'4106021','Handheld Collection Devices','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1179,'4106099','Other Office Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1180,'4107001','Cabinets & Partitions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1181,'4107002','Cupboards','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1182,'4107003','Fans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1183,'4107004','Electrical Fittings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1184,'4107005','Tables & Chairs','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1185,'4107006','Bureaus and Racks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1186,'4107007','Fixtures','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1187,'4107008','Books','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1188,'4107009','Survey and Drawing Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1189,'4107010','Generators','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1190,'4107099','Other Appliances','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1191,'4108001','Dumper Bins','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1192,'4108002','Dust and Litter Bins','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1193,'4108003','Dumping Yard facilities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1194,'4108004','Dumping Yard Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1195,'4108005','Vermi Compost Unit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1196,'4108006','SWM Processing Unit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1197,'4108007','Operation Theatre Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1198,'4108008','Medical Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1199,'4108009','Play and Sports Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1200,'4108010','Zym Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1201,'4108011','Food Adulteration Testing','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1202,'4108012','Rain Water Harvesting Structures','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1203,'4108013','Tree Guards','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1204,'4108014','Mapping and GIS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1205,'4108015','School Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1206,'4108016','Animals in Parks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1207,'4108017','Sewing Centers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1208,'4108018','Hawker Zones','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1209,'4108019','Sanitation Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1210,'4108020','Electronic Library','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1211,'4108021','Quality Lab Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1212,'4108022','Freezer Boxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1213,'4108023','Fogging Machines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1214,'4108024','Technical Lab Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1215,'4108025','Printing Press Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1216,'4108026','General Workshop Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1217,'4108027','Mechanical Workshop Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1218,'4108028','Shredder','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1219,'4108029','Books','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1220,'4108099','Other Fixed Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1221,'4109001','Valuable Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1222,'4109002','Scraped Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1223,'4112001','Acc. Dep.-Office Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1224,'4112002','Acc. Dep.-Commercial Complex','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1225,'4112003','Acc. Dep.-Health Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1226,'4112004','Acc. Dep.-Community Halls','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1227,'4112005','Acc. Dep.-Guest Houses and Travellers Bunglows','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1228,'4112006','Acc. Dep.-Staff Quarters','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1229,'4112007','Acc. Dep.-Public Latrines & Urinals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1230,'4112008','Acc. Dep.-School Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1231,'4112009','Acc. Dep.-Stadium','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1232,'4112010','Acc. Dep.-Reading Rooms/Libraries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1233,'4112011','Acc. Dep.-Swimming Pools','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1234,'4112012','Acc. Dep.-Skating Ring','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1235,'4112013','Acc. Dep.-Slaughter House','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1236,'4112014','Acc. Dep.-Markets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1237,'4112015','Acc. Dep.-Eseva Building','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1238,'4112016','Acc. Dep.-Crematorium Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1239,'4112017','Acc. Dep.-Dhobi Ghats','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1240,'4112018','Acc. Dep.-Zymnasium Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1241,'4112019','Acc. Dep.-Town Halls and Theatres','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1242,'4112020','Acc. Dep.-Open Air Theatres','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1243,'4112021','Acc. Dep.-Bus Shelters','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1244,'4112022','Acc. Dep.-Public Conveniences','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1245,'4112023','Acc. Dep.-Compound Walls','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1246,'4112024','Acc. Dep.-Seats in Parks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1247,'4112099','Acc. Dep.-Other Buildings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1248,'4113001','Acc. Dep.-Concrete Road','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1249,'4113002','Acc. Dep.-Black Topped Roads','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1250,'4113003','Acc. Dep.-Link Roads, Parallel Roads & Slip Roads','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1251,'4113004','Acc. Dep.-Footpaths & Pavements Concrete','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1252,'4113005','Acc. Dep.-Bridges & Culverts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1253,'4113006','Acc. Dep.-Fly-overs & Over Bridges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1254,'4113007','Acc. Dep.-Subways & Causeways','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1255,'4113008','Acc. Dep.-Foot-over Bridges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1256,'4113009','Acc. Dep.-Traffic Junctions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1257,'4113010','Acc. Dep.-Traffic Island and Central Media','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1258,'4113011','Acc. Dep.-Traffic Signals and Solar Signalling','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1259,'4113012','Acc. Dep.-Road Widening Compensation','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1260,'4113013','Acc. Dep.-Pedestrain Project','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1261,'4113014','Acc. Dep.-Parking Lots','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1262,'4113015','Acc. Dep.-Stone and Metal Roads','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1263,'4113016','Acc. Dep.-Footpaths & Pavements Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1264,'4113099','Acc. Dep.-Other Roads and Bridges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1265,'4113101','Acc. Dep.-Underground Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1266,'4113102','Acc. Dep.-Major Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1267,'4113103','Acc. Dep.-Minor Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1268,'4113104','Acc. Dep.-Sewerage Treatment Plant','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1269,'4113105','Acc. Dep.-CC Culverts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1270,'4113106','Acc. Dep.-Open Mason Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1271,'4113107','Acc. Dep.-Table Drains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1272,'4113108','Acc. Dep.-Sewerage Lines (MS/GI/CI)','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1273,'4113109','Acc. Dep.-Dewatering Pumps','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1274,'4113110','Acc. Dep.-Pumps, Motors and Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1275,'4113201','Acc. Dep.-Water Works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1276,'4113202','Acc. Dep.-Open Wells','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1277,'4113203','Acc. Dep.-Reservoirs','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1278,'4113204','Acc. Dep.-Pump House','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1279,'4113205','Acc. Dep.-Water Main Lines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1280,'4113206','Acc. Dep.-Water Distribution Lines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1281,'4113207','Acc. Dep.-Water bodies – Major','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1282,'4113208','Acc. Dep.-Water bodies - Minor','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1283,'4113209','Acc. Dep.-Elevated Service Reservoir','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1284,'4113210','Acc. Dep.-Ground Level Service Reservoir','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1285,'4113211','Acc. Dep.-Summer Storage Tank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1286,'4113212','Acc. Dep.-Water Channels','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1287,'4113213','Acc. Dep.-Bore Wells - Motor','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1288,'4113214','Acc. Dep.-Submersible Pumps','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1289,'4113215','Acc. Dep.-SCADA System','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1290,'4113216','Acc. Dep.-Water Quality Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1291,'4113217','Acc. Dep.-Water Metering','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1292,'4113218','Acc. Dep.-Water Fountains','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1293,'4113219','Acc. Dep.-River Embanking','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1294,'4113220','Acc. Dep.-Drinking Water Units','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1295,'4113301','Acc. Dep.-Lighting On Main Roads','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1296,'4113302','Acc. Dep.-Lighting On Lanes By lanes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1297,'4113303','Acc. Dep.-Decorative Lighting','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1298,'4113304','Acc. Dep.-Solar Lighting','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1299,'4114001','Acc. Dep.-Roads Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1300,'4114002','Acc. Dep.-Water Supply Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1301,'4114003','Acc. Dep.-Transport Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1302,'4114004','Acc. Dep.-Electrical Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1303,'4114005','Acc. Dep.-Electrical Crematorium','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1304,'4114006','Acc. Dep.-Slaughter House Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1305,'4114099','Acc. Dep.-Other Plant and Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1306,'4115001','Acc. Dep.-Ambulance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1307,'4115002','Acc. Dep.-Buses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1308,'4115003','Acc. Dep.-Cars & Jeeps','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1309,'4115004','Acc. Dep.-Cranes/JCB/Proclainer','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1310,'4115005','Acc. Dep.-Trucks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1311,'4115006','Acc. Dep.-Tankers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1312,'4115007','Acc. Dep.-Sweeping Machines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1313,'4115008','Acc. Dep.-Autos','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1314,'4115009','Acc. Dep.-Tractors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1315,'4115010','Acc. Dep.-Two Wheelers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1316,'4115011','Acc. Dep.-Mini Lorries','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1317,'4115012','Acc. Dep.-Hydraulic Ladders','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1318,'4115013','Acc. Dep.-Loader','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1319,'4115014','Acc. Dep.-Compacter','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1320,'4115015','Acc. Dep.-Carts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1321,'4115016','Acc. Dep.-Bicycles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1322,'4115017','Acc. Dep.-Tricycles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1323,'4115018','Acc. Dep.-Push Carts and Trolleys','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1324,'4115019','Acc. Dep.-Wheel Borrows','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1325,'4115020','Acc. Dep.-Vehicle Tracking System','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1326,'4115021','Acc. Dep.-Road Rollers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1327,'4115022','Acc. Dep.-Bull Dozers and Excavators','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1328,'4115099','Acc. Dep.-Other Vehicles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1329,'4116001','Acc. Dep.-Air Conditioners','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1330,'4116002','Acc. Dep.-Computers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1331,'4116003','Acc. Dep.-Faxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1332,'4116004','Acc. Dep.-Photocopiers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1333,'4116005','Acc. Dep.-Refrigerators','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1334,'4116006','Acc. Dep.-Network Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1335,'4116007','Acc. Dep.-Network Cabling','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1336,'4116008','Acc. Dep.-TV','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1337,'4116009','Acc. Dep.-Mobiles','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1338,'4116010','Acc. Dep.-Telephones and EPABX','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1339,'4116011','Acc. Dep.-Cameras','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1340,'4116012','Acc. Dep.-WiFi Connectivity','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1341,'4116013','Acc. Dep.-Water Coolers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1342,'4116014','Acc. Dep.-Public Address System','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1343,'4116015','Acc. Dep.-Typewriters/Duplicating Machines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1344,'4116016','Acc. Dep.-Radios','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1345,'4116017','Acc. Dep.-Computer Peripherals','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1346,'4116018','Acc. Dep.-Stabilizer and UPS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1347,'4116019','Acc. Dep.-Plotter and Scanner','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1348,'4116020','Acc. Dep.-Printers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1349,'4116021','Acc. Dep.-Handheld Collection Devices','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1350,'4116099','Acc. Dep.-Other Office Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1351,'4117001','Acc. Dep.-Cabinets & Partitions','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1352,'4117002','Acc. Dep.-Cupboards','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1353,'4117003','Acc. Dep.-Fans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1354,'4117004','Acc. Dep.-Electrical Fittings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1355,'4117005','Acc. Dep.-Tables & Chairs','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1356,'4117006','Acc. Dep.-Bureaus and Racks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1357,'4117007','Acc. Dep.-Fixtures','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1358,'4117008','Acc. Dep.-Books','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1359,'4117009','Acc. Dep.-Survey and Drawing Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1360,'4117010','Acc. Dep.-Generators','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1361,'4117099','Acc. Dep.-Other Appliances','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1362,'4118001','Acc. Dep.-Dumper Bins','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1363,'4118002','Acc. Dep.-Dust and Litter Bins','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1364,'4118003','Acc. Dep.-Dumping Yard facilities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1365,'4118004','Acc. Dep.-Dumping Yard Machinery','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1366,'4118005','Acc. Dep.-Vermi Compost Unit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1367,'4118006','Acc. Dep.-SWM Processing Unit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1368,'4118007','Acc. Dep.-Operation Theatre Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1369,'4118008','Acc. Dep.-Medical Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1370,'4118009','Acc. Dep.-Play and Sports Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1371,'4118010','Acc. Dep.-Zym Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1372,'4118011','Acc. Dep.-Food Adulteration Testing','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1373,'4118012','Acc. Dep.-Rain Water Harvesting Structures','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1374,'4118013','Acc. Dep.-Tree Guards','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1375,'4118014','Acc. Dep.-Mapping and GIS','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1376,'4118015','Acc. Dep.-School Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1377,'4118016','Acc. Dep.-Animals in Parks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1378,'4118017','Acc. Dep.-Sewing Centers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1379,'4118018','Acc. Dep.-Hawker Zones','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1380,'4118019','Acc. Dep.-Sanitation Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1381,'4118020','Acc. Dep.-Electronic Library','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1382,'4118021','Acc. Dep.-Quality Lab Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1383,'4118022','Acc. Dep.-Freezer Boxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1384,'4118023','Acc. Dep.-Fogging Machines','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1385,'4118024','Acc. Dep.-Technical Lab Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1386,'4118025','Acc. Dep.-Printing Press Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1387,'4118026','Acc. Dep.-General Workshop Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1388,'4118027','Acc. Dep.-Mechanical Workshop Equipment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1389,'4118028','Acc. Dep.-Shredder','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1390,'4118029','Acc. Dep.-Books','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1391,'4118099','Acc. Dep.-Other Fixed Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1392,'4122001','CWIP-Office Buildings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1393,'4122002','CWIP-Commercial Complex','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1394,'4122003','CWIP-Health Buildings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1395,'4122004','CWIP-Community Halls','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1396,'4122005','CWIP-Guest Houses and Travellers Bunglows','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1397,'4122006','CWIP-Staff Quarters','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1398,'4122007','CWIP-Public Latrines & Urinals','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1399,'4122008','CWIP-School Buildings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1400,'4122009','CWIP-Stadium','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1401,'4122010','CWIP-Reading Rooms/Libraries','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1402,'4122011','CWIP-Swimming Pools','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1403,'4122012','CWIP-Skating Ring','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1404,'4122013','CWIP-Slaughter House','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1405,'4122014','CWIP-Markets','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1406,'4122015','CWIP-Eseva Building','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1407,'4122016','CWIP-Crematorium Buildings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1408,'4122017','CWIP-Dhobi Ghats','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1409,'4122018','CWIP-Zymnasium Buildings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1410,'4122019','CWIP-Town Halls and Theatres','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1411,'4122020','CWIP-Open Air Theatres','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1412,'4122021','CWIP-Bus Shelters','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1413,'4122022','CWIP-Public Conveniences','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1414,'4122023','CWIP-Compound Walls','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1415,'4122024','CWIP-Seats in Parks','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1416,'4122099','CWIP-Other Buildings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1417,'4123001','CWIP-Concrete Road','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1418,'4123002','CWIP-Black Topped Roads','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1419,'4123003','CWIP-Link Roads, Parallel Roads & Slip Roads','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1420,'4123004','CWIP-Footpaths & Pavements Concrete','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1421,'4123005','CWIP-Bridges & Culverts','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1422,'4123006','CWIP-Fly-overs & Over Bridges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1423,'4123007','CWIP-Subways & Causeways','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1424,'4123008','CWIP-Foot-over Bridges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1425,'4123009','CWIP-Traffic Junctions','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1426,'4123010','CWIP-Traffic Island and Central Media','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1427,'4123011','CWIP-Traffic Signals and Solar Signalling','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1428,'4123012','CWIP-Road Widening Compensation','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1429,'4123013','CWIP-Pedestrain Project','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1430,'4123014','CWIP-Parking Lots','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1431,'4123015','CWIP-Stone and Metal Roads','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1432,'4123016','CWIP-Footpaths & Pavements Others','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1433,'4123099','CWIP-Others Roads and Bridges','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1434,'4123101','CWIP-Underground Drains','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1435,'4123102','CWIP-Major Drains','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1436,'4123103','CWIP-Minor Drains','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1437,'4123104','CWIP-Sewerage Treatment Plant','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1438,'4123105','CWIP-CC Culverts','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1439,'4123106','CWIP-Open Mason Drains','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1440,'4123107','CWIP-Table Drains','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1441,'4123108','CWIP-Sewerage Lines (MS/GI/CI)','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1442,'4123109','CWIP-Dewatering Pumps','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1443,'4123110','CWIP-Pumps, Motors and Machinery','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1444,'4123201','CWIP-Water Works','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1445,'4123202','CWIP-Open Wells','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1446,'4123203','CWIP-Reservoirs','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1447,'4123204','CWIP-Pump House','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1448,'4123205','CWIP-Water Main Lines','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1449,'4123206','CWIP-Water Distribution Lines','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1450,'4123207','CWIP-Water bodies – Major','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1451,'4123208','CWIP-Water bodies - Minor','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1452,'4123209','CWIP-Elevated Service Reservoir','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1453,'4123210','CWIP-Ground Level Service Reservoir','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1454,'4123211','CWIP-Summer Storage Tank','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1455,'4123212','CWIP-Water Channels','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1456,'4123213','CWIP-Bore Wells - Motor','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1457,'4123214','CWIP-Submersible Pumps','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1458,'4123215','CWIP-SCADA System','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1459,'4123216','CWIP-Water Quality Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1460,'4123217','CWIP-Water Metering','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1461,'4123218','CWIP-Water Fountains','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1462,'4123219','CWIP-River Embanking','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1463,'4123220','CWIP-Drinking Water Units','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1464,'4123301','CWIP-Lighting On Main Roads','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1465,'4123302','CWIP-Lighting On Lanes By lanes','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1466,'4123303','CWIP-Decorative Lighting','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1467,'4123304','CWIP-Solar Lighting','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1468,'4124001','CWIP-Roads Machinery','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1469,'4124002','CWIP-Water Supply Machinery','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1470,'4124003','CWIP-Transport Machinery','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1471,'4124004','CWIP-Electrical Machinery','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1472,'4124005','CWIP-Electrical Crematorium','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1473,'4124006','CWIP-Slaughter House Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1474,'4124099','CWIP-Other Plant and Machinery','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1475,'4125001','CWIP-Ambulance','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1476,'4125002','CWIP-Buses','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1477,'4125003','CWIP-Cars & Jeeps','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1478,'4125004','CWIP-Cranes/JCB/Proclainer','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1479,'4125005','CWIP-Trucks','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1480,'4125006','CWIP-Tankers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1481,'4125007','CWIP-Sweeping Machines','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1482,'4125008','CWIP-Autos','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1483,'4125009','CWIP-Tractors','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1484,'4125010','CWIP-Two Wheelers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1485,'4125011','CWIP-Mini Lorries','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1486,'4125012','CWIP-Hydraulic Ladders','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1487,'4125013','CWIP-Loader','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1488,'4125014','CWIP-Compacter','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1489,'4125015','CWIP-Carts','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1490,'4125016','CWIP-Bicycles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1491,'4125017','CWIP-Tricycles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1492,'4125018','CWIP-Push Carts and Trolleys','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1493,'4125019','CWIP-Wheel Borrows','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1494,'4125020','CWIP-Vehicle Tracking System','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1495,'4125021','CWIP-Road Rollers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1496,'4125022','CWIP-Bull Dozers and Excavators','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1497,'4125099','CWIP-Other Vehicles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1498,'4126001','CWIP-Air Conditioners','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1499,'4126002','CWIP-Computers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1500,'4126003','CWIP-Faxes','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1501,'4126004','CWIP-Photocopiers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1502,'4126005','CWIP-Refrigerators','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1503,'4126006','CWIP-Network Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1504,'4126007','CWIP-Network Cabling','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1505,'4126008','CWIP-TV','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1506,'4126009','CWIP-Mobiles','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1507,'4126010','CWIP-Telephones and EPABX','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1508,'4126011','CWIP-Cameras','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1509,'4126012','CWIP-WiFi Connectivity','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1510,'4126013','CWIP-Water Coolers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1511,'4126014','CWIP-Public Address System','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1512,'4126015','CWIP-Typewriters/Duplicating Machines','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1513,'4126016','CWIP-Radios','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1514,'4126017','CWIP-Computer Peripherals','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1515,'4126018','CWIP-Stabilizer and UPS','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1516,'4126019','CWIP-Plotter and Scanner','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1517,'4126020','CWIP-Printers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1518,'4126021','CWIP-Handheld Collection Devices','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1519,'4126099','CWIP-Other Office Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1520,'4127001','CWIP-Cabinets & Partitions','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1521,'4127002','CWIP-Cupboards','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1522,'4127003','CWIP-Fans','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1523,'4127004','CWIP-Electrical Fittings','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1524,'4127005','CWIP-Tables & Chairs','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1525,'4127006','CWIP-Bureaus and Racks','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1526,'4127007','CWIP-Fixtures','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1527,'4127008','CWIP-Books','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1528,'4127009','CWIP-Survey and Drawing Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1529,'4127010','CWIP-Generators','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1530,'4127099','CWIP-Other Appliances','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1531,'4128001','CWIP-Dumper Bins','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1532,'4128002','CWIP-Dust and Litter Bins','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1533,'4128003','CWIP-Dumping Yard facilities','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1534,'4128004','CWIP-Dumping Yard Machinery','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1535,'4128005','CWIP-Vermi Compost Unit','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1536,'4128006','CWIP-SWM Processing Unit','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1537,'4128007','CWIP-Operation Theatre Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1538,'4128008','CWIP-Medical Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1539,'4128009','CWIP-Play and Sports Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1540,'4128010','CWIP-Zym Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1541,'4128011','CWIP-Food Adulteration Testing','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1542,'4128012','CWIP-Rain Water Harvesting Structures','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1543,'4128013','CWIP-Tree Guards','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1544,'4128014','CWIP-Mapping and GIS','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1545,'4128015','CWIP-School Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1546,'4128016','CWIP-Animals in Parks','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1547,'4128017','CWIP-Sewing Centers','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1548,'4128018','CWIP-Hawker Zones','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1549,'4128019','CWIP-Sanitation Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1550,'4128020','CWIP-Electronic Library','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1551,'4128021','CWIP-Quality Lab Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1552,'4128022','CWIP-Freezer Boxes','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1553,'4128023','CWIP-Fogging Machines','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1554,'4128024','CWIP-Technical Lab Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1555,'4128025','CWIP-Printing Press Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1556,'4128026','CWIP-General Workshop Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1557,'4128027','CWIP-Mechanical Workshop Equipment','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1558,'4128028','CWIP-Shredder','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1559,'4128029','CWIP-Books','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1560,'4128099','CWIP-Other Fixed Assets','1');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1561,'4201000','Central Government Securities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1562,'4202000','State Government Securities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1563,'4203000','Debentures and Bonds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1564,'4204000','Preference Shares','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1565,'4205000','Equity Shares','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1566,'4206000','Units of Mutual Funds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1567,'4208001','Fixed Deposits with Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1568,'4209000','Accumulated Provision','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1569,'4211000','Central Government Securities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1570,'4212000','State Government Securities','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1571,'4213000','Debentures and Bonds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1572,'4214000','Preference Shares','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1573,'4215000','Equity Shares','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1574,'4216000','Units of Mutual Funds','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1575,'4218001','Fixed Deposits with Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1576,'4219000','Accumulated Provision','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1577,'4301001','Engineering Stores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1578,'4301002','TransportStores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1579,'4301003','Medical Stores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1580,'4301004','Central Stationery Stores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1581,'4301005','Livery for PH staff','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1582,'4301006','Livery for Engineering staff','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1583,'4301007','Livery for Administration staff','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1584,'4301008','Sanitation Stores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1585,'4301009','Other Stores','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1586,'4302000','Loose Tools-Loose Tools','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1587,'4308000','Others-Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1588,'4311001','PT Receivable - Private Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1589,'4311002','PT Receivable - Government Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1590,'4311003','Receivable - Vacant Land Tax','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1591,'4311004','PT Receivable - Arrears - Private Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1592,'4311901','Receivable Other Taxes Private Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1593,'4311902','Receivable Other Taxes Government Properties','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1594,'4311903','Receivable Other Taxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1595,'4312000','Receivables for Cess','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1596,'4313001','Receivables for Water Supply','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1597,'4313002','Receivables for Trade License','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1598,'4313003','Receivables for Other User Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1599,'4314001','Receivable for Rent','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1600,'4314002','Interest Accrued & Due','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1601,'4314003','Interest Accrued but not due','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1602,'4314004','Interest Receivable on Employee Loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1603,'4314005','Receivable Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1604,'4315001','Receivable from State Government','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1605,'4315002','Receivable from Central Government','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1606,'4315003','Receivable from Government Departments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1607,'4315004','Receivable from Public Sector Undertakings','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1608,'4318001','Property Taxes Receivables Control','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1609,'4319100','Receivable from Government Departments','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1610,'4319200','State Govt Cess/ levies in Water Taxes - Control account','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1611,'4319900','State Govt Cess/ levies in Other Taxes - Control account','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1612,'4321000','Provision for outstanding Property Taxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1613,'4321100','Provision for outstanding Water Taxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1614,'4321200','Provision for outstanding Other Taxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1615,'4322000','Provision for outstanding Cess','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1616,'4323000','Provision for outstanding Fees and User Charges','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1617,'4324000','Provision for outstanding other receivable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1618,'4329100','State Govt Cess/ levies in Property Taxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1619,'4329200','State Govt Cess/ levies in Water Taxes - Provision account','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1620,'4329900','State Govt Cess/ levies in Other Taxes - Provision account','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1621,'4401000','Establishment-Establishment','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1622,'4402001','Prepaid Rent, Rates and Taxes','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1623,'4402002','Prepaid Insurance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1624,'4402011','Other Prepaid Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1625,'4403001','Prepaid Annual Maintenance Contracts','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1626,'4501001','Cash On Hand','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1627,'4501002','Cash In Transit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1628,'4501003','Cash with Collecting Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1629,'4501004','Cash in Central Pool Account','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1630,'4501051','Cheques-in-hand','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1631,'4501091','Inter Bank Account Fund Transfer','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1632,'4502101','State Bank of India','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1633,'4502102','State Bank of Hyderabad','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1634,'4502103','Andhra Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1635,'4502104','Canara Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1636,'4502201','ICICI Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1637,'4502202','IDBI Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1638,'4502203','HDFC Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1639,'4502204','Axis Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1640,'4502300','Scheduled Co-operative Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1641,'4502400','Post Office','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1642,'4504101','State Bank Of India','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1643,'4504102','State Bank Of Hyderabad','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1644,'4504103','Andhra Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1645,'4504104','Canara Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1646,'4504201','ICICI Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1647,'4504202','IDBI Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1648,'4504203','HDFC Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1649,'4504204','Axis Bank','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1650,'4504300','Scheduled Co-operative Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1651,'4504400','Post Office','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1652,'4506101','State Bank Of India','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1653,'4506102','State Bank Of Hyderabad','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1654,'4506200','Other Scheduled Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1655,'4506300','Scheduled Co-operative Banks','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1656,'4506400','Post Office','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1657,'4601001','House Building Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1658,'4601002','Vehicle Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1659,'4601003','Computer Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1660,'4601004','Festival Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1661,'4601005','Education Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1662,'4601006','Other Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1663,'4601007','Pay advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1664,'4601008','LTC Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1665,'4601009','Marriage Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1666,'4601010','Medical Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1667,'4601011','Spl Festival Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1668,'4602001','PF Temporary Advances','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1669,'4603000','Loans to Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1670,'4604001','Advance to Suppliers','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1671,'4604002','Advance to Contractors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1672,'4604003','Advance for Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1673,'4604004','Materials Issued to Contractors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1674,'4604005','Mobilization Advance to Contractors','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1675,'4605001','Advance to Employees for works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1676,'4605002','Travel Advance','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1677,'4605003','Imprest','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1678,'4605004','Advance to Executing agency for projects','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1679,'4606001','Telephone Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1680,'4606002','Electricity Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1681,'4606003','Petrol Pumps Deposit','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1682,'4606004','Court Deposits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1683,'4606099','Other Deposit with External Agencies','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1684,'4608001','HP Instalments receivable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1685,'4608099','Other Current Assets','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1686,'4611000','Loans to Others','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1687,'4612000','Advances-Advances','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1688,'4613000','Deposits-Deposits','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1689,'4701001','Civil Works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1690,'4701002','Electric Works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1691,'4701003','Other Works','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1692,'4702051','Inter Fund Transfer','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1693,'4703000','Interest ControlPayable','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1694,'4801001','Deferred Revenue Expenses','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1695,'4802000','Discount on Issue of loans','0');
insert into tmp_new_coa (srlno,glcode,name,budgetenable) values (1696,'4803000','Others-Others','0');
 -----------------
update tmp_new_coa set coatype='A' where glcode like '4%';
update tmp_new_coa set coatype='L' where glcode like '3%';
update tmp_new_coa set coatype='I' where glcode like '1%';
update tmp_new_coa set coatype='E' where glcode like '2%';
