-----------------------------------addalterAmountMigrationCurrInst start-----------------------------------------------

create or replace function addalterAmountMigrationCurrInst(incrno bigint)
returns bigint as 
$$
declare
  v_curr_inst_id bigint;
  v_current_inst_desc character varying(16);
  v_moduleid bigint;
  v_add_date timestamp without time zone;
  v_asmtno bigint;
  v_genTax double precision;
  v_eduCess double precision;
  v_libCess double precision;
  v_unAuthPenalty double precision;
  v_temp bigint;
  v_curr_inst_start_date timestamp without time zone;
  v_curr_inst_end_date timestamp without time zone;
  v_propid bigint;
  v_currdemand bigint;
  rec pt_extnasmtbal_tbl%ROWTYPE;

begin
  --raise notice 'addalterAmountMigrationCurrInst : incrno (%)', incrno;
  select id into v_moduleid from eg_module where name = 'Property Tax';
  select id, start_date, end_date, description into v_curr_inst_id, v_curr_inst_start_date, v_curr_inst_end_date, v_current_inst_desc from eg_installment_master where now() between start_date and end_date and id_module = v_moduleid;
for rec in (select * from pt_extnasmtbal_tbl where c_delflag = 'N' and ismigrated = 'F' and error='Excluded from migration as it is altered in Current installment' and incrementalno = incrno)
  loop
  
  --raise notice 'addalterAmountMigrationCurrInst : alteration date, assesment no (% %)', v_add_date, v_asmtno;
  
  select id into v_propid from egpt_property where id_basic_property = (select id from egpt_basic_property where propertyid = cast(rec.i_asmtno as character varying)) and status = 'A';

  select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property=v_propid) and id_installment = v_curr_inst_id;
  
   if (rec.dt_addaltdt >= v_curr_inst_start_date AND rec.dt_addaltdt <= v_curr_inst_end_date) then 

   select d_crnpt,d_crned,d_crnlcs,d_crnuauthcnstplty into v_genTax, v_eduCess, v_libCess, v_unAuthPenalty  from pt_dmndrgtr_tbl where i_asmtno = rec.i_asmtno and vc_dmndyear = v_current_inst_desc order by ts_dttm desc limit 1;
    --raise notice 'addalterAmountMigrationCurrInst : v_genTax, v_libCess, v_eduCess, v_unAuthPenalty (% % % % % %)', v_genTax, v_libCess, v_eduCess, v_unAuthPenalty, asmtno, v_current_inst_desc;
    
    v_temp := updateAlteredCurrInstDemandDetail(rec.i_asmtno, v_currdemand, v_curr_inst_id, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, incrno);
    
    
    update pt_extnasmtbal_tbl set ismigrated = 'Y', error=null where ismigrated = 'F' and error = 'Excluded from migration as it is altered in Current installment' and c_delflag = 'N' and incrementalno = incrno;
end if;
  end loop;
return 1;
exception
when others then
  --raise notice 'addalterAmountMigrationCurrInst : % %', SQLERRM, SQLSTATE;
end;
$$
language plpgsql;

------------------------------------addalterAmountMigrationCurrInst end--------------------------------------------------


--------------------------------updateAlteredCurrInstDemandDetail start---------------------------------------------------

create or replace function updateAlteredCurrInstDemandDetail(asmtno integer, currIdDemand IN bigint, currIdInstall IN bigint, propTax IN double precision, eduCess IN double precision, libCess IN double precision, unAuthPenalty IN double precision, idModule IN bigint, incrno bigint) 
RETURNS numeric as $$
declare
  v_temp bigint;
  v_add_propTax double precision;
  v_add_eduCess double precision;
  v_add_libCess double precision;
  v_add_unAuthPen double precision;
BEGIN 
  --raise notice 'updateAlteredCurrInstDemandDetail asmtno, currIdDemand, currIdInstall, propTax, eduCess, libCess, unAuthPenalty, idModule (% % % % % % % %)', asmtno, currIdDemand, currIdInstall, propTax, eduCess, libCess, unAuthPenalty, idModule;
	
  select d_crnpt, d_crned, d_crnlcs, d_crnuauthcnstplty into v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen from pt_extnasmtbal_tbl where i_asmtno = asmtno and incrementalno = incrno;
  
  --raise notice 'updateAlteredCurrInstDemandDetail v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen (% % % % )', v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen;
  
  IF (coalesce(propTax,0)>0) then
	  
	  v_temp := updateAlterCurrDemandDetail(currIdDemand, getDemandReason(currIdInstall, 'GEN_TAX', idModule), propTax);
  end if;
  IF (coalesce(eduCess,0)>0) then
	  
	  v_temp := updateAlterCurrDemandDetail(currIdDemand, getDemandReason(currIdInstall, 'EDU_CESS', idModule), eduCess);
  end if;
  IF (coalesce(libCess,0)>0) then
	  
	  v_temp := updateAlterCurrDemandDetail(currIdDemand, getDemandReason(currIdInstall, 'LIB_CESS', idModule), libCess);
  end if;
  IF (coalesce(unAuthPenalty,0)>0) then
	  
	  v_temp := updateAlterCurrDemandDetail(currIdDemand, getDemandReason(currIdInstall, 'UNAUTH_PENALTY', idModule), unAuthPenalty);
  end if;
  --raise notice 'updateAlteredCurrInstDemandDetail DemandDetails for installment (%) Created ', currIdInstall;
  return v_temp;
EXCEPTION
  WHEN OTHERS THEN
    --raise notice 'updateAlteredCurrInstDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--------------------------------updateAlteredCurrInstDemandDetail end--------------------------------------------------


--------------------------------updateAlterCurrDemandDetail start-------------------------------------------------------

create or replace FUNCTION updateAlterCurrDemandDetail(currIdDemand IN bigint, currIdDemandRsn IN bigint, taxAmount IN double precision) 
RETURNS numeric as $$
declare
v_temp bigint;
v_dmddetpk bigint;
BEGIN 
	--raise notice 'updateAlterCurrDemandDetail currIdDemand, currIdDemandRsn, taxAmount, assessmentdate (% % % )',currIdDemand, currIdDemandRsn, taxAmount;
	
	select id into v_temp from eg_demand_details where id_demand = currIdDemand and id_demand_reason = currIdDemandRsn;
	IF (v_temp IS NOT NULL) then
	
	
	update eg_demand_details set amount=taxAmount where id_demand = currIdDemand and id_demand_reason = currIdDemandRsn;
	ELSE
	
	
	select nextval('seq_eg_demand_details') into v_dmddetpk;	
	INSERT INTO eg_demand_details(id, id_demand, id_demand_reason, amount, modified_date, create_date, amt_collected)
	VALUES (v_dmddetpk, currIdDemand, currIdDemandRsn, taxAmount, now(), now(), 0);
	
	END IF;
	--raise notice 'updateAlterCurrDemandDetail DemandDetail Created';
return 1;
EXCEPTION
WHEN OTHERS THEN
--raise notice 'updateAlterCurrDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--------------------------------updateAlterCurrDemandDetail end-------------------------------------------------------
