create table eg_demand_bill(
  id bigint not null,
  assessmentno character varying (12) not null,
  houseno character varying (64),
  ownername character varying (256),
  locality bigint,
  revenueward bigint,
  block bigint,
  advance double precision,
  arrearspenalty double precision,
  createddate timestamp without time zone,
  createdby bigint,
  lastmodifieddate timestamp without time zone,
  lastmodifiedby bigint
);

alter table only eg_demand_bill add constraint pk_eg_demand_bill primary key (id);

create table eg_demand_bill_details(
  id bigint not null,
  paidBeforeDate timestamp without time zone not null,
  arreartax double precision,
  arrearPenalty double precision,
  currfirsthalftax double precision,
  currsecondhalftax double precision,
  currfirsthalfpenalty double precision,
  currsecondhalfpenalty double precision,
  totalamount double precision,
  egdemandbillid bigint,
  createddate timestamp without time zone,
  createdby bigint,
  lastmodifieddate timestamp without time zone,
  lastmodifiedby bigint
);

alter table only eg_demand_bill_details add constraint pk_eg_demand_bill_details primary key (id);
alter table only eg_demand_bill_details add constraint fk_bill_details_id_bill foreign key (egdemandbillid) 
    references eg_demand_bill(id);


create table eg_demand_inst_details(
  id bigint not null,
  installment character varying (24) not null,
  generaltax double precision,
  educationtax double precision,
  librarycess double precision,
  unauthorizedpenalty double precision,
  totaltax double precision,
  egdemandbillid bigint,
  createddate timestamp without time zone,
  createdby bigint,
  lastmodifieddate timestamp without time zone,
  lastmodifiedby bigint
);

alter table only eg_demand_inst_details add constraint pk_eg_demand_inst_details primary key (id);
alter table only eg_demand_inst_details add constraint fk_inst_details_id_bill foreign key (egdemandbillid) 
    references eg_demand_bill(id);
    
create sequence seq_eg_demand_bill;
create sequence seq_eg_demand_bill_details;
create sequence seq_eg_demand_inst_details;
