--------------------------------addalterAmountMigrationSingleAssessment start--------------------------------------------

create or replace function addalterAmountMigrationSingleAssessment(asmtno integer, currdmdId bigint,  incrno bigint)
returns bigint as 
$$
declare
  v_altered_inst bigint;
  v_altered_inst_desc character varying(16);
  v_moduleid bigint;
  v_add_date timestamp without time zone;
  v_to_instdate timestamp without time zone;
  rec record;
  v_genTax double precision;
  v_eduCess double precision;
  v_libCess double precision;
  v_unAuthPenalty double precision;
  v_temp bigint;
  v_curr_inst_start_date timestamp without time zone;
  v_delflag character(1);
begin
  --raise notice 'addalterAmountMigrationSingleAssessment : assessmentNo, currentDemandid, incrno (% % %)', asmtno, currdmdId, incrno;
  select id into v_moduleid from eg_module where name = 'Property Tax';
  select start_date into v_curr_inst_start_date from eg_installment_master where now() between start_date and end_date and id_module = v_moduleid;
  
  select dt_addaltdt into v_add_date from pt_extnasmtbal_tbl where c_delflag = 'N' and i_asmtno = asmtno and ismigrated = 'N' and incrementalno = incrno;
  --raise notice 'addalterAmountMigrationSingleAssessment : alteration date (%)', v_add_date;
  select id, description into v_altered_inst, v_altered_inst_desc from eg_installment_master where id_module = v_moduleid and v_add_date between start_date and end_date;
  --raise notice 'addalterAmountMigrationSingleAssessment : Altered installment (%)', v_altered_inst;
  select min(start_date) into v_to_instdate from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst where dd.id_demand = currdmdId and dd.id_demand_reason = dr.id and dr.id_installment = inst.id;
  if (v_add_date < v_curr_inst_start_date) then 
    select d_crnpt,d_crned,d_crnlcs,d_crnuauthcnstplty into v_genTax, v_eduCess, v_libCess, v_unAuthPenalty  from pt_dmndrgtr_tbl where i_asmtno = asmtno and vc_dmndyear = v_altered_inst_desc order by ts_dttm desc limit 1;
    --raise notice 'addalterAmountMigrationSingleAssessment : v_genTax, v_libCess, v_eduCess, v_unAuthPenalty (% % % % % %)', v_genTax, v_libCess, v_eduCess, v_unAuthPenalty, asmtno, v_altered_inst_desc;
    --No entry in arrear table (payment is done)
    if (v_add_date < v_to_instdate) then
      v_temp := createAlteredInstDemandDetail(asmtno, currdmdId, v_altered_inst, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date, incrno);
    else
      v_temp := updateAlteredInstDemandDetail(asmtno, currdmdId, v_altered_inst, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date, incrno, v_delflag);
    end if;
     
    for rec in (select id, description from eg_installment_master where id_module = v_moduleid and start_date > v_add_date and start_date < v_to_instdate)
    loop
      select d_crnpt,d_crned,d_crnlcs,d_crnuauthcnstplty into v_genTax, v_eduCess, v_libCess, v_unAuthPenalty  from pt_dmndrgtr_tbl where i_asmtno = asmtno and vc_dmndyear = rec.description order by ts_dttm desc limit 1;
      --raise notice 'addalterAmountMigrationSingleAssessment : v_genTax, v_libCess, v_eduCess, v_unAuthPenalty (% % % %)', v_genTax, v_libCess, v_eduCess, v_unAuthPenalty;
      v_temp := createAlteredDemandDetail(currdmdId, rec.id, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date);
    end loop;
    update pt_extnasmtbal_tbl set ismigrated = 'Y' where i_asmtno = asmtno and ismigrated = 'N' and c_delflag = 'N' and incrementalno = incrno;
  else 
    update pt_extnasmtbal_tbl set ismigrated = 'F', error = 'Excluded from migration as it is altered in Current installment' where i_asmtno = asmtno and ismigrated = 'N' and c_delflag = 'N' and incrementalno = incrno;
  end if;
  
return 1;
exception
when others then
  raise notice 'addalterAmountMigrationSingleAssessment : % %', SQLERRM, SQLSTATE;
end;
$$
language plpgsql;

--------------------------------addalterAmountMigrationSingleAssessment end--------------------------------------------


--------------------------------updateAlteredInstDemandDetail start----------------------------------------------------

create or replace function updateAlteredInstDemandDetail(asmtno integer, idDemand IN bigint, idInstall IN bigint, propTax IN double precision, eduCess IN double precision, libCess IN double precision, unAuthPenalty IN double precision, idModule IN bigint, assessmentdate IN timestamp without time zone, incrno bigint, delflag character(1)) 
RETURNS numeric as $$
declare
  v_temp bigint;  
  v_propTaxColl double precision;
  v_eduCessColl double precision;
  v_libCessColl double precision;
  v_unAuthPenaltyColl double precision;
  v_add_propTax double precision;
  v_add_eduCess double precision;
  v_add_libCess double precision;
  v_add_unAuthPen double precision;
BEGIN 
  --raise notice 'updateAlteredInstDemandDetail asmtno, idDemand, idInstall, propTax, eduCess, libCess, unAuthPenalty, idModule, assessmentdate (% % % % % % % % %)', asmtno, idDemand, idInstall, propTax, eduCess, libCess, unAuthPenalty, idModule, assessmentdate;
	
  select d_crnpt, d_crned, d_crnlcs, d_crnuauthcnstplty into v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen from pt_extnasmtbal_tbl where i_asmtno = asmtno and incrementalno = incrno;
  
  --raise notice 'updateAlteredInstDemandDetail v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen (% % % % )', v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen;
  
  IF (coalesce(propTax,0)>0) then
	  
	  v_temp := updateAlterDemandDetail(idDemand, getDemandReason(idInstall, 'GEN_TAX', idModule), propTax, v_propTaxColl);
  end if;
  IF (coalesce(eduCess,0)>0) then
	  
	  v_temp := updateAlterDemandDetail(idDemand, getDemandReason(idInstall, 'EDU_CESS', idModule), eduCess, v_eduCessColl);
  end if;
  IF (coalesce(libCess,0)>0) then
	  
	  v_temp := updateAlterDemandDetail(idDemand, getDemandReason(idInstall, 'LIB_CESS', idModule), libCess, v_libCessColl);
  end if;
  IF (coalesce(unAuthPenalty,0)>0) then
	  
	  v_temp := updateAlterDemandDetail(idDemand, getDemandReason(idInstall, 'UNAUTH_PENALTY', idModule), unAuthPenalty, v_unAuthPenaltyColl);
  end if;
  --raise notice 'updateAlteredInstDemandDetail DemandDetails for installment (%) Created ', idInstall;
  return v_temp;
EXCEPTION
  WHEN OTHERS THEN
    raise notice 'updateAlteredInstDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--------------------------------updateAlteredInstDemandDetail end----------------------------------------------------



--------------------------------updateAlterDemandDetail start--------------------------------------------------------

create or replace FUNCTION updateAlterDemandDetail(idDemand IN bigint, idDemandRsn IN bigint, taxAmount IN double precision, collectionAmount IN double precision) 
RETURNS numeric as $$
declare  
BEGIN 
	--raise notice 'updateAlterDemandDetail idDemand, idDemandRsn, taxAmount, assessmentdate (% % % )',idDemand, idDemandRsn, taxAmount;

	update eg_demand_details set amount=taxAmount where id_demand = idDemand and id_demand_reason = idDemandRsn;

	--raise notice 'updateAlterDemandDetail DemandDetail Created';
return 1;
EXCEPTION
WHEN OTHERS THEN
raise notice 'updateDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--------------------------------updateAlterDemandDetail end--------------------------------------------------------
