-- Temporary table for loading master data --
create table tmp_contractor_master
(srlno numeric not null primary key,
code varchar(100) not null,
name varchar(300) not null,
pan varchar(10),
address varchar(1000),
status varchar(400)
);


---- Procedure for loading contractor master ---
create or replace function load_contractor()  RETURNS void AS
$BODY$
declare
vstatusid numeric default 0;
retid numeric default 0;
v_depid numeric default 0;
vdettypeid numeric default 0;
contdetailid numeric default 0;
v_pan varchar(10);
v_address varchar(1000);
v_srlno numeric default 0;
v_code varchar(100) default '';
cur_cont tmp_contractor_master%ROWTYPE;

begin
RAISE NOTICE 'Inside Contractor data load';
select id into vstatusid from egw_status where upper(moduletype)=upper('Contractor') and upper(description)=upper('Active');
select id into vdettypeid from accountdetailtype where upper(name)=upper('Contractor');
--Mapping to Engineering department bu default
select id into v_depid from eg_department where code='ENG';
if(vstatusid is null or vdettypeid is null or v_depid is null) then
	RAISE NOTICE 'Set Up data incorrect for loading Contractor master check-Status/accountdetailtype/Department';
	exit;
end if;

RAISE NOTICE 'Starting to loop Contractor data load';
for cur_cont in( select * from tmp_contractor_master where status is null or status !='SUCESS')
loop
retid:=0;
v_srlno:=cur_cont.srlno;
v_pan:=cur_cont.pan;
v_address:=cur_cont.address;
v_code:=cur_cont.code;


	begin
	select id into retid from egw_contractor where upper(code)=upper(v_code);
	IF NOT FOUND THEN
		RAISE NOTICE 'Inserting a new code: %',v_code ;
		retid:=-1;
		end if;
	end;
	RAISE NOTICE 'Processing code %',v_code;
	RAISE NOTICE 'Processing retid %',retid;
	if (retid=-1) then
		select nextval('seq_egw_contractor') into retid;
		insert into egw_contractor
		(ID,CODE,NAME,CORRESPONDENCE_ADDRESS,PAN_NUMBER,CREATEDBY,MODIFIEDBY,CREATEDDATE,MODIFIEDDATE)
		values
		(retid,cur_cont.code,cur_cont.name,v_address,v_pan,1,1,current_date,current_date);
		insert into accountdetailkey(ID,GROUPID,DETAILTYPEID,DETAILNAME,DETAILKEY)
		values
		(nextval('seq_accountdetailkey'),1,vdettypeid,'contractor_id',retid);
	
	select nextval('seq_egw_contractor_detail') into contdetailid;
	insert into EGW_CONTRACTOR_DETAIL (ID,CONTRACTOR_ID,DEPARTMENT_ID,STATUS_ID,STARTDATE,CREATEDBY,MODIFIEDBY,CREATEDDATE,MODIFIEDDATE,MY_CONTRACTOR_INDEX) values
		(contdetailid,retid,v_depid,vstatusid,'01-Apr-2015',1,1,current_date,current_date,0);
	update tmp_contractor_master set status='SUCESS' where srlno=v_srlno;	
	
	else
	 update tmp_contractor_master set status='Contactor with same code already exist' where srlno=v_srlno;
	end if;
	end loop;
	RAISE NOTICE 'Finshed Contractor data load';
	end;
	
	$BODY$
	LANGUAGE plpgsql;
	
--------End of procedure---------
--select load_contractor();