create or replace function migrateIncrementalRecipts(incrno bigint) 
returns bigint as $$
declare
  v_moduleid bigint;
  v_currinst bigint;
  v_propid bigint;
  v_currdemand bigint;
  v_asmtno bigint;
  v_temp bigint;
  v_valid boolean;
  assessmentno character varying;
begin
  select id into v_moduleid from eg_module where name='Property Tax';
  select id into v_currinst from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;      
  for assessmentno in (select distinct i_asmtno assessmentno from pt_asmtrcpt_tbl where incrementalno=incrno and i_asmtno not in (select i_asmtno from pt_asmt_mstr_tbl where incrementalno = incrno) and (ismigrated is null or ismigrated='N' or ismigrated='F') and C_ISRLSD <> 'X' AND C_DELFLAG = 'N')
  loop
    v_asmtno := assessmentno;
    v_valid := validateAssessmentForTransactions(cast(v_asmtno as text));
	--raise notice 'migrateCollectionIncremental v_asmtno, v_valid (% %)',v_asmtno, v_valid;
    if (v_valid = false) then
      select id into v_propid from egpt_property where id_basic_property = (select id from egpt_basic_property where propertyid = cast(v_asmtno as character varying)) and status = 'A';
      select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property=v_propid) and id_installment = v_currinst;
      --raise notice 'migrateCollectionIncremental assessmentNo, idDemand (% %)',v_asmtno, v_currdemand;
      v_temp := migrateCollectionIncremental(v_asmtno, v_currdemand, incrno);
      --raise notice 'assessment receipts migrated, assessmentNo (%)',v_asmtno;		
      insert into egpt_property_receipts (id, id_basic_property, booknumber, rcpt_number, rcpt_date, from_date, to_date, rcpt_amount)
	select nextval('seq_egpt_property_receipts'), bp.id, i_bookno, trim(i_slno), dt_etrydt, dt_paidfrmprddt, dt_paidtoprddt, (d_arrpt + d_arred + d_arrlcs + d_arruauthcnstplty + d_pltyonarr + d_crnpt + d_crned + d_crnlcs + d_crnuauthcnstplty + d_pltyoncrn + d_advamt) 
	from pt_asmtrcpt_tbl rcpt, egpt_basic_property bp where cast(bp.propertyid as int)=rcpt.i_asmtno and rcpt.c_delflag='N' and rcpt.i_asmtno=v_asmtno and rcpt.incrementalno=incrno;
    elsif (v_valid = true) then
      update pt_asmtrcpt_tbl set error = 'Transactions are there for this assessment', ismigrated='F' where incrementalno = incrno and i_asmtno = v_asmtno;
    end if;
  end loop;
  return v_temp;
exception
when OTHERS then
  raise notice 'migrateIncrementalRecipts : % %', SQLERRM, SQLSTATE;
end;
$$ LANGUAGE plpgsql;

-----------------validateAssessmentForTransactions start-----------------------------
create or replace function validateAssessmentForTransactions(assessmentno character varying(12))
	returns boolean as $$
declare
	v_basicPropId bigint;
	v_count bigint;
	v_valid boolean default false;
	v_isrcpt boolean default false;
	v_isalter boolean default false;
	v_ismutation boolean default false;
begin
	raise notice 'validateAssessmentForTransactions assessmentno : %', assessmentno;
	select id into v_basicPropId from egpt_basic_property where propertyid = assessmentno;
	select count(*) into v_count from egcl_collectionheader where consumercode = assessmentno;
	if (select count(*) from egcl_collectionheader where consumercode = assessmentno and servicedetails = (select id from egcl_servicedetails where upper(name) = 'PROPERTY TAX') and status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED', 'PENDING'))) > 0 then
		v_valid := true;
		v_isrcpt := true;
	elsif (select count(*) from egpt_property_status_values where id_basic_property = v_basicPropId) > 0 then
		v_valid := true;
		v_isalter := true;
	elsif (select count(*) from egpt_vacancy_remission where basicproperty = v_basicPropId) > 0 then
		v_valid := true;
	elsif (select count(*) from egpt_property_mutation where basicproperty = v_basicPropId) > 0 then
	    v_valid := true;
		v_ismutation := true;
	else
		v_valid := false;
	end if;
	--raise notice 'validateAssessmentForTransactions trans v_isrcpt, v_isalter, v_ismutation, v_valid: (% % % %)', v_isrcpt, v_isalter, v_ismutation, v_valid;
	return v_valid;
exception
	when others then
		raise notice 'validateAssessmentForTransactions : % %', SQLERRM, SQLSTATE;
	return false;
end; 
$$ language plpgsql;
-----------------validateAssessmentForTransactions end-----------------------------
