create or replace FUNCTION createorupdatemonthlyinterest(idDemand IN bigint, idDemandRsn IN bigint, taxAmount IN double precision, assessmentdate IN date) 
RETURNS numeric as $$
declare
	v_dmddetpk 	bigint;  
	v_ddid		bigint;  
BEGIN 
	--raise notice 'createorupdatepenalty idDemand, idDemandRsn, taxAmount, assessmentdate (% % % %)',idDemand, idDemandRsn, taxAmount, assessmentdate;
	select id into v_ddid from eg_demand_details where id_demand=idDemand and id_demand_reason=idDemandRsn;
	--raise notice 'createorupdatepenalty v_ddid (%)', v_ddid;
	if (v_ddid is not null) then
		update eg_demand_details set amount=amount+taxAmount where id=v_ddid;
	else
		select nextval('seq_eg_demand_details') into v_dmddetpk;
		INSERT INTO eg_demand_details(id, id_demand, id_demand_reason, amount, modified_date, create_date, amt_collected)
		VALUES (v_dmddetpk, idDemand, idDemandRsn, taxAmount, assessmentdate, assessmentdate, 0);
	end if;
	--raise notice 'createorupdatepenalty updated';
return v_dmddetpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createorupdatepenalty : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--migrate penalty amount egptaddmonthlyinterest_assessment
create or replace FUNCTION egptaddmonthlyinterest_assessment(assessmentNo IN varchar(16), currInst IN bigint, idModule IN bigint, idDemand IN bigint) 
RETURNS numeric as $$
declare
	v_temp 		bigint; 
	v_idinst	bigint; 
	v_inst	 	varchar(16);
	v_tax	 	double precision;
	v_collection 	double precision;
	v_penalty	 	double precision;
	dcbrec record;
BEGIN 
	--raise notice 'migrateassessmentpenalty assessmentNo, currInst, idModule, idDemand (% % % %)',assessmentNo, currInst, idModule, idDemand;
	 for dcbrec in (select inst.id, inst.description, sum(dd.amount) tax, sum(dd.amt_collected) as collection
from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst
where dd.id_demand=idDemand
and dd.id_demand_reason = dr.id
and dr.id_installment = inst.id
--and inst.id != currInst
and dr.id_demand_reason_master in (select id from eg_demand_reason_master where module=idModule and code in ('GEN_TAX','VAC_LAND_TAX','LIB_CESS','EDU_CESS','UNAUTH_PENALTY'))
group by inst.description, inst.id)
	 loop 
		begin
			v_inst := dcbrec.description;
			v_collection := dcbrec.collection;
			v_idinst := dcbrec.id;
			v_tax := dcbrec.tax;
			v_penalty := 0;
			--raise notice 'migrateassessmentpenalty v_inst, v_collection, v_idinst (% % %)', v_inst, v_collection, v_idinst;
			if(v_collection=0) then
				v_penalty := v_tax*0.02;--calcualting for one month
				--raise notice 'migrateassessmentpenalty v_penalty (%)', v_penalty;
				if(v_penalty>0) then
				v_temp := createorupdatemonthlyinterest(idDemand, getDemandReason(v_idinst, 'PENALTY_FINES', idModule), round(v_penalty), now()::date);
				end if;
			end if;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmentpenalty, failed while adding arrears : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
return v_temp;
END;
$$ LANGUAGE plpgsql;

--migrate penalty amount
create or replace FUNCTION egptaddmonthlyinterest(in_wardid IN bigint) 
RETURNS numeric as $$
declare
	v_temp 		bigint; 
	v_currinst	bigint;
	v_moduleid	bigint;
	v_demandid	bigint;
	v_assessmento 	varchar(16);
	proprec record;
BEGIN 
	--raise notice 'migratepenalty in_wardid (%)',in_wardid;

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_currinst from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;

	 for proprec in (select mv.upicno, cd.id_demand from egpt_mv_propertyinfo mv, egpt_mv_bp_curr_demand cd where cd.id_basic_property=mv.basicpropertyid and mv.aggregate_arrear_demand>0 and (aggregate_arrear_demand - arrearcollection) > 0 and mv.source='M' and mv.isexempted=false and mv.isactive=true and mv.basicpropertyid not in (select id_basic_property from egpt_property_status_values where id_status = (select id from egpt_status where code='ADD_OR_ALTER')) and mv.wardid=in_wardid)
	 loop 
		begin
			v_assessmento := proprec.upicno;
			v_demandid := proprec.id_demand;
			--raise notice 'egptaddmonthlyinterest v_demandid, v_assessmento (% %)', v_demandid, v_assessmento;
		v_temp := migrateassessmentpenalty(v_assessmento, v_currinst, v_moduleid, v_demandid);
		EXCEPTION
		WHEN OTHERS THEN
		--raise notice 'egptaddmonthlyinterest, failed while adding arrears : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
return v_temp;
END;
$$ LANGUAGE plpgsql;
