--migrate penalty amount
create or replace FUNCTION migrateassessmentpenalty(assessmentNo IN varchar(16), currInst IN bigint, idModule IN bigint, idDemand IN bigint) 
RETURNS numeric as $$
declare
	v_temp 		bigint; 
	v_idinst	bigint; 
	v_inst	 	varchar(16);
	v_tax	 	double precision;
	v_collection 	double precision;
	v_penalty	 	double precision;
	v_newpenalty 	double precision;
	dcbrec record;
BEGIN 
	--raise notice 'migrateassessmentpenalty assessmentNo, currInst, idModule, idDemand (% % % %)',assessmentNo, currInst, idModule, idDemand;
	 for dcbrec in (select inst.id, inst.description, sum(dd.amount) tax, sum(dd.amt_collected) as collection
from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst
where dd.id_demand=idDemand
and dd.id_demand_reason = dr.id
and dr.id_installment = inst.id
--and inst.id != currInst
and dr.id_demand_reason_master in (select id from eg_demand_reason_master where module=idModule and code in ('GEN_TAX','VAC_LAND_TAX','LIB_CESS','EDU_CESS','UNAUTH_PENALTY'))
group by inst.description, inst.id)
	 loop 
		begin
			v_inst := dcbrec.description;
			v_collection := dcbrec.collection;
			v_idinst := dcbrec.id;
			v_tax := dcbrec.tax;
			v_penalty := 0;
			--raise notice 'migrateassessmentpenalty v_inst, v_collection, v_idinst (% % %)', v_inst, v_collection, v_idinst;
			if(v_collection=0) then
				--getting calculated penalty till Sept 2015 from eSuvidha for arrears
				if(v_idinst!=currInst) then
				select d_pltyonarrs into v_penalty from pt_arrear_tbl where i_asmtno=assessmentNo::bigint and vc_dmndyear=v_inst and c_delflag='N';
				v_newpenalty := v_tax*0.12;--calcualting from Oct 2015 to Feb 2016
				--raise notice 'migrateassessmentpenalty v_newpenalty (%)', v_newpenalty;
				v_newpenalty := v_newpenalty + v_penalty;
				else
				v_newpenalty := v_tax*0.06;--calculating penalty for Jan 2016 to Feb 2016 for current installment
				end if;
				--raise notice 'migrateassessmentpenalty v_newpenalty (%)', v_newpenalty;
				if(v_newpenalty>0) then
				v_temp := createorupdatepenalty(idDemand, getDemandReason(v_idinst, 'PENALTY_FINES', idModule), round(v_newpenalty), now()::date);
				end if;
			end if;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmentpenalty, failed while adding arrears : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
return v_temp;
END;
$$ LANGUAGE plpgsql;
