CREATE OR REPLACE FUNCTION  LoadptisBillCollectorDailycollection()
  RETURNS void AS
$BODY$
declare
  v_cityname character varying(128);
  v_schemaName   character varying(50);
  billcollectorList EGPT_BILLCOLLCTOR_DETAIL%rowtype;
  v_count bigint;
  v_billCollectorId bigint;
  v_currentdemand double precision;
  v_arreardemand double precision;
  v_eg_currentcoll double precision;
  v_eg_arrearcoll double precision;
  v_es_currentcoll double precision;
  v_es_arrearcoll double precision;
  v_curr_currentcoll double precision;
  v_curr_arrearcoll double precision;
  v_prev_currentcoll double precision;
  v_prev_arrearcoll double precision;
  v_curr_yes_arrearcoll double precision;
  v_curr_yes_currentcoll double precision;
  v_prev_yes_currentcoll double precision;
  v_prev_yes_arrearcoll double precision;
 
  v_currentdemand_court double precision;
  v_arreardemand_court double precision;
  v_eg_currentcoll_court double precision;
  v_eg_arrearcoll_court double precision;
  v_es_currentcoll_court double precision;
  v_es_arrearcoll_court double precision;
  v_curr_currentcoll_court double precision;
  v_curr_arrearcoll_court double precision;
  v_prev_currentcoll_court double precision;
  v_prev_arrearcoll_court double precision;
  v_curr_yes_arrearcoll_court double precision;
  v_curr_yes_currentcoll_court double precision;
  v_prev_yes_currentcoll_court double precision;
  v_prev_yes_arrearcoll_court double precision;

  cities EGPT_BILLCOLLECTORWISE_REPORT%ROWTYPE;
  v_propertyTypdId bigint;
  v_propertyTypdCode character varying(32);

begin
for cities in (select * from EGPT_BILLCOLLECTORWISE_REPORT  where  last_calculated_date is null or last_calculated_date ::timestamp::date < (current_date) and isactive=true) 
  loop
    v_cityname := cities.ulbname;
    v_schemaName:= cities.schemaname;
    v_count := 0;
    v_currentdemand := 0;
    v_arreardemand := 0;
    v_eg_currentcoll := 0;
    v_eg_arrearcoll := 0;
    v_es_currentcoll := 0;
    v_es_arrearcoll := 0;
    v_curr_currentcoll := 0;
    v_curr_arrearcoll := 0;
    v_prev_currentcoll := 0;
    v_prev_arrearcoll := 0;
    v_curr_yes_arrearcoll := 0;
    v_curr_yes_currentcoll := 0;
    v_prev_yes_currentcoll := 0;
    v_prev_yes_arrearcoll := 0;

    v_currentdemand_court := 0;
    v_arreardemand_court := 0;
    v_eg_currentcoll_court := 0;
    v_eg_arrearcoll_court := 0;
    v_es_currentcoll_court := 0;
    v_es_arrearcoll_court := 0;
    v_curr_currentcoll_court := 0;
    v_curr_arrearcoll_court := 0;
    v_prev_currentcoll_court := 0;
    v_prev_arrearcoll_court := 0;
    v_curr_yes_arrearcoll_court := 0;
    v_curr_yes_currentcoll_court := 0;
    v_prev_yes_currentcoll_court := 0;
    v_prev_yes_arrearcoll_court := 0;

    raise notice 'Getting bill collector report for City : %', v_cityname;
  --  EXECUTE 'set search_path to '|| v_cityname; -- security
    for billcollectorList in (select * from EGPT_BILLCOLLCTOR_DETAIL where isactive=true order by id)
    loop
     
     select id into v_billCollectorId from EGPT_BCREPORT_COLLECTION where date =current_date and billcollector=billcollectorList.id;
     select id,code into v_propertyTypdId, v_propertyTypdCode from egpt_property_type_master where code='PRIVATE';
    
    if( v_billCollectorId is null) then 

        v_billCollectorId:=billcollectorList.id;
	select COALESCE (sum(aggregate_current_demand),0), COALESCE (sum(aggregate_arrear_demand),0) into v_currentdemand, v_arreardemand  from egpt_mv_propertyinfo where blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
	and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId )
	 and proptymaster= v_propertyTypdId;

select COALESCE (sum(aggregate_current_demand),0), COALESCE (sum(aggregate_arrear_demand),0) into v_currentdemand_court, v_arreardemand_court  from egpt_mv_propertyinfo,pt_court_cases_tbl court where  court.i_asmtno::text= upicno and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
	and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId );

-- cummulative tax 
     select COALESCE(sum(cd.cramount),0) into v_eg_currentcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date between currFinYearDate(current_date)::date 
      and (select DATE 'yesterday')::date and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description like concat('%',currentFinancialYear(),'%')
      and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId )  and proptymaster= v_propertyTypdId and cd.cramount>0 and chartofaccount not in (select id from chartofaccounts where glcode in ('1402002'));

 select COALESCE(sum(cd.cramount),0) into v_eg_currentcoll_court from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
     ,pt_court_cases_tbl court where  court.i_asmtno::text= mv.upicno and  mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date between currFinYearDate(current_date)::date 
      and (select DATE 'yesterday')::date and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description like concat('%',currentFinancialYear(),'%')
      and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) and cd.cramount>0 and chartofaccount not in (select id from chartofaccounts where glcode in ('1402002'));


-- cummulative arrears

select  COALESCE (sum(cd.cramount),0) into v_eg_arrearcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date between currFinYearDate(current_date)::date 
      and (select DATE 'yesterday')::date and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description not like concat('%',currentFinancialYear(),'%')
      and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) and proptymaster= v_propertyTypdId and cd.cramount>0 and chartofaccount not in (select id from chartofaccounts where glcode in ('1402002'));
 

select  COALESCE (sum(cd.cramount),0) into v_eg_arrearcoll_court from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      ,pt_court_cases_tbl court where  court.i_asmtno::text= mv.upicno and  mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date between currFinYearDate(current_date)::date 
      and (select DATE 'yesterday')::date and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description not like concat('%',currentFinancialYear(),'%')
      and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) and cd.cramount>0 and chartofaccount not in (select id from chartofaccounts where glcode in ('1402002'));
     
-- cummulative tax/arrears in Eseva 

    select  COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty),0), COALESCE( sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty),0) into v_es_currentcoll, v_es_arrearcoll 
      from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv 
      where rcpt.i_asmtno::text = mv.upicno and rcpt.dt_etrydt between currFinYearDate(current_date)::date and (select DATE 'yesterday')::date 
    and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId )  and proptymaster= v_propertyTypdId ;

   select  COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty),0), COALESCE( sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty),0) into v_es_currentcoll_court, v_es_arrearcoll_court 
      from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv  ,pt_court_cases_tbl court where  court.i_asmtno::text= mv.upicno and
       rcpt.i_asmtno::text = mv.upicno and rcpt.dt_etrydt between currFinYearDate(current_date)::date and (select DATE 'yesterday')::date 
    and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId )  ;

      v_curr_arrearcoll := v_eg_arrearcoll + v_es_arrearcoll;
      v_curr_currentcoll := v_eg_currentcoll + v_es_currentcoll; 
  
     v_curr_arrearcoll_court := v_eg_arrearcoll_court + v_es_arrearcoll_court;
      v_curr_currentcoll_court := v_eg_currentcoll_court + v_es_currentcoll_court; 
     
---  today tax collection
select   COALESCE (sum(cd.cramount),0) into v_curr_yes_currentcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date= (select DATE 'yesterday')::date 
       and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description like concat('%',currentFinancialYear(),'%')
      and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) and proptymaster= v_propertyTypdId and cd.cramount>0 and chartofaccount not in (select id from chartofaccounts where glcode in ('1402002'));


select   COALESCE (sum(cd.cramount),0) into v_curr_yes_currentcoll_court from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv  ,pt_court_cases_tbl court where  court.i_asmtno::text= mv.upicno and
       mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date= (select DATE 'yesterday')::date 
       and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description like concat('%',currentFinancialYear(),'%')
      and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) and cd.cramount>0 and chartofaccount not in (select id from chartofaccounts where glcode in ('1402002'));


--  today arrears collection
select  COALESCE (sum(cd.cramount),0)  into v_curr_yes_arrearcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date = (select DATE 'yesterday')::date 
      and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description not like concat('%',currentFinancialYear(),'%')
      and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId )  and proptymaster= v_propertyTypdId and cd.cramount>0 and chartofaccount not in (select id from chartofaccounts where glcode in ('1402002'));

select  COALESCE (sum(cd.cramount),0)  into v_curr_yes_arrearcoll_court from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv ,pt_court_cases_tbl court where  court.i_asmtno::text= mv.upicno and
       mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date = (select DATE 'yesterday')::date 
      and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description not like concat('%',currentFinancialYear(),'%')
      and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId )  and cd.cramount>0 and chartofaccount not in (select id from chartofaccounts where glcode in ('1402002'));

  -- Last year tax cummulative

  select COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty),0), COALESCE(sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty) ,0)    into v_prev_currentcoll, v_prev_arrearcoll
       from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv
      where rcpt.i_asmtno::text = mv.upicno and  rcpt.dt_etrydt between lastFinYearDate(current_date)::date 
      and concat(extract(year from current_date) - 1, '-', (extract(month from current_date)), '-' ,extract(day from current_date) - 1)::date 
    and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) and proptymaster= v_propertyTypdId ;

  select COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty),0), COALESCE(sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty) ,0)    into v_prev_currentcoll_court, v_prev_arrearcoll_court
       from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv ,pt_court_cases_tbl court where  court.i_asmtno::text= mv.upicno and
       rcpt.i_asmtno::text = mv.upicno and  rcpt.dt_etrydt between lastFinYearDate(current_date)::date 
      and concat(extract(year from current_date) - 1, '-', (extract(month from current_date)), '-' ,extract(day from current_date) - 1)::date 
    and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId );



--Last year as on day
  select COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty),0), COALESCE(sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty) ,0)  into v_prev_yes_currentcoll, v_prev_yes_arrearcoll 
       from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv
      where rcpt.i_asmtno::text = mv.upicno and  rcpt.dt_etrydt=concat(extract(year from current_date) - 1, '-', (extract(month from current_date)), '-' ,extract(day from current_date) - 1)::date 
    and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) and proptymaster= v_propertyTypdId;  


  select COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty),0), COALESCE(sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty) ,0)  into v_prev_yes_currentcoll_court, v_prev_yes_arrearcoll_court 
       from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv,pt_court_cases_tbl court where  court.i_asmtno::text= mv.upicno and
       rcpt.i_asmtno::text = mv.upicno and  rcpt.dt_etrydt=concat(extract(year from current_date) - 1, '-', (extract(month from current_date)), '-' ,extract(day from current_date) - 1)::date 
    and blockid in ( select blockid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId ) 
and  wardid in ( select wardid from EGPT_BILLCOLLCTOR_BLOCKDETAIL where billcollector=v_billCollectorId );  



insert into EGPT_BCREPORT_COLLECTION (id,date,billcollector,target_arrears_demand,target_current_demand,today_arrears_collection,today_currentyear_collection,cummulative_arrears_collection,cummulative_currentyear_collection,lastyear_collection,lastyear_cummulative_collection,type)
values (nextval('SEQ_BCREPORT_COLLECTION'),now(),billcollectorList.id,v_arreardemand,v_currentdemand,  v_curr_yes_arrearcoll,v_curr_yes_currentcoll,v_curr_arrearcoll, v_curr_currentcoll, (v_prev_yes_currentcoll+ v_prev_yes_arrearcoll),( v_prev_currentcoll+v_prev_arrearcoll) ,'PRIVATE');

insert into EGPT_BCREPORT_COLLECTION (id,date,billcollector,target_arrears_demand,target_current_demand,today_arrears_collection,today_currentyear_collection,cummulative_arrears_collection,cummulative_currentyear_collection,lastyear_collection,lastyear_cummulative_collection,type)
values (nextval('SEQ_BCREPORT_COLLECTION'),now(),billcollectorList.id,v_arreardemand_court,v_currentdemand_court,  v_curr_yes_arrearcoll_court,v_curr_yes_currentcoll_court,v_curr_arrearcoll_court, v_prev_yes_currentcoll_court, (v_prev_yes_currentcoll_court+ v_prev_yes_arrearcoll_court),( v_prev_currentcoll_court+v_prev_arrearcoll_court) ,'COURTCASE');


end if;  
  raise notice 'inserted for billcollector id : %', billcollectorList.id;

  end loop;    
	update EGPT_BILLCOLLECTORWISE_REPORT set last_calculated_date=current_date where ulbname= v_cityname;
end loop;
-- set search_path to public;
end;
$BODY$
  LANGUAGE plpgsql;
  
  
  

CREATE OR REPLACE FUNCTION  LoadPtisUlbDailycollection()
  RETURNS void AS
$BODY$
declare
  v_cityname character varying(128);
  v_schemaName   character varying(50);
  v_count bigint;
  v_currentdemand double precision;
  v_arreardemand double precision;
  v_eg_currentcoll double precision;
  v_eg_arrearcoll double precision;
  v_es_currentcoll double precision;
  v_es_arrearcoll double precision;
  v_curr_currentcoll double precision;
  v_curr_arrearcoll double precision;
  v_prev_currentcoll double precision;
  v_prev_arrearcoll double precision;
  v_curr_yes_arrearcoll double precision;
  v_curr_yes_currentcoll double precision;
  v_prev_yes_currentcoll double precision;
  v_prev_yes_arrearcoll double precision;
  cities EGPT_ULBWISEDAILYCOLLECTION%ROWTYPE;
begin
for cities in (select * from EGPT_ULBWISEDAILYCOLLECTION  where  last_calculated_date is null or last_calculated_date ::timestamp::date < (current_date) and isactive=true) 
  loop
    v_cityname := cities.ulbname;
    v_schemaName:= cities.schemaname;
    v_count := 0;
    v_currentdemand := 0;
    v_arreardemand := 0;
    v_eg_currentcoll := 0;
    v_eg_arrearcoll := 0;
    v_es_currentcoll := 0;
    v_es_arrearcoll := 0;
    v_curr_currentcoll := 0;
    v_curr_arrearcoll := 0;
    v_prev_currentcoll := 0;
    v_prev_arrearcoll := 0;
    v_curr_yes_arrearcoll := 0;
    v_curr_yes_currentcoll := 0;
    v_prev_yes_currentcoll := 0;
    v_prev_yes_arrearcoll := 0;
    raise notice 'Getting details for City : %', v_cityname;
  --  EXECUTE 'set search_path to '|| v_cityname; -- security

select COALESCE (sum(aggregate_current_demand),0), COALESCE (sum(aggregate_arrear_demand),0) into v_currentdemand, v_arreardemand  from egpt_mv_propertyinfo ;

-- cummulative tax 
     select COALESCE(sum(cd.cramount),0) into v_eg_currentcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date between currFinYearDate(current_date)::date 
      and (select DATE 'yesterday')::date and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description like concat('%',currentFinancialYear(),'%');

-- cummulative arrears

select  COALESCE (sum(cd.cramount),0) into v_eg_arrearcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date between currFinYearDate(current_date)::date 
      and (select DATE 'yesterday')::date and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description not like concat('%',currentFinancialYear(),'%');
      
-- cummulative tax/arrears in Eseva 

    select  COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_pltyoncrn),0), COALESCE( sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_pltyonarr),0) into v_es_currentcoll, v_es_arrearcoll 
      from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv 
      where rcpt.i_asmtno::text = mv.upicno and rcpt.dt_etrydt between currFinYearDate(current_date)::date and (select DATE 'yesterday')::date ;

      v_curr_arrearcoll := v_eg_arrearcoll + v_es_arrearcoll;
      v_curr_currentcoll := v_eg_currentcoll + v_es_currentcoll; 
 
     
---  today tax collection
select   COALESCE (sum(cd.cramount),0) into v_curr_yes_currentcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date= (select DATE 'yesterday')::date 
       and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description like concat('%',currentFinancialYear(),'%');

--  today arrears collection
select  COALESCE (sum(cd.cramount),0)  into v_curr_yes_arrearcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date = (select DATE 'yesterday')::date 
      and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description not like concat('%',currentFinancialYear(),'%') ;

  -- Last year tax cummulative

  select COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_pltyoncrn),0), COALESCE(sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_pltyonarr) ,0)    into v_prev_currentcoll, v_prev_arrearcoll
       from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv
      where rcpt.i_asmtno::text = mv.upicno and  rcpt.dt_etrydt between lastFinYearDate(current_date)::date 
      and concat(extract(year from current_date) - 1, '-', (extract(month from current_date)), '-' ,extract(day from current_date) - 1)::date 
   ;


--Last year as on day
  select COALESCE(sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_pltyoncrn),0), COALESCE(sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_pltyonarr) ,0)  into v_prev_yes_currentcoll, v_prev_yes_arrearcoll 
       from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv
      where rcpt.i_asmtno::text = mv.upicno and  rcpt.dt_etrydt=concat(extract(year from current_date) - 1, '-', (extract(month from current_date)), '-' ,extract(day from current_date) - 1)::date 
   ;  

update EGPT_ULBWISEDAILYCOLLECTION set last_calculated_date=now(), target_arrears_demand= v_arreardemand ,target_current_demand=v_currentdemand,today_arrears_collection=(v_curr_yes_arrearcoll),today_currentyear_collection=(v_curr_yes_currentcoll),cummulative_arrears_collection=(cummulative_arrears_collection+v_curr_arrearcoll),cummulative_currentyear_collection=(cummulative_currentyear_collection+v_curr_currentcoll),lastyear_collection=(v_prev_yes_currentcoll+ v_prev_yes_arrearcoll),lastyear_cummulative_collection=(lastyear_cummulative_collection + v_prev_currentcoll+v_prev_arrearcoll) where id=cities.id;


raise notice 'updated for city : %', v_cityname;

end loop;
-- set search_path to public;
end;
$BODY$
  LANGUAGE plpgsql;
