-----------------validateAssessmentForTransactions start-----------------------------
create or replace function validateAssessmentForTransactions(assessmentno character varying(12))
	returns boolean as $$
declare
	v_basicPropId bigint;
	v_count bigint;
	v_valid boolean default false;
begin
	--raise notice 'validateAssessmentForTransactions assessmentno : %', assessmentno;
	select id into v_basicPropId from egpt_basic_property where propertyid = assessmentno;
	select count(*) into v_count from egcl_collectionheader where consumercode = assessmentno;
	if (select count(*) from egcl_collectionheader where consumercode = assessmentno) > 0 then
		v_valid := true;
	elsif (select count(*) from egpt_property_status_values where id_basic_property = v_basicPropId) > 0 then
		v_valid := true;
	elsif (select count(*) from egpt_vacancy_remission where basicproperty = v_basicPropId) > 0 then
		v_valid := true;
	elsif (select count(*) from egpt_property_mutation where basicproperty = v_basicPropId) > 0 then
	        v_valid := true;
	else
		v_valid := false;
	end if;
	return v_valid;
exception
	when others then
		raise notice 'validateAssessmentForTransactions : % %', SQLERRM, SQLSTATE;
	return false;
end; 
$$ language plpgsql;
-----------------validateAssessmentForTransactions end-----------------------------
