--migrate penalty amount
create or replace FUNCTION migrateassessmentpenalty(assessmentNo IN varchar(16), currInst IN bigint, idModule IN bigint, idDemand IN bigint) 
RETURNS numeric as $$
declare
	v_temp 		bigint; 
	v_idinst	bigint; 
	v_inst	 	varchar(16);
	v_tax	 	double precision;
	v_collection 	double precision;
	v_penalty	 	double precision;
	v_newpenalty 	double precision;
	dcbrec record;
BEGIN 
	--raise notice 'migrateassessmentpenalty assessmentNo, currInst, idModule, idDemand (% % % %)',assessmentNo, currInst, idModule, idDemand;
	 for dcbrec in (select inst.id, inst.description, sum(dd.amount) tax, sum(dd.amt_collected) as collection
from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst
where dd.id_demand=idDemand
and dd.id_demand_reason = dr.id
and dr.id_installment = inst.id
and inst.id != currInst
and dr.id_demand_reason_master in (select id from eg_demand_reason_master where module=idModule and code in ('GEN_TAX','VAC_LAND_TAX','LIB_CESS','EDU_CESS','UNAUTH_PENALTY'))
group by inst.description, inst.id)
	 loop 
		begin
			v_inst := dcbrec.description;
			v_collection := dcbrec.collection;
			v_idinst := dcbrec.id;
			v_tax := dcbrec.tax;
			--raise notice 'migrateassessmentpenalty v_inst, v_collection, v_idinst (% % %)', v_inst, v_collection, v_idinst;
			if(v_collection=0) then
				select d_pltyonarrs into v_penalty from pt_arrear_tbl where i_asmtno=assessmentNo::bigint and vc_dmndyear=v_inst and c_delflag='N';
				v_newpenalty := v_tax*0.1;--calcualting from Oct 2015 to Feb 2016
				--raise notice 'migrateassessmentpenalty v_newpenalty (%)', v_newpenalty;
				v_newpenalty := v_newpenalty + v_penalty;
				--raise notice 'migrateassessmentpenalty v_newpenalty (%)', v_newpenalty;
				if(v_newpenalty>0) then
				v_temp := createorupdatepenalty(idDemand, getDemandReason(v_idinst, 'PENALTY_FINES', idModule), round(v_newpenalty), now()::date);
				end if;
			end if;
		EXCEPTION
		WHEN OTHERS THEN
		--raise notice 'migrateassessmentpenalty, failed while adding arrears : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
return v_temp;
END;
$$ LANGUAGE plpgsql;

--migrate penalty amount
create or replace FUNCTION migratepenalty(in_wardid IN bigint) 
RETURNS numeric as $$
declare
	v_temp 		bigint; 
	v_currinst	bigint;
	v_moduleid	bigint;
	v_demandid	bigint;
	v_assessmento 	varchar(16);
	proprec record;
BEGIN 
	--raise notice 'migrateassessmentpenalty in_wardid (%)',in_wardid;

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_currinst from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;

	 for proprec in (select mv.upicno, cd.id_demand from egpt_mv_propertyinfo mv, egpt_mv_bp_curr_demand cd where cd.id_basic_property=mv.basicpropertyid and mv.aggregate_arrear_demand>0 and (aggregate_arrear_demand - arrearcollection) > 0 and mv.source='M' and mv.isexempted=false and mv.isactive=true and mv.basicpropertyid not in (select id_basic_property from egpt_property_status_values where id_status = (select id from egpt_status where code='ADD_OR_ALTER')) and mv.wardid=in_wardid)
	 loop 
		begin
			v_assessmento := proprec.upicno;
			v_demandid := proprec.id_demand;
			--raise notice 'migratepenalty v_demandid, v_assessmento (% %)', v_demandid, v_assessmento;
		v_temp := migrateassessmentpenalty(v_assessmento, v_currinst, v_moduleid, v_demandid);
		EXCEPTION
		WHEN OTHERS THEN
		--raise notice 'migratepenalty, failed while adding arrears : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
return v_temp;
END;
$$ LANGUAGE plpgsql;

