--loadAssessmentMaster
CREATE OR REPLACE FUNCTION loadAssessmentMaster()
  RETURNS character varying AS
$BODY$
declare
	v_strucpk 	bigint; 
	v_usagepk 	bigint;
	v_floortypepk 	bigint;
	v_rooftypepk 	bigint;
	v_woodtypepk 	bigint;
	v_walltypepk 	bigint;
	v_exemptionpk 	bigint;
	v_apartmentpk 	bigint;
	v_occupancypk 	bigint;
	v_titlereason	bigint;
	v_isassmasterloaded	bigint default 1;
	bldgclass egpt_stg_bldgclass_mater%ROWTYPE;
	usageMstr egpt_stg_usagemaster%ROWTYPE;
	floorType egpt_stg_floortype%ROWTYPE;
	roofType egpt_stg_rooftype%ROWTYPE;
	wallType egpt_stg_walltype%ROWTYPE;
	woodType egpt_stg_woodtype%ROWTYPE;
	exemption egpt_stg_exemption%ROWTYPE;
	apartment egpt_stg_apartment%ROWTYPE;
	occupancy egpt_stg_occupancy%ROWTYPE;
	titlereasons pt_doctype_mstr_tbl%ROWTYPE;
BEGIN 
begin
	--Building Classification
	for bldgclass in (select * from egpt_stg_bldgclass_mater where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_struc_cl') into v_strucpk;
				INSERT INTO egpt_struc_cl(id, constr_num, constr_type, constr_descr, modified_date, is_history, created_by, code, order_id, from_date, to_date, created_date, modified_by, id_installment)
				VALUES (v_strucpk, 1, bldgclass.name, bldgclass.name, now(), 'N', 1, upper(substr(replace(replace(replace(bldgclass.name,'.',''),' ',''),',',''),1,16)), v_strucpk, to_date('01/04/2004', 'dd/mm/yyyy'), to_date('01/04/2099', 'dd/mm/yyyy'), now(), 1, (select id from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and current_timestamp between start_date and end_date));
				update egpt_stg_bldgclass_mater set egovcode =v_strucpk where code=bldgclass.code;		   
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading building classification failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Building Classification loaded';

	--Property Usage
	for usageMstr in (select * from egpt_stg_usagemaster where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_property_usage_master') into v_usagepk;
			   	INSERT INTO egpt_property_usage_master(id, usg_name, modified_date, code, order_id, from_date, to_date, is_enabled, created_by, modified_by, created_date, isresidential)
		        VALUES (v_usagepk, usageMstr.name, now(),upper(substr(replace(replace(replace(usageMstr.name,'.',''),' ',''),',',''),1,16)), v_usagepk, to_date('01/04/2004', 'dd/mm/yyyy') ,to_date('01/04/2099', 'dd/mm/yyyy'), 1, 1, 1, now(), FALSE);
				update egpt_stg_usagemaster set egovcode =v_usagepk where code=usageMstr.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Usage Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	update egpt_property_usage_master set isresidential = TRUE where upper(usg_name) like 'RESI%';
	RAISE NOTICE 'Property Usage loaded';

	--Floor Type
	for floorType in (select * from egpt_stg_floortype where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_floor_type') into v_floortypepk;
			   	INSERT INTO egpt_floor_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_floortypepk, floorType.name, upper(substr(replace(replace(replace(floorType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_floortype set egovcode =v_floortypepk where code=floorType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Floor Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Floor type loaded';

	--Roof Type
	for roofType in (select * from egpt_stg_rooftype where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_roof_type') into v_rooftypepk;
			   	INSERT INTO egpt_roof_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_rooftypepk, roofType.name, upper(substr(replace(replace(replace(roofType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_rooftype set egovcode =v_rooftypepk where code=roofType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Roof Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Roof type loaded';

	--Wood Type
	for woodType in (select * from egpt_stg_woodtype where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_wood_type') into v_woodtypepk;
			   	INSERT INTO egpt_wood_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_woodtypepk, woodType.name, upper(substr(replace(replace(replace(woodType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_woodtype set egovcode =v_woodtypepk where code=woodType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Wood Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Wood type loaded';

	--Wall Type
	for wallType in (select * from egpt_stg_walltype where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_wall_type') into v_walltypepk;
			   	INSERT INTO egpt_wall_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_walltypepk, wallType.name, upper(substr(replace(replace(replace(wallType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_walltype set egovcode =v_walltypepk where code=wallType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Wall Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Wall type loaded';

	--Exemption Master
	for exemption in (select * from egpt_stg_exemption where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_exemption_reason') into v_exemptionpk;
				INSERT INTO egpt_exemption_reason(id, name, code, createddate, lastmodifieddate, createdby, lastmodifiedby)
		        VALUES (v_exemptionpk, exemption.name, upper(substr(replace(replace(replace(exemption.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_exemption set egovcode =v_exemptionpk where code=exemption.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Exemption Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Exemption Master loaded';

	--Apartment Master
	for apartment in (select * from egpt_stg_apartment where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_apartment') into v_apartmentpk;
				INSERT INTO egpt_apartment(id, name, code, createddate, lastmodifieddate, createdby, lastmodifiedby)
		        VALUES (v_apartmentpk, apartment.name, upper(substr(replace(replace(replace(apartment.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_apartment set egovcode =v_apartmentpk where code=apartment.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Apartment Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Apartment Master loaded';

	--Occupancy Master
	for occupancy in (select * from egpt_stg_occupancy where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_occupation_type_master') into v_occupancypk;
				INSERT INTO egpt_occupation_type_master(id, occupation, modified_date, occupation_local, code, created_by, modified_by, created_date)
				VALUES (v_occupancypk, occupancy.name, now(), occupancy.name, upper(substr(replace(replace(replace(occupancy.name,'.',''),' ',''),',',''),1,10)), 1, 1, now());
				update egpt_stg_occupancy set egovcode =v_occupancypk where code=occupancy.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Occuapancy Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Occuapancy Master loaded';

	--Reasons for title transfer
	for titlereasons in (select * from pt_doctype_mstr_tbl where c_delflag='N')
		loop 
			begin
				select nextval('SEQ_EGPT_MUTATION_MASTER') into v_titlereason;
				Insert into egpt_mutation_master (ID,MUTATION_NAME,MUTATION_DESC,TYPE,CODE,ORDER_ID)
				VALUES (v_titlereason, titlereasons.vc_doctypedesc, titlereasons.vc_doctypedesc, 'TRANSFER', upper(substr(replace(replace(replace(titlereasons.vc_doctypedesc,'.',''),' ',''),',',''),1,10)), v_occupancypk);

				update egpt_stg_occupancy set egovcode =v_titlereason where code=occupancy.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Reasons for title transfer failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Reasons for title transfer loaded';
EXCEPTION
WHEN OTHERS THEN
raise notice 'loadAssessmentMaster failed : % %', SQLERRM, SQLSTATE;
v_isassmasterloaded := 0;
END;
return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;


--createFlrDmdCalc
create or replace FUNCTION migrateCollection(assessmentNo IN bigint, idDemand IN bigint)
RETURNS bigint as $$
declare
v_collection double precision;
v_mindate	date;
v_maxdate	date;
v_instfdate	timestamp without time zone;
v_insttdate	timestamp without time zone;
dds record;
BEGIN 
	--raise notice 'migrateCollection assessmentNo, idDemand (% %)',assessmentNo, idDemand;
	select sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_advamt) total, min(dt_paidfrmprddt), max(dt_paidtoprddt) into v_collection, v_mindate, v_maxdate from pt_asmtrcpt_tbl where i_asmtno=assessmentNo and C_ISRLSD <> 'X' AND C_DELFLAG = 'N';
	--raise notice 'migrateCollection v_collection, v_mindate, v_maxdate (% % %)',v_collection, v_mindate, v_maxdate;
	select inst.start_date into v_instfdate from eg_installment_master inst where v_mindate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');

	select inst.end_date into v_insttdate from eg_installment_master inst where v_maxdate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');
	
	for dds in (SELECT dd.id ddid, dd.amount FROM eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst where dd.id_demand=idDemand and dd.id_demand_reason=dr.id and dr.id_installment=inst.id and inst.start_date>=v_instfdate and inst.end_date<=v_insttdate order by inst.start_date)
	loop 
		begin
			if v_collection>0 then
				v_collection := v_collection - dds.amount;
				update eg_demand_details set amt_collected=amount where id=dds.ddid;
			end if;
			--raise notice 'migrateCollection after adjust v_collection (%)',v_collection;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateCollection, Migrate collection failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	--raise notice 'Collection Migrated';
return 1;
EXCEPTION
WHEN OTHERS THEN
raise notice 'migrateCollection : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;


--loadReceipts  
CREATE OR REPLACE FUNCTION loadReceipts()
  RETURNS character varying AS
$BODY$
declare
	v_categorypk 	bigint; 
	v_bndrycategorypk 	bigint;
	v_usagename 	varchar(256); 
	v_classname 	varchar(256); 
	v_catename	 	varchar(64);
	v_isassmasterloaded	bigint default 1;
	unitrate pt_ur_mstr_tbl%ROWTYPE;
BEGIN
	begin
		delete from egpt_property_receipts;
		insert into egpt_property_receipts (id, id_basic_property, booknumber, rcpt_number, rcpt_date, from_date, to_date, rcpt_amount)
		select nextval('seq_egpt_property_receipts'), bp.id, i_bookno, trim(i_slno), dt_etrydt, dt_paidfrmprddt, dt_paidtoprddt, (d_arrpt + d_arred + d_arrlcs + d_arruauthcnstplty + d_pltyonarr + d_crnpt + d_crned + d_crnlcs + d_crnuauthcnstplty + d_pltyoncrn + d_advamt) from pt_asmtrcpt_tbl rcpt, egpt_basic_property bp where cast(bp.propertyid as int)=rcpt.i_asmtno and rcpt.c_delflag='N' and rcpt.C_ISRLSD <> 'X';
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'loadReceipts, loading Unit Rates failed : % %', SQLERRM, SQLSTATE;
	v_isassmasterloaded := 0;
	END;
RAISE NOTICE 'Receipts loaded';

return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
