--Demand
create or replace FUNCTION createDemand(assessmentNo IN bigint, idProp IN bigint, currInst IN bigint, assessmentdate IN date, idModule IN bigint, arv double precision, currInstDesc varchar(16)) 
RETURNS numeric as $$
declare
	v_demandpk 	bigint; 
	v_dmddet 	bigint; 
	v_temp 		bigint; 
	v_idinst	bigint; 
	v_proptax 	double precision;
	v_educess 	double precision;
	v_libcess 	double precision;
	v_unauthtax	double precision;
	v_totaltax	double precision;
	v_arreartax	double precision;
	arrearDmds 	pt_arrear_tbl%ROWTYPE;
BEGIN 
	--raise notice 'createDemand assessmentNo, idProp, currInst, assessmentdate, idModule (% % % %)',assessmentNo, idProp, currInst, assessmentdate, idModule;
	select d_crnpt, d_crned, d_crnlcs, d_crnuauthcnstplty
	into v_proptax, v_educess, v_libcess, v_unauthtax
	from pt_dmndrgtr_tbl where i_asmtno =assessmentNo and vc_dmndyear=currInstDesc;

	if(v_proptax is null or v_proptax=0) then
		select d_fxdpt, d_fxded, d_fxdlcs, d_fxdunauthplnplty
		into v_proptax, v_educess, v_libcess, v_unauthtax
		from pt_asmt_mstr_tbl where i_asmtno =assessmentNo;
	end if;

	v_totaltax := v_proptax + v_educess + v_libcess + v_unauthtax;
	--raise notice 'createDemand v_proptax, v_educess, v_libcess, v_unauthtax, v_proptax (% % % % %)',v_proptax, v_educess, v_libcess, v_unauthtax, v_proptax;

	select nextval('seq_eg_demand') into v_demandpk;
	INSERT INTO eg_demand(id, id_installment, base_demand, is_history, create_date, modified_date, amt_collected)
    VALUES (v_demandpk, currInst, v_totaltax, 'N', assessmentdate, assessmentdate, 0);

	insert into egpt_ptdemand (id_demand, id_property) values (v_demandpk, idProp);
	--raise notice 'createDemand Demand Created';
	--select * from pt_dmndrgtr_tbl where i_asmtno =1065010757
	v_temp := createInstDemandDetail(v_demandpk, currInst, v_proptax, v_educess, v_libcess, v_unauthtax, idModule, assessmentdate);
	begin
		select coalesce(sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty), 0) into v_arreartax from pt_arrear_tbl where c_delflag='N' and i_asmtno=assessmentNo;
		if(v_arreartax>0)then
		for arrearDmds in (select * from pt_arrear_tbl where c_delflag='N' and i_asmtno =assessmentNo)
		loop 
			begin
				select id into v_idinst from eg_installment_master where id_module=idModule and description=arrearDmds.vc_dmndyear;
				v_temp := createInstDemandDetail(v_demandpk, v_idinst, arrearDmds.d_arrpt, arrearDmds.d_arred, arrearDmds.d_arrlcs, arrearDmds.d_arruauthcnstplty, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'createDemand, failed while adding arrears : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;
		end if;
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'createDemand, failed while checking arrears : % %', SQLERRM, SQLSTATE;
	END;
return v_demandpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createDemand : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

