 --updateDuplicateAlterations
create or replace function updateDuplicateAlterations(incrno bigint)
returns bigint as
$$
declare
  v_count bigint;
  temp record;
  asmt record;
begin
  for asmt in (select distinct(i_asmtno) from pt_extnasmtbal_tbl where c_delflag = 'N' and ismigrated = 'N' and incrementalno = incrno)
  loop
    v_count:=0;
    for temp in (select i_slno from pt_extnasmtbal_tbl where c_delflag = 'N' and (ismigrated = 'N' or ismigrated is null) and i_asmtno = asmt.i_asmtno and incrementalno=incrno order by ts_dttm desc)
    loop
      --raise notice 'count %', v_count;
      if ( v_count > 0 ) then
	update pt_extnasmtbal_tbl set error = 'Old Alteration', ismigrated='F' where i_slno=temp.i_slno;
      end if;
      v_count:=v_count+1;
    end loop;
  end loop;
  return 1;
  exception
  when others then
    raise notice 'updateDuplicateAlterations : % %', SQLERRM, SQLSTATE;
end;
$$
language plpgsql;

--addalterAmountMigration
create or replace function addalterAmountMigration(incrno bigint)
returns bigint as
$$ 
declare
  asmt record;
  v_asmtno integer;
  v_moduleid bigint;
  v_currinst bigint;
  v_temp bigint;
  v_propid bigint;
  v_currdemand bigint;
  v_valid boolean;
  v_start_date timestamp without time zone;
  v_end_date timestamp without time zone;
  v_duplicateCount bigint;
begin
  select count(*) into v_duplicateCount from (select i_asmtno from pt_extnasmtbal_tbl where c_delflag = 'N' and ismigrated = 'N' group by i_asmtno having count(*) > 1) temp;
  if (v_duplicateCount > 0) then
    raise exception 'Duplicate records are there. Execute updateDuplicateAlterations procedure';
  end if;
  select id into v_moduleid from eg_module where name='Property Tax';
  select id, start_date, end_date into v_currinst, v_start_date, v_end_date from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;
  for asmt in (select distinct(i_asmtno) from pt_extnasmtbal_tbl where c_delflag = 'N' and ismigrated = 'N' and incrementalno = incrno)
    loop
      begin
	v_asmtno := asmt.i_asmtno;
	--raise notice 'addalterAmountMigration: AssessmentNo (%)', v_asmtno;
	v_valid := validateAssessmentForAlteration(cast(v_asmtno as text));
	if (v_valid = false) then
	  select id into v_propid from egpt_property where id_basic_property = (select id from egpt_basic_property where propertyid = cast(v_asmtno as character varying)) and status = 'A';
	  select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property=v_propid) and id_installment = v_currinst;
	  --raise notice 'addalterAmountMigrationSingleAssessment assessmentNo, idDemand (% %)',v_asmtno, v_currdemand;
	  v_temp := addalterAmountMigrationSingleAssessment(v_asmtno, v_currdemand, incrno);
	  --raise notice 'Alteration amount for assessment % has been migrated successfully', v_asmtno;
	elsif (v_valid = true) then
	  update pt_extnasmtbal_tbl set error = 'Assessment has been altered in egov system', ismigrated='F' where incrementalno = incrno and i_asmtno = v_asmtno;
	end if;
	exception
	  when others then
	    raise notice 'addalterAmountMigration : % %', SQLERRM, SQLSTATE;
      end;
    end loop;
return 1;
end;
$$ 
language plpgsql;

--addalterAmountMigrationSingleAssessment
create or replace function addalterAmountMigrationSingleAssessment(asmtno integer, currdmdId bigint,  incrno bigint)
returns bigint as 
$$
declare
  v_altered_inst bigint;
  v_altered_inst_desc character varying(16);
  v_moduleid bigint;
  v_add_date timestamp without time zone;
  v_to_instdate timestamp without time zone;
  rec record;
  v_genTax double precision;
  v_eduCess double precision;
  v_libCess double precision;
  v_unAuthPenalty double precision;
  v_temp bigint;
  v_curr_inst_start_date timestamp without time zone;
begin
  --raise notice 'addalterAmountMigrationSingleAssessment : assessmentNo, currentDemandid, incrno (% % %)', asmtno, currdmdId, incrno;
  select id into v_moduleid from eg_module where name = 'Property Tax';
  select start_date into v_curr_inst_start_date from eg_installment_master where now() between start_date and end_date and id_module = v_moduleid;
  
  select dt_addaltdt into v_add_date from pt_extnasmtbal_tbl where c_delflag = 'N' and i_asmtno = asmtno and ismigrated = 'N' and incrementalno = incrno;
  --raise notice 'addalterAmountMigrationSingleAssessment : alteration date (%)', v_add_date;
  select id, description into v_altered_inst, v_altered_inst_desc from eg_installment_master where id_module = v_moduleid and v_add_date between start_date and end_date;
  --raise notice 'addalterAmountMigrationSingleAssessment : Altered installment (%)', v_altered_inst;
  select min(start_date) into v_to_instdate from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst where dd.id_demand = currdmdId and dd.id_demand_reason = dr.id and dr.id_installment = inst.id;
  
  if (v_add_date < v_curr_inst_start_date) then 
    select d_crnpt,d_crned,d_crnlcs,d_crnuauthcnstplty into v_genTax, v_eduCess, v_libCess, v_unAuthPenalty  from pt_dmndrgtr_tbl where i_asmtno = asmtno and vc_dmndyear = v_altered_inst_desc order by ts_dttm desc limit 1;
    --raise notice 'addalterAmountMigrationSingleAssessment : v_genTax, v_libCess, v_eduCess, v_unAuthPenalty (% % % % % %)', v_genTax, v_libCess, v_eduCess, v_unAuthPenalty, asmtno, v_altered_inst_desc;
    v_temp := createAlteredInstDemandDetail(asmtno, currdmdId, v_altered_inst, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date, incrno);
    for rec in (select id, description from eg_installment_master where id_module = v_moduleid and start_date >= v_add_date and start_date < v_to_instdate)
    loop
      select d_crnpt,d_crned,d_crnlcs,d_crnuauthcnstplty into v_genTax, v_eduCess, v_libCess, v_unAuthPenalty  from pt_dmndrgtr_tbl where i_asmtno = asmtno and vc_dmndyear = rec.description order by ts_dttm desc limit 1;
      --raise notice 'addalterAmountMigrationSingleAssessment : v_genTax, v_libCess, v_eduCess, v_unAuthPenalty (% % % %)', v_genTax, v_libCess, v_eduCess, v_unAuthPenalty;
      v_temp := createAlteredDemandDetail(currdmdId, rec.id, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date);
    end loop;
    update pt_extnasmtbal_tbl set ismigrated = 'Y' where i_asmtno = asmtno and ismigrated = 'N' and c_delflag = 'N' and incrementalno = incrno;
  else 
    update pt_extnasmtbal_tbl set ismigrated = 'F', error = 'Excluded from migration as it is altered in Current installment' where i_asmtno = asmtno and ismigrated = 'N' and c_delflag = 'N' and incrementalno = incrno;
  end if;
  
return 1;
exception
when others then
  raise notice 'addalterAmountMigrationSingleAssessment : % %', SQLERRM, SQLSTATE;
end;
$$
language plpgsql;
