--migrateassessmtCity
CREATE OR REPLACE FUNCTION migrateassessmtCity()
RETURNS void AS
$BODY$
DECLARE
asmstr pt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and (incrementalno=0 or incrementalno is null))
	loop 
		begin
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'migrateassessmtCity : Started for assessment no (%)', v_assessmentno;
			v_temp  := migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmtCity : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;

--migrateassessmtWard
CREATE OR REPLACE FUNCTION migrateassessmtWard(wardCode IN bigint)
RETURNS void AS
$BODY$
DECLARE
asmstr pt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and (incrementalno=0 or incrementalno is null) and i_rwobjid=wardCode)
	loop 
		begin
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'migrateassessmtWard : Started for assessment no (%)', v_assessmentno;
			v_temp  := migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmtWard : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;

--migrateassessmtblock
CREATE OR REPLACE FUNCTION migrateassessmtblock(blockCode IN bigint)
RETURNS void AS
$BODY$
DECLARE
asmstr pt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and (incrementalno=0 or incrementalno is null) and i_blckobjid=blockCode)
	loop 
		begin
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'migrateassessmtblock : Started for assessment no (%)', v_assessmentno;
			v_temp  := migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmtblock : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;


--migrateIncrementalAssessments
create or replace function migrateIncrementalAssessments(incrno bigint) 
	returns void as $$
declare
	asmstr pt_asmt_mstr_tbl%ROWTYPE;
	v_idsource bigint;
	v_currinst bigint;
	v_currinstdesc varchar(16);
	v_moduleid bigint;
	v_assessmentno integer;
	v_valid boolean;
	v_temp integer;
	v_temp1 boolean;
	v_exists boolean;
begin
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';
	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and incrementalno = incrno)
	loop
		v_assessmentno := asmstr.i_asmtno;
		--raise notice 'Assessment : %', v_assessmentno;
		v_valid := validateAssessmentForTransactions(cast(v_assessmentno as text));
		if (v_valid = false) then
			v_exists := existsInEgovSystem(cast(v_assessmentno as text));
			if (v_exists = false) then
			    v_temp1 := deleteAssessment(cast(v_assessmentno as text));
			    -- if (v_temp1 = true) then
			    -- 	raise notice 'Assessment Deleted: %', v_assessmentno;
			    -- end if;
			    v_temp  := migrateIncrementalSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid, incrno);
			    --raise notice 'Assessment Migrated: %', v_assessmentno;
			    insert into egpt_property_receipts (id, id_basic_property, booknumber, rcpt_number, rcpt_date, from_date, to_date, rcpt_amount)
				select nextval('seq_egpt_property_receipts'), bp.id, i_bookno, trim(i_slno), dt_rcptdt, dt_paidfrmprddt, dt_paidtoprddt, (d_arrpt + d_arred + d_arrlcs + d_arruauthcnstplty + d_pltyonarr + d_crnpt + d_crned + d_crnlcs + d_crnuauthcnstplty + d_pltyoncrn + d_advamt) 
				from pt_asmtrcpt_tbl rcpt, egpt_basic_property bp where cast(bp.propertyid as int)=rcpt.i_asmtno and rcpt.c_delflag='N' and rcpt.i_asmtno=v_assessmentno;
			else 
			    update pt_asmt_mstr_tbl set error = 'Assessment with same assessment number is created in egov system', ismigrated='F' where incrementalno = incrno and i_asmtno = v_assessmentno;
			    update pt_asmtrcpt_tbl set error = 'Assessment with same assessment number is created in egov system', ismigrated='F' where incrementalno = incrno and i_asmtno = v_assessmentno;
			end if;
		elsif (v_valid = true) then
			update pt_asmt_mstr_tbl set error = 'Transactions are there for this assessment', ismigrated='F' where incrementalno = incrno and i_asmtno = v_assessmentno;
			update pt_asmtrcpt_tbl set error = 'Transactions are there for this assessment', ismigrated='F' where incrementalno = incrno and i_asmtno = v_assessmentno;
		end if;
	end loop;
	exception 
		WHEN OTHERS THEN 
			raise exception 'migrateIncrementalAssessments : % %', SQLERRM, SQLSTATE;
end;
$$ language plpgsql;
