--loadReceipts  
CREATE OR REPLACE FUNCTION loadReceipts()
  RETURNS character varying AS
$BODY$
declare
	v_categorypk 	bigint; 
	v_bndrycategorypk 	bigint;
	v_usagename 	varchar(256); 
	v_classname 	varchar(256); 
	v_catename	 	varchar(64);
	v_isassmasterloaded	bigint default 1;
	unitrate pt_ur_mstr_tbl%ROWTYPE;
BEGIN
	begin
		delete from egpt_property_receipts;
		insert into egpt_property_receipts (id, id_basic_property, booknumber, rcpt_number, rcpt_date, from_date, to_date, rcpt_amount)
		select nextval('seq_egpt_property_receipts'), bp.id, i_bookno, trim(i_slno), dt_etrydt, dt_paidfrmprddt, dt_paidtoprddt, (d_arrpt + d_arred + d_arrlcs + d_arruauthcnstplty + d_pltyonarr + d_crnpt + d_crned + d_crnlcs + d_crnuauthcnstplty + d_pltyoncrn + d_advamt) from pt_asmtrcpt_tbl rcpt, egpt_basic_property bp where cast(bp.propertyid as int)=rcpt.i_asmtno and rcpt.c_delflag='N';
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'loadReceipts, loading Unit Rates failed : % %', SQLERRM, SQLSTATE;
	v_isassmasterloaded := 0;
	END;
RAISE NOTICE 'Unit Rates loaded';

return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
