---Updated procedure to take only new records from tmp_employee

CREATE OR REPLACE FUNCTION load_employee()
  RETURNS void AS
$BODY$
declare
desig_name varchar(100); 
dept_name varchar(100);
emp_code varchar(10);
emp_name varchar(100);
emp_gender varchar(1);
emp_gender_num smallint;
emp_mobile varchar(10);
v_username varchar(50);
existing_emp_username varchar(50);
isDepartmentExist boolean default false;
isDesignationExist  boolean default false;
isEmployeeCodeUnique boolean default true;
isUserNameUnique boolean default true;
isDeptDesignationExist  boolean default true;
isAssignmentUnique boolean default true;
isEmployeeSameChecking boolean default false;
srl bigint;
user_seq bigint;
pos_seq bigint;
dept_code varchar(3);
deptdesig_id bigint default 0;
max_position smallint;
cur_emp tmp_employee%ROWTYPE;

begin
RAISE NOTICE 'Inside Employee data load';
for cur_emp in( select * from tmp_employee where status is null order by srlno)
loop
begin
emp_name:=cur_emp.name;
emp_code:=cur_emp.code;
desig_name:=cur_emp.designation;
dept_name:=cur_emp.department;
srl:=cur_emp.srlno;
emp_gender:=cur_emp.gender;
emp_mobile:=cur_emp.mobile;
v_username=cur_emp.username;
RAISE NOTICE 'Employee data for code %',emp_code;
isDepartmentExist:=department_exist(dept_name);
isDesignationExist:=designation_exist(desig_name);
isEmployeeCodeUnique :=employee_code_unique(emp_code);
isUserNameUnique:=username_unique(v_username);


if(isDepartmentExist=false) then
RAISE NOTICE 'Department does not exist %',dept_name;
update tmp_employee set status ='Department does not exist' where srlno=srl;
end if;

if(isDesignationExist=false) then
RAISE NOTICE 'Designation does not exist %',desig_name;
update tmp_employee set status ='Designation does not exist' where srlno=srl;
end if;

if(isUserNameUnique=false) then
RAISE NOTICE 'User Name already exist %',v_username;
update tmp_employee set status ='User Name already exist' where srlno=srl;
end if;

if(isEmployeeCodeUnique=false) then
RAISE NOTICE 'Employee Code already exist %',emp_code;
isEmployeeSameChecking:=check_employee_with_code_name(emp_code,emp_name);
	if(isEmployeeSameChecking=true) then
		isAssignmentUnique:=check_assignment_unique(emp_code,dept_name,desig_name);
		if(isAssignmentUnique=false) then
			------**Load the temporary assignment**------
			-----------Load to Position
			select nextval('seq_eg_position') into pos_seq;
			select code into dept_code from eg_department where upper(name)=upper(dept_name);
			select username into existing_emp_username from eg_user where id=(select id from egeis_employee where upper(code)=upper(emp_code));
			---If deptdesig not there then we need to insert one row
			isDeptDesignationExist:=deptdesig_exist(desig_name,dept_name);
			RAISE NOTICE 'DEPT-DESIG EXISTS ***** %',isDeptDesignationExist;

			if(isDeptDesignationExist=false) then
			--select nextval('seq_egeis_deptdesig') into deptdesig_id;
			insert into egeis_deptdesig (id,designation,department,sanctionedposts,version,createddate,lastmodifieddate,createdby,lastmodifiedby)
			values(nextval('seq_egeis_deptdesig'),(select id from eg_designation where upper(name)=upper(desig_name)),(select id from eg_department where upper(name)=upper(dept_name)),1,1,current_date,current_date,1,1);
			RAISE NOTICE 'Inserted to DEpt-Desig %',desig_name;
			end if;

			select id into deptdesig_id from egeis_deptdesig des where designation in(select id from eg_designation where upper(name)=upper(desig_name))
			and department in(select id from eg_department where upper(name)=upper(dept_name));

			select count(id) into max_position from eg_position where deptdesig=deptdesig_id;

			insert into eg_position(name,id,deptdesig,createddate,lastmodifieddate,createdby,lastmodifiedby,ispostoutsourced,version)
			values(dept_code||'_'||desig_name||'_'||max_position+1,pos_seq,deptdesig_id,current_date,current_date,1,1,false,0);

			----------Load to assignment---------
			insert into egeis_assignment (id,designation,department,position,grade,lastmodifiedby,lastmodifieddate,
			createddate,createdby,fromdate,todate,version,isprimary,employee)
			values(nextval('seq_egeis_assignment'),(select id from eg_designation where upper(name)=upper(desig_name)),
			(select id from eg_department where upper(name)=upper(dept_name)),pos_seq,(select grade_id from egeis_grade_mstr where grade_value='A'),
			1,current_date,current_date,1,'01-Apr-2015','31-Mar-2017',0,false,(select id from egeis_employee where upper(code)=upper(emp_code)));
			------End of loading temporary assignment
			update tmp_employee set status ='Updated',remarks='Loaded temporary assignment for User-'||existing_emp_username where srlno=srl;
		else
			update tmp_employee set status ='Employee already exist' where srlno=srl;
		end if;
	else
		update tmp_employee set status ='Employee Code already exist' where srlno=srl;
	end if;
end if;

if(isDepartmentExist=true and isDesignationExist=true and isEmployeeCodeUnique=true and isUserNameUnique=true) then
RAISE NOTICE 'Ready for Employee data load';
---Load to user table
select nextval('seq_eg_user') into user_seq;

if(upper(emp_gender)='M') then
emp_gender_num:=1;
else
emp_gender_num:=0;
end if;
insert into eg_user(id,locale,username,password,pwdexpirydate,mobilenumber,createddate,lastmodifieddate,createdby,
lastmodifiedby,active,name,gender,type,version)
values(user_seq,'en_IN',v_username,
'$2a$10$uheIOutTnD33x7CDqac1zOL8DMiuz7mWplToPgcf7oxAI9OzRKxmK','01-Jan-2099',emp_mobile,
current_date,current_date,1,1,true,emp_name,emp_gender_num,'EMPLOYEE',0);
RAISE NOTICE 'After loading User...';
--------------Load to eg_employee
insert into egeis_employee(id,code,employeestatus,employeetype,version) values(user_seq,emp_code,'EMPLOYED',(select id from egeis_employeetype where name='Permanent'),0);
RAISE NOTICE 'After loading Employee';
-----------Load to Position
select nextval('seq_eg_position') into pos_seq;
select code into dept_code from eg_department where upper(name)=upper(dept_name);

---If deptdesig not there then we need to insert one row
isDeptDesignationExist:=deptdesig_exist(desig_name,dept_name);
RAISE NOTICE 'DEPT-DESIG EXISTS ***** %',isDeptDesignationExist;

if(isDeptDesignationExist=false) then
--select nextval('seq_egeis_deptdesig') into deptdesig_id;
insert into egeis_deptdesig (id,designation,department,sanctionedposts,version,createddate,lastmodifieddate,createdby,lastmodifiedby)
values(nextval('seq_egeis_deptdesig'),(select id from eg_designation where upper(name)=upper(desig_name)),(select id from eg_department where upper(name)=upper(dept_name)),1,1,current_date,current_date,1,1);
RAISE NOTICE 'Inserted to DEpt-Desig %',desig_name;
end if;

select id into deptdesig_id from egeis_deptdesig des where designation in(select id from eg_designation where upper(name)=upper(desig_name))
and department in(select id from eg_department where upper(name)=upper(dept_name));

select count(id) into max_position from eg_position where deptdesig=deptdesig_id;

insert into eg_position(name,id,deptdesig,createddate,lastmodifieddate,createdby,lastmodifiedby,ispostoutsourced,version)
values(dept_code||'_'||desig_name||'_'||max_position+1,pos_seq,deptdesig_id,current_date,current_date,1,1,false,0);
----------Update Dept-Desig for number of post--------
--update egeis_deptdesig set sanctionedposts=sanctionedposts+1 where id=deptdesig_id;

----------Load to assignment---------
insert into egeis_assignment (id,designation,department,position,grade,lastmodifiedby,lastmodifieddate,
createddate,createdby,fromdate,todate,version,isprimary,employee)
values(nextval('seq_egeis_assignment'),(select id from eg_designation where upper(name)=upper(desig_name)),
(select id from eg_department where upper(name)=upper(dept_name)),pos_seq,(select grade_id from egeis_grade_mstr where grade_value='A'),
1,current_date,current_date,1,'01-Apr-2015','31-Mar-2017',0,true,user_seq);

---Update employee to jurisdiction as City-----------------
insert into egeis_jurisdiction (id,employee,boundarytype,createddate,lastmodifieddate,createdby,lastmodifiedby,version,boundary)
values(nextval('seq_egeis_jurisdiction'),user_seq,(select id from eg_boundary_type where upper(name)=upper('City') 
and hierarchytype in(select id from eg_hierarchy_type where upper(name)='ADMINISTRATION')),current_date,current_date,1,1,0,(select id from eg_boundary where boundarytype =(select id from eg_boundary_type where upper(name)=upper('City') 
and hierarchytype in(select id from eg_hierarchy_type where upper(name)='ADMINISTRATION'))));

------------Update the user role for this employee as EMPLOYEE
insert into eg_userrole(roleid,userid) values((select id from eg_role where upper(name)='EMPLOYEE'),user_seq);
---------------Update temp table---------------------
update tmp_employee set status ='Updated' where srlno=srl;
end if;
end;
 end loop;
end;
$BODY$
LANGUAGE plpgsql;

