--------------migrateIncrementalSingleAssess start-------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION migrateIncrementalSingleAssess(assessmentno integer, idsource bigint, currinst bigint, currinstdesc character varying, idmodule bigint, incrno bigint)
	RETURNS bigint AS $BODY$
DECLARE
	v_idinstall bigint;
	v_addressid bigint;
	v_idpropid bigint;
	v_idowner bigint;
	v_idbasic bigint;
	v_idprop bigint;
	v_idpropdet bigint;
	v_idfloor bigint;
	v_idownerlk bigint;
	v_iddmd bigint;
	v_iddmdcalc bigint;
	v_houseno varchar(32);
	v_zone int;
	v_ward int;
	v_block int;
	v_locality int;
	v_eward int;
	v_street int;
	v_assmtdate date;
	v_corraddr1 varchar(32); 
	v_corraddr2 varchar(32);
	v_isExempted character;
	v_arv double precision;
	v_totaltax double precision;
	v_exemptionReason integer;
	v_delflag character;
BEGIN
	begin
		--raise notice 'migrateIncrementalSingleAssess : Started for assessment no (% % % % %)', assessmentNo, idsource, currinst, currinstdesc, idModule;
		select asmtmstr.vc_onrdoorno, asmtmstr.i_zoneobjid, asmtmstr.i_rwobjid, asmtmstr.i_blckobjid, asmtmstr.i_lctyobjid, asmtmstr.i_strtobjid, asmtmstr.i_ewobjid, asmtmstr.dt_taxassddt, asmtmstr.vc_onraddr1, asmtmstr.vc_onraddr2, asmtmstr.c_xptn, asmtmstr.i_xptnpcode, asmtmstr.d_fxdarv, (coalesce(asmtmstr.d_fxdpt,0)+coalesce(asmtmstr.d_fxded,0)+coalesce(asmtmstr.d_fxdlcs,0)+coalesce(asmtmstr.d_fxdunauthplnplty,0)), asmtmstr.c_delflag
		into v_houseno, v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag
		from pt_asmt_mstr_tbl asmtmstr where asmtmstr.i_asmtno = assessmentNo and (isMigrated is null or isMigrated = 'N') and asmtmstr.incrementalno = incrno;
		--raise notice 'migrateIncrementalSingleAssess v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag (% % % % % % % % % % % % % % % %)', v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag;
		select id into v_idinstall from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and v_assmtdate between start_date and end_date;
		--raise notice 'migrateIncrementalSingleAssess : v_idinstall 1(%)', v_idinstall;
		if (v_idinstall is null) then
			select id into v_idinstall from eg_installment_master where start_date=(select min(inst.start_date) from pt_arrear_tbl arr, eg_installment_master inst where inst.id_module=idModule and arr.i_asmtno=assessmentNo and arr.vc_dmndyear=inst.description  and arr.incrementalno = incrno) and id_module=idModule;
		end if;
		if (v_idinstall is null) then
			v_idinstall := currinst;
		end if;
		--raise notice 'migrateIncrementalSingleAssess : v_idinstall 2(%)', v_idinstall;
		--raise notice 'migrateIncrementalSingleAssess : got installment (%)', v_idinstall;
		v_addressid := createAddress(v_houseno, v_locality,v_ward);
		--raise notice 'migrateIncrementalSingleAssess : address created (%)', v_addressid;
		v_idpropid := createPropertyid(v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate);
		--raise notice 'migrateIncrementalSingleAssess : propertyid created (%)', v_idpropid;
		v_idowner := createownerIncremental(assessmentNo, v_corraddr1, v_corraddr2, v_addressid, incrno);
		--raise notice 'migrateIncrementalSingleAssess : owner created (%)', v_idowner;
		v_idbasic := createbasicpropIncremental(assessmentNo, v_addressid, v_idpropid, v_eward, v_delflag, incrno);
		--raise notice 'migrateIncrementalSingleAssess : Basicproperty created (%)', v_idbasic;
		v_idownerlk := linkOwner(v_idbasic, idsource, v_idowner);
		--raise notice 'migrateIncrementalSingleAssess : Owner linked (%)', v_idownerlk;
		v_idprop := createProperty(v_assmtdate, idsource, v_idbasic, v_isExempted, v_exemptionReason, v_idinstall);
		--raise notice 'migrateIncrementalSingleAssess : Property Created (%)', v_idprop;
		v_idpropdet := createpropertydetIncremental(assessmentNo, v_idprop, incrno);
		--raise notice 'Property Details created (%)', v_idpropdet;
		v_iddmd := createdemandIncremental(assessmentNo, v_idprop, currinst, v_assmtdate, idModule, v_arv, currinstdesc, incrno);
		--raise notice 'migrateIncrementalSingleAssess : Demand created';
		v_iddmdcalc := createDemandCalc(v_iddmd, v_totaltax, currinst, v_assmtdate, v_arv);
		--raise notice 'migrateIncrementalSingleAssess : createDemandCalc created';
		v_idfloor := addfloorsIncremental(assessmentNo, v_assmtdate, v_idpropdet, v_iddmdcalc, incrno);
		--raise notice 'Floors created';
		v_idfloor := migrateCollection(assessmentNo, v_iddmd);
		--raise notice 'Collection created';
		update pt_asmt_mstr_tbl set ismigrated='Y' where i_asmtno=assessmentNo and incrementalno = incrno;
		update pt_asmtrcpt_tbl set ismigrated='Y' where i_asmtno=assessmentNo and incrementalno = incrno;
		return v_idfloor;
	EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateIncrementalSingleAssess : % %', SQLERRM, SQLSTATE;
		update pt_asmt_mstr_tbl set error = SQLSTATE || '-' || SQLERRM where i_asmtno=assessmentNo and incrementalno = incrno;
	END;
END;
$BODY$
	LANGUAGE plpgsql;
--------------migrateIncrementalSingleAssess end-------------------------------------------------------------------------------
