create or replace FUNCTION generateUsername(surname IN varchar(8), name IN varchar(8))  
RETURNS VARCHAR as $$
declare
	v_username 	varchar(14); 
	v_surname 	varchar(10); 
	v_random 	varchar(18);
	v_random1 	varchar(18);
	v_randomno 	varchar(6);
	v_surrandomno   varchar(4);
BEGIN 
	--raise notice 'generateUsername name (%)',name;
	v_username := lpad(upper(substr(replace(replace(replace(name,'.',''),' ',''),',',''),1,4)), 4, '0');
	v_random := random()*100000;
	v_random1 := random()*100000;
	v_randomno := substring(v_random from 1 for 6);
	v_surrandomno := substring(v_random1 from 1 for 4);	
	if (surname is not null) then
	  v_surname := rpad(upper(substr(replace(replace(replace(surname,'.',''),' ',''),',',''),1,4)), 4, v_surrandomno);
	  v_username := v_surname || v_username || v_randomno;
	else 
	  v_username := v_username || v_randomno;
	end if;
	--raise notice 'generateUsername, username generated (%)', v_username;
return v_username;
EXCEPTION
WHEN OTHERS THEN
raise notice 'generateUsername : % %', SQLERRM, SQLSTATE;
END;  
$$ LANGUAGE plpgsql;