----------------------- addalterAmountMigrationSingleAssessment start ------------------------------------------
create or replace function addalterAmountMigrationSingleAssessment(asmtno integer, currdmdId bigint,  incrno bigint)
returns bigint as 
$$
declare
  v_altered_inst bigint;
  v_moduleid bigint;
  v_add_date timestamp without time zone;
  v_to_instdate timestamp without time zone;
  rec record;
  instid bigint;
  v_genTax double precision;
  v_eduCess double precision;
  v_libCess double precision;
  v_unAuthPenalty double precision;
  v_temp bigint;
  v_curr_inst_start_date timestamp without time zone;
begin
  --raise notice 'addalterAmountMigrationSingleAssessment : assessmentNo, currentDemandid, incrno (% % %)', asmtno, currdmdId, incrno;
  select id into v_moduleid from eg_module where name = 'Property Tax';
  select start_date into v_curr_inst_start_date from eg_installment_master where now() between start_date and end_date and id_module = v_moduleid;
  
  select dt_addaltdt into v_add_date from pt_extnasmtbal_tbl where i_asmtno = asmtno and incrementalno = incrno;
  --raise notice 'addalterAmountMigrationSingleAssessment : alteration date (%)', v_add_date;
  select id into v_altered_inst from eg_installment_master where id_module = v_moduleid and v_add_date between start_date and end_date;
  --raise notice 'addalterAmountMigrationSingleAssessment : Altered installment (%)', v_altered_inst;
  select min(start_date) into v_to_instdate from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst where dd.id_demand = currdmdId and dd.id_demand_reason = dr.id and dr.id_installment = inst.id;
  
  for rec in (select drm.code, dd.amount from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst 
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = inst.id and dd.id_demand = currdmdId and now() between start_date and end_date) 
  loop
    if rec.code = 'GEN_TAX' then
      v_genTax := rec.amount;
    elsif rec.code = 'LIB_CESS' then
      v_libCess := rec.amount;
    elsif rec.code = 'EDU_CESS' then
      v_eduCess := rec.amount;
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_unAuthPenalty := rec.amount;
    end if;
  end loop;
  --raise notice 'addalterAmountMigrationSingleAssessment : v_genTax, v_libCess, v_eduCess, v_unAuthPenalty (% % % %)', v_genTax, v_libCess, v_eduCess, v_unAuthPenalty;
  if (v_add_date < v_curr_inst_start_date) then 
    v_temp := createAlteredInstDemandDetail(asmtno, currdmdId, v_altered_inst, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date, incrno);
    for instid in (select id from eg_installment_master where id_module = v_moduleid and start_date >= v_add_date and start_date < v_to_instdate)
    loop
      v_temp := createAlteredDemandDetail(currdmdId, instid, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date);
    end loop;
    update pt_extnasmtbal_tbl set ismigrated = 'Y' where i_asmtno = asmtno and incrementalno = incrno;
  else 
    update pt_extnasmtbal_tbl set ismigrated = 'F', error = 'Excluded from migration as it is altered in Current installment' where i_asmtno = asmtno and incrementalno = incrno;
  end if;
  
return 1;
exception
when others then
  raise notice 'addalterAmountMigrationSingleAssessment : % %', SQLERRM, SQLSTATE;
end;
$$
language plpgsql;
---------------------- addalterAmountMigrationSingleAssessment end----------------------------------------------------

