--------------------------- createAlterDemandDetail start ----------------------------------------------------------------------------
create or replace FUNCTION createAlterDemandDetail(idDemand IN bigint, idDemandRsn IN bigint, taxAmount IN double precision, collAmount IN double precision, assessmentdate IN timestamp without time zone) 
RETURNS numeric as $$
declare
  v_dmddetpk bigint;  
BEGIN 
  --raise notice 'createAlterDemandDetail idDemand, idDemandRsn, taxAmount, collAmount, assessmentdate (% % % % %)',idDemand, idDemandRsn, taxAmount, collAmount, assessmentdate;

  select nextval('seq_eg_demand_details') into v_dmddetpk;
  INSERT INTO eg_demand_details(id, id_demand, id_demand_reason, amount, modified_date, create_date, amt_collected)
  VALUES (v_dmddetpk, idDemand, idDemandRsn, taxAmount, assessmentdate, assessmentdate, collAmount);

  --raise notice 'createAlterDemandDetail DemandDetail Created';
return v_dmddetpk;
EXCEPTION
  WHEN OTHERS THEN
    raise notice 'createAlterDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
--------------------------- createAlterDemandDetail end ----------------------------------------------------------------------------


----------------------------- createAlteredDemandDetail start ---------------------------------------------------------------------
create or replace FUNCTION createAlteredDemandDetail(idDemand IN bigint, idInstall IN bigint, propTax IN double precision, eduCess IN double precision, libCess IN double precision, unAuthPenalty IN double precision, idModule IN bigint, assessmentdate IN timestamp without time zone) 
RETURNS numeric as $$
declare
  v_temp bigint;  
BEGIN 
  --raise notice 'createAlteredDemandDetail idDemand, idInstall, propTax, eduCess, libCess, unAuthPenalty, idModule, assessmentdate (% % % % % % % %)',idDemand, idInstall, propTax, eduCess, libCess, unAuthPenalty, idModule, assessmentdate;

  IF (coalesce(propTax,0)>0) then
    v_temp := createAlterDemandDetail(idDemand, getDemandReason(idInstall, 'GEN_TAX', idModule), propTax, propTax, assessmentdate);
  end if;
  IF (coalesce(eduCess,0)>0) then
    v_temp := createAlterDemandDetail(idDemand, getDemandReason(idInstall, 'EDU_CESS', idModule), eduCess, eduCess, assessmentdate);
  end if;
  IF (coalesce(libCess,0)>0) then
    v_temp := createAlterDemandDetail(idDemand, getDemandReason(idInstall, 'LIB_CESS', idModule), libCess, libCess, assessmentdate);
  end if;
  IF (coalesce(unAuthPenalty,0)>0) then
    v_temp := createAlterDemandDetail(idDemand, getDemandReason(idInstall, 'UNAUTH_PENALTY', idModule), unAuthPenalty, unAuthPenalty, assessmentdate);
  end if;
  --raise notice 'createAlteredDemandDetail DemandDetails for installment (%) Created ', idInstall;
  return v_temp;
EXCEPTION
  WHEN OTHERS THEN
    raise notice 'createAlteredDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
----------------------------- createAlteredDemandDetail end ---------------------------------------------------------------------


--------------------------------- createAlteredInstDemandDetail start ---------------------------------------------------------------------
create or replace function createAlteredInstDemandDetail(asmtno integer, idDemand IN bigint, idInstall IN bigint, propTax IN double precision, eduCess IN double precision, libCess IN double precision, unAuthPenalty IN double precision, idModule IN bigint, assessmentdate IN timestamp without time zone, incrno bigint) 
RETURNS numeric as $$
declare
  v_temp bigint;  
  v_propTaxColl double precision;
  v_eduCessColl double precision;
  v_libCessColl double precision;
  v_unAuthPenaltyColl double precision;
  v_add_propTax double precision;
  v_add_eduCess double precision;
  v_add_libCess double precision;
  v_add_unAuthPen double precision;
BEGIN 
  --raise notice 'createAlteredInstDemandDetail asmtno, idDemand, idInstall, propTax, eduCess, libCess, unAuthPenalty, idModule, assessmentdate (% % % % % % % % %)', asmtno, idDemand, idInstall, propTax, eduCess, libCess, unAuthPenalty, idModule, assessmentdate;
	
  select d_crnpt, d_crned, d_crnlcs, d_crnuauthcnstplty into v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen from pt_extnasmtbal_tbl where i_asmtno = asmtno and incrementalno = incrno;
  
  --raise notice 'createAlteredInstDemandDetail v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen (% % % % )', v_add_propTax, v_add_eduCess, v_add_libCess, v_add_unAuthPen;
  
  IF (coalesce(propTax,0)>0) then
	  v_propTaxColl := propTax - coalesce(v_add_propTax,0);
	  v_temp := createAlterDemandDetail(idDemand, getDemandReason(idInstall, 'GEN_TAX', idModule), propTax, v_propTaxColl, assessmentdate);
  end if;
  IF (coalesce(eduCess,0)>0) then
	  v_eduCessColl := eduCess - coalesce(v_add_eduCess,0);
	  v_temp := createAlterDemandDetail(idDemand, getDemandReason(idInstall, 'EDU_CESS', idModule), eduCess, v_eduCessColl, assessmentdate);
  end if;
  IF (coalesce(libCess,0)>0) then
	  v_libCessColl := libCess - coalesce(v_add_libCess,0);
	  v_temp := createAlterDemandDetail(idDemand, getDemandReason(idInstall, 'LIB_CESS', idModule), libCess, v_libCessColl, assessmentdate);
  end if;
  IF (coalesce(unAuthPenalty,0)>0) then
	  v_unAuthPenaltyColl := unAuthPenalty - coalesce(v_add_unAuthPen,0);
	  v_temp := createAlterDemandDetail(idDemand, getDemandReason(idInstall, 'UNAUTH_PENALTY', idModule), unAuthPenalty, v_unAuthPenaltyColl, assessmentdate);
  end if;
  --raise notice 'createAlteredInstDemandDetail DemandDetails for installment (%) Created ', idInstall;
  return v_temp;
EXCEPTION
  WHEN OTHERS THEN
    raise notice 'createAlteredInstDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
---------------------------------createAlteredInstDemandDetail end ---------------------------------------------------------------------

------------------------ validateAssessmentForAlteration start-------------------------------------------------
create or replace function validateAssessmentForAlteration(asmtno character varying)
returns boolean as
$$
declare
  v_basicPropId bigint;
  v_valid boolean default false;
begin
  --raise notice 'validateAssessmentForAlteration : assessmentNo (%)', asmtno;
  select id into v_basicPropId from egpt_basic_property where propertyid = asmtno;
  if (select count(*) from egpt_property_status_values where id_basic_property = v_basicPropId and id_status in 
    (select id from egpt_status where lower(status_name) in ('bifurcation', 'alter'))) > 0 then
    v_valid := true;
  end if;
  return v_valid;
exception
  when others then
    raise notice 'validateAssessmentForAlteration : % %', SQLERRM, SQLSTATE;
    return false;
end;
$$
language plpgsql;
----------------------- validateAssessmentForAlteration end-----------------------------------------------------

----------------------- addalterAmountMigrationSingleAssessment start ------------------------------------------
create or replace function addalterAmountMigrationSingleAssessment(asmtno integer, currdmdId bigint,  incrno bigint)
returns bigint as 
$$
declare
  v_altered_inst bigint;
  v_moduleid bigint;
  v_add_date timestamp without time zone;
  v_to_instdate timestamp without time zone;
  rec record;
  instid bigint;
  v_genTax double precision;
  v_eduCess double precision;
  v_libCess double precision;
  v_unAuthPenalty double precision;
  v_temp bigint;
  v_curr_start_date timestamp without time zone;
  v_curr_end_date timestamp without time zone;
begin
  --raise notice 'addalterAmountMigrationSingleAssessment : assessmentNo, currentDemandid, incrno (% % %)', asmtno, currdmdId, incrno;
  select id into v_moduleid from eg_module where name = 'Property Tax';
  select start_date, end_date into v_curr_start_date, v_curr_end_date from eg_installment_master where now() between start_date and end_date and id_module = v_moduleid;
  
  select dt_addaltdt into v_add_date from pt_extnasmtbal_tbl where i_asmtno = asmtno and incrementalno = incrno;
  --raise notice 'addalterAmountMigrationSingleAssessment : alteration date (%)', v_add_date;
  select id into v_altered_inst from eg_installment_master where id_module = v_moduleid and v_add_date between start_date and end_date;
  --raise notice 'addalterAmountMigrationSingleAssessment : Altered installment (%)', v_altered_inst;
  select min(start_date) into v_to_instdate from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst where dd.id_demand = currdmdId and dd.id_demand_reason = dr.id and dr.id_installment = inst.id;
  
  for rec in (select drm.code, dd.amount from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst 
    where dd.id_demand_reason = dr.id and dr.id_demand_reason_master = drm.id and dr.id_installment = inst.id and dd.id_demand = currdmdId and now() between start_date and end_date) 
  loop
    if rec.code = 'GEN_TAX' then
      v_genTax := rec.amount;
    elsif rec.code = 'LIB_CESS' then
      v_libCess := rec.amount;
    elsif rec.code = 'EDU_CESS' then
      v_eduCess := rec.amount;
    elsif rec.code = 'UNAUTH_PENALTY' then 
      v_unAuthPenalty := rec.amount;
    end if;
  end loop;
  --raise notice 'addalterAmountMigrationSingleAssessment : v_genTax, v_libCess, v_eduCess, v_unAuthPenalty (% % % %)', v_genTax, v_libCess, v_eduCess, v_unAuthPenalty;
  if (v_add_date < v_curr_start_date) then 
    v_temp := createAlteredInstDemandDetail(asmtno, currdmdId, v_altered_inst, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date, incrno);
  end if;
  for instid in (select id from eg_installment_master where id_module = v_moduleid and start_date >= v_add_date and start_date < v_to_instdate)
  loop
    v_temp := createAlteredDemandDetail(currdmdId, instid, v_genTax, v_eduCess, v_libCess, v_unAuthPenalty, v_moduleid, v_add_date);
  end loop;
return 1;
exception
when others then
  raise notice 'addalterAmountMigrationSingleAssessment : % %', SQLERRM, SQLSTATE;
end;
$$
language plpgsql;
---------------------- addalterAmountMigrationSingleAssessment end----------------------------------------------------


---------------------- addalterAmountMigration start-----------------------------------------------------------------
create or replace function addalterAmountMigration(incrno bigint)
returns bigint as
$$ 
declare
  asmt pt_extnasmtbal_tbl%ROWTYPE;
  v_asmtno integer;
  v_moduleid bigint;
  v_currinst bigint;
  v_temp bigint;
  v_propid bigint;
  v_currdemand bigint;
  v_valid boolean;
  v_start_date timestamp without time zone;
  v_end_date timestamp without time zone;
begin
  select id into v_moduleid from eg_module where name='Property Tax';
  select id, start_date, end_date into v_currinst, v_start_date, v_end_date from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;
  for asmt in (select * from pt_extnasmtbal_tbl where c_delflag = 'N' and ismigrated = 'N' and incrementalno = incrno)
    loop
      begin
	v_asmtno := asmt.i_asmtno;
	--raise notice 'addalterAmountMigration: AssessmentNo (%)', v_asmtno;
	v_valid := validateAssessmentForAlteration(cast(v_asmtno as text));
	if (v_valid = false) then
	  select id into v_propid from egpt_property where id_basic_property = (select id from egpt_basic_property where propertyid = cast(v_asmtno as character varying)) and status = 'A';
	  select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property=v_propid) and id_installment = v_currinst;
	  --raise notice 'addalterAmountMigrationSingleAssessment assessmentNo, idDemand (% %)',v_asmtno, v_currdemand;
	  v_temp := addalterAmountMigrationSingleAssessment(v_asmtno, v_currdemand, incrno);
	  --raise notice 'Alteration amount for assessment % has been migrated successfully', v_asmtno;
	elsif (v_valid = true) then
	  update pt_extnasmtbal_tbl set error = 'Assessment has been altered in egov system', ismigrated='F' where incrementalno = incrno and i_asmtno = v_asmtno;
	end if;
	exception
	  when others then
	    raise notice 'addalterAmountMigration : % %', SQLERRM, SQLSTATE;
      end;
    end loop;
return 1;
end;
$$ 
language plpgsql;
------------------------------addalterAmountMigration end---------------------------------------------------------------------------