-------------Adding/Deleting to designation-role mapping-------------
delete from tmp_designation_rolemapping where role='ULB Operator' and designation='Bill Collector';
delete from tmp_designation_rolemapping where srlno in(55,56,57,58);

insert into  tmp_designation_rolemapping (srlno,designation,role) values(55,'Junior Assistant','Collection Operator');
insert into  tmp_designation_rolemapping (srlno,designation,role) values(56,'Senior Assistant','Collection Operator');
insert into  tmp_designation_rolemapping (srlno,designation,role) values(57,'Bill Collector','Collection Operator');
insert into  tmp_designation_rolemapping (srlno,designation,role) values(58,'Record Assistant','Collection Operator');

---calling procedure in all instances
select load_user_role_mapping();

------------------------------------------------------
-----------Updating the procedure for change in role name------------------
CREATE OR REPLACE FUNCTION load_user_counter_mapping()
  RETURNS void AS
$BODY$
declare 
desig varchar(100); 
rolename varchar(100);
user_name varchar(100);
srl numeric;
userid numeric default 0;
roleid numeric default 0;
isUserCounterMappingExist boolean default false;
isUserRoleMappingExist boolean default false;
cur_emp tmp_employee%ROWTYPE;

begin
for cur_emp in( select * from tmp_employee where status='Updated' and (countermappingstatus is null or countermappingstatus!='Updated')order by srlno)
loop
begin
--desig:=upper(cur_emp.designation);
srl:=cur_emp.srlno;
user_name:=cur_emp.username;

RAISE NOTICE 'Processing for User %',user_name;
select id into userid from eg_user where username=user_name;
if(userid=null) then
update tmp_employee set countermappingstatus='Cannot identify the user' where srlno=srl;
else
begin
select id into roleid from eg_role where upper(name)=upper('Collection Operator');
end;
isUserRoleMappingExist:=userrole_mapping_exist(roleid,userid);
if(isUserRoleMappingExist=true) then
isUserCounterMappingExist:=usercounter_mapping_exist('Zone-1',userid);

if(isUserCounterMappingExist=false) then

--Load the usercountermapping to location Zone-1
insert into eg_usercounter_map (id, counterid, fromdate, todate, modifiedby, modifieddate, userid )values
(nextval('seq_eg_usercounter_map'), (select id from eg_location where name='Zone-1'), to_date('01-04-2015','DD-MM-YYYY'), to_date('31-03-2099','DD-MM-YYYY'),1, current_timestamp,userid);

--Update tmp table as sucess
update tmp_employee set countermappingstatus='Updated' where srlno=srl;
else
update tmp_employee set countermappingstatus='Counter mapping already exist for this user' where srlno=srl;
end if;

else
update tmp_employee set countermappingstatus='User is not an Collection Operator' where srlno=srl;
end if;
end if;


end;
end loop;
RAISE NOTICE 'End Processing for User Counter mapping';
end ;
$BODY$
  LANGUAGE plpgsql ;

------------------------------------------------------------------------------------------
------------Deleting the existing mapping and re-loading again-----
update tmp_employee set countermappingstatus = null;
delete from eg_usercounter_map where userid in(select userid from eg_userrole where roleid not in(select id from eg_role where name='Collection Operator'));

select load_user_counter_mapping();
-----------------------------------------------------------------------