-------Procedure to load user counter mapping for all users with role as "ULB OPERATOR" under Zone 1.
create or replace FUNCTION load_router_position()  	
RETURNS void AS
$BODY$
declare 
srl numeric;
userid numeric default 0;
posid numeric default 0;
user_name varchar(20);
isRouterDataExist boolean default false;
cur_emp tmp_employee%ROWTYPE;

begin

isRouterDataExist:=default_router_exist();
if(isRouterDataExist=false) then
	for cur_emp in( select * from tmp_employee where status='Updated' and upper(designation)=upper('Manager') order by srlno)
	loop
	begin
	srl:=cur_emp.srlno;
	user_name:=cur_emp.username;
	RAISE NOTICE 'Processing for User %',user_name;
	select id into userid from eg_user where username=user_name;
	if(userid=null) then
		update tmp_employee set countermappingstatus='Cannot identify the user' where srlno=srl;
	else
		select max(position) into posid from view_egeis_employee where designation=(select id from eg_designation where upper(name)=upper('Manager'));
		if(posid is not null and posid>0)then
			insert into egpgr_router (id,position,bndryid,version,createdby,createddate,lastmodifiedby,lastmodifieddate) values(
			nextval('seq_egpgr_router'),posid,(select id from eg_boundary where boundarytype =(select id from eg_boundary_type where upper(name)=upper('City') 
			and hierarchytype in(select id from eg_hierarchy_type where upper(name)='ADMINISTRATION'))),0,1,current_date,1,current_date);
		end if;
	end if;
	end;
	end loop;
else
RAISE NOTICE 'Router data already exist, hence not processing';
end if;
end ;
$BODY$
LANGUAGE plpgsql;	

----------------------------------
create or replace function default_router_exist() returns boolean as 
$BODY$
declare isexist boolean default true;
begin
	PERFORM id from egpgr_router where complainttypeid is null and bndryid=(select id from eg_boundary where boundarytype =(select id from eg_boundary_type where upper(name)=upper('City') 
	and hierarchytype in(select id from eg_hierarchy_type where upper(name)='ADMINISTRATION')));
	IF NOT FOUND THEN
		RAISE NOTICE 'Inside Router data checking';
		isexist:=false;
	END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;

--------------------
-- To execute call- load_router_position

