alter table pt_asmtrcpt_tbl add ismigrated character varying(1);
alter table pt_asmtrcpt_tbl add error character varying(512);

-----------------------migrateCollectionIncremental start ----------------------------------------------------------------------------------
create or replace FUNCTION migrateCollectionIncremental(assessmentNo IN bigint, idDemand IN bigint)
RETURNS bigint as $$
declare
v_collection double precision;
v_mindate	date;
v_maxdate	date;
v_instfdate	timestamp without time zone;
v_insttdate	timestamp without time zone;
dds record;
BEGIN 
	--raise notice 'migrateCollectionIncremental assessmentNo, idDemand (% %)',assessmentNo, idDemand;
	select sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_advamt) total, min(dt_paidfrmprddt), max(dt_paidtoprddt) into v_collection, v_mindate, v_maxdate from pt_asmtrcpt_tbl where i_asmtno=assessmentNo and isIncremental=true;
	--raise notice 'migrateCollectionIncremental v_collection, v_mindate, v_maxdate (% % %)',v_collection, v_mindate, v_maxdate;
	select inst.start_date into v_instfdate from eg_installment_master inst where v_mindate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');

	select inst.end_date into v_insttdate from eg_installment_master inst where v_maxdate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');
	
	for dds in (SELECT dd.id ddid, dd.amount FROM eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst where dd.id_demand=idDemand and dd.id_demand_reason=dr.id and dr.id_installment=inst.id and inst.start_date>=v_instfdate and inst.end_date<=v_insttdate order by inst.start_date)
	loop 
		begin
			--raise notice 'migrateCollectionIncremental  (% %)',dds.ddid, dds.amount;
			if v_collection>0 then
				v_collection := v_collection - dds.amount;
				update eg_demand_details set amt_collected=amount where id=dds.ddid;
			end if;
			--raise notice 'migrateCollectionIncremental after adjust v_collection (%)',v_collection;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateCollectionIncremental, Migrate collection failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	update pt_asmtrcpt_tbl set ismigrated = 'Y' where i_asmtno=assessmentNo and isIncremental=true;
	--raise notice 'Collection Migrated';
return 1;
EXCEPTION
WHEN OTHERS THEN
raise notice 'migrateCollectionIncremental : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
------------------------migrateCollectionIncremental end -------------------------------------------------------------------------------

------------------------migrateIncrementalRecipts start --------------------------------------------------------------------------------
create or replace function migrateIncrementalRecipts() 
returns bigint as $$
declare
  v_moduleid bigint;
  v_currinst bigint;
  v_propid bigint;
  v_currdemand bigint;
  v_asmtno bigint;
  v_temp bigint;
  v_valid boolean;
  assessmentno character varying;
begin
  select id into v_moduleid from eg_module where name='Property Tax';
  select id into v_currinst from eg_installment_master where id_module=v_moduleid and now() between start_date and end_date;      
  for assessmentno in (select distinct i_asmtno assessmentno from pt_asmtrcpt_tbl where isincremental=true and i_asmtno not in (select i_asmtno from pt_asmt_mstr_tbl where isincremental = true))
  loop
    v_asmtno := assessmentno;
    v_valid := validateAssessmentForTransactions(cast(v_asmtno as text));
    if (v_valid = false) then
      select id into v_propid from egpt_property where id_basic_property = (select id from egpt_basic_property where propertyid = cast(v_asmtno as character varying)) and status = 'A';
      select id into v_currdemand from eg_demand where id in (select id_demand from egpt_ptdemand where id_property=v_propid) and id_installment = v_currinst;
      --raise notice 'migrateCollectionIncremental assessmentNo, idDemand (% %)',v_asmtno, v_currdemand;
      v_temp := migrateCollectionIncremental(v_asmtno, v_currdemand);
      --raise notice 'assessment receipts migrated, assessmentNo (%)',v_asmtno;		
      insert into egpt_property_receipts (id, id_basic_property, booknumber, rcpt_number, rcpt_date, from_date, to_date, rcpt_amount)
	select nextval('seq_egpt_property_receipts'), bp.id, i_bookno, trim(i_slno), dt_rcptdt, dt_paidfrmprddt, dt_paidtoprddt, (d_arrpt + d_arred + d_arrlcs + d_arruauthcnstplty + d_pltyonarr + d_crnpt + d_crned + d_crnlcs + d_crnuauthcnstplty + d_pltyoncrn + d_advamt) 
	from pt_asmtrcpt_tbl rcpt, egpt_basic_property bp where cast(bp.propertyid as int)=rcpt.i_asmtno and rcpt.c_delflag='N' and rcpt.i_asmtno=v_asmtno and rcpt.isincremental=true;
    elsif (v_valid = true) then
      update pt_asmtrcpt_tbl set error = 'Transactions are there for this assessment', ismigrated='F' where isIncremental = true and i_asmtno = v_asmtno;
    end if;
  end loop;
  return v_temp;
exception
when OTHERS then
  raise notice 'migrateIncrementalRecipts : % %', SQLERRM, SQLSTATE;
end;
$$ LANGUAGE plpgsql;
-------------------------migrateIncrementalRecipts end ------------------------------------------------------------------------------------------------------------