----------------------------------Start----------------------------------
--createFlrDmdCalc
create or replace FUNCTION migrateCollection(assessmentNo IN bigint, idDemand IN bigint)
RETURNS bigint as $$
declare
v_collection double precision;
v_mindate	date;
v_maxdate	date;
v_instfdate	timestamp without time zone;
v_insttdate	timestamp without time zone;
dds record;
BEGIN 
	--raise notice 'migrateCollection assessmentNo, idDemand (% %)',assessmentNo, idDemand;
	select sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_advamt) total, min(dt_paidfrmprddt), max(dt_paidtoprddt) into v_collection, v_mindate, v_maxdate from pt_asmtrcpt_tbl where i_asmtno=assessmentNo;
	--raise notice 'migrateCollection v_collection, v_mindate, v_maxdate (% % %)',v_collection, v_mindate, v_maxdate;
	select inst.start_date into v_instfdate from eg_installment_master inst where v_mindate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');

	select inst.end_date into v_insttdate from eg_installment_master inst where v_maxdate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');
	
	for dds in (SELECT dd.id ddid, dd.amount FROM eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst where dd.id_demand=idDemand and dd.id_demand_reason=dr.id and dr.id_installment=inst.id and inst.start_date>=v_instfdate and inst.end_date<=v_insttdate order by inst.start_date)
	loop 
		begin
			if v_collection>0 then
				v_collection := v_collection - dds.amount;
				update eg_demand_details set amt_collected=amount where id=dds.ddid;
			end if;
			--raise notice 'migrateCollection after adjust v_collection (%)',v_collection;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateCollection, Migrate collection failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	--raise notice 'Collection Migrated';
return 1;
EXCEPTION
WHEN OTHERS THEN
raise notice 'migrateCollection : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
----------------------------------End----------------------------------
