------------------------Start-------------------------------
create or replace FUNCTION deactMigZeroTaxNonExempted()
RETURNS void as $$
declare
v_basicpropid bigint;
migrecords record;
BEGIN
     for migrecords in (select i_asmtno from pt_asmt_mstr_tbl where ismigrated='Y' and c_xptn='N' and d_fxdpt=0)
    loop
        begin
		select bp.id into v_basicpropid from egpt_basic_property bp where bp.propertyid = cast(migrecords.i_asmtno as text);
		insert into egpt_property_status_values (ID,ID_STATUS,ID_BASIC_PROPERTY,REF_DATE,REF_NUM,REMARKS,
IS_ACTIVE,MODIFIED_DATE,CREATED_DATE,CREATED_BY,MODIFIED_BY,EXTRA_FIELD1)
values (nextval('SEQ_PROPERTY_STATUS_VALUES'), (select id from egpt_status where code = 'INACTIVE'), 
v_basicpropid,null,null,'This is a migrated non-exempted property, deactivating because tax is zero','Y',now(),now(),1,1,'TAX_ZERO');
		UPDATE EGPT_BASIC_PROPERTY SET isactive=FALSE WHERE ID= v_basicpropid;
	EXCEPTION
	WHEN OTHERS THEN
	NULL;   
	END;
    END LOOP;
END;
$$ LANGUAGE plpgsql;
------------------------End-------------------------------
