﻿------Upding existing records with flag isIcremental false -------------------------
alter table pt_asmt_mstr_tbl add isIncremental boolean default false;
alter table pt_asmt_dtls_tbl add isIncremental boolean default false;
alter table pt_arrear_tbl add isIncremental boolean default false;
alter table pt_dmndrgtr_tbl add isIncremental boolean default false;
alter table pt_asmtrcpt_tbl add isIncremental boolean default false;
alter table pt_asmtbal_tbl add isIncremental boolean default false;
-------------------------------------------------------------------------------------


-----------------validateAssessmentForTransactions start-----------------------------
create or replace function validateAssessmentForTransactions(assessmentno character varying(12))
	returns boolean as $$
declare
	v_basicPropId bigint;
	v_count bigint;
	v_valid boolean default false;
begin
	--raise notice 'validateAssessmentForTransactions assessmentno : %', assessmentno;
	select id into v_basicPropId from egpt_basic_property where propertyid = assessmentno;
	select count(*) into v_count from egcl_collectionheader where consumercode = assessmentno;
	if (select count(*) from egcl_collectionheader where consumercode = assessmentno) > 0 then
		v_valid := true;
	elsif (select count(*) from eg_bill  where consumer_id = assessmentno) > 0 then
		v_valid := true;
	elsif (select count(*) from egpt_property_status_values where id_basic_property = v_basicPropId) > 0 then
		v_valid := true;
	elsif (select count(*) from egpt_vacancy_remission where basicproperty = v_basicPropId) > 0 then
		v_valid := true;
	else
		v_valid := false;
	end if;
	return v_valid;
exception
	when others then
		raise notice 'validateAssessmentForTransactions : % %', SQLERRM, SQLSTATE;
	return false;
end; 
$$ language plpgsql;
--------------validateAssessmentForTransactions end----------------------------------------------------------------


--------------deleteAssessment start-------------------------------------------------------------------------------
create or replace function deleteAssessment(assessmentno character varying(12))
	returns boolean as $$
declare
	v_id_propertyid bigint;
	v_basicPropId bigint;
begin
	--raise notice 'deleteAssessment assessmentno : %', assessmentno;
	select id into v_basicPropId from egpt_basic_property where propertyid  = assessmentno;
	if (v_basicPropId is null) then 
		raise notice 'Property Does not exist';
		return false;
	else 
		select id_propertyid into v_id_propertyid from egpt_basic_property where propertyid = assessmentno;
		delete from egpt_floordemandcalc  where id_floordet in (select id from egpt_floor_detail  where id_property_detail in (select id from egpt_property_detail where id_property in (select id from egpt_property  where id_basic_property  = (select id from egpt_basic_property where propertyid = assessmentno))));
		delete from egpt_demandcalculations where id_demand  in (select id_demand from egpt_ptdemand where id_property  in (select id from egpt_property  where id_basic_property  = (select id from egpt_basic_property where propertyid  = assessmentno)));
		delete from eg_correspondence_address where id in (select addressid from egpt_basic_property where propertyid  = assessmentno);
		delete from egpt_address where id in (select addressid from egpt_basic_property where propertyid  = assessmentno);
		delete from eg_address where id in (select addressid from egpt_basic_property where propertyid  = assessmentno);
		delete from eg_bill_details where id_bill in (select id from eg_bill where consumer_id  = assessmentno);
		delete from eg_bill where consumer_id  = assessmentno;
		delete from egpt_ptdemand where id_property  in (select id from egpt_property  where id_basic_property  = (select id from egpt_basic_property where propertyid = assessmentno));
		delete from eg_demand_details where id_demand in (select id_demand from egpt_ptdemand where id_property  in (select id from egpt_property  where id_basic_property  = (select id from egpt_basic_property where propertyid = assessmentno)));
		delete from eg_demand where id in (select id_demand from egpt_ptdemand where id_property  in (select id from egpt_property  where id_basic_property  = (select id from egpt_basic_property where propertyid = assessmentno)));
		delete from egp_citizen where id in (select id from eg_user where id in (select owner from egpt_property_owner_info where basicproperty in (select id from egpt_basic_property where propertyid  = assessmentno)) and type='CITIZEN' and password = 'NOT SET');
		delete from eg_user where id in (select owner from egpt_property_owner_info where basicproperty in (select id from egpt_basic_property where propertyid  = assessmentno)) and type='CITIZEN' and password = 'NOT SET';
		delete from egpt_property_owner_info where basicproperty in (select id from egpt_basic_property where propertyid  = assessmentno);
		delete from egpt_floor_detail  where id_property_detail in (select id from egpt_property_detail where id_property in (select id from egpt_property  where id_basic_property  = (select id from egpt_basic_property where propertyid = assessmentno)));
		delete from egpt_property_detail where id_property in (select id from egpt_property  where id_basic_property  = (select id from egpt_basic_property where propertyid = assessmentno));
		delete from egpt_property  where id_basic_property  = (select id from egpt_basic_property where propertyid = assessmentno);
		delete from egpt_notice where id_basicproperty  = (select id from egpt_basic_property where propertyid = assessmentno);
		delete from egpt_property_receipts where id_basic_property  = (select id from egpt_basic_property where propertyid = assessmentno);
		delete from egpt_basic_property where propertyid = assessmentno;
		delete from egpt_propertyid where id = v_id_propertyid;
		return true;
	end if;
exception
	when others then
		raise exception 'deleteAssessment : % %', SQLERRM, SQLSTATE;
end;
$$ language plpgsql;
--------------deleteAssessment end-------------------------------------------------------------------------------


--------------createownerIncremental start-------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION createownerIncremental(assessmentno integer, corraddr1 character varying, corraddr2 character varying, addressid bigint)
	RETURNS numeric AS
$BODY$
declare
	v_userpk 	bigint;  
	v_addresspk	bigint;
BEGIN 
	--raise notice 'createownerIncremental assessmentNo, corraddr1, corraddr2, addressid (% % % % %)', assessmentNo, corraddr1, corraddr2, addressid;
	select nextval('seq_eg_address') into v_addresspk;
	select nextval('seq_eg_user') into v_userpk;
	INSERT INTO eg_user(id, locale, username, password, mobilenumber, emailid, createddate, lastmodifieddate, createdby, lastmodifiedby, active, name, gender, type, aadhaarnumber, guardian, guardianrelation)
	select v_userpk, 'en_IN', generateUsername(substring(vc_onrsurname from 1 for 8), substring(vc_onrname from 1 for 8)), 'NOT SET', vc_onrmobino, vc_onreid, dt_taxassddt, dt_taxassddt, 1, 1, TRUE, trim((coalesce(vc_onrsurname,'') ||' '|| coalesce(vc_onrname,''))), (CASE WHEN c_sex = 'F' THEN 0 ELSE 1 END), 'CITIZEN', vc_uid, vc_fthrsurname ||' '|| vc_fthrname, 'Father' from pt_asmt_mstr_tbl where i_asmtno=assessmentNo and isIncremental = true;
	--raise notice 'createownerIncremental Owner created';
	IF (corraddr1 IS NOT NULL OR corraddr2 IS NOT NULL) AND (length(corraddr1)>0 OR length(corraddr2)>0) then
		--raise notice 'createownerIncremental Corr Address available';
		INSERT INTO eg_address(type, streetroadline, arealocalitysector, pincode, id, userid)
		values ('CORRESPONDENCE', corraddr1, corraddr2, NULL, v_addresspk, v_userpk);
		insert into eg_correspondence_address (id) values (v_addresspk);
		--raise notice 'createownerIncremental Owner address created with available corr address';
	else
		--raise notice 'createownerIncremental Corr Address NOT available';
		INSERT INTO eg_address(housenobldgapt, type, streetroadline, arealocalitysector, pincode, id, userid)
		select housenobldgapt, 'CORRESPONDENCE', streetroadline, arealocalitysector, pincode, v_addresspk, v_userpk from eg_address where id=addressid;
		insert into eg_correspondence_address (id) values (v_addresspk);
		--raise notice 'createownerIncremental Owner address created with property address';
END IF;
	return v_userpk;
EXCEPTION
	WHEN OTHERS THEN
		raise notice 'createownerIncremental : % %', SQLERRM, SQLSTATE;
END;  
$BODY$
	LANGUAGE plpgsql;
--------------createownerIncremental end-------------------------------------------------------------------------------


--------------createbasicpropIncremental start-------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION createbasicpropIncremental(assessmentno integer, addressid bigint, id_propertyid bigint, eleward integer, isactive character)
	RETURNS numeric AS
$BODY$
declare
	v_basicpk 	bigint;  
BEGIN 
	--raise notice 'createbasicpropIncremental assessmentNo, addressid, idBasicProp, id_propertyid, eleWard, isactive (% % % % % %)',assessmentNo, addressid, idBasicProp, id_propertyid, eleWard, isactive;
	select nextval('seq_egpt_basic_property') into v_basicpk;
	INSERT INTO egpt_basic_property(id, createdby, propertyid, isactive, addressid, createddate, lastmodifieddate, id_propertyid, municiapl_no_old, id_adm_bndry, id_prop_create_reason, prop_occupancy_date, status, modifiedby, vl_assessmentno, regd_doc_no, regd_doc_date, assessmentdate, source)
	select v_basicpk, 1, i_asmtno, (CASE WHEN isactive = 'N' THEN TRUE ELSE FALSE END), addressid, dt_taxassddt, dt_taxassddt, id_propertyid, vc_oldasmtno, (select egovcode from eg_stg_election where code=eleWard), (select id from EGPT_MUTATION_MASTER where type='CREATE' and code='NEW'), dt_taxassddt, (select id from egpt_status where code='ASSESSED'), 1, i_vcntlndasmtno, vc_rgtddocno, dt_rgtddocdt, dt_taxassddt, 'M' from pt_asmt_mstr_tbl where i_asmtno=assessmentNo and isIncremental = true;
	--raise notice 'createbasicpropIncremental basicproperty created';
	return v_basicpk;
EXCEPTION
	WHEN OTHERS THEN
	raise notice 'createbasicpropIncremental : % %', SQLERRM, SQLSTATE;
END; 
$BODY$
	LANGUAGE plpgsql;
--------------createbasicpropIncremental end-------------------------------------------------------------------------------


--------------createpropertydetIncremental start-------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION createpropertydetIncremental(assessmentno integer, idproperty bigint)
	RETURNS numeric AS
$BODY$
declare
	v_pdpk 	bigint;
BEGIN 
	--raise notice 'createpropertydetIncremental assessmentNo, idproperty (% %)',assessmentNo, idproperty;
	select nextval('seq_egpt_property_detail') into v_pdpk;
	INSERT INTO egpt_property_detail(id, id_property, sital_area, property_type, id_propertytypemaster, id_mutation, updt_timestamp, lift, toilets, watertap, structure, electricity, attachedbathroom, waterharvesting, cable, extentsite, extent_appurtenant_land, siteowner, floortype, rooftype, walltype, woodtype, apartment, building_permission_no, building_permission_date, buildingplandetails_checked, appurtenantland_checked)
		select v_pdpk, idproperty, coalesce(d_extoflnd, 0), 'BuiltUpProperty', (select egovcode from pt_os_mstr_tbl osm where osm.i_oscode=ptmstr.i_oscode), (select id from EGPT_MUTATION_MASTER where type='CREATE' and code='NEW'), dt_taxassddt, (CASE WHEN c_lift = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_tlts = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_wt = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_sprstru = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_ecty = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_athdbathroom = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_whp = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_cablecntn = 'Y' THEN TRUE ELSE FALSE END), coalesce(d_extoflnd, 0), coalesce(d_areaoveraptt, 0), vc_siteonr, (select egovcode from egpt_stg_floortype where code=i_flrtypecode), (select egovcode from egpt_stg_rooftype where code=i_rftypecode), (select egovcode from egpt_stg_walltype where code=i_walltypecode), (select egovcode from egpt_stg_woodtype where code=i_woodtypecode), (select egovcode from egpt_stg_apartment where code=i_aprtcplxcode),  vc_bldgprmnno, dt_bldgprmndt, (CASE WHEN c_bldgplanoptn = 'Y' THEN TRUE ELSE FALSE END), FALSE from pt_asmt_mstr_tbl ptmstr where i_asmtno=assessmentNo and isIncremental = true;
	--raise notice 'createpropertydetIncremental PropertyDetail Created';
	return v_pdpk;
EXCEPTION
	WHEN OTHERS THEN
		raise notice 'createpropertydetIncremental : % %', SQLERRM, SQLSTATE;
END;
$BODY$
	LANGUAGE plpgsql;
--------------createpropertydetIncremental end-------------------------------------------------------------------------------


--------------createdemandIncremental start-------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION createdemandIncremental(assessmentno bigint, idprop bigint, currinst bigint, assessmentdate date, idmodule bigint, arv double precision, currinstdesc character varying)
	RETURNS numeric AS
$BODY$
declare
	v_demandpk 	bigint; 
	v_dmddet 	bigint; 
	v_temp 		bigint; 
	v_idinst	bigint; 
	v_proptax 	double precision;
	v_educess 	double precision;
	v_libcess 	double precision;
	v_unauthtax	double precision;
	v_totaltax	double precision;
	v_arreartax	double precision;
	arrearDmds 	pt_arrear_tbl%ROWTYPE;
BEGIN 
	--raise notice 'createdemandIncremental assessmentNo, idProp, currInst, assessmentdate, idModule (% % % %)',assessmentNo, idProp, currInst, assessmentdate, idModule;
	select d_fxdpt, d_fxded, d_fxdlcs, d_fxdunauthplnplty
	into v_proptax, v_educess, v_libcess, v_unauthtax
	from pt_asmt_mstr_tbl where i_asmtno =assessmentNo and isIncremental = true;
	v_totaltax := v_proptax + v_educess + v_libcess + v_unauthtax;

	--raise notice 'createdemandIncremental v_proptax, v_educess, v_libcess, v_unauthtax, v_proptax (% % % % %)',v_proptax, v_educess, v_libcess, v_unauthtax, v_proptax;

	select nextval('seq_eg_demand') into v_demandpk;
	INSERT INTO eg_demand(id, id_installment, base_demand, is_history, create_date, modified_date, amt_collected)
	VALUES (v_demandpk, currInst, v_totaltax, 'N', assessmentdate, assessmentdate, 0);

	insert into egpt_ptdemand (id_demand, id_property) values (v_demandpk, idProp);
	--raise notice 'createdemandIncremental Demand Created';
	v_temp := createInstDemandDetail(v_demandpk, currInst, v_proptax, v_educess, v_libcess, v_unauthtax, idModule, assessmentdate);
	begin
		select (d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty) into v_arreartax from pt_dmndrgtr_tbl where i_asmtno =assessmentNo and isIncremental = true and vc_dmndyear=currInstDesc;
		if(v_arreartax>0)then
		for arrearDmds in (select * from pt_arrear_tbl where i_asmtno =assessmentNo and isIncremental = true)
		loop 
			begin
				select id into v_idinst from eg_installment_master where id_module=idModule and description=arrearDmds.vc_dmndyear;
				v_temp := createInstDemandDetail(v_demandpk, v_idinst, arrearDmds.d_arrpt, arrearDmds.d_arred, arrearDmds.d_arrlcs, arrearDmds.d_arruauthcnstplty, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'createInstDemandDetail, failed while adding arrears : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;
		end if;
	EXCEPTION
		WHEN OTHERS THEN
			raise notice 'createdemandIncremental, failed while checking arrears : % %', SQLERRM, SQLSTATE;
	END;
	return v_demandpk;
EXCEPTION
	WHEN OTHERS THEN
		raise notice 'createdemandIncremental : % %', SQLERRM, SQLSTATE;
END;
$BODY$
	LANGUAGE plpgsql;
--------------createdemandIncremental end-------------------------------------------------------------------------------


--------------createflrdmdcalcIncremental start-------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION createflrdmdcalcIncremental(iddmdcal bigint, idasmdtls bigint, idflrdtl bigint, assessmentdate date, assessmentno bigint)
	RETURNS bigint AS
$BODY$
declare
	v_idFlrDmdCalc 	bigint;  
BEGIN 
	--raise notice 'createflrdmdcalcIncremental idDmdCal, idAsmDtls, idFlrDtl, assessmentdate (% % % %)',idDmdCal, idAsmDtls, idFlrDtl, assessmentdate;
	select nextval('seq_egpt_floordemandcalc') into v_idFlrDmdCalc;
	--raise notice 'createflrdmdcalcIncremental v_idFlrDmdCalc (%)',v_idFlrDmdCalc;
	INSERT INTO egpt_floordemandcalc(id, id_floordet, id_dmdcalc, categoryamt, createtimestamp, lastupdatedtimestamp, alv, mrv) select v_idFlrDmdCalc, idFlrDtl, idDmdCal, i_ur, assessmentdate, assessmentdate, d_arv, d_mrv from pt_asmt_dtls_tbl where i_asmtdtlsno=idAsmDtls and i_asmtno=assessmentNo and isIncremental = true;
	--raise notice 'Floor Demand Calcs Created';
	return v_idFlrDmdCalc;
EXCEPTION
	WHEN OTHERS THEN
		raise notice 'createflrdmdcalcIncremental : % %', SQLERRM, SQLSTATE;
END;
$BODY$
	LANGUAGE plpgsql;
--------------createflrdmdcalcIncremental end-------------------------------------------------------------------------------

  
--------------addfloorsIncremental start-------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION addfloorsIncremental(assessmentno integer, assessmentdate date, idpropdet bigint, iddmdcal bigint)
	RETURNS numeric AS
$BODY$
declare
	v_FlrDetpk bigint;
	v_FlrDmdCalc bigint;
	v_occDate_str character varying(10);
	floors pt_asmt_dtls_tbl%ROWTYPE;
BEGIN 
	--raise notice 'addfloorsIncremental assessmentNo, assessmentdate, idPropDet, idDmdCal (% % % %)',assessmentNo, assessmentdate, idPropDet, idDmdCal;
	select case when extract (month from assessmentdate) between 4 and 9 then '01/04/' else '01/10/' end into v_occDate_str;
	for floors in (select * from pt_asmt_dtls_tbl where c_delflag='N' and i_asmtno = assessmentNo and isIncremental = true order by i_flrno)
	loop 
		begin
			select nextval('seq_egpt_property_detail') into v_FlrDetpk;
			--raise notice 'addfloorsIncremental v_FlrDetpk (%)',v_FlrDetpk;
			INSERT INTO egpt_floor_detail(id, id_property_detail, floor_no, created_date, builtup_area, id_struc_cl, id_occpn_mstr, id_usg_mstr, modified_date, created_by, modified_by, id_depreciationmaster, occupancydate)
			values (v_FlrDetpk, idPropDet, floors.i_flrno, assessmentdate, floors.d_plntarea, (select egovcode from egpt_stg_bldgclass_mater where code=floors.i_clscode), (select egovcode from egpt_stg_occupancy where code=floors.i_ocpntypecode), (select egovcode from egpt_stg_usagemaster where code=floors.i_bldgusecode), assessmentdate, 1, 1, (select egovcode from egpt_stg_depreciation where code=floors.i_depcode), case when floors.i_bldgage is not null then to_date(v_occDate_str||cast(floors.i_bldgage as varchar),'dd/MM/yyyy') end);
			--raise notice 'Floor done';
			v_FlrDmdCalc := createflrdmdcalcIncremental(idDmdCal, floors.i_asmtdtlsno, v_FlrDetpk, assessmentdate, assessmentNo);
			--raise notice 'Floor demand calc is done';
		EXCEPTION
			WHEN OTHERS THEN
				raise notice 'addfloorsIncremental, adding floors failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	return 1;
EXCEPTION
	WHEN OTHERS THEN
		--raise notice 'addfloorsIncremental : % %', SQLERRM, SQLSTATE;
END;
$BODY$
	LANGUAGE plpgsql;
--------------addfloorsIncremental end-------------------------------------------------------------------------------
  

--------------migrateIncrementalSingleAssess start-------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION migrateIncrementalSingleAssess(assessmentno integer, idsource bigint, currinst bigint, currinstdesc character varying, idmodule bigint)
	RETURNS bigint AS $BODY$
DECLARE
	v_idinstall bigint;
	v_addressid bigint;
	v_idpropid bigint;
	v_idowner bigint;
	v_idbasic bigint;
	v_idprop bigint;
	v_idpropdet bigint;
	v_idfloor bigint;
	v_idownerlk bigint;
	v_iddmd bigint;
	v_iddmdcalc bigint;
	v_houseno varchar(32);
	v_zone int;
	v_ward int;
	v_block int;
	v_locality int;
	v_eward int;
	v_street int;
	v_assmtdate date;
	v_corraddr1 varchar(32); 
	v_corraddr2 varchar(32);
	v_isExempted character;
	v_arv double precision;
	v_totaltax double precision;
	v_exemptionReason integer;
	v_delflag character;
BEGIN
	begin
		--raise notice 'migrateIncrementalSingleAssess : Started for assessment no (% % % % %)', assessmentNo, idsource, currinst, currinstdesc, idModule;
		select asmtmstr.vc_onrdoorno, asmtmstr.i_zoneobjid, asmtmstr.i_rwobjid, asmtmstr.i_blckobjid, asmtmstr.i_lctyobjid, asmtmstr.i_strtobjid, asmtmstr.i_ewobjid, asmtmstr.dt_taxassddt, asmtmstr.vc_onraddr1, asmtmstr.vc_onraddr2, asmtmstr.c_xptn, asmtmstr.i_xptnpcode, asmtmstr.d_fxdarv, (coalesce(asmtmstr.d_fxdpt,0)+coalesce(asmtmstr.d_fxded,0)+coalesce(asmtmstr.d_fxdlcs,0)+coalesce(asmtmstr.d_fxdunauthplnplty,0)), asmtmstr.c_delflag
		into v_houseno, v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag
		from pt_asmt_mstr_tbl asmtmstr where asmtmstr.i_asmtno = assessmentNo and (isMigrated is null or isMigrated = 'N') and asmtmstr.isIncremental = true;
		--raise notice 'migrateIncrementalSingleAssess v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag (% % % % % % % % % % % % % % % %)', v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag;
		select id into v_idinstall from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and v_assmtdate between start_date and end_date;
		--raise notice 'migrateIncrementalSingleAssess : v_idinstall 1(%)', v_idinstall;
		if (v_idinstall is null) then
			select id into v_idinstall from eg_installment_master where start_date=(select min(inst.start_date) from pt_arrear_tbl arr, eg_installment_master inst where inst.id_module=idModule and arr.i_asmtno=assessmentNo and arr.vc_dmndyear=inst.description  and arr.isIncremental = true) and id_module=idModule;
		end if;
		if (v_idinstall is null) then
			v_idinstall := currinst;
		end if;
		--raise notice 'migrateIncrementalSingleAssess : v_idinstall 2(%)', v_idinstall;
		--raise notice 'migrateIncrementalSingleAssess : got installment (%)', v_idinstall;
		v_addressid := createAddress(v_houseno, v_locality);
		--raise notice 'migrateIncrementalSingleAssess : address created (%)', v_addressid;
		v_idpropid := createPropertyid(v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate);
		--raise notice 'migrateIncrementalSingleAssess : propertyid created (%)', v_idpropid;
		v_idowner := createownerIncremental(assessmentNo, v_corraddr1, v_corraddr2, v_addressid);
		--raise notice 'migrateIncrementalSingleAssess : owner created (%)', v_idowner;
		v_idbasic := createbasicpropIncremental(assessmentNo, v_addressid, v_idpropid, v_eward, v_delflag);
		--raise notice 'migrateIncrementalSingleAssess : Basicproperty created (%)', v_idbasic;
		v_idownerlk := linkOwner(v_idbasic, idsource, v_idowner);
		--raise notice 'migrateIncrementalSingleAssess : Owner linked (%)', v_idownerlk;
		v_idprop := createProperty(v_assmtdate, idsource, v_idbasic, v_isExempted, v_exemptionReason, v_idinstall);
		--raise notice 'migrateIncrementalSingleAssess : Property Created (%)', v_idprop;
		v_idpropdet := createpropertydetIncremental(assessmentNo, v_idprop);
		--raise notice 'Property Details created (%)', v_idpropdet;
		v_iddmd := createdemandIncremental(assessmentNo, v_idprop, currinst, v_assmtdate, idModule, v_arv, currinstdesc);
		--raise notice 'migrateIncrementalSingleAssess : Demand created';
		v_iddmdcalc := createDemandCalc(v_iddmd, v_totaltax, currinst, v_assmtdate, v_arv);
		--raise notice 'migrateIncrementalSingleAssess : createDemandCalc created';
		v_idfloor := addfloorsIncremental(assessmentNo, v_assmtdate, v_idpropdet, v_iddmdcalc);
		--raise notice 'Floors created';
		v_idfloor := migrateCollection(assessmentNo, v_iddmd);
		--raise notice 'Collection created';
		update pt_asmt_mstr_tbl set ismigrated='Y' where i_asmtno=assessmentNo and isIncremental = true;
		return v_idfloor;
	EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateIncrementalSingleAssess : % %', SQLERRM, SQLSTATE;
		update pt_asmt_mstr_tbl set error = SQLSTATE || '-' || SQLERRM where i_asmtno=assessmentNo and isIncremental = true;
	END;
END;
$BODY$
	LANGUAGE plpgsql;
--------------migrateIncrementalSingleAssess end-------------------------------------------------------------------------------


--------------migrateIncrementalAssessments start-------------------------------------------------------------------------------
create or replace function migrateIncrementalAssessments() 
	returns void as $$
declare
	asmstr pt_asmt_mstr_tbl%ROWTYPE;
	v_idsource bigint;
	v_currinst bigint;
	v_currinstdesc varchar(16);
	v_moduleid bigint;
	v_assessmentno integer;
	v_valid boolean;
	v_temp integer;
	v_temp1 boolean;
begin
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';
	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and isIncremental = true and i_oscode not in (select i_oscode from pt_os_mstr_tbl where vc_osdesc like '%EWSHS'))
	loop
		v_assessmentno := asmstr.i_asmtno;
		--raise notice 'Assessment : %', v_assessmentno;
		v_valid := validateAssessmentForTransactions(cast(v_assessmentno as text));
		if (v_valid = false) then
			v_temp1 := deleteAssessment(cast(v_assessmentno as text));
			-- if (v_temp1 = true) then
			-- 	raise notice 'Assessment Deleted: %', v_assessmentno;
			-- end if;
			v_temp  := migrateIncrementalSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			--raise notice 'Assessment Migrated: %', v_assessmentno;
			insert into egpt_property_receipts (id, id_basic_property, booknumber, rcpt_number, rcpt_date, from_date, to_date, rcpt_amount)
				select nextval('seq_egpt_property_receipts'), bp.id, i_bookno, trim(i_slno), dt_rcptdt, dt_paidfrmprddt, dt_paidtoprddt, (d_arrpt + d_arred + d_arrlcs + d_arruauthcnstplty + d_pltyonarr + d_crnpt + d_crned + d_crnlcs + d_crnuauthcnstplty + d_pltyoncrn + d_advamt) 
				from pt_asmtrcpt_tbl rcpt, egpt_basic_property bp where cast(bp.propertyid as int)=rcpt.i_asmtno and rcpt.c_delflag='N' and rcpt.i_asmtno=v_assessmentno;
		elsif (v_valid = true) then
			update pt_asmt_mstr_tbl set error = 'Transactions are there for this assessment', ismigrated='F' where isIncremental = true and i_asmtno = v_assessmentno;
		end if;
	end loop;
	exception 
		WHEN OTHERS THEN 
			raise exception 'migrateIncrementalAssessments : % %', SQLERRM, SQLSTATE;
end;
$$ language plpgsql;
--------------migrateIncrementalAssessments end-------------------------------------------------------------------------------
