--loadTaxRates
CREATE OR REPLACE FUNCTION loadTaxRates()
  RETURNS character varying AS
$BODY$
declare
	v_ptresd	double precision default 0;
	v_ptnrresd	double precision default 0;
	v_edutax	double precision default 0;
	v_libcess	double precision default 0;
	v_tax		varchar(128);
	v_isassmasterloaded	bigint default 1;
	taxrate pt_taxrate_mstr_tbl%ROWTYPE;
BEGIN 
begin
	for taxrate in (select * from pt_taxrate_mstr_tbl where c_delflag='N')
		loop 
		v_tax := taxrate.vc_taxratetype;
	
		if (v_tax='Property Tax For Residence') then
			v_ptresd := taxrate.d_taxrate;
		end if;
		if (v_tax='Property Tax For Non Residence') then
			v_ptnrresd := taxrate.d_taxrate;
		end if;
		if (v_tax='Library Cess') then
			v_libcess := taxrate.d_taxrate;
		end if;
		if (v_tax='Education Tax') then
			v_edutax := taxrate.d_taxrate;
		end if;
	END LOOP;
	raise notice 'loadTaxRates, v_ptresd, v_ptnrresd, v_libcess, v_edutax : % % % %', v_ptresd, v_ptnrresd, v_libcess, v_edutax;
	update eg_appconfig_values set value='GEN_TAX_RESD='||v_ptresd||chr(10)||'GEN_TAX_NR='||v_ptnrresd||chr(10)||'VAC_LAND_TAX=0.2'||chr(10)||'LIB_CESS='||v_libcess||chr(10)||'EDU_CESS='||v_edutax||chr(10)||'SEW_TAX_RESD=0'||chr(10)||'SEW_TAX_NR=0'||chr(10)||'PRIMARY_SER_CHRG=0' where key_id=(SELECT id FROM EG_APPCONFIG WHERE KEY_NAME='PT_TAXRATES' and module = (select id from eg_module where name='Property Tax'));
EXCEPTION
WHEN OTHERS THEN
raise notice 'loadTaxRates, loading Tax Rates failed : % %', SQLERRM, SQLSTATE;
v_isassmasterloaded := 0;
END;
RAISE NOTICE 'Tax Rates loaded';

return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
