---Adding one more status field in temp table
alter table tmp_employee add  column countermappingstatus varchar(200);
 
-------Procedure to load user counter mapping for all users with role as "ULB OPERATOR" under Zone 1.
create or replace FUNCTION load_user_counter_mapping()  	
RETURNS void AS
$BODY$
declare 
desig varchar(100); 
rolename varchar(100);
user_name varchar(100);
srl numeric;
userid numeric default 0;
roleid numeric default 0;
isUserCounterMappingExist boolean default false;
isUserRoleMappingExist boolean default false;
cur_emp tmp_employee%ROWTYPE;

begin
for cur_emp in( select * from tmp_employee where status='Updated' and (countermappingstatus is null or countermappingstatus!='Updated')order by srlno)
loop
begin
--desig:=upper(cur_emp.designation);
srl:=cur_emp.srlno;
user_name:=cur_emp.username;

RAISE NOTICE 'Processing for User %',user_name;
select id into userid from eg_user where username=user_name;
if(userid=null) then
update tmp_employee set countermappingstatus='Cannot identify the user' where srlno=srl;
else
begin
select id into roleid from eg_role where upper(name)='ULB OPERATOR';
end;
isUserRoleMappingExist:=userrole_mapping_exist(roleid,userid);
if(isUserRoleMappingExist=true) then
isUserCounterMappingExist:=usercounter_mapping_exist('Zone-1',userid);

if(isUserCounterMappingExist=false) then

--Load the usercountermapping to location Zone-1
insert into eg_usercounter_map (id, counterid, fromdate, todate, modifiedby, modifieddate, userid )values
(nextval('seq_eg_usercounter_map'), (select id from eg_location where name='Zone-1'), to_date('01-04-2015','DD-MM-YYYY'), to_date('31-03-2099','DD-MM-YYYY'),1, current_timestamp,userid);

--Update tmp table as sucess
update tmp_employee set countermappingstatus='Updated' where srlno=srl;
else
update tmp_employee set countermappingstatus='Counter mapping already exist for this user' where srlno=srl;
end if;

else
update tmp_employee set countermappingstatus='User is not an ULB Operator' where srlno=srl;
end if;
end if;


end;
end loop;
RAISE NOTICE 'End Processing for User Counter mapping';
end ;
$BODY$
LANGUAGE plpgsql;	

----------------------------------
create or replace function usercounter_mapping_exist(vlocationname varchar,vuserid numeric) returns boolean as 
$BODY$
declare isexist boolean default true;
begin
--PERFORM id from eg_department dept where upper(dept.name)=upper(deptName);
PERFORM id from eg_usercounter_map where counterid=(select id from eg_location where name=vlocationname) and userid=vuserid;
IF NOT FOUND THEN
--RAISE NOTICE 'Inside User Counter checking- DOES NOT EXIST %',vuserid;
isexist:=false;
END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;

--------------------
-- To execute call- load_user_counter_mapping();