--loadUnitRates
  CREATE OR REPLACE FUNCTION loadUnitRates()
  RETURNS character varying AS
$BODY$
declare
	v_categorypk 	bigint; 
	v_bndrycategorypk 	bigint;
	v_usagename 	varchar(256); 
	v_classname 	varchar(256); 
	v_catename	 	varchar(64);
	v_zonename	 	varchar(64);
	v_isassmasterloaded	bigint default 1;
	unitrate pt_ur_mstr_tbl%ROWTYPE;
BEGIN 

for unitrate in (select * from pt_ur_mstr_tbl order by i_zoneobjid)
	loop 
		begin
			select nextval('seq_egpt_mstr_category') into v_categorypk;
			select nextval('seq_egpt_mstr_bndry_category') into v_bndrycategorypk;
			--raise notice 'unitrate.i_clscode, unitrate.i_bldgusecode % %', unitrate.i_clscode, unitrate.i_bldgusecode;
			select name into v_usagename from egpt_stg_usagemaster where code=unitrate.i_bldgusecode;
			select name into v_classname from egpt_stg_bldgclass_mater where code=unitrate.i_clscode;
			select name into v_zonename from eg_stg_zone where code=unitrate.i_zoneobjid;
			v_catename := upper(substr(replace(replace(replace(v_usagename,'.',''),' ',''),',',''),1,4)) || '-' || upper(substr(replace(replace(replace(v_classname,'.',''),' ',''),',',''),1,4)) || '-' || upper(substr(replace(replace(replace(v_zonename,'.',''),' ',''),',',''),1,4)) || '-' || unitrate.d_ur|| '-' || round(random()*100000);

			--raise notice 'v_usagename, v_classname, v_catename, unitrate.dt_wefdate % % % %', v_usagename, v_classname, v_catename, unitrate.dt_wefdate;	
		
			Insert into EGPT_MSTR_CATEGORY (id, category_name, category_amnt, id_installment, is_history, created_by, id_usage, from_date, to_date, modified_by, created_date, modified_date, id_struct_cl) values (v_categorypk, v_catename, unitrate.d_ur, null,'N', 1, (select egovcode from egpt_stg_usagemaster where code=unitrate.i_bldgusecode), unitrate.dt_wefdate, to_date('2099-03-31 00:00:00.0','null'),1, unitrate.ts_dttm, unitrate.ts_dttm, (select egovcode from egpt_stg_bldgclass_mater where code=unitrate.i_clscode));

			Insert into EGPT_MSTR_BNDRY_CATEGORY (id, id_bndry, id_category, modified_date, from_date, to_date, created_by, modified_by, created_date) values (v_bndrycategorypk, (select egovcode from eg_stg_zone where code = unitrate.i_zoneobjid), v_categorypk, unitrate.ts_dttm, unitrate.dt_wefdate, to_date('31-03-2099','DD-MM-YYYY'), 1, 1, unitrate.ts_dttm);

		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'loadUnitRates, loading Unit Rates failed : % %', SQLERRM, SQLSTATE;
		v_isassmasterloaded := 0;
		END;
END LOOP;
RAISE NOTICE 'Unit Rates loaded';

return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
