drop function generateUsername(varchar);

create or replace FUNCTION addFloors(assessmentNo IN integer, assessmentdate IN date, idPropDet IN bigint, idDmdCal IN bigint)  
RETURNS numeric as $$
declare
	v_FlrDetpk bigint;
	v_FlrDmdCalc bigint;
	v_occDate_str character varying(10);
	floors pt_asmt_dtls_tbl%ROWTYPE;
BEGIN 
	--raise notice 'addFloors assessmentNo, assessmentdate, idPropDet, idDmdCal (% % % %)',assessmentNo, assessmentdate, idPropDet, idDmdCal;
select case when extract (month from assessmentdate) between 4 and 9 then '01/04/' else '01/10/' end into v_occDate_str;
for floors in (select * from pt_asmt_dtls_tbl where c_delflag='N' and i_asmtno = assessmentNo order by i_flrno)
	loop 
		begin
			select nextval('seq_egpt_property_detail') into v_FlrDetpk;
			--raise notice 'addFloors v_FlrDetpk (%)',v_FlrDetpk;
			INSERT INTO egpt_floor_detail(id, id_property_detail, floor_no, created_date, builtup_area, id_struc_cl, id_occpn_mstr, id_usg_mstr, modified_date, created_by, modified_by, id_depreciationmaster, occupancydate)
			values (v_FlrDetpk, idPropDet, floors.i_flrno, assessmentdate, floors.d_plntarea, (select egovcode from egpt_stg_bldgclass_mater where code=floors.i_clscode), (select egovcode from egpt_stg_occupancy where code=floors.i_ocpntypecode), (select egovcode from egpt_stg_usagemaster where code=floors.i_bldgusecode), assessmentdate, 1, 1, (select egovcode from egpt_stg_depreciation where code=floors.i_depcode), case when floors.i_bldgage is not null then to_date(v_occDate_str+floors.i_bldgage,'dd/MM/yyyy') end);
			--raise notice 'Floor done';
			v_FlrDmdCalc := createFlrDmdCalc(idDmdCal, floors.i_asmtdtlsno, v_FlrDetpk, assessmentdate, assessmentNo);
			--raise notice 'Floor demand calc is done';
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'addFloors, adding floors failed : % %', SQLERRM, SQLSTATE;
		END;
END LOOP;
	return 1;
EXCEPTION
WHEN OTHERS THEN
--raise notice 'addFloors : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;