create or replace FUNCTION generateUsername(surname IN varchar(8), name IN varchar(8))  
RETURNS VARCHAR as $$
declare
	v_username 	varchar(14); 
	v_surname 	varchar(10); 
	v_random 	varchar(18);
	v_random1 	varchar(18);
	v_randomno 	varchar(6);
	v_surrandomno   varchar(4);
BEGIN 
	--raise notice 'generateUsername name (%)',name;
	v_username := lpad(upper(substr(replace(replace(replace(name,'.',''),' ',''),',',''),1,4)), 4, '0');
	v_random := random()*100000;
	v_random1 := random()*100000;
	v_randomno := substring(v_random from 1 for 6);
	v_surrandomno := substring(v_random1 from 1 for 4);	
	v_surname := rpad(upper(substr(replace(replace(replace(surname,'.',''),' ',''),',',''),1,4)), 4, v_surrandomno);
	v_username := v_surname || v_username || v_randomno;
	--raise notice 'generateUsername, username generated (%)', v_username;
return v_username;
EXCEPTION
WHEN OTHERS THEN
raise notice 'generateUsername : % %', SQLERRM, SQLSTATE;
END;  
$$ LANGUAGE plpgsql;


create or replace FUNCTION createOwner(assessmentNo IN integer, corraddr1 IN varchar(32), corraddr2 IN varchar(32), addressid IN bigint)  
RETURNS numeric as $$
declare
	v_userpk 	bigint;  
	v_addresspk	bigint;
BEGIN 
	--raise notice 'createOwner assessmentNo, corraddr1, corraddr2, addressid (% % % % %)', assessmentNo, corraddr1, corraddr2, addressid;
	select nextval('seq_eg_address') into v_addresspk;
	select nextval('seq_eg_user') into v_userpk;
	INSERT INTO eg_user(id, locale, username, password, mobilenumber, emailid, createddate, lastmodifieddate, createdby, lastmodifiedby, active, name, gender, type, aadhaarnumber, guardian, guardianrelation)
    select v_userpk, 'en_IN', generateUsername(substring(vc_onrsurname from 1 for 8), substring(vc_onrname from 1 for 8)), 'NOT SET', vc_onrmobino, vc_onreid, dt_taxassddt, dt_taxassddt, 1, 1, TRUE, trim((coalesce(vc_onrsurname,'') ||' '|| coalesce(vc_onrname,''))), (CASE WHEN c_sex = 'F' THEN 0 ELSE 1 END), 'CITIZEN', vc_uid, vc_fthrsurname ||' '|| vc_fthrname, 'Father' from pt_asmt_mstr_tbl where i_asmtno=assessmentNo;
	--raise notice 'createOwner Owner created';
IF (corraddr1 IS NOT NULL OR corraddr2 IS NOT NULL) AND (length(corraddr1)>0 OR length(corraddr2)>0) then
	--raise notice 'createOwner Corr Address available';
    INSERT INTO eg_address(type, streetroadline, arealocalitysector, pincode, id, userid)
    values ('CORRESPONDENCE', corraddr1, corraddr2, NULL, v_addresspk, v_userpk);
	insert into eg_correspondence_address (id) values (v_addresspk);
	--raise notice 'createOwner Owner address created with available corr address';
else
	--raise notice 'createOwner Corr Address NOT available';
	INSERT INTO eg_address(housenobldgapt, type, streetroadline, arealocalitysector, pincode, id, userid)
	select housenobldgapt, 'CORRESPONDENCE', streetroadline, arealocalitysector, pincode, v_addresspk, v_userpk from eg_address where id=addressid;
	insert into eg_correspondence_address (id) values (v_addresspk);
	--raise notice 'createOwner Owner address created with property address';
END IF;

return v_userpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createOwner : % %', SQLERRM, SQLSTATE;
END;  
$$ LANGUAGE plpgsql;